<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVendorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->nullable();
            $table->integer('store')->nullable();
            $table->string('name')->nullable();
            $table->string('name_kana')->nullable();
            $table->integer('manner')->nullable();
            $table->string('zip')->nullable();                // 郵便番号
            $table->integer('address1')->nullable();          // 都道府県
            $table->integer('address2')->nullable();          // 市区郡
            $table->integer('address3')->nullable();          // 町村
            $table->string('address4')->nullable();                         // その他住所
            $table->string('vendor_tel1')->nullable();
            $table->string('vendor_tel2')->nullable();
            $table->string('vendor_fax')->nullable();
            $table->string('vendor_mail')->nullable();
            $table->text('vendor_url')->nullable();
            $table->string('vendor_charge')->nullable();
            $table->string('vendor_charge_kana')->nullable();
            // $table->integer('flyer')->nullable();
            // $table->integer('freepaper')->nullable();
            // $table->integer('house_hp')->nullable();
            // $table->integer('portal')->nullable();
            // $table->integer('signboard')->nullable();
            // $table->date('ad_conf_day')->nullable();
            // $table->date('article_conf_day')->nullable();
            $table->string('vendor_time')->nullable();
            $table->string('vendor_holiday')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendors');
    }
}
