<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstStationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_stations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('line')->nullable();
            $table->integer('line_id')->nullable();
            $table->string('name')->nullable();
            $table->integer('area_id')->nullable();
            $table->string('address')->nullable();
            $table->double('lat', 9, 6)->nullable();
            $table->double('lng', 9, 6)->nullable();
            $table->text('service')->nullable();
            $table->text('memo')->nullable();
            $table->string('count')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_stations');
    }
}
