<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRainsDuplicateVendorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rains_duplicate_vendors', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->nullable();
            $table->integer('store')->nullable();
            $table->string('name')->nullable();                 // 業者名
            $table->string('name_kana')->nullable();            // 業者名カナ
            $table->integer('manner')->nullable();              // 
            $table->string('zip')->nullable();                  // 郵便番号
            $table->integer('address1')->nullable();            // 都道府県
            $table->integer('address2')->nullable();            // 市区郡
            $table->integer('address3')->nullable();            // 町村
            $table->string('address4')->nullable();             // その他住所
            $table->string('vendor_tel1')->nullable();          // 電話番号１
            $table->string('vendor_tel2')->nullable();          // 電話番号２
            $table->string('vendor_fax')->nullable();           // FAX
            $table->string('vendor_mail')->nullable();          // メールアドレス
            $table->text('vendor_url')->nullable();             // URL
            $table->string('vendor_charge')->nullable();        // 担当者名
            $table->string('vendor_charge_kana')->nullable();   // 担当者名カナ
            $table->integer('flyer')->nullable();               // 
            $table->integer('freepaper')->nullable();           // 
            $table->integer('house_hp')->nullable();            // 
            $table->integer('portal')->nullable();              // 
            $table->integer('signboard')->nullable();           // 
            $table->date('ad_conf_day')->nullable();            // 
            $table->string('vendor_time')->nullable();          // 営業時間
            $table->string('vendor_holiday')->nullable();       // 定休日
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rains_duplicate_vendors');
    }
}
