<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_stores', function (Blueprint $table) {
            $table->increments('id');
            $table->int('code');
            $table->bigInteger('company_id');
            $table->string('name')->nullable();                 // 店舗名
            $table->string('name_kana')->nullable();            // 店舗名カナ
            $table->string('zip')->nullable(); 
            $table->integer('address1')->required();          // 都道府県
            $table->integer('address2')->required();          // 市区郡
            $table->integer('address3')->required();          // 町村
            $table->string('address4')->nullable();
            $table->string('tel')->nullable();
            $table->string('fax')->nullable();
            $table->text('email')->nullable();
            $table->text('business_hours')->nullable();
            $table->text('holiday')->nullable();
            $table->string('parking')->nullable();
            $table->text('comment')->nullable();
            $table->integer('disp')->required();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_stores');
    }
}
