<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRelationVendorArticlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('relation_vendor_articles', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('article_id');
            $table->bigInteger('vendor_id');
            $table->string('charge');
            $table->integer('flyer')->nullable();
            $table->integer('freepaper')->nullable();
            $table->integer('house_hp')->nullable();
            $table->integer('portal')->nullable();
            $table->integer('signboard')->nullable();
            $table->integer('ad_conf')->nullable();
            $table->date('ad_conf_day')->nullable();
            $table->date('article_conf_day')->nullable();
            $table->integer('manner')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('relation_vendor_articles');
    }
}
