<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('company_id')->nullable();
            $table->date('news_date')->nullable();
            $table->integer('news_category')->nullable();
            $table->string('news_category_text')->nullable();
            $table->text('news_title')->nullable();
            $table->integer('news_link')->nullable();
            $table->integer('news_link_target')->nullable();
            $table->text('news_link_target_url')->nullable();
            $table->text('news_link_target_text')->nullable();
            $table->integer('shop')->nullable();
            $table->integer('order')->nullable();
            $table->string('file_path')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('news');
    }
}
