<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomContentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('custom_contents', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('company_id');
            $table->integer('code')->default(0); // 種別コード(value)
            $table->integer('type')->default(0);
            $table->text('name')->nullable(); // 種別名(name)
            $table->text('contents')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('custom_contents');
    }
}
