<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFacilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('facilities', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->nullable();                         // 施設名
            $table->integer('kind')->nullable();          // 都道府県
            $table->string('zip')->nullable();                // 郵便番号
            $table->integer('address1')->nullable();          // 都道府県
            $table->integer('address2')->nullable();          // 市区郡
            $table->integer('address3')->nullable();          // 町村
            $table->string('address4')->nullable();                         // その他住所
            $table->double('lat', 9, 6)->nullable();                        // 緯度
            $table->double('lng', 9, 6)->nullable();                        // 経度
            $table->text('memo')->nullable();                        // 経度
            $table->string('file_path')->nullable();                         // file_path
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('facilities');
    }
}
