<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReformsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reforms', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('company_id')->nullable();
            $table->date('regist_date')->nullable();
            $table->integer('category')->nullable();
            $table->text('title')->nullable();
            $table->text('area')->nullable();
            $table->integer('from_year')->nullable();
            $table->integer('from_month')->nullable();
            $table->integer('cost')->nullable();
            $table->text('target')->nullable();
            $table->text('plan')->nullable();
            $table->text('point')->nullable();
            $table->integer('disp')->nullable();
            $table->integer('reform_num')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reforms');
    }
}
