<?php

use Illuminate\Database\Seeder;

class MstCitiesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // データのクリア
        DB::table('mst_cities')->truncate();

        // データの挿入
        $cities = [
            ['pref_code' => 1, 'code' => 101, 'name' => '札幌市中央区'],
            ['pref_code' => 1, 'code' => 102, 'name' => '札幌市北区'],
            ['pref_code' => 1, 'code' => 103, 'name' => '札幌市東区'],
            ['pref_code' => 1, 'code' => 104, 'name' => '札幌市白石区'],
            ['pref_code' => 1, 'code' => 105, 'name' => '札幌市豊平区'],
            ['pref_code' => 1, 'code' => 106, 'name' => '札幌市南区'],
            ['pref_code' => 1, 'code' => 107, 'name' => '札幌市西区'],
            ['pref_code' => 1, 'code' => 108, 'name' => '札幌市厚別区'],
            ['pref_code' => 1, 'code' => 109, 'name' => '札幌市手稲区'],
            ['pref_code' => 1, 'code' => 110, 'name' => '札幌市清田区'],
            ['pref_code' => 1, 'code' => 202, 'name' => '函館市'],
            ['pref_code' => 1, 'code' => 203, 'name' => '小樽市'],
            ['pref_code' => 1, 'code' => 204, 'name' => '旭川市'],
            ['pref_code' => 1, 'code' => 205, 'name' => '室蘭市'],
            ['pref_code' => 1, 'code' => 206, 'name' => '釧路市'],
            ['pref_code' => 1, 'code' => 207, 'name' => '帯広市'],
            ['pref_code' => 1, 'code' => 208, 'name' => '北見市'],
            ['pref_code' => 1, 'code' => 209, 'name' => '夕張市'],
            ['pref_code' => 1, 'code' => 210, 'name' => '岩見沢市'],
            ['pref_code' => 1, 'code' => 211, 'name' => '網走市'],
            ['pref_code' => 1, 'code' => 212, 'name' => '留萌市'],
            ['pref_code' => 1, 'code' => 213, 'name' => '苫小牧市'],
            ['pref_code' => 1, 'code' => 214, 'name' => '稚内市'],
            ['pref_code' => 1, 'code' => 215, 'name' => '美唄市'],
            ['pref_code' => 1, 'code' => 216, 'name' => '芦別市'],
            ['pref_code' => 1, 'code' => 217, 'name' => '江別市'],
            ['pref_code' => 1, 'code' => 218, 'name' => '赤平市'],
            ['pref_code' => 1, 'code' => 219, 'name' => '紋別市'],
            ['pref_code' => 1, 'code' => 220, 'name' => '士別市'],
            ['pref_code' => 1, 'code' => 221, 'name' => '名寄市'],
            ['pref_code' => 1, 'code' => 222, 'name' => '三笠市'],
            ['pref_code' => 1, 'code' => 223, 'name' => '根室市'],
            ['pref_code' => 1, 'code' => 224, 'name' => '千歳市'],
            ['pref_code' => 1, 'code' => 225, 'name' => '滝川市'],
            ['pref_code' => 1, 'code' => 226, 'name' => '砂川市'],
            ['pref_code' => 1, 'code' => 227, 'name' => '歌志内市'],
            ['pref_code' => 1, 'code' => 228, 'name' => '深川市'],
            ['pref_code' => 1, 'code' => 229, 'name' => '富良野市'],
            ['pref_code' => 1, 'code' => 230, 'name' => '登別市'],
            ['pref_code' => 1, 'code' => 231, 'name' => '恵庭市'],
            ['pref_code' => 1, 'code' => 233, 'name' => '伊達市'],
            ['pref_code' => 1, 'code' => 234, 'name' => '北広島市'],
            ['pref_code' => 1, 'code' => 235, 'name' => '石狩市'],
            ['pref_code' => 1, 'code' => 236, 'name' => '北斗市'],
            ['pref_code' => 1, 'code' => 303, 'name' => '石狩郡当別町'],
            ['pref_code' => 1, 'code' => 304, 'name' => '石狩郡新篠津村'],
            ['pref_code' => 1, 'code' => 331, 'name' => '松前郡松前町'],
            ['pref_code' => 1, 'code' => 332, 'name' => '松前郡福島町'],
            ['pref_code' => 1, 'code' => 333, 'name' => '上磯郡知内町'],
            ['pref_code' => 1, 'code' => 334, 'name' => '上磯郡木古内町'],
            ['pref_code' => 1, 'code' => 337, 'name' => '亀田郡七飯町'],
            ['pref_code' => 1, 'code' => 343, 'name' => '茅部郡鹿部町'],
            ['pref_code' => 1, 'code' => 345, 'name' => '茅部郡森町'],
            ['pref_code' => 1, 'code' => 346, 'name' => '二海郡八雲町'],
            ['pref_code' => 1, 'code' => 347, 'name' => '山越郡長万部町'],
            ['pref_code' => 1, 'code' => 361, 'name' => '檜山郡江差町'],
            ['pref_code' => 1, 'code' => 362, 'name' => '檜山郡上ノ国町'],
            ['pref_code' => 1, 'code' => 363, 'name' => '檜山郡厚沢部町'],
            ['pref_code' => 1, 'code' => 364, 'name' => '爾志郡乙部町'],
            ['pref_code' => 1, 'code' => 367, 'name' => '奥尻郡奥尻町'],
            ['pref_code' => 1, 'code' => 370, 'name' => '瀬棚郡今金町'],
            ['pref_code' => 1, 'code' => 371, 'name' => '久遠郡せたな町'],
            ['pref_code' => 1, 'code' => 391, 'name' => '島牧郡島牧村'],
            ['pref_code' => 1, 'code' => 392, 'name' => '寿都郡寿都町'],
            ['pref_code' => 1, 'code' => 393, 'name' => '寿都郡黒松内町'],
            ['pref_code' => 1, 'code' => 394, 'name' => '磯谷郡蘭越町'],
            ['pref_code' => 1, 'code' => 395, 'name' => '虻田郡ニセコ町'],
            ['pref_code' => 1, 'code' => 396, 'name' => '虻田郡真狩村'],
            ['pref_code' => 1, 'code' => 397, 'name' => '虻田郡留寿都村'],
            ['pref_code' => 1, 'code' => 398, 'name' => '虻田郡喜茂別町'],
            ['pref_code' => 1, 'code' => 399, 'name' => '虻田郡京極町'],
            ['pref_code' => 1, 'code' => 400, 'name' => '虻田郡倶知安町'],
            ['pref_code' => 1, 'code' => 401, 'name' => '岩内郡共和町'],
            ['pref_code' => 1, 'code' => 402, 'name' => '岩内郡岩内町'],
            ['pref_code' => 1, 'code' => 403, 'name' => '古宇郡泊村'],
            ['pref_code' => 1, 'code' => 404, 'name' => '古宇郡神恵内村'],
            ['pref_code' => 1, 'code' => 405, 'name' => '積丹郡積丹町'],
            ['pref_code' => 1, 'code' => 406, 'name' => '古平郡古平町'],
            ['pref_code' => 1, 'code' => 407, 'name' => '余市郡仁木町'],
            ['pref_code' => 1, 'code' => 408, 'name' => '余市郡余市町'],
            ['pref_code' => 1, 'code' => 409, 'name' => '余市郡赤井川村'],
            ['pref_code' => 1, 'code' => 423, 'name' => '空知郡南幌町'],
            ['pref_code' => 1, 'code' => 424, 'name' => '空知郡奈井江町'],
            ['pref_code' => 1, 'code' => 425, 'name' => '空知郡上砂川町'],
            ['pref_code' => 1, 'code' => 427, 'name' => '夕張郡由仁町'],
            ['pref_code' => 1, 'code' => 428, 'name' => '夕張郡長沼町'],
            ['pref_code' => 1, 'code' => 429, 'name' => '夕張郡栗山町'],
            ['pref_code' => 1, 'code' => 430, 'name' => '樺戸郡月形町'],
            ['pref_code' => 1, 'code' => 431, 'name' => '樺戸郡浦臼町'],
            ['pref_code' => 1, 'code' => 432, 'name' => '樺戸郡新十津川町'],
            ['pref_code' => 1, 'code' => 433, 'name' => '雨竜郡妹背牛町'],
            ['pref_code' => 1, 'code' => 434, 'name' => '雨竜郡秩父別町'],
            ['pref_code' => 1, 'code' => 436, 'name' => '雨竜郡雨竜町'],
            ['pref_code' => 1, 'code' => 437, 'name' => '雨竜郡北竜町'],
            ['pref_code' => 1, 'code' => 438, 'name' => '雨竜郡沼田町'],
            ['pref_code' => 1, 'code' => 452, 'name' => '上川郡鷹栖町'],
            ['pref_code' => 1, 'code' => 453, 'name' => '上川郡東神楽町'],
            ['pref_code' => 1, 'code' => 454, 'name' => '上川郡当麻町'],
            ['pref_code' => 1, 'code' => 455, 'name' => '上川郡比布町'],
            ['pref_code' => 1, 'code' => 456, 'name' => '上川郡愛別町'],
            ['pref_code' => 1, 'code' => 457, 'name' => '上川郡上川町'],
            ['pref_code' => 1, 'code' => 458, 'name' => '上川郡東川町'],
            ['pref_code' => 1, 'code' => 459, 'name' => '上川郡美瑛町'],
            ['pref_code' => 1, 'code' => 460, 'name' => '空知郡上富良野町'],
            ['pref_code' => 1, 'code' => 461, 'name' => '空知郡中富良野町'],
            ['pref_code' => 1, 'code' => 462, 'name' => '空知郡南富良野町'],
            ['pref_code' => 1, 'code' => 463, 'name' => '勇払郡占冠村'],
            ['pref_code' => 1, 'code' => 464, 'name' => '上川郡和寒町'],
            ['pref_code' => 1, 'code' => 465, 'name' => '上川郡剣淵町'],
            ['pref_code' => 1, 'code' => 468, 'name' => '上川郡下川町'],
            ['pref_code' => 1, 'code' => 469, 'name' => '中川郡美深町'],
            ['pref_code' => 1, 'code' => 470, 'name' => '中川郡音威子府村'],
            ['pref_code' => 1, 'code' => 471, 'name' => '中川郡中川町'],
            ['pref_code' => 1, 'code' => 472, 'name' => '雨竜郡幌加内町'],
            ['pref_code' => 1, 'code' => 481, 'name' => '増毛郡増毛町'],
            ['pref_code' => 1, 'code' => 482, 'name' => '留萌郡小平町'],
            ['pref_code' => 1, 'code' => 483, 'name' => '苫前郡苫前町'],
            ['pref_code' => 1, 'code' => 484, 'name' => '苫前郡羽幌町'],
            ['pref_code' => 1, 'code' => 485, 'name' => '苫前郡初山別村'],
            ['pref_code' => 1, 'code' => 486, 'name' => '天塩郡遠別町'],
            ['pref_code' => 1, 'code' => 487, 'name' => '天塩郡天塩町'],
            ['pref_code' => 1, 'code' => 511, 'name' => '宗谷郡猿払村'],
            ['pref_code' => 1, 'code' => 512, 'name' => '枝幸郡浜頓別町'],
            ['pref_code' => 1, 'code' => 513, 'name' => '枝幸郡中頓別町'],
            ['pref_code' => 1, 'code' => 514, 'name' => '枝幸郡枝幸町'],
            ['pref_code' => 1, 'code' => 516, 'name' => '天塩郡豊富町'],
            ['pref_code' => 1, 'code' => 517, 'name' => '礼文郡礼文町'],
            ['pref_code' => 1, 'code' => 518, 'name' => '利尻郡利尻町'],
            ['pref_code' => 1, 'code' => 519, 'name' => '利尻郡利尻富士町'],
            ['pref_code' => 1, 'code' => 520, 'name' => '天塩郡幌延町'],
            ['pref_code' => 1, 'code' => 543, 'name' => '網走郡美幌町'],
            ['pref_code' => 1, 'code' => 544, 'name' => '網走郡津別町'],
            ['pref_code' => 1, 'code' => 545, 'name' => '斜里郡斜里町'],
            ['pref_code' => 1, 'code' => 546, 'name' => '斜里郡清里町'],
            ['pref_code' => 1, 'code' => 547, 'name' => '斜里郡小清水町'],
            ['pref_code' => 1, 'code' => 549, 'name' => '常呂郡訓子府町'],
            ['pref_code' => 1, 'code' => 550, 'name' => '常呂郡置戸町'],
            ['pref_code' => 1, 'code' => 552, 'name' => '常呂郡佐呂間町'],
            ['pref_code' => 1, 'code' => 555, 'name' => '紋別郡遠軽町'],
            ['pref_code' => 1, 'code' => 559, 'name' => '紋別郡湧別町'],
            ['pref_code' => 1, 'code' => 560, 'name' => '紋別郡滝上町'],
            ['pref_code' => 1, 'code' => 561, 'name' => '紋別郡興部町'],
            ['pref_code' => 1, 'code' => 562, 'name' => '紋別郡西興部村'],
            ['pref_code' => 1, 'code' => 563, 'name' => '紋別郡雄武町'],
            ['pref_code' => 1, 'code' => 564, 'name' => '網走郡大空町'],
            ['pref_code' => 1, 'code' => 571, 'name' => '虻田郡豊浦町'],
            ['pref_code' => 1, 'code' => 575, 'name' => '有珠郡壮瞥町'],
            ['pref_code' => 1, 'code' => 578, 'name' => '白老郡白老町'],
            ['pref_code' => 1, 'code' => 581, 'name' => '勇払郡厚真町'],
            ['pref_code' => 1, 'code' => 584, 'name' => '虻田郡洞爺湖町'],
            ['pref_code' => 1, 'code' => 585, 'name' => '勇払郡安平町'],
            ['pref_code' => 1, 'code' => 586, 'name' => '勇払郡むかわ町'],
            ['pref_code' => 1, 'code' => 601, 'name' => '沙流郡日高町'],
            ['pref_code' => 1, 'code' => 602, 'name' => '沙流郡平取町'],
            ['pref_code' => 1, 'code' => 604, 'name' => '新冠郡新冠町'],
            ['pref_code' => 1, 'code' => 607, 'name' => '浦河郡浦河町'],
            ['pref_code' => 1, 'code' => 608, 'name' => '様似郡様似町'],
            ['pref_code' => 1, 'code' => 609, 'name' => '幌泉郡えりも町'],
            ['pref_code' => 1, 'code' => 610, 'name' => '日高郡新ひだか町'],
            ['pref_code' => 1, 'code' => 631, 'name' => '河東郡音更町'],
            ['pref_code' => 1, 'code' => 632, 'name' => '河東郡士幌町'],
            ['pref_code' => 1, 'code' => 633, 'name' => '河東郡上士幌町'],
            ['pref_code' => 1, 'code' => 634, 'name' => '河東郡鹿追町'],
            ['pref_code' => 1, 'code' => 635, 'name' => '上川郡新得町'],
            ['pref_code' => 1, 'code' => 636, 'name' => '上川郡清水町'],
            ['pref_code' => 1, 'code' => 637, 'name' => '河西郡芽室町'],
            ['pref_code' => 1, 'code' => 638, 'name' => '河西郡中札内村'],
            ['pref_code' => 1, 'code' => 639, 'name' => '河西郡更別村'],
            ['pref_code' => 1, 'code' => 641, 'name' => '広尾郡大樹町'],
            ['pref_code' => 1, 'code' => 642, 'name' => '広尾郡広尾町'],
            ['pref_code' => 1, 'code' => 643, 'name' => '中川郡幕別町'],
            ['pref_code' => 1, 'code' => 644, 'name' => '中川郡池田町'],
            ['pref_code' => 1, 'code' => 645, 'name' => '中川郡豊頃町'],
            ['pref_code' => 1, 'code' => 646, 'name' => '中川郡本別町'],
            ['pref_code' => 1, 'code' => 647, 'name' => '足寄郡足寄町'],
            ['pref_code' => 1, 'code' => 648, 'name' => '足寄郡陸別町'],
            ['pref_code' => 1, 'code' => 649, 'name' => '十勝郡浦幌町'],
            ['pref_code' => 1, 'code' => 661, 'name' => '釧路郡釧路町'],
            ['pref_code' => 1, 'code' => 662, 'name' => '厚岸郡厚岸町'],
            ['pref_code' => 1, 'code' => 663, 'name' => '厚岸郡浜中町'],
            ['pref_code' => 1, 'code' => 664, 'name' => '川上郡標茶町'],
            ['pref_code' => 1, 'code' => 665, 'name' => '川上郡弟子屈町'],
            ['pref_code' => 1, 'code' => 667, 'name' => '阿寒郡鶴居村'],
            ['pref_code' => 1, 'code' => 668, 'name' => '白糠郡白糠町'],
            ['pref_code' => 1, 'code' => 691, 'name' => '野付郡別海町'],
            ['pref_code' => 1, 'code' => 692, 'name' => '標津郡中標津町'],
            ['pref_code' => 1, 'code' => 693, 'name' => '標津郡標津町'],
            ['pref_code' => 1, 'code' => 694, 'name' => '目梨郡羅臼町'],
            ['pref_code' => 2, 'code' => 201, 'name' => '青森市'],
            ['pref_code' => 2, 'code' => 202, 'name' => '弘前市'],
            ['pref_code' => 2, 'code' => 203, 'name' => '八戸市'],
            ['pref_code' => 2, 'code' => 204, 'name' => '黒石市'],
            ['pref_code' => 2, 'code' => 205, 'name' => '五所川原市'],
            ['pref_code' => 2, 'code' => 206, 'name' => '十和田市'],
            ['pref_code' => 2, 'code' => 207, 'name' => '三沢市'],
            ['pref_code' => 2, 'code' => 208, 'name' => 'むつ市'],
            ['pref_code' => 2, 'code' => 209, 'name' => 'つがる市'],
            ['pref_code' => 2, 'code' => 210, 'name' => '平川市'],
            ['pref_code' => 2, 'code' => 301, 'name' => '東津軽郡平内町'],
            ['pref_code' => 2, 'code' => 303, 'name' => '東津軽郡今別町'],
            ['pref_code' => 2, 'code' => 304, 'name' => '東津軽郡蓬田村'],
            ['pref_code' => 2, 'code' => 307, 'name' => '東津軽郡外ヶ浜町'],
            ['pref_code' => 2, 'code' => 321, 'name' => '西津軽郡鰺ヶ沢町'],
            ['pref_code' => 2, 'code' => 323, 'name' => '西津軽郡深浦町'],
            ['pref_code' => 2, 'code' => 343, 'name' => '中津軽郡西目屋村'],
            ['pref_code' => 2, 'code' => 361, 'name' => '南津軽郡藤崎町'],
            ['pref_code' => 2, 'code' => 362, 'name' => '南津軽郡大鰐町'],
            ['pref_code' => 2, 'code' => 367, 'name' => '南津軽郡田舎館村'],
            ['pref_code' => 2, 'code' => 381, 'name' => '北津軽郡板柳町'],
            ['pref_code' => 2, 'code' => 384, 'name' => '北津軽郡鶴田町'],
            ['pref_code' => 2, 'code' => 387, 'name' => '北津軽郡中泊町'],
            ['pref_code' => 2, 'code' => 401, 'name' => '上北郡野辺地町'],
            ['pref_code' => 2, 'code' => 402, 'name' => '上北郡七戸町'],
            ['pref_code' => 2, 'code' => 405, 'name' => '上北郡六戸町'],
            ['pref_code' => 2, 'code' => 406, 'name' => '上北郡横浜町'],
            ['pref_code' => 2, 'code' => 408, 'name' => '上北郡東北町'],
            ['pref_code' => 2, 'code' => 411, 'name' => '上北郡六ヶ所村'],
            ['pref_code' => 2, 'code' => 412, 'name' => '上北郡おいらせ町'],
            ['pref_code' => 2, 'code' => 423, 'name' => '下北郡大間町'],
            ['pref_code' => 2, 'code' => 424, 'name' => '下北郡東通村'],
            ['pref_code' => 2, 'code' => 425, 'name' => '下北郡風間浦村'],
            ['pref_code' => 2, 'code' => 426, 'name' => '下北郡佐井村'],
            ['pref_code' => 2, 'code' => 441, 'name' => '三戸郡三戸町'],
            ['pref_code' => 2, 'code' => 442, 'name' => '三戸郡五戸町'],
            ['pref_code' => 2, 'code' => 443, 'name' => '三戸郡田子町'],
            ['pref_code' => 2, 'code' => 445, 'name' => '三戸郡南部町'],
            ['pref_code' => 2, 'code' => 446, 'name' => '三戸郡階上町'],
            ['pref_code' => 2, 'code' => 450, 'name' => '三戸郡新郷村'],
            ['pref_code' => 3, 'code' => 201, 'name' => '盛岡市'],
            ['pref_code' => 3, 'code' => 202, 'name' => '宮古市'],
            ['pref_code' => 3, 'code' => 203, 'name' => '大船渡市'],
            ['pref_code' => 3, 'code' => 205, 'name' => '花巻市'],
            ['pref_code' => 3, 'code' => 206, 'name' => '北上市'],
            ['pref_code' => 3, 'code' => 207, 'name' => '久慈市'],
            ['pref_code' => 3, 'code' => 208, 'name' => '遠野市'],
            ['pref_code' => 3, 'code' => 209, 'name' => '一関市'],
            ['pref_code' => 3, 'code' => 210, 'name' => '陸前高田市'],
            ['pref_code' => 3, 'code' => 211, 'name' => '釜石市'],
            ['pref_code' => 3, 'code' => 213, 'name' => '二戸市'],
            ['pref_code' => 3, 'code' => 214, 'name' => '八幡平市'],
            ['pref_code' => 3, 'code' => 215, 'name' => '奥州市'],
            ['pref_code' => 3, 'code' => 216, 'name' => '滝沢市'],
            ['pref_code' => 3, 'code' => 301, 'name' => '岩手郡雫石町'],
            ['pref_code' => 3, 'code' => 302, 'name' => '岩手郡葛巻町'],
            ['pref_code' => 3, 'code' => 303, 'name' => '岩手郡岩手町'],
            ['pref_code' => 3, 'code' => 305, 'name' => '岩手郡滝沢村'],
            ['pref_code' => 3, 'code' => 321, 'name' => '紫波郡紫波町'],
            ['pref_code' => 3, 'code' => 322, 'name' => '紫波郡矢巾町'],
            ['pref_code' => 3, 'code' => 366, 'name' => '和賀郡西和賀町'],
            ['pref_code' => 3, 'code' => 381, 'name' => '胆沢郡金ケ崎町'],
            ['pref_code' => 3, 'code' => 402, 'name' => '西磐井郡平泉町'],
            ['pref_code' => 3, 'code' => 422, 'name' => '東磐井郡藤沢町'],
            ['pref_code' => 3, 'code' => 441, 'name' => '気仙郡住田町'],
            ['pref_code' => 3, 'code' => 461, 'name' => '上閉伊郡大槌町'],
            ['pref_code' => 3, 'code' => 482, 'name' => '下閉伊郡山田町'],
            ['pref_code' => 3, 'code' => 483, 'name' => '下閉伊郡岩泉町'],
            ['pref_code' => 3, 'code' => 484, 'name' => '下閉伊郡田野畑村'],
            ['pref_code' => 3, 'code' => 485, 'name' => '下閉伊郡普代村'],
            ['pref_code' => 3, 'code' => 501, 'name' => '九戸郡軽米町'],
            ['pref_code' => 3, 'code' => 503, 'name' => '九戸郡野田村'],
            ['pref_code' => 3, 'code' => 506, 'name' => '九戸郡九戸村'],
            ['pref_code' => 3, 'code' => 507, 'name' => '九戸郡洋野町'],
            ['pref_code' => 3, 'code' => 524, 'name' => '二戸郡一戸町'],
            ['pref_code' => 4, 'code' => 101, 'name' => '仙台市青葉区'],
            ['pref_code' => 4, 'code' => 102, 'name' => '仙台市宮城野区'],
            ['pref_code' => 4, 'code' => 103, 'name' => '仙台市若林区'],
            ['pref_code' => 4, 'code' => 104, 'name' => '仙台市太白区'],
            ['pref_code' => 4, 'code' => 105, 'name' => '仙台市泉区'],
            ['pref_code' => 4, 'code' => 202, 'name' => '石巻市'],
            ['pref_code' => 4, 'code' => 203, 'name' => '塩竈市'],
            ['pref_code' => 4, 'code' => 205, 'name' => '気仙沼市'],
            ['pref_code' => 4, 'code' => 206, 'name' => '白石市'],
            ['pref_code' => 4, 'code' => 207, 'name' => '名取市'],
            ['pref_code' => 4, 'code' => 208, 'name' => '角田市'],
            ['pref_code' => 4, 'code' => 209, 'name' => '多賀城市'],
            ['pref_code' => 4, 'code' => 211, 'name' => '岩沼市'],
            ['pref_code' => 4, 'code' => 212, 'name' => '登米市'],
            ['pref_code' => 4, 'code' => 213, 'name' => '栗原市'],
            ['pref_code' => 4, 'code' => 214, 'name' => '東松島市'],
            ['pref_code' => 4, 'code' => 215, 'name' => '大崎市'],
            ['pref_code' => 4, 'code' => 216, 'name' => '富谷市'],
            ['pref_code' => 4, 'code' => 301, 'name' => '刈田郡蔵王町'],
            ['pref_code' => 4, 'code' => 302, 'name' => '刈田郡七ヶ宿町'],
            ['pref_code' => 4, 'code' => 321, 'name' => '柴田郡大河原町'],
            ['pref_code' => 4, 'code' => 322, 'name' => '柴田郡村田町'],
            ['pref_code' => 4, 'code' => 323, 'name' => '柴田郡柴田町'],
            ['pref_code' => 4, 'code' => 324, 'name' => '柴田郡川崎町'],
            ['pref_code' => 4, 'code' => 341, 'name' => '伊具郡丸森町'],
            ['pref_code' => 4, 'code' => 361, 'name' => '亘理郡亘理町'],
            ['pref_code' => 4, 'code' => 362, 'name' => '亘理郡山元町'],
            ['pref_code' => 4, 'code' => 401, 'name' => '宮城郡松島町'],
            ['pref_code' => 4, 'code' => 404, 'name' => '宮城郡七ヶ浜町'],
            ['pref_code' => 4, 'code' => 406, 'name' => '宮城郡利府町'],
            ['pref_code' => 4, 'code' => 421, 'name' => '黒川郡大和町'],
            ['pref_code' => 4, 'code' => 422, 'name' => '黒川郡大郷町'],
            ['pref_code' => 4, 'code' => 423, 'name' => '黒川郡富谷町'],
            ['pref_code' => 4, 'code' => 424, 'name' => '黒川郡大衡村'],
            ['pref_code' => 4, 'code' => 444, 'name' => '加美郡色麻町'],
            ['pref_code' => 4, 'code' => 445, 'name' => '加美郡加美町'],
            ['pref_code' => 4, 'code' => 501, 'name' => '遠田郡涌谷町'],
            ['pref_code' => 4, 'code' => 505, 'name' => '遠田郡美里町'],
            ['pref_code' => 4, 'code' => 581, 'name' => '牡鹿郡女川町'],
            ['pref_code' => 4, 'code' => 606, 'name' => '本吉郡南三陸町'],
            ['pref_code' => 5, 'code' => 201, 'name' => '秋田市'],
            ['pref_code' => 5, 'code' => 202, 'name' => '能代市'],
            ['pref_code' => 5, 'code' => 203, 'name' => '横手市'],
            ['pref_code' => 5, 'code' => 204, 'name' => '大館市'],
            ['pref_code' => 5, 'code' => 206, 'name' => '男鹿市'],
            ['pref_code' => 5, 'code' => 207, 'name' => '湯沢市'],
            ['pref_code' => 5, 'code' => 209, 'name' => '鹿角市'],
            ['pref_code' => 5, 'code' => 210, 'name' => '由利本荘市'],
            ['pref_code' => 5, 'code' => 211, 'name' => '潟上市'],
            ['pref_code' => 5, 'code' => 212, 'name' => '大仙市'],
            ['pref_code' => 5, 'code' => 213, 'name' => '北秋田市'],
            ['pref_code' => 5, 'code' => 214, 'name' => 'にかほ市'],
            ['pref_code' => 5, 'code' => 215, 'name' => '仙北市'],
            ['pref_code' => 5, 'code' => 303, 'name' => '鹿角郡小坂町'],
            ['pref_code' => 5, 'code' => 327, 'name' => '北秋田郡上小阿仁村'],
            ['pref_code' => 5, 'code' => 346, 'name' => '山本郡藤里町'],
            ['pref_code' => 5, 'code' => 348, 'name' => '山本郡三種町'],
            ['pref_code' => 5, 'code' => 349, 'name' => '山本郡八峰町'],
            ['pref_code' => 5, 'code' => 361, 'name' => '南秋田郡五城目町'],
            ['pref_code' => 5, 'code' => 363, 'name' => '南秋田郡八郎潟町'],
            ['pref_code' => 5, 'code' => 366, 'name' => '南秋田郡井川町'],
            ['pref_code' => 5, 'code' => 368, 'name' => '南秋田郡大潟村'],
            ['pref_code' => 5, 'code' => 434, 'name' => '仙北郡美郷町'],
            ['pref_code' => 5, 'code' => 463, 'name' => '雄勝郡羽後町'],
            ['pref_code' => 5, 'code' => 464, 'name' => '雄勝郡東成瀬村'],
            ['pref_code' => 6, 'code' => 201, 'name' => '山形市'],
            ['pref_code' => 6, 'code' => 202, 'name' => '米沢市'],
            ['pref_code' => 6, 'code' => 203, 'name' => '鶴岡市'],
            ['pref_code' => 6, 'code' => 204, 'name' => '酒田市'],
            ['pref_code' => 6, 'code' => 205, 'name' => '新庄市'],
            ['pref_code' => 6, 'code' => 206, 'name' => '寒河江市'],
            ['pref_code' => 6, 'code' => 207, 'name' => '上山市'],
            ['pref_code' => 6, 'code' => 208, 'name' => '村山市'],
            ['pref_code' => 6, 'code' => 209, 'name' => '長井市'],
            ['pref_code' => 6, 'code' => 210, 'name' => '天童市'],
            ['pref_code' => 6, 'code' => 211, 'name' => '東根市'],
            ['pref_code' => 6, 'code' => 212, 'name' => '尾花沢市'],
            ['pref_code' => 6, 'code' => 213, 'name' => '南陽市'],
            ['pref_code' => 6, 'code' => 301, 'name' => '東村山郡山辺町'],
            ['pref_code' => 6, 'code' => 302, 'name' => '東村山郡中山町'],
            ['pref_code' => 6, 'code' => 321, 'name' => '西村山郡河北町'],
            ['pref_code' => 6, 'code' => 322, 'name' => '西村山郡西川町'],
            ['pref_code' => 6, 'code' => 323, 'name' => '西村山郡朝日町'],
            ['pref_code' => 6, 'code' => 324, 'name' => '西村山郡大江町'],
            ['pref_code' => 6, 'code' => 341, 'name' => '北村山郡大石田町'],
            ['pref_code' => 6, 'code' => 361, 'name' => '最上郡金山町'],
            ['pref_code' => 6, 'code' => 362, 'name' => '最上郡最上町'],
            ['pref_code' => 6, 'code' => 363, 'name' => '最上郡舟形町'],
            ['pref_code' => 6, 'code' => 364, 'name' => '最上郡真室川町'],
            ['pref_code' => 6, 'code' => 365, 'name' => '最上郡大蔵村'],
            ['pref_code' => 6, 'code' => 366, 'name' => '最上郡鮭川村'],
            ['pref_code' => 6, 'code' => 367, 'name' => '最上郡戸沢村'],
            ['pref_code' => 6, 'code' => 381, 'name' => '東置賜郡高畠町'],
            ['pref_code' => 6, 'code' => 382, 'name' => '東置賜郡川西町'],
            ['pref_code' => 6, 'code' => 401, 'name' => '西置賜郡小国町'],
            ['pref_code' => 6, 'code' => 402, 'name' => '西置賜郡白鷹町'],
            ['pref_code' => 6, 'code' => 403, 'name' => '西置賜郡飯豊町'],
            ['pref_code' => 6, 'code' => 426, 'name' => '東田川郡三川町'],
            ['pref_code' => 6, 'code' => 428, 'name' => '東田川郡庄内町'],
            ['pref_code' => 6, 'code' => 461, 'name' => '飽海郡遊佐町'],
            ['pref_code' => 7, 'code' => 201, 'name' => '福島市'],
            ['pref_code' => 7, 'code' => 202, 'name' => '会津若松市'],
            ['pref_code' => 7, 'code' => 203, 'name' => '郡山市'],
            ['pref_code' => 7, 'code' => 204, 'name' => 'いわき市'],
            ['pref_code' => 7, 'code' => 205, 'name' => '白河市'],
            ['pref_code' => 7, 'code' => 207, 'name' => '須賀川市'],
            ['pref_code' => 7, 'code' => 208, 'name' => '喜多方市'],
            ['pref_code' => 7, 'code' => 209, 'name' => '相馬市'],
            ['pref_code' => 7, 'code' => 210, 'name' => '二本松市'],
            ['pref_code' => 7, 'code' => 211, 'name' => '田村市'],
            ['pref_code' => 7, 'code' => 212, 'name' => '南相馬市'],
            ['pref_code' => 7, 'code' => 213, 'name' => '伊達市'],
            ['pref_code' => 7, 'code' => 214, 'name' => '本宮市'],
            ['pref_code' => 7, 'code' => 301, 'name' => '伊達郡桑折町'],
            ['pref_code' => 7, 'code' => 303, 'name' => '伊達郡国見町'],
            ['pref_code' => 7, 'code' => 308, 'name' => '伊達郡川俣町'],
            ['pref_code' => 7, 'code' => 322, 'name' => '安達郡大玉村'],
            ['pref_code' => 7, 'code' => 342, 'name' => '岩瀬郡鏡石町'],
            ['pref_code' => 7, 'code' => 344, 'name' => '岩瀬郡天栄村'],
            ['pref_code' => 7, 'code' => 362, 'name' => '南会津郡下郷町'],
            ['pref_code' => 7, 'code' => 364, 'name' => '南会津郡檜枝岐村'],
            ['pref_code' => 7, 'code' => 367, 'name' => '南会津郡只見町'],
            ['pref_code' => 7, 'code' => 368, 'name' => '南会津郡南会津町'],
            ['pref_code' => 7, 'code' => 402, 'name' => '耶麻郡北塩原村'],
            ['pref_code' => 7, 'code' => 405, 'name' => '耶麻郡西会津町'],
            ['pref_code' => 7, 'code' => 407, 'name' => '耶麻郡磐梯町'],
            ['pref_code' => 7, 'code' => 408, 'name' => '耶麻郡猪苗代町'],
            ['pref_code' => 7, 'code' => 421, 'name' => '河沼郡会津坂下町'],
            ['pref_code' => 7, 'code' => 422, 'name' => '河沼郡湯川村'],
            ['pref_code' => 7, 'code' => 423, 'name' => '河沼郡柳津町'],
            ['pref_code' => 7, 'code' => 444, 'name' => '大沼郡三島町'],
            ['pref_code' => 7, 'code' => 445, 'name' => '大沼郡金山町'],
            ['pref_code' => 7, 'code' => 446, 'name' => '大沼郡昭和村'],
            ['pref_code' => 7, 'code' => 447, 'name' => '大沼郡会津美里町'],
            ['pref_code' => 7, 'code' => 461, 'name' => '西白河郡西郷村'],
            ['pref_code' => 7, 'code' => 464, 'name' => '西白河郡泉崎村'],
            ['pref_code' => 7, 'code' => 465, 'name' => '西白河郡中島村'],
            ['pref_code' => 7, 'code' => 466, 'name' => '西白河郡矢吹町'],
            ['pref_code' => 7, 'code' => 481, 'name' => '東白川郡棚倉町'],
            ['pref_code' => 7, 'code' => 482, 'name' => '東白川郡矢祭町'],
            ['pref_code' => 7, 'code' => 483, 'name' => '東白川郡塙町'],
            ['pref_code' => 7, 'code' => 484, 'name' => '東白川郡鮫川村'],
            ['pref_code' => 7, 'code' => 501, 'name' => '石川郡石川町'],
            ['pref_code' => 7, 'code' => 502, 'name' => '石川郡玉川村'],
            ['pref_code' => 7, 'code' => 503, 'name' => '石川郡平田村'],
            ['pref_code' => 7, 'code' => 504, 'name' => '石川郡浅川町'],
            ['pref_code' => 7, 'code' => 505, 'name' => '石川郡古殿町'],
            ['pref_code' => 7, 'code' => 521, 'name' => '田村郡三春町'],
            ['pref_code' => 7, 'code' => 522, 'name' => '田村郡小野町'],
            ['pref_code' => 7, 'code' => 541, 'name' => '双葉郡広野町'],
            ['pref_code' => 7, 'code' => 542, 'name' => '双葉郡楢葉町'],
            ['pref_code' => 7, 'code' => 543, 'name' => '双葉郡富岡町'],
            ['pref_code' => 7, 'code' => 544, 'name' => '双葉郡川内村'],
            ['pref_code' => 7, 'code' => 545, 'name' => '双葉郡大熊町'],
            ['pref_code' => 7, 'code' => 546, 'name' => '双葉郡双葉町'],
            ['pref_code' => 7, 'code' => 547, 'name' => '双葉郡浪江町'],
            ['pref_code' => 7, 'code' => 548, 'name' => '双葉郡葛尾村'],
            ['pref_code' => 7, 'code' => 561, 'name' => '相馬郡新地町'],
            ['pref_code' => 7, 'code' => 564, 'name' => '相馬郡飯舘村'],
            ['pref_code' => 8, 'code' => 201, 'name' => '水戸市'],
            ['pref_code' => 8, 'code' => 202, 'name' => '日立市'],
            ['pref_code' => 8, 'code' => 203, 'name' => '土浦市'],
            ['pref_code' => 8, 'code' => 204, 'name' => '古河市'],
            ['pref_code' => 8, 'code' => 205, 'name' => '石岡市'],
            ['pref_code' => 8, 'code' => 207, 'name' => '結城市'],
            ['pref_code' => 8, 'code' => 208, 'name' => '龍ケ崎市'],
            ['pref_code' => 8, 'code' => 210, 'name' => '下妻市'],
            ['pref_code' => 8, 'code' => 211, 'name' => '常総市'],
            ['pref_code' => 8, 'code' => 212, 'name' => '常陸太田市'],
            ['pref_code' => 8, 'code' => 214, 'name' => '高萩市'],
            ['pref_code' => 8, 'code' => 215, 'name' => '北茨城市'],
            ['pref_code' => 8, 'code' => 216, 'name' => '笠間市'],
            ['pref_code' => 8, 'code' => 217, 'name' => '取手市'],
            ['pref_code' => 8, 'code' => 219, 'name' => '牛久市'],
            ['pref_code' => 8, 'code' => 220, 'name' => 'つくば市'],
            ['pref_code' => 8, 'code' => 221, 'name' => 'ひたちなか市'],
            ['pref_code' => 8, 'code' => 222, 'name' => '鹿嶋市'],
            ['pref_code' => 8, 'code' => 223, 'name' => '潮来市'],
            ['pref_code' => 8, 'code' => 224, 'name' => '守谷市'],
            ['pref_code' => 8, 'code' => 225, 'name' => '常陸大宮市'],
            ['pref_code' => 8, 'code' => 226, 'name' => '那珂市'],
            ['pref_code' => 8, 'code' => 227, 'name' => '筑西市'],
            ['pref_code' => 8, 'code' => 228, 'name' => '坂東市'],
            ['pref_code' => 8, 'code' => 229, 'name' => '稲敷市'],
            ['pref_code' => 8, 'code' => 230, 'name' => 'かすみがうら市'],
            ['pref_code' => 8, 'code' => 231, 'name' => '桜川市'],
            ['pref_code' => 8, 'code' => 232, 'name' => '神栖市'],
            ['pref_code' => 8, 'code' => 233, 'name' => '行方市'],
            ['pref_code' => 8, 'code' => 234, 'name' => '鉾田市'],
            ['pref_code' => 8, 'code' => 235, 'name' => 'つくばみらい市'],
            ['pref_code' => 8, 'code' => 236, 'name' => '小美玉市'],
            ['pref_code' => 8, 'code' => 302, 'name' => '東茨城郡茨城町'],
            ['pref_code' => 8, 'code' => 309, 'name' => '東茨城郡大洗町'],
            ['pref_code' => 8, 'code' => 310, 'name' => '東茨城郡城里町'],
            ['pref_code' => 8, 'code' => 341, 'name' => '那珂郡東海村'],
            ['pref_code' => 8, 'code' => 364, 'name' => '久慈郡大子町'],
            ['pref_code' => 8, 'code' => 442, 'name' => '稲敷郡美浦村'],
            ['pref_code' => 8, 'code' => 443, 'name' => '稲敷郡阿見町'],
            ['pref_code' => 8, 'code' => 447, 'name' => '稲敷郡河内町'],
            ['pref_code' => 8, 'code' => 521, 'name' => '結城郡八千代町'],
            ['pref_code' => 8, 'code' => 542, 'name' => '猿島郡五霞町'],
            ['pref_code' => 8, 'code' => 546, 'name' => '猿島郡境町'],
            ['pref_code' => 8, 'code' => 564, 'name' => '北相馬郡利根町'],
            ['pref_code' => 9, 'code' => 201, 'name' => '宇都宮市'],
            ['pref_code' => 9, 'code' => 202, 'name' => '足利市'],
            ['pref_code' => 9, 'code' => 203, 'name' => '栃木市'],
            ['pref_code' => 9, 'code' => 204, 'name' => '佐野市'],
            ['pref_code' => 9, 'code' => 205, 'name' => '鹿沼市'],
            ['pref_code' => 9, 'code' => 206, 'name' => '日光市'],
            ['pref_code' => 9, 'code' => 208, 'name' => '小山市'],
            ['pref_code' => 9, 'code' => 209, 'name' => '真岡市'],
            ['pref_code' => 9, 'code' => 210, 'name' => '大田原市'],
            ['pref_code' => 9, 'code' => 211, 'name' => '矢板市'],
            ['pref_code' => 9, 'code' => 213, 'name' => '那須塩原市'],
            ['pref_code' => 9, 'code' => 214, 'name' => 'さくら市'],
            ['pref_code' => 9, 'code' => 215, 'name' => '那須烏山市'],
            ['pref_code' => 9, 'code' => 216, 'name' => '下野市'],
            ['pref_code' => 9, 'code' => 301, 'name' => '河内郡上三川町'],
            ['pref_code' => 9, 'code' => 321, 'name' => '上都賀郡西方町'],
            ['pref_code' => 9, 'code' => 342, 'name' => '芳賀郡益子町'],
            ['pref_code' => 9, 'code' => 343, 'name' => '芳賀郡茂木町'],
            ['pref_code' => 9, 'code' => 344, 'name' => '芳賀郡市貝町'],
            ['pref_code' => 9, 'code' => 345, 'name' => '芳賀郡芳賀町'],
            ['pref_code' => 9, 'code' => 361, 'name' => '下都賀郡壬生町'],
            ['pref_code' => 9, 'code' => 364, 'name' => '下都賀郡野木町'],
            ['pref_code' => 9, 'code' => 367, 'name' => '下都賀郡岩舟町'],
            ['pref_code' => 9, 'code' => 384, 'name' => '塩谷郡塩谷町'],
            ['pref_code' => 9, 'code' => 386, 'name' => '塩谷郡高根沢町'],
            ['pref_code' => 9, 'code' => 407, 'name' => '那須郡那須町'],
            ['pref_code' => 9, 'code' => 411, 'name' => '那須郡那珂川町'],
            ['pref_code' => 10, 'code' => 201, 'name' => '前橋市'],
            ['pref_code' => 10, 'code' => 202, 'name' => '高崎市'],
            ['pref_code' => 10, 'code' => 203, 'name' => '桐生市'],
            ['pref_code' => 10, 'code' => 204, 'name' => '伊勢崎市'],
            ['pref_code' => 10, 'code' => 205, 'name' => '太田市'],
            ['pref_code' => 10, 'code' => 206, 'name' => '沼田市'],
            ['pref_code' => 10, 'code' => 207, 'name' => '館林市'],
            ['pref_code' => 10, 'code' => 208, 'name' => '渋川市'],
            ['pref_code' => 10, 'code' => 209, 'name' => '藤岡市'],
            ['pref_code' => 10, 'code' => 210, 'name' => '富岡市'],
            ['pref_code' => 10, 'code' => 211, 'name' => '安中市'],
            ['pref_code' => 10, 'code' => 212, 'name' => 'みどり市'],
            ['pref_code' => 10, 'code' => 344, 'name' => '北群馬郡榛東村'],
            ['pref_code' => 10, 'code' => 345, 'name' => '北群馬郡吉岡町'],
            ['pref_code' => 10, 'code' => 366, 'name' => '多野郡上野村'],
            ['pref_code' => 10, 'code' => 367, 'name' => '多野郡神流町'],
            ['pref_code' => 10, 'code' => 382, 'name' => '甘楽郡下仁田町'],
            ['pref_code' => 10, 'code' => 383, 'name' => '甘楽郡南牧村'],
            ['pref_code' => 10, 'code' => 384, 'name' => '甘楽郡甘楽町'],
            ['pref_code' => 10, 'code' => 421, 'name' => '吾妻郡中之条町'],
            ['pref_code' => 10, 'code' => 424, 'name' => '吾妻郡長野原町'],
            ['pref_code' => 10, 'code' => 425, 'name' => '吾妻郡嬬恋村'],
            ['pref_code' => 10, 'code' => 426, 'name' => '吾妻郡草津町'],
            ['pref_code' => 10, 'code' => 428, 'name' => '吾妻郡高山村'],
            ['pref_code' => 10, 'code' => 429, 'name' => '吾妻郡東吾妻町'],
            ['pref_code' => 10, 'code' => 443, 'name' => '利根郡片品村'],
            ['pref_code' => 10, 'code' => 444, 'name' => '利根郡川場村'],
            ['pref_code' => 10, 'code' => 448, 'name' => '利根郡昭和村'],
            ['pref_code' => 10, 'code' => 449, 'name' => '利根郡みなかみ町'],
            ['pref_code' => 10, 'code' => 464, 'name' => '佐波郡玉村町'],
            ['pref_code' => 10, 'code' => 521, 'name' => '邑楽郡板倉町'],
            ['pref_code' => 10, 'code' => 522, 'name' => '邑楽郡明和町'],
            ['pref_code' => 10, 'code' => 523, 'name' => '邑楽郡千代田町'],
            ['pref_code' => 10, 'code' => 524, 'name' => '邑楽郡大泉町'],
            ['pref_code' => 10, 'code' => 525, 'name' => '邑楽郡邑楽町'],
            ['pref_code' => 11, 'code' => 101, 'name' => 'さいたま市西区'],
            ['pref_code' => 11, 'code' => 102, 'name' => 'さいたま市北区'],
            ['pref_code' => 11, 'code' => 103, 'name' => 'さいたま市大宮区'],
            ['pref_code' => 11, 'code' => 104, 'name' => 'さいたま市見沼区'],
            ['pref_code' => 11, 'code' => 105, 'name' => 'さいたま市中央区'],
            ['pref_code' => 11, 'code' => 106, 'name' => 'さいたま市桜区'],
            ['pref_code' => 11, 'code' => 107, 'name' => 'さいたま市浦和区'],
            ['pref_code' => 11, 'code' => 108, 'name' => 'さいたま市南区'],
            ['pref_code' => 11, 'code' => 109, 'name' => 'さいたま市緑区'],
            ['pref_code' => 11, 'code' => 110, 'name' => 'さいたま市岩槻区'],
            ['pref_code' => 11, 'code' => 201, 'name' => '川越市'],
            ['pref_code' => 11, 'code' => 202, 'name' => '熊谷市'],
            ['pref_code' => 11, 'code' => 203, 'name' => '川口市'],
            ['pref_code' => 11, 'code' => 206, 'name' => '行田市'],
            ['pref_code' => 11, 'code' => 207, 'name' => '秩父市'],
            ['pref_code' => 11, 'code' => 208, 'name' => '所沢市'],
            ['pref_code' => 11, 'code' => 209, 'name' => '飯能市'],
            ['pref_code' => 11, 'code' => 210, 'name' => '加須市'],
            ['pref_code' => 11, 'code' => 211, 'name' => '本庄市'],
            ['pref_code' => 11, 'code' => 212, 'name' => '東松山市'],
            ['pref_code' => 11, 'code' => 214, 'name' => '春日部市'],
            ['pref_code' => 11, 'code' => 215, 'name' => '狭山市'],
            ['pref_code' => 11, 'code' => 216, 'name' => '羽生市'],
            ['pref_code' => 11, 'code' => 217, 'name' => '鴻巣市'],
            ['pref_code' => 11, 'code' => 218, 'name' => '深谷市'],
            ['pref_code' => 11, 'code' => 219, 'name' => '上尾市'],
            ['pref_code' => 11, 'code' => 221, 'name' => '草加市'],
            ['pref_code' => 11, 'code' => 222, 'name' => '越谷市'],
            ['pref_code' => 11, 'code' => 223, 'name' => '蕨市'],
            ['pref_code' => 11, 'code' => 224, 'name' => '戸田市'],
            ['pref_code' => 11, 'code' => 225, 'name' => '入間市'],
            ['pref_code' => 11, 'code' => 226, 'name' => '鳩ケ谷市'],
            ['pref_code' => 11, 'code' => 227, 'name' => '朝霞市'],
            ['pref_code' => 11, 'code' => 228, 'name' => '志木市'],
            ['pref_code' => 11, 'code' => 229, 'name' => '和光市'],
            ['pref_code' => 11, 'code' => 230, 'name' => '新座市'],
            ['pref_code' => 11, 'code' => 231, 'name' => '桶川市'],
            ['pref_code' => 11, 'code' => 232, 'name' => '久喜市'],
            ['pref_code' => 11, 'code' => 233, 'name' => '北本市'],
            ['pref_code' => 11, 'code' => 234, 'name' => '八潮市'],
            ['pref_code' => 11, 'code' => 235, 'name' => '富士見市'],
            ['pref_code' => 11, 'code' => 237, 'name' => '三郷市'],
            ['pref_code' => 11, 'code' => 238, 'name' => '蓮田市'],
            ['pref_code' => 11, 'code' => 239, 'name' => '坂戸市'],
            ['pref_code' => 11, 'code' => 240, 'name' => '幸手市'],
            ['pref_code' => 11, 'code' => 241, 'name' => '鶴ヶ島市'],
            ['pref_code' => 11, 'code' => 242, 'name' => '日高市'],
            ['pref_code' => 11, 'code' => 243, 'name' => '吉川市'],
            ['pref_code' => 11, 'code' => 245, 'name' => 'ふじみ野市'],
            ['pref_code' => 11, 'code' => 246, 'name' => '白岡市'],
            ['pref_code' => 11, 'code' => 301, 'name' => '北足立郡伊奈町'],
            ['pref_code' => 11, 'code' => 324, 'name' => '入間郡三芳町'],
            ['pref_code' => 11, 'code' => 326, 'name' => '入間郡毛呂山町'],
            ['pref_code' => 11, 'code' => 327, 'name' => '入間郡越生町'],
            ['pref_code' => 11, 'code' => 341, 'name' => '比企郡滑川町'],
            ['pref_code' => 11, 'code' => 342, 'name' => '比企郡嵐山町'],
            ['pref_code' => 11, 'code' => 343, 'name' => '比企郡小川町'],
            ['pref_code' => 11, 'code' => 346, 'name' => '比企郡川島町'],
            ['pref_code' => 11, 'code' => 347, 'name' => '比企郡吉見町'],
            ['pref_code' => 11, 'code' => 348, 'name' => '比企郡鳩山町'],
            ['pref_code' => 11, 'code' => 349, 'name' => '比企郡ときがわ町'],
            ['pref_code' => 11, 'code' => 361, 'name' => '秩父郡横瀬町'],
            ['pref_code' => 11, 'code' => 362, 'name' => '秩父郡皆野町'],
            ['pref_code' => 11, 'code' => 363, 'name' => '秩父郡長瀞町'],
            ['pref_code' => 11, 'code' => 365, 'name' => '秩父郡小鹿野町'],
            ['pref_code' => 11, 'code' => 369, 'name' => '秩父郡東秩父村'],
            ['pref_code' => 11, 'code' => 381, 'name' => '児玉郡美里町'],
            ['pref_code' => 11, 'code' => 383, 'name' => '児玉郡神川町'],
            ['pref_code' => 11, 'code' => 385, 'name' => '児玉郡上里町'],
            ['pref_code' => 11, 'code' => 408, 'name' => '大里郡寄居町'],
            ['pref_code' => 11, 'code' => 442, 'name' => '南埼玉郡宮代町'],
            ['pref_code' => 11, 'code' => 445, 'name' => '南埼玉郡白岡町'],
            ['pref_code' => 11, 'code' => 464, 'name' => '北葛飾郡杉戸町'],
            ['pref_code' => 11, 'code' => 465, 'name' => '北葛飾郡松伏町'],
            ['pref_code' => 12, 'code' => 101, 'name' => '千葉市中央区'],
            ['pref_code' => 12, 'code' => 102, 'name' => '千葉市花見川区'],
            ['pref_code' => 12, 'code' => 103, 'name' => '千葉市稲毛区'],
            ['pref_code' => 12, 'code' => 104, 'name' => '千葉市若葉区'],
            ['pref_code' => 12, 'code' => 105, 'name' => '千葉市緑区'],
            ['pref_code' => 12, 'code' => 106, 'name' => '千葉市美浜区'],
            ['pref_code' => 12, 'code' => 202, 'name' => '銚子市'],
            ['pref_code' => 12, 'code' => 203, 'name' => '市川市'],
            ['pref_code' => 12, 'code' => 204, 'name' => '船橋市'],
            ['pref_code' => 12, 'code' => 205, 'name' => '館山市'],
            ['pref_code' => 12, 'code' => 206, 'name' => '木更津市'],
            ['pref_code' => 12, 'code' => 207, 'name' => '松戸市'],
            ['pref_code' => 12, 'code' => 208, 'name' => '野田市'],
            ['pref_code' => 12, 'code' => 210, 'name' => '茂原市'],
            ['pref_code' => 12, 'code' => 211, 'name' => '成田市'],
            ['pref_code' => 12, 'code' => 212, 'name' => '佐倉市'],
            ['pref_code' => 12, 'code' => 213, 'name' => '東金市'],
            ['pref_code' => 12, 'code' => 215, 'name' => '旭市'],
            ['pref_code' => 12, 'code' => 216, 'name' => '習志野市'],
            ['pref_code' => 12, 'code' => 217, 'name' => '柏市'],
            ['pref_code' => 12, 'code' => 218, 'name' => '勝浦市'],
            ['pref_code' => 12, 'code' => 219, 'name' => '市原市'],
            ['pref_code' => 12, 'code' => 220, 'name' => '流山市'],
            ['pref_code' => 12, 'code' => 221, 'name' => '八千代市'],
            ['pref_code' => 12, 'code' => 222, 'name' => '我孫子市'],
            ['pref_code' => 12, 'code' => 223, 'name' => '鴨川市'],
            ['pref_code' => 12, 'code' => 224, 'name' => '鎌ケ谷市'],
            ['pref_code' => 12, 'code' => 225, 'name' => '君津市'],
            ['pref_code' => 12, 'code' => 226, 'name' => '富津市'],
            ['pref_code' => 12, 'code' => 227, 'name' => '浦安市'],
            ['pref_code' => 12, 'code' => 228, 'name' => '四街道市'],
            ['pref_code' => 12, 'code' => 229, 'name' => '袖ケ浦市'],
            ['pref_code' => 12, 'code' => 230, 'name' => '八街市'],
            ['pref_code' => 12, 'code' => 231, 'name' => '印西市'],
            ['pref_code' => 12, 'code' => 232, 'name' => '白井市'],
            ['pref_code' => 12, 'code' => 233, 'name' => '富里市'],
            ['pref_code' => 12, 'code' => 234, 'name' => '南房総市'],
            ['pref_code' => 12, 'code' => 235, 'name' => '匝瑳市'],
            ['pref_code' => 12, 'code' => 236, 'name' => '香取市'],
            ['pref_code' => 12, 'code' => 237, 'name' => '山武市'],
            ['pref_code' => 12, 'code' => 238, 'name' => 'いすみ市'],
            ['pref_code' => 12, 'code' => 239, 'name' => '大網白里市'],
            ['pref_code' => 12, 'code' => 322, 'name' => '印旛郡酒々井町'],
            ['pref_code' => 12, 'code' => 329, 'name' => '印旛郡栄町'],
            ['pref_code' => 12, 'code' => 342, 'name' => '香取郡神崎町'],
            ['pref_code' => 12, 'code' => 347, 'name' => '香取郡多古町'],
            ['pref_code' => 12, 'code' => 349, 'name' => '香取郡東庄町'],
            ['pref_code' => 12, 'code' => 403, 'name' => '山武郡九十九里町'],
            ['pref_code' => 12, 'code' => 409, 'name' => '山武郡芝山町'],
            ['pref_code' => 12, 'code' => 410, 'name' => '山武郡横芝光町'],
            ['pref_code' => 12, 'code' => 421, 'name' => '長生郡一宮町'],
            ['pref_code' => 12, 'code' => 422, 'name' => '長生郡睦沢町'],
            ['pref_code' => 12, 'code' => 423, 'name' => '長生郡長生村'],
            ['pref_code' => 12, 'code' => 424, 'name' => '長生郡白子町'],
            ['pref_code' => 12, 'code' => 426, 'name' => '長生郡長柄町'],
            ['pref_code' => 12, 'code' => 427, 'name' => '長生郡長南町'],
            ['pref_code' => 12, 'code' => 441, 'name' => '夷隅郡大多喜町'],
            ['pref_code' => 12, 'code' => 443, 'name' => '夷隅郡御宿町'],
            ['pref_code' => 12, 'code' => 463, 'name' => '安房郡鋸南町'],
            ['pref_code' => 13, 'code' => 101, 'name' => '千代田区'],
            ['pref_code' => 13, 'code' => 102, 'name' => '中央区'],
            ['pref_code' => 13, 'code' => 103, 'name' => '港区'],
            ['pref_code' => 13, 'code' => 104, 'name' => '新宿区'],
            ['pref_code' => 13, 'code' => 105, 'name' => '文京区'],
            ['pref_code' => 13, 'code' => 106, 'name' => '台東区'],
            ['pref_code' => 13, 'code' => 107, 'name' => '墨田区'],
            ['pref_code' => 13, 'code' => 108, 'name' => '江東区'],
            ['pref_code' => 13, 'code' => 109, 'name' => '品川区'],
            ['pref_code' => 13, 'code' => 110, 'name' => '目黒区'],
            ['pref_code' => 13, 'code' => 111, 'name' => '大田区'],
            ['pref_code' => 13, 'code' => 112, 'name' => '世田谷区'],
            ['pref_code' => 13, 'code' => 113, 'name' => '渋谷区'],
            ['pref_code' => 13, 'code' => 114, 'name' => '中野区'],
            ['pref_code' => 13, 'code' => 115, 'name' => '杉並区'],
            ['pref_code' => 13, 'code' => 116, 'name' => '豊島区'],
            ['pref_code' => 13, 'code' => 117, 'name' => '北区'],
            ['pref_code' => 13, 'code' => 118, 'name' => '荒川区'],
            ['pref_code' => 13, 'code' => 119, 'name' => '板橋区'],
            ['pref_code' => 13, 'code' => 120, 'name' => '練馬区'],
            ['pref_code' => 13, 'code' => 121, 'name' => '足立区'],
            ['pref_code' => 13, 'code' => 122, 'name' => '葛飾区'],
            ['pref_code' => 13, 'code' => 123, 'name' => '江戸川区'],
            ['pref_code' => 13, 'code' => 201, 'name' => '八王子市'],
            ['pref_code' => 13, 'code' => 202, 'name' => '立川市'],
            ['pref_code' => 13, 'code' => 203, 'name' => '武蔵野市'],
            ['pref_code' => 13, 'code' => 204, 'name' => '三鷹市'],
            ['pref_code' => 13, 'code' => 205, 'name' => '青梅市'],
            ['pref_code' => 13, 'code' => 206, 'name' => '府中市'],
            ['pref_code' => 13, 'code' => 207, 'name' => '昭島市'],
            ['pref_code' => 13, 'code' => 208, 'name' => '調布市'],
            ['pref_code' => 13, 'code' => 209, 'name' => '町田市'],
            ['pref_code' => 13, 'code' => 210, 'name' => '小金井市'],
            ['pref_code' => 13, 'code' => 211, 'name' => '小平市'],
            ['pref_code' => 13, 'code' => 212, 'name' => '日野市'],
            ['pref_code' => 13, 'code' => 213, 'name' => '東村山市'],
            ['pref_code' => 13, 'code' => 214, 'name' => '国分寺市'],
            ['pref_code' => 13, 'code' => 215, 'name' => '国立市'],
            ['pref_code' => 13, 'code' => 218, 'name' => '福生市'],
            ['pref_code' => 13, 'code' => 219, 'name' => '狛江市'],
            ['pref_code' => 13, 'code' => 220, 'name' => '東大和市'],
            ['pref_code' => 13, 'code' => 221, 'name' => '清瀬市'],
            ['pref_code' => 13, 'code' => 222, 'name' => '東久留米市'],
            ['pref_code' => 13, 'code' => 223, 'name' => '武蔵村山市'],
            ['pref_code' => 13, 'code' => 224, 'name' => '多摩市'],
            ['pref_code' => 13, 'code' => 225, 'name' => '稲城市'],
            ['pref_code' => 13, 'code' => 227, 'name' => '羽村市'],
            ['pref_code' => 13, 'code' => 228, 'name' => 'あきる野市'],
            ['pref_code' => 13, 'code' => 229, 'name' => '西東京市'],
            ['pref_code' => 13, 'code' => 303, 'name' => '西多摩郡瑞穂町'],
            ['pref_code' => 13, 'code' => 305, 'name' => '西多摩郡日の出町'],
            ['pref_code' => 13, 'code' => 307, 'name' => '西多摩郡檜原村'],
            ['pref_code' => 13, 'code' => 308, 'name' => '西多摩郡奥多摩町'],
            ['pref_code' => 13, 'code' => 361, 'name' => '大島町'],
            ['pref_code' => 13, 'code' => 362, 'name' => '利島村'],
            ['pref_code' => 13, 'code' => 363, 'name' => '新島村'],
            ['pref_code' => 13, 'code' => 364, 'name' => '神津島村'],
            ['pref_code' => 13, 'code' => 381, 'name' => '三宅島三宅村'],
            ['pref_code' => 13, 'code' => 382, 'name' => '御蔵島村'],
            ['pref_code' => 13, 'code' => 401, 'name' => '八丈島八丈町'],
            ['pref_code' => 13, 'code' => 402, 'name' => '青ヶ島村'],
            ['pref_code' => 13, 'code' => 421, 'name' => '小笠原村'],
            ['pref_code' => 14, 'code' => 101, 'name' => '横浜市鶴見区'],
            ['pref_code' => 14, 'code' => 102, 'name' => '横浜市神奈川区'],
            ['pref_code' => 14, 'code' => 103, 'name' => '横浜市西区'],
            ['pref_code' => 14, 'code' => 104, 'name' => '横浜市中区'],
            ['pref_code' => 14, 'code' => 105, 'name' => '横浜市南区'],
            ['pref_code' => 14, 'code' => 106, 'name' => '横浜市保土ケ谷区'],
            ['pref_code' => 14, 'code' => 107, 'name' => '横浜市磯子区'],
            ['pref_code' => 14, 'code' => 108, 'name' => '横浜市金沢区'],
            ['pref_code' => 14, 'code' => 109, 'name' => '横浜市港北区'],
            ['pref_code' => 14, 'code' => 110, 'name' => '横浜市戸塚区'],
            ['pref_code' => 14, 'code' => 111, 'name' => '横浜市港南区'],
            ['pref_code' => 14, 'code' => 112, 'name' => '横浜市旭区'],
            ['pref_code' => 14, 'code' => 113, 'name' => '横浜市緑区'],
            ['pref_code' => 14, 'code' => 114, 'name' => '横浜市瀬谷区'],
            ['pref_code' => 14, 'code' => 115, 'name' => '横浜市栄区'],
            ['pref_code' => 14, 'code' => 116, 'name' => '横浜市泉区'],
            ['pref_code' => 14, 'code' => 117, 'name' => '横浜市青葉区'],
            ['pref_code' => 14, 'code' => 118, 'name' => '横浜市都筑区'],
            ['pref_code' => 14, 'code' => 131, 'name' => '川崎市川崎区'],
            ['pref_code' => 14, 'code' => 132, 'name' => '川崎市幸区'],
            ['pref_code' => 14, 'code' => 133, 'name' => '川崎市中原区'],
            ['pref_code' => 14, 'code' => 134, 'name' => '川崎市高津区'],
            ['pref_code' => 14, 'code' => 135, 'name' => '川崎市多摩区'],
            ['pref_code' => 14, 'code' => 136, 'name' => '川崎市宮前区'],
            ['pref_code' => 14, 'code' => 137, 'name' => '川崎市麻生区'],
            ['pref_code' => 14, 'code' => 151, 'name' => '相模原市緑区'],
            ['pref_code' => 14, 'code' => 152, 'name' => '相模原市中央区'],
            ['pref_code' => 14, 'code' => 153, 'name' => '相模原市南区'],
            ['pref_code' => 14, 'code' => 201, 'name' => '横須賀市'],
            ['pref_code' => 14, 'code' => 203, 'name' => '平塚市'],
            ['pref_code' => 14, 'code' => 204, 'name' => '鎌倉市'],
            ['pref_code' => 14, 'code' => 205, 'name' => '藤沢市'],
            ['pref_code' => 14, 'code' => 206, 'name' => '小田原市'],
            ['pref_code' => 14, 'code' => 207, 'name' => '茅ヶ崎市'],
            ['pref_code' => 14, 'code' => 208, 'name' => '逗子市'],
            ['pref_code' => 14, 'code' => 209, 'name' => '相模原市'],
            ['pref_code' => 14, 'code' => 210, 'name' => '三浦市'],
            ['pref_code' => 14, 'code' => 211, 'name' => '秦野市'],
            ['pref_code' => 14, 'code' => 212, 'name' => '厚木市'],
            ['pref_code' => 14, 'code' => 213, 'name' => '大和市'],
            ['pref_code' => 14, 'code' => 214, 'name' => '伊勢原市'],
            ['pref_code' => 14, 'code' => 215, 'name' => '海老名市'],
            ['pref_code' => 14, 'code' => 216, 'name' => '座間市'],
            ['pref_code' => 14, 'code' => 217, 'name' => '南足柄市'],
            ['pref_code' => 14, 'code' => 218, 'name' => '綾瀬市'],
            ['pref_code' => 14, 'code' => 301, 'name' => '三浦郡葉山町'],
            ['pref_code' => 14, 'code' => 321, 'name' => '高座郡寒川町'],
            ['pref_code' => 14, 'code' => 341, 'name' => '中郡大磯町'],
            ['pref_code' => 14, 'code' => 342, 'name' => '中郡二宮町'],
            ['pref_code' => 14, 'code' => 361, 'name' => '足柄上郡中井町'],
            ['pref_code' => 14, 'code' => 362, 'name' => '足柄上郡大井町'],
            ['pref_code' => 14, 'code' => 363, 'name' => '足柄上郡松田町'],
            ['pref_code' => 14, 'code' => 364, 'name' => '足柄上郡山北町'],
            ['pref_code' => 14, 'code' => 366, 'name' => '足柄上郡開成町'],
            ['pref_code' => 14, 'code' => 382, 'name' => '足柄下郡箱根町'],
            ['pref_code' => 14, 'code' => 383, 'name' => '足柄下郡真鶴町'],
            ['pref_code' => 14, 'code' => 384, 'name' => '足柄下郡湯河原町'],
            ['pref_code' => 14, 'code' => 401, 'name' => '愛甲郡愛川町'],
            ['pref_code' => 14, 'code' => 402, 'name' => '愛甲郡清川村'],
            ['pref_code' => 15, 'code' => 101, 'name' => '新潟市北区'],
            ['pref_code' => 15, 'code' => 102, 'name' => '新潟市東区'],
            ['pref_code' => 15, 'code' => 103, 'name' => '新潟市中央区'],
            ['pref_code' => 15, 'code' => 104, 'name' => '新潟市江南区'],
            ['pref_code' => 15, 'code' => 105, 'name' => '新潟市秋葉区'],
            ['pref_code' => 15, 'code' => 106, 'name' => '新潟市南区'],
            ['pref_code' => 15, 'code' => 107, 'name' => '新潟市西区'],
            ['pref_code' => 15, 'code' => 108, 'name' => '新潟市西蒲区'],
            ['pref_code' => 15, 'code' => 202, 'name' => '長岡市'],
            ['pref_code' => 15, 'code' => 204, 'name' => '三条市'],
            ['pref_code' => 15, 'code' => 205, 'name' => '柏崎市'],
            ['pref_code' => 15, 'code' => 206, 'name' => '新発田市'],
            ['pref_code' => 15, 'code' => 208, 'name' => '小千谷市'],
            ['pref_code' => 15, 'code' => 209, 'name' => '加茂市'],
            ['pref_code' => 15, 'code' => 210, 'name' => '十日町市'],
            ['pref_code' => 15, 'code' => 211, 'name' => '見附市'],
            ['pref_code' => 15, 'code' => 212, 'name' => '村上市'],
            ['pref_code' => 15, 'code' => 213, 'name' => '燕市'],
            ['pref_code' => 15, 'code' => 216, 'name' => '糸魚川市'],
            ['pref_code' => 15, 'code' => 217, 'name' => '妙高市'],
            ['pref_code' => 15, 'code' => 218, 'name' => '五泉市'],
            ['pref_code' => 15, 'code' => 222, 'name' => '上越市'],
            ['pref_code' => 15, 'code' => 223, 'name' => '阿賀野市'],
            ['pref_code' => 15, 'code' => 224, 'name' => '佐渡市'],
            ['pref_code' => 15, 'code' => 225, 'name' => '魚沼市'],
            ['pref_code' => 15, 'code' => 226, 'name' => '南魚沼市'],
            ['pref_code' => 15, 'code' => 227, 'name' => '胎内市'],
            ['pref_code' => 15, 'code' => 307, 'name' => '北蒲原郡聖籠町'],
            ['pref_code' => 15, 'code' => 342, 'name' => '西蒲原郡弥彦村'],
            ['pref_code' => 15, 'code' => 361, 'name' => '南蒲原郡田上町'],
            ['pref_code' => 15, 'code' => 385, 'name' => '東蒲原郡阿賀町'],
            ['pref_code' => 15, 'code' => 405, 'name' => '三島郡出雲崎町'],
            ['pref_code' => 15, 'code' => 461, 'name' => '南魚沼郡湯沢町'],
            ['pref_code' => 15, 'code' => 482, 'name' => '中魚沼郡津南町'],
            ['pref_code' => 15, 'code' => 504, 'name' => '刈羽郡刈羽村'],
            ['pref_code' => 15, 'code' => 581, 'name' => '岩船郡関川村'],
            ['pref_code' => 15, 'code' => 586, 'name' => '岩船郡粟島浦村'],
            ['pref_code' => 16, 'code' => 201, 'name' => '富山市'],
            ['pref_code' => 16, 'code' => 202, 'name' => '高岡市'],
            ['pref_code' => 16, 'code' => 204, 'name' => '魚津市'],
            ['pref_code' => 16, 'code' => 205, 'name' => '氷見市'],
            ['pref_code' => 16, 'code' => 206, 'name' => '滑川市'],
            ['pref_code' => 16, 'code' => 207, 'name' => '黒部市'],
            ['pref_code' => 16, 'code' => 208, 'name' => '砺波市'],
            ['pref_code' => 16, 'code' => 209, 'name' => '小矢部市'],
            ['pref_code' => 16, 'code' => 210, 'name' => '南砺市'],
            ['pref_code' => 16, 'code' => 211, 'name' => '射水市'],
            ['pref_code' => 16, 'code' => 321, 'name' => '中新川郡舟橋村'],
            ['pref_code' => 16, 'code' => 322, 'name' => '中新川郡上市町'],
            ['pref_code' => 16, 'code' => 323, 'name' => '中新川郡立山町'],
            ['pref_code' => 16, 'code' => 342, 'name' => '下新川郡入善町'],
            ['pref_code' => 16, 'code' => 343, 'name' => '下新川郡朝日町'],
            ['pref_code' => 17, 'code' => 201, 'name' => '金沢市'],
            ['pref_code' => 17, 'code' => 202, 'name' => '七尾市'],
            ['pref_code' => 17, 'code' => 203, 'name' => '小松市'],
            ['pref_code' => 17, 'code' => 204, 'name' => '輪島市'],
            ['pref_code' => 17, 'code' => 205, 'name' => '珠洲市'],
            ['pref_code' => 17, 'code' => 206, 'name' => '加賀市'],
            ['pref_code' => 17, 'code' => 207, 'name' => '羽咋市'],
            ['pref_code' => 17, 'code' => 209, 'name' => 'かほく市'],
            ['pref_code' => 17, 'code' => 210, 'name' => '白山市'],
            ['pref_code' => 17, 'code' => 211, 'name' => '能美市'],
            ['pref_code' => 17, 'code' => 212, 'name' => '野々市市'],
            ['pref_code' => 17, 'code' => 324, 'name' => '能美郡川北町'],
            ['pref_code' => 17, 'code' => 344, 'name' => '石川郡野々市町'],
            ['pref_code' => 17, 'code' => 361, 'name' => '河北郡津幡町'],
            ['pref_code' => 17, 'code' => 365, 'name' => '河北郡内灘町'],
            ['pref_code' => 17, 'code' => 384, 'name' => '羽咋郡志賀町'],
            ['pref_code' => 17, 'code' => 386, 'name' => '羽咋郡宝達志水町'],
            ['pref_code' => 17, 'code' => 407, 'name' => '鹿島郡中能登町'],
            ['pref_code' => 17, 'code' => 461, 'name' => '鳳珠郡穴水町'],
            ['pref_code' => 17, 'code' => 463, 'name' => '鳳珠郡能登町'],
            ['pref_code' => 18, 'code' => 201, 'name' => '福井市'],
            ['pref_code' => 18, 'code' => 202, 'name' => '敦賀市'],
            ['pref_code' => 18, 'code' => 204, 'name' => '小浜市'],
            ['pref_code' => 18, 'code' => 205, 'name' => '大野市'],
            ['pref_code' => 18, 'code' => 206, 'name' => '勝山市'],
            ['pref_code' => 18, 'code' => 207, 'name' => '鯖江市'],
            ['pref_code' => 18, 'code' => 208, 'name' => 'あわら市'],
            ['pref_code' => 18, 'code' => 209, 'name' => '越前市'],
            ['pref_code' => 18, 'code' => 210, 'name' => '坂井市'],
            ['pref_code' => 18, 'code' => 322, 'name' => '吉田郡永平寺町'],
            ['pref_code' => 18, 'code' => 382, 'name' => '今立郡池田町'],
            ['pref_code' => 18, 'code' => 404, 'name' => '南条郡南越前町'],
            ['pref_code' => 18, 'code' => 423, 'name' => '丹生郡越前町'],
            ['pref_code' => 18, 'code' => 442, 'name' => '三方郡美浜町'],
            ['pref_code' => 18, 'code' => 481, 'name' => '大飯郡高浜町'],
            ['pref_code' => 18, 'code' => 483, 'name' => '大飯郡おおい町'],
            ['pref_code' => 18, 'code' => 501, 'name' => '三方上中郡若狭町'],
            ['pref_code' => 19, 'code' => 201, 'name' => '甲府市'],
            ['pref_code' => 19, 'code' => 202, 'name' => '富士吉田市'],
            ['pref_code' => 19, 'code' => 204, 'name' => '都留市'],
            ['pref_code' => 19, 'code' => 205, 'name' => '山梨市'],
            ['pref_code' => 19, 'code' => 206, 'name' => '大月市'],
            ['pref_code' => 19, 'code' => 207, 'name' => '韮崎市'],
            ['pref_code' => 19, 'code' => 208, 'name' => '南アルプス市'],
            ['pref_code' => 19, 'code' => 209, 'name' => '北杜市'],
            ['pref_code' => 19, 'code' => 210, 'name' => '甲斐市'],
            ['pref_code' => 19, 'code' => 211, 'name' => '笛吹市'],
            ['pref_code' => 19, 'code' => 212, 'name' => '上野原市'],
            ['pref_code' => 19, 'code' => 213, 'name' => '甲州市'],
            ['pref_code' => 19, 'code' => 214, 'name' => '中央市'],
            ['pref_code' => 19, 'code' => 346, 'name' => '西八代郡市川三郷町'],
            ['pref_code' => 19, 'code' => 364, 'name' => '南巨摩郡早川町'],
            ['pref_code' => 19, 'code' => 365, 'name' => '南巨摩郡身延町'],
            ['pref_code' => 19, 'code' => 366, 'name' => '南巨摩郡南部町'],
            ['pref_code' => 19, 'code' => 368, 'name' => '南巨摩郡富士川町'],
            ['pref_code' => 19, 'code' => 384, 'name' => '中巨摩郡昭和町'],
            ['pref_code' => 19, 'code' => 422, 'name' => '南都留郡道志村'],
            ['pref_code' => 19, 'code' => 423, 'name' => '南都留郡西桂町'],
            ['pref_code' => 19, 'code' => 424, 'name' => '南都留郡忍野村'],
            ['pref_code' => 19, 'code' => 425, 'name' => '南都留郡山中湖村'],
            ['pref_code' => 19, 'code' => 429, 'name' => '南都留郡鳴沢村'],
            ['pref_code' => 19, 'code' => 430, 'name' => '南都留郡富士河口湖町'],
            ['pref_code' => 19, 'code' => 442, 'name' => '北都留郡小菅村'],
            ['pref_code' => 19, 'code' => 443, 'name' => '北都留郡丹波山村'],
            ['pref_code' => 20, 'code' => 201, 'name' => '長野市'],
            ['pref_code' => 20, 'code' => 202, 'name' => '松本市'],
            ['pref_code' => 20, 'code' => 203, 'name' => '上田市'],
            ['pref_code' => 20, 'code' => 204, 'name' => '岡谷市'],
            ['pref_code' => 20, 'code' => 205, 'name' => '飯田市'],
            ['pref_code' => 20, 'code' => 206, 'name' => '諏訪市'],
            ['pref_code' => 20, 'code' => 207, 'name' => '須坂市'],
            ['pref_code' => 20, 'code' => 208, 'name' => '小諸市'],
            ['pref_code' => 20, 'code' => 209, 'name' => '伊那市'],
            ['pref_code' => 20, 'code' => 210, 'name' => '駒ヶ根市'],
            ['pref_code' => 20, 'code' => 211, 'name' => '中野市'],
            ['pref_code' => 20, 'code' => 212, 'name' => '大町市'],
            ['pref_code' => 20, 'code' => 213, 'name' => '飯山市'],
            ['pref_code' => 20, 'code' => 214, 'name' => '茅野市'],
            ['pref_code' => 20, 'code' => 215, 'name' => '塩尻市'],
            ['pref_code' => 20, 'code' => 217, 'name' => '佐久市'],
            ['pref_code' => 20, 'code' => 218, 'name' => '千曲市'],
            ['pref_code' => 20, 'code' => 219, 'name' => '東御市'],
            ['pref_code' => 20, 'code' => 220, 'name' => '安曇野市'],
            ['pref_code' => 20, 'code' => 303, 'name' => '南佐久郡小海町'],
            ['pref_code' => 20, 'code' => 304, 'name' => '南佐久郡川上村'],
            ['pref_code' => 20, 'code' => 305, 'name' => '南佐久郡南牧村'],
            ['pref_code' => 20, 'code' => 306, 'name' => '南佐久郡南相木村'],
            ['pref_code' => 20, 'code' => 307, 'name' => '南佐久郡北相木村'],
            ['pref_code' => 20, 'code' => 309, 'name' => '南佐久郡佐久穂町'],
            ['pref_code' => 20, 'code' => 321, 'name' => '北佐久郡軽井沢町'],
            ['pref_code' => 20, 'code' => 323, 'name' => '北佐久郡御代田町'],
            ['pref_code' => 20, 'code' => 324, 'name' => '北佐久郡立科町'],
            ['pref_code' => 20, 'code' => 349, 'name' => '小県郡青木村'],
            ['pref_code' => 20, 'code' => 350, 'name' => '小県郡長和町'],
            ['pref_code' => 20, 'code' => 361, 'name' => '諏訪郡下諏訪町'],
            ['pref_code' => 20, 'code' => 362, 'name' => '諏訪郡富士見町'],
            ['pref_code' => 20, 'code' => 363, 'name' => '諏訪郡原村'],
            ['pref_code' => 20, 'code' => 382, 'name' => '上伊那郡辰野町'],
            ['pref_code' => 20, 'code' => 383, 'name' => '上伊那郡箕輪町'],
            ['pref_code' => 20, 'code' => 384, 'name' => '上伊那郡飯島町'],
            ['pref_code' => 20, 'code' => 385, 'name' => '上伊那郡南箕輪村'],
            ['pref_code' => 20, 'code' => 386, 'name' => '上伊那郡中川村'],
            ['pref_code' => 20, 'code' => 388, 'name' => '上伊那郡宮田村'],
            ['pref_code' => 20, 'code' => 402, 'name' => '下伊那郡松川町'],
            ['pref_code' => 20, 'code' => 403, 'name' => '下伊那郡高森町'],
            ['pref_code' => 20, 'code' => 404, 'name' => '下伊那郡阿南町'],
            ['pref_code' => 20, 'code' => 407, 'name' => '下伊那郡阿智村'],
            ['pref_code' => 20, 'code' => 409, 'name' => '下伊那郡平谷村'],
            ['pref_code' => 20, 'code' => 410, 'name' => '下伊那郡根羽村'],
            ['pref_code' => 20, 'code' => 411, 'name' => '下伊那郡下條村'],
            ['pref_code' => 20, 'code' => 412, 'name' => '下伊那郡売木村'],
            ['pref_code' => 20, 'code' => 413, 'name' => '下伊那郡天龍村'],
            ['pref_code' => 20, 'code' => 414, 'name' => '下伊那郡泰阜村'],
            ['pref_code' => 20, 'code' => 415, 'name' => '下伊那郡喬木村'],
            ['pref_code' => 20, 'code' => 416, 'name' => '下伊那郡豊丘村'],
            ['pref_code' => 20, 'code' => 417, 'name' => '下伊那郡大鹿村'],
            ['pref_code' => 20, 'code' => 422, 'name' => '木曽郡上松町'],
            ['pref_code' => 20, 'code' => 423, 'name' => '木曽郡南木曽町'],
            ['pref_code' => 20, 'code' => 425, 'name' => '木曽郡木祖村'],
            ['pref_code' => 20, 'code' => 429, 'name' => '木曽郡王滝村'],
            ['pref_code' => 20, 'code' => 430, 'name' => '木曽郡大桑村'],
            ['pref_code' => 20, 'code' => 432, 'name' => '木曽郡木曽町'],
            ['pref_code' => 20, 'code' => 446, 'name' => '東筑摩郡麻績村'],
            ['pref_code' => 20, 'code' => 448, 'name' => '東筑摩郡生坂村'],
            ['pref_code' => 20, 'code' => 450, 'name' => '東筑摩郡山形村'],
            ['pref_code' => 20, 'code' => 451, 'name' => '東筑摩郡朝日村'],
            ['pref_code' => 20, 'code' => 452, 'name' => '東筑摩郡筑北村'],
            ['pref_code' => 20, 'code' => 481, 'name' => '北安曇郡池田町'],
            ['pref_code' => 20, 'code' => 482, 'name' => '北安曇郡松川村'],
            ['pref_code' => 20, 'code' => 485, 'name' => '北安曇郡白馬村'],
            ['pref_code' => 20, 'code' => 486, 'name' => '北安曇郡小谷村'],
            ['pref_code' => 20, 'code' => 521, 'name' => '埴科郡坂城町'],
            ['pref_code' => 20, 'code' => 541, 'name' => '上高井郡小布施町'],
            ['pref_code' => 20, 'code' => 543, 'name' => '上高井郡高山村'],
            ['pref_code' => 20, 'code' => 561, 'name' => '下高井郡山ノ内町'],
            ['pref_code' => 20, 'code' => 562, 'name' => '下高井郡木島平村'],
            ['pref_code' => 20, 'code' => 563, 'name' => '下高井郡野沢温泉村'],
            ['pref_code' => 20, 'code' => 583, 'name' => '上水内郡信濃町'],
            ['pref_code' => 20, 'code' => 588, 'name' => '上水内郡小川村'],
            ['pref_code' => 20, 'code' => 590, 'name' => '上水内郡飯綱町'],
            ['pref_code' => 20, 'code' => 602, 'name' => '下水内郡栄村'],
            ['pref_code' => 21, 'code' => 201, 'name' => '岐阜市'],
            ['pref_code' => 21, 'code' => 202, 'name' => '大垣市'],
            ['pref_code' => 21, 'code' => 203, 'name' => '高山市'],
            ['pref_code' => 21, 'code' => 204, 'name' => '多治見市'],
            ['pref_code' => 21, 'code' => 205, 'name' => '関市'],
            ['pref_code' => 21, 'code' => 206, 'name' => '中津川市'],
            ['pref_code' => 21, 'code' => 207, 'name' => '美濃市'],
            ['pref_code' => 21, 'code' => 208, 'name' => '瑞浪市'],
            ['pref_code' => 21, 'code' => 209, 'name' => '羽島市'],
            ['pref_code' => 21, 'code' => 210, 'name' => '恵那市'],
            ['pref_code' => 21, 'code' => 211, 'name' => '美濃加茂市'],
            ['pref_code' => 21, 'code' => 212, 'name' => '土岐市'],
            ['pref_code' => 21, 'code' => 213, 'name' => '各務原市'],
            ['pref_code' => 21, 'code' => 214, 'name' => '可児市'],
            ['pref_code' => 21, 'code' => 215, 'name' => '山県市'],
            ['pref_code' => 21, 'code' => 216, 'name' => '瑞穂市'],
            ['pref_code' => 21, 'code' => 217, 'name' => '飛騨市'],
            ['pref_code' => 21, 'code' => 218, 'name' => '本巣市'],
            ['pref_code' => 21, 'code' => 219, 'name' => '郡上市'],
            ['pref_code' => 21, 'code' => 220, 'name' => '下呂市'],
            ['pref_code' => 21, 'code' => 221, 'name' => '海津市'],
            ['pref_code' => 21, 'code' => 302, 'name' => '羽島郡岐南町'],
            ['pref_code' => 21, 'code' => 303, 'name' => '羽島郡笠松町'],
            ['pref_code' => 21, 'code' => 341, 'name' => '養老郡養老町'],
            ['pref_code' => 21, 'code' => 361, 'name' => '不破郡垂井町'],
            ['pref_code' => 21, 'code' => 362, 'name' => '不破郡関ケ原町'],
            ['pref_code' => 21, 'code' => 381, 'name' => '安八郡神戸町'],
            ['pref_code' => 21, 'code' => 382, 'name' => '安八郡輪之内町'],
            ['pref_code' => 21, 'code' => 383, 'name' => '安八郡安八町'],
            ['pref_code' => 21, 'code' => 401, 'name' => '揖斐郡揖斐川町'],
            ['pref_code' => 21, 'code' => 403, 'name' => '揖斐郡大野町'],
            ['pref_code' => 21, 'code' => 404, 'name' => '揖斐郡池田町'],
            ['pref_code' => 21, 'code' => 421, 'name' => '本巣郡北方町'],
            ['pref_code' => 21, 'code' => 501, 'name' => '加茂郡坂祝町'],
            ['pref_code' => 21, 'code' => 502, 'name' => '加茂郡富加町'],
            ['pref_code' => 21, 'code' => 503, 'name' => '加茂郡川辺町'],
            ['pref_code' => 21, 'code' => 504, 'name' => '加茂郡七宗町'],
            ['pref_code' => 21, 'code' => 505, 'name' => '加茂郡八百津町'],
            ['pref_code' => 21, 'code' => 506, 'name' => '加茂郡白川町'],
            ['pref_code' => 21, 'code' => 507, 'name' => '加茂郡東白川村'],
            ['pref_code' => 21, 'code' => 521, 'name' => '可児郡御嵩町'],
            ['pref_code' => 21, 'code' => 604, 'name' => '大野郡白川村'],
            ['pref_code' => 22, 'code' => 101, 'name' => '静岡市葵区'],
            ['pref_code' => 22, 'code' => 102, 'name' => '静岡市駿河区'],
            ['pref_code' => 22, 'code' => 103, 'name' => '静岡市清水区'],
            ['pref_code' => 22, 'code' => 131, 'name' => '浜松市中区'],
            ['pref_code' => 22, 'code' => 132, 'name' => '浜松市東区'],
            ['pref_code' => 22, 'code' => 133, 'name' => '浜松市西区'],
            ['pref_code' => 22, 'code' => 134, 'name' => '浜松市南区'],
            ['pref_code' => 22, 'code' => 135, 'name' => '浜松市北区'],
            ['pref_code' => 22, 'code' => 136, 'name' => '浜松市浜北区'],
            ['pref_code' => 22, 'code' => 137, 'name' => '浜松市天竜区'],
            ['pref_code' => 22, 'code' => 203, 'name' => '沼津市'],
            ['pref_code' => 22, 'code' => 205, 'name' => '熱海市'],
            ['pref_code' => 22, 'code' => 206, 'name' => '三島市'],
            ['pref_code' => 22, 'code' => 207, 'name' => '富士宮市'],
            ['pref_code' => 22, 'code' => 208, 'name' => '伊東市'],
            ['pref_code' => 22, 'code' => 209, 'name' => '島田市'],
            ['pref_code' => 22, 'code' => 210, 'name' => '富士市'],
            ['pref_code' => 22, 'code' => 211, 'name' => '磐田市'],
            ['pref_code' => 22, 'code' => 212, 'name' => '焼津市'],
            ['pref_code' => 22, 'code' => 213, 'name' => '掛川市'],
            ['pref_code' => 22, 'code' => 214, 'name' => '藤枝市'],
            ['pref_code' => 22, 'code' => 215, 'name' => '御殿場市'],
            ['pref_code' => 22, 'code' => 216, 'name' => '袋井市'],
            ['pref_code' => 22, 'code' => 219, 'name' => '下田市'],
            ['pref_code' => 22, 'code' => 220, 'name' => '裾野市'],
            ['pref_code' => 22, 'code' => 221, 'name' => '湖西市'],
            ['pref_code' => 22, 'code' => 222, 'name' => '伊豆市'],
            ['pref_code' => 22, 'code' => 223, 'name' => '御前崎市'],
            ['pref_code' => 22, 'code' => 224, 'name' => '菊川市'],
            ['pref_code' => 22, 'code' => 225, 'name' => '伊豆の国市'],
            ['pref_code' => 22, 'code' => 226, 'name' => '牧之原市'],
            ['pref_code' => 22, 'code' => 301, 'name' => '賀茂郡東伊豆町'],
            ['pref_code' => 22, 'code' => 302, 'name' => '賀茂郡河津町'],
            ['pref_code' => 22, 'code' => 304, 'name' => '賀茂郡南伊豆町'],
            ['pref_code' => 22, 'code' => 305, 'name' => '賀茂郡松崎町'],
            ['pref_code' => 22, 'code' => 306, 'name' => '賀茂郡西伊豆町'],
            ['pref_code' => 22, 'code' => 325, 'name' => '田方郡函南町'],
            ['pref_code' => 22, 'code' => 341, 'name' => '駿東郡清水町'],
            ['pref_code' => 22, 'code' => 342, 'name' => '駿東郡長泉町'],
            ['pref_code' => 22, 'code' => 344, 'name' => '駿東郡小山町'],
            ['pref_code' => 22, 'code' => 424, 'name' => '榛原郡吉田町'],
            ['pref_code' => 22, 'code' => 429, 'name' => '榛原郡川根本町'],
            ['pref_code' => 22, 'code' => 461, 'name' => '周智郡森町'],
            ['pref_code' => 23, 'code' => 101, 'name' => '名古屋市千種区'],
            ['pref_code' => 23, 'code' => 102, 'name' => '名古屋市東区'],
            ['pref_code' => 23, 'code' => 103, 'name' => '名古屋市北区'],
            ['pref_code' => 23, 'code' => 104, 'name' => '名古屋市西区'],
            ['pref_code' => 23, 'code' => 105, 'name' => '名古屋市中村区'],
            ['pref_code' => 23, 'code' => 106, 'name' => '名古屋市中区'],
            ['pref_code' => 23, 'code' => 107, 'name' => '名古屋市昭和区'],
            ['pref_code' => 23, 'code' => 108, 'name' => '名古屋市瑞穂区'],
            ['pref_code' => 23, 'code' => 109, 'name' => '名古屋市熱田区'],
            ['pref_code' => 23, 'code' => 110, 'name' => '名古屋市中川区'],
            ['pref_code' => 23, 'code' => 111, 'name' => '名古屋市港区'],
            ['pref_code' => 23, 'code' => 112, 'name' => '名古屋市南区'],
            ['pref_code' => 23, 'code' => 113, 'name' => '名古屋市守山区'],
            ['pref_code' => 23, 'code' => 114, 'name' => '名古屋市緑区'],
            ['pref_code' => 23, 'code' => 115, 'name' => '名古屋市名東区'],
            ['pref_code' => 23, 'code' => 116, 'name' => '名古屋市天白区'],
            ['pref_code' => 23, 'code' => 201, 'name' => '豊橋市'],
            ['pref_code' => 23, 'code' => 202, 'name' => '岡崎市'],
            ['pref_code' => 23, 'code' => 203, 'name' => '一宮市'],
            ['pref_code' => 23, 'code' => 204, 'name' => '瀬戸市'],
            ['pref_code' => 23, 'code' => 205, 'name' => '半田市'],
            ['pref_code' => 23, 'code' => 206, 'name' => '春日井市'],
            ['pref_code' => 23, 'code' => 207, 'name' => '豊川市'],
            ['pref_code' => 23, 'code' => 208, 'name' => '津島市'],
            ['pref_code' => 23, 'code' => 209, 'name' => '碧南市'],
            ['pref_code' => 23, 'code' => 210, 'name' => '刈谷市'],
            ['pref_code' => 23, 'code' => 211, 'name' => '豊田市'],
            ['pref_code' => 23, 'code' => 212, 'name' => '安城市'],
            ['pref_code' => 23, 'code' => 213, 'name' => '西尾市'],
            ['pref_code' => 23, 'code' => 214, 'name' => '蒲郡市'],
            ['pref_code' => 23, 'code' => 215, 'name' => '犬山市'],
            ['pref_code' => 23, 'code' => 216, 'name' => '常滑市'],
            ['pref_code' => 23, 'code' => 217, 'name' => '江南市'],
            ['pref_code' => 23, 'code' => 219, 'name' => '小牧市'],
            ['pref_code' => 23, 'code' => 220, 'name' => '稲沢市'],
            ['pref_code' => 23, 'code' => 221, 'name' => '新城市'],
            ['pref_code' => 23, 'code' => 222, 'name' => '東海市'],
            ['pref_code' => 23, 'code' => 223, 'name' => '大府市'],
            ['pref_code' => 23, 'code' => 224, 'name' => '知多市'],
            ['pref_code' => 23, 'code' => 225, 'name' => '知立市'],
            ['pref_code' => 23, 'code' => 226, 'name' => '尾張旭市'],
            ['pref_code' => 23, 'code' => 227, 'name' => '高浜市'],
            ['pref_code' => 23, 'code' => 228, 'name' => '岩倉市'],
            ['pref_code' => 23, 'code' => 229, 'name' => '豊明市'],
            ['pref_code' => 23, 'code' => 230, 'name' => '日進市'],
            ['pref_code' => 23, 'code' => 231, 'name' => '田原市'],
            ['pref_code' => 23, 'code' => 232, 'name' => '愛西市'],
            ['pref_code' => 23, 'code' => 233, 'name' => '清須市'],
            ['pref_code' => 23, 'code' => 234, 'name' => '北名古屋市'],
            ['pref_code' => 23, 'code' => 235, 'name' => '弥富市'],
            ['pref_code' => 23, 'code' => 236, 'name' => 'みよし市'],
            ['pref_code' => 23, 'code' => 237, 'name' => 'あま市'],
            ['pref_code' => 23, 'code' => 238, 'name' => '長久手市'],
            ['pref_code' => 23, 'code' => 302, 'name' => '愛知郡東郷町'],
            ['pref_code' => 23, 'code' => 304, 'name' => '愛知郡長久手町'],
            ['pref_code' => 23, 'code' => 342, 'name' => '西春日井郡豊山町'],
            ['pref_code' => 23, 'code' => 361, 'name' => '丹羽郡大口町'],
            ['pref_code' => 23, 'code' => 362, 'name' => '丹羽郡扶桑町'],
            ['pref_code' => 23, 'code' => 424, 'name' => '海部郡大治町'],
            ['pref_code' => 23, 'code' => 425, 'name' => '海部郡蟹江町'],
            ['pref_code' => 23, 'code' => 427, 'name' => '海部郡飛島村'],
            ['pref_code' => 23, 'code' => 441, 'name' => '知多郡阿久比町'],
            ['pref_code' => 23, 'code' => 442, 'name' => '知多郡東浦町'],
            ['pref_code' => 23, 'code' => 445, 'name' => '知多郡南知多町'],
            ['pref_code' => 23, 'code' => 446, 'name' => '知多郡美浜町'],
            ['pref_code' => 23, 'code' => 447, 'name' => '知多郡武豊町'],
            ['pref_code' => 23, 'code' => 481, 'name' => '幡豆郡一色町'],
            ['pref_code' => 23, 'code' => 482, 'name' => '幡豆郡吉良町'],
            ['pref_code' => 23, 'code' => 483, 'name' => '幡豆郡幡豆町'],
            ['pref_code' => 23, 'code' => 501, 'name' => '額田郡幸田町'],
            ['pref_code' => 23, 'code' => 561, 'name' => '北設楽郡設楽町'],
            ['pref_code' => 23, 'code' => 562, 'name' => '北設楽郡東栄町'],
            ['pref_code' => 23, 'code' => 563, 'name' => '北設楽郡豊根村'],
            ['pref_code' => 24, 'code' => 201, 'name' => '津市'],
            ['pref_code' => 24, 'code' => 202, 'name' => '四日市市'],
            ['pref_code' => 24, 'code' => 203, 'name' => '伊勢市'],
            ['pref_code' => 24, 'code' => 204, 'name' => '松阪市'],
            ['pref_code' => 24, 'code' => 205, 'name' => '桑名市'],
            ['pref_code' => 24, 'code' => 207, 'name' => '鈴鹿市'],
            ['pref_code' => 24, 'code' => 208, 'name' => '名張市'],
            ['pref_code' => 24, 'code' => 209, 'name' => '尾鷲市'],
            ['pref_code' => 24, 'code' => 210, 'name' => '亀山市'],
            ['pref_code' => 24, 'code' => 211, 'name' => '鳥羽市'],
            ['pref_code' => 24, 'code' => 212, 'name' => '熊野市'],
            ['pref_code' => 24, 'code' => 214, 'name' => 'いなべ市'],
            ['pref_code' => 24, 'code' => 215, 'name' => '志摩市'],
            ['pref_code' => 24, 'code' => 216, 'name' => '伊賀市'],
            ['pref_code' => 24, 'code' => 303, 'name' => '桑名郡木曽岬町'],
            ['pref_code' => 24, 'code' => 324, 'name' => '員弁郡東員町'],
            ['pref_code' => 24, 'code' => 341, 'name' => '三重郡菰野町'],
            ['pref_code' => 24, 'code' => 343, 'name' => '三重郡朝日町'],
            ['pref_code' => 24, 'code' => 344, 'name' => '三重郡川越町'],
            ['pref_code' => 24, 'code' => 441, 'name' => '多気郡多気町'],
            ['pref_code' => 24, 'code' => 442, 'name' => '多気郡明和町'],
            ['pref_code' => 24, 'code' => 443, 'name' => '多気郡大台町'],
            ['pref_code' => 24, 'code' => 461, 'name' => '度会郡玉城町'],
            ['pref_code' => 24, 'code' => 470, 'name' => '度会郡度会町'],
            ['pref_code' => 24, 'code' => 471, 'name' => '度会郡大紀町'],
            ['pref_code' => 24, 'code' => 472, 'name' => '度会郡南伊勢町'],
            ['pref_code' => 24, 'code' => 543, 'name' => '北牟婁郡紀北町'],
            ['pref_code' => 24, 'code' => 561, 'name' => '南牟婁郡御浜町'],
            ['pref_code' => 24, 'code' => 562, 'name' => '南牟婁郡紀宝町'],
            ['pref_code' => 25, 'code' => 201, 'name' => '大津市'],
            ['pref_code' => 25, 'code' => 202, 'name' => '彦根市'],
            ['pref_code' => 25, 'code' => 203, 'name' => '長浜市'],
            ['pref_code' => 25, 'code' => 204, 'name' => '近江八幡市'],
            ['pref_code' => 25, 'code' => 206, 'name' => '草津市'],
            ['pref_code' => 25, 'code' => 207, 'name' => '守山市'],
            ['pref_code' => 25, 'code' => 208, 'name' => '栗東市'],
            ['pref_code' => 25, 'code' => 209, 'name' => '甲賀市'],
            ['pref_code' => 25, 'code' => 210, 'name' => '野洲市'],
            ['pref_code' => 25, 'code' => 211, 'name' => '湖南市'],
            ['pref_code' => 25, 'code' => 212, 'name' => '高島市'],
            ['pref_code' => 25, 'code' => 213, 'name' => '東近江市'],
            ['pref_code' => 25, 'code' => 214, 'name' => '米原市'],
            ['pref_code' => 25, 'code' => 383, 'name' => '蒲生郡日野町'],
            ['pref_code' => 25, 'code' => 384, 'name' => '蒲生郡竜王町'],
            ['pref_code' => 25, 'code' => 425, 'name' => '愛知郡愛荘町'],
            ['pref_code' => 25, 'code' => 441, 'name' => '犬上郡豊郷町'],
            ['pref_code' => 25, 'code' => 442, 'name' => '犬上郡甲良町'],
            ['pref_code' => 25, 'code' => 443, 'name' => '犬上郡多賀町'],
            ['pref_code' => 26, 'code' => 101, 'name' => '京都市北区'],
            ['pref_code' => 26, 'code' => 102, 'name' => '京都市上京区'],
            ['pref_code' => 26, 'code' => 103, 'name' => '京都市左京区'],
            ['pref_code' => 26, 'code' => 104, 'name' => '京都市中京区'],
            ['pref_code' => 26, 'code' => 105, 'name' => '京都市東山区'],
            ['pref_code' => 26, 'code' => 106, 'name' => '京都市下京区'],
            ['pref_code' => 26, 'code' => 107, 'name' => '京都市南区'],
            ['pref_code' => 26, 'code' => 108, 'name' => '京都市右京区'],
            ['pref_code' => 26, 'code' => 109, 'name' => '京都市伏見区'],
            ['pref_code' => 26, 'code' => 110, 'name' => '京都市山科区'],
            ['pref_code' => 26, 'code' => 111, 'name' => '京都市西京区'],
            ['pref_code' => 26, 'code' => 201, 'name' => '福知山市'],
            ['pref_code' => 26, 'code' => 202, 'name' => '舞鶴市'],
            ['pref_code' => 26, 'code' => 203, 'name' => '綾部市'],
            ['pref_code' => 26, 'code' => 204, 'name' => '宇治市'],
            ['pref_code' => 26, 'code' => 205, 'name' => '宮津市'],
            ['pref_code' => 26, 'code' => 206, 'name' => '亀岡市'],
            ['pref_code' => 26, 'code' => 207, 'name' => '城陽市'],
            ['pref_code' => 26, 'code' => 208, 'name' => '向日市'],
            ['pref_code' => 26, 'code' => 209, 'name' => '長岡京市'],
            ['pref_code' => 26, 'code' => 210, 'name' => '八幡市'],
            ['pref_code' => 26, 'code' => 211, 'name' => '京田辺市'],
            ['pref_code' => 26, 'code' => 212, 'name' => '京丹後市'],
            ['pref_code' => 26, 'code' => 213, 'name' => '南丹市'],
            ['pref_code' => 26, 'code' => 214, 'name' => '木津川市'],
            ['pref_code' => 26, 'code' => 303, 'name' => '乙訓郡大山崎町'],
            ['pref_code' => 26, 'code' => 322, 'name' => '久世郡久御山町'],
            ['pref_code' => 26, 'code' => 343, 'name' => '綴喜郡井手町'],
            ['pref_code' => 26, 'code' => 344, 'name' => '綴喜郡宇治田原町'],
            ['pref_code' => 26, 'code' => 364, 'name' => '相楽郡笠置町'],
            ['pref_code' => 26, 'code' => 365, 'name' => '相楽郡和束町'],
            ['pref_code' => 26, 'code' => 366, 'name' => '相楽郡精華町'],
            ['pref_code' => 26, 'code' => 367, 'name' => '相楽郡南山城村'],
            ['pref_code' => 26, 'code' => 407, 'name' => '船井郡京丹波町'],
            ['pref_code' => 26, 'code' => 463, 'name' => '与謝郡伊根町'],
            ['pref_code' => 26, 'code' => 465, 'name' => '与謝郡与謝野町'],
            ['pref_code' => 27, 'code' => 102, 'name' => '大阪市都島区'],
            ['pref_code' => 27, 'code' => 103, 'name' => '大阪市福島区'],
            ['pref_code' => 27, 'code' => 104, 'name' => '大阪市此花区'],
            ['pref_code' => 27, 'code' => 106, 'name' => '大阪市西区'],
            ['pref_code' => 27, 'code' => 107, 'name' => '大阪市港区'],
            ['pref_code' => 27, 'code' => 108, 'name' => '大阪市大正区'],
            ['pref_code' => 27, 'code' => 109, 'name' => '大阪市天王寺区'],
            ['pref_code' => 27, 'code' => 111, 'name' => '大阪市浪速区'],
            ['pref_code' => 27, 'code' => 113, 'name' => '大阪市西淀川区'],
            ['pref_code' => 27, 'code' => 114, 'name' => '大阪市東淀川区'],
            ['pref_code' => 27, 'code' => 115, 'name' => '大阪市東成区'],
            ['pref_code' => 27, 'code' => 116, 'name' => '大阪市生野区'],
            ['pref_code' => 27, 'code' => 117, 'name' => '大阪市旭区'],
            ['pref_code' => 27, 'code' => 118, 'name' => '大阪市城東区'],
            ['pref_code' => 27, 'code' => 119, 'name' => '大阪市阿倍野区'],
            ['pref_code' => 27, 'code' => 120, 'name' => '大阪市住吉区'],
            ['pref_code' => 27, 'code' => 121, 'name' => '大阪市東住吉区'],
            ['pref_code' => 27, 'code' => 122, 'name' => '大阪市西成区'],
            ['pref_code' => 27, 'code' => 123, 'name' => '大阪市淀川区'],
            ['pref_code' => 27, 'code' => 124, 'name' => '大阪市鶴見区'],
            ['pref_code' => 27, 'code' => 125, 'name' => '大阪市住之江区'],
            ['pref_code' => 27, 'code' => 126, 'name' => '大阪市平野区'],
            ['pref_code' => 27, 'code' => 127, 'name' => '大阪市北区'],
            ['pref_code' => 27, 'code' => 128, 'name' => '大阪市中央区'],
            ['pref_code' => 27, 'code' => 141, 'name' => '堺市堺区'],
            ['pref_code' => 27, 'code' => 142, 'name' => '堺市中区'],
            ['pref_code' => 27, 'code' => 143, 'name' => '堺市東区'],
            ['pref_code' => 27, 'code' => 144, 'name' => '堺市西区'],
            ['pref_code' => 27, 'code' => 145, 'name' => '堺市南区'],
            ['pref_code' => 27, 'code' => 146, 'name' => '堺市北区'],
            ['pref_code' => 27, 'code' => 147, 'name' => '堺市美原区'],
            ['pref_code' => 27, 'code' => 202, 'name' => '岸和田市'],
            ['pref_code' => 27, 'code' => 203, 'name' => '豊中市'],
            ['pref_code' => 27, 'code' => 204, 'name' => '池田市'],
            ['pref_code' => 27, 'code' => 205, 'name' => '吹田市'],
            ['pref_code' => 27, 'code' => 206, 'name' => '泉大津市'],
            ['pref_code' => 27, 'code' => 207, 'name' => '高槻市'],
            ['pref_code' => 27, 'code' => 208, 'name' => '貝塚市'],
            ['pref_code' => 27, 'code' => 209, 'name' => '守口市'],
            ['pref_code' => 27, 'code' => 210, 'name' => '枚方市'],
            ['pref_code' => 27, 'code' => 211, 'name' => '茨木市'],
            ['pref_code' => 27, 'code' => 212, 'name' => '八尾市'],
            ['pref_code' => 27, 'code' => 213, 'name' => '泉佐野市'],
            ['pref_code' => 27, 'code' => 214, 'name' => '富田林市'],
            ['pref_code' => 27, 'code' => 215, 'name' => '寝屋川市'],
            ['pref_code' => 27, 'code' => 216, 'name' => '河内長野市'],
            ['pref_code' => 27, 'code' => 217, 'name' => '松原市'],
            ['pref_code' => 27, 'code' => 218, 'name' => '大東市'],
            ['pref_code' => 27, 'code' => 219, 'name' => '和泉市'],
            ['pref_code' => 27, 'code' => 220, 'name' => '箕面市'],
            ['pref_code' => 27, 'code' => 221, 'name' => '柏原市'],
            ['pref_code' => 27, 'code' => 222, 'name' => '羽曳野市'],
            ['pref_code' => 27, 'code' => 223, 'name' => '門真市'],
            ['pref_code' => 27, 'code' => 224, 'name' => '摂津市'],
            ['pref_code' => 27, 'code' => 225, 'name' => '高石市'],
            ['pref_code' => 27, 'code' => 226, 'name' => '藤井寺市'],
            ['pref_code' => 27, 'code' => 227, 'name' => '東大阪市'],
            ['pref_code' => 27, 'code' => 228, 'name' => '泉南市'],
            ['pref_code' => 27, 'code' => 229, 'name' => '四條畷市'],
            ['pref_code' => 27, 'code' => 230, 'name' => '交野市'],
            ['pref_code' => 27, 'code' => 231, 'name' => '大阪狭山市'],
            ['pref_code' => 27, 'code' => 232, 'name' => '阪南市'],
            ['pref_code' => 27, 'code' => 301, 'name' => '三島郡島本町'],
            ['pref_code' => 27, 'code' => 321, 'name' => '豊能郡豊能町'],
            ['pref_code' => 27, 'code' => 322, 'name' => '豊能郡能勢町'],
            ['pref_code' => 27, 'code' => 341, 'name' => '泉北郡忠岡町'],
            ['pref_code' => 27, 'code' => 361, 'name' => '泉南郡熊取町'],
            ['pref_code' => 27, 'code' => 362, 'name' => '泉南郡田尻町'],
            ['pref_code' => 27, 'code' => 366, 'name' => '泉南郡岬町'],
            ['pref_code' => 27, 'code' => 381, 'name' => '南河内郡太子町'],
            ['pref_code' => 27, 'code' => 382, 'name' => '南河内郡河南町'],
            ['pref_code' => 27, 'code' => 383, 'name' => '南河内郡千早赤阪村'],
            ['pref_code' => 28, 'code' => 101, 'name' => '神戸市東灘区'],
            ['pref_code' => 28, 'code' => 102, 'name' => '神戸市灘区'],
            ['pref_code' => 28, 'code' => 105, 'name' => '神戸市兵庫区'],
            ['pref_code' => 28, 'code' => 106, 'name' => '神戸市長田区'],
            ['pref_code' => 28, 'code' => 107, 'name' => '神戸市須磨区'],
            ['pref_code' => 28, 'code' => 108, 'name' => '神戸市垂水区'],
            ['pref_code' => 28, 'code' => 109, 'name' => '神戸市北区'],
            ['pref_code' => 28, 'code' => 110, 'name' => '神戸市中央区'],
            ['pref_code' => 28, 'code' => 111, 'name' => '神戸市西区'],
            ['pref_code' => 28, 'code' => 201, 'name' => '姫路市'],
            ['pref_code' => 28, 'code' => 202, 'name' => '尼崎市'],
            ['pref_code' => 28, 'code' => 203, 'name' => '明石市'],
            ['pref_code' => 28, 'code' => 204, 'name' => '西宮市'],
            ['pref_code' => 28, 'code' => 205, 'name' => '洲本市'],
            ['pref_code' => 28, 'code' => 206, 'name' => '芦屋市'],
            ['pref_code' => 28, 'code' => 207, 'name' => '伊丹市'],
            ['pref_code' => 28, 'code' => 208, 'name' => '相生市'],
            ['pref_code' => 28, 'code' => 209, 'name' => '豊岡市'],
            ['pref_code' => 28, 'code' => 210, 'name' => '加古川市'],
            ['pref_code' => 28, 'code' => 212, 'name' => '赤穂市'],
            ['pref_code' => 28, 'code' => 213, 'name' => '西脇市'],
            ['pref_code' => 28, 'code' => 214, 'name' => '宝塚市'],
            ['pref_code' => 28, 'code' => 215, 'name' => '三木市'],
            ['pref_code' => 28, 'code' => 216, 'name' => '高砂市'],
            ['pref_code' => 28, 'code' => 217, 'name' => '川西市'],
            ['pref_code' => 28, 'code' => 218, 'name' => '小野市'],
            ['pref_code' => 28, 'code' => 219, 'name' => '三田市'],
            ['pref_code' => 28, 'code' => 220, 'name' => '加西市'],
            ['pref_code' => 28, 'code' => 221, 'name' => '篠山市'],
            ['pref_code' => 28, 'code' => 222, 'name' => '養父市'],
            ['pref_code' => 28, 'code' => 223, 'name' => '丹波市'],
            ['pref_code' => 28, 'code' => 224, 'name' => '南あわじ市'],
            ['pref_code' => 28, 'code' => 225, 'name' => '朝来市'],
            ['pref_code' => 28, 'code' => 226, 'name' => '淡路市'],
            ['pref_code' => 28, 'code' => 227, 'name' => '宍粟市'],
            ['pref_code' => 28, 'code' => 228, 'name' => '加東市'],
            ['pref_code' => 28, 'code' => 229, 'name' => 'たつの市'],
            ['pref_code' => 28, 'code' => 301, 'name' => '川辺郡猪名川町'],
            ['pref_code' => 28, 'code' => 365, 'name' => '多可郡多可町'],
            ['pref_code' => 28, 'code' => 381, 'name' => '加古郡稲美町'],
            ['pref_code' => 28, 'code' => 382, 'name' => '加古郡播磨町'],
            ['pref_code' => 28, 'code' => 442, 'name' => '神崎郡市川町'],
            ['pref_code' => 28, 'code' => 443, 'name' => '神崎郡福崎町'],
            ['pref_code' => 28, 'code' => 446, 'name' => '神崎郡神河町'],
            ['pref_code' => 28, 'code' => 464, 'name' => '揖保郡太子町'],
            ['pref_code' => 28, 'code' => 481, 'name' => '赤穂郡上郡町'],
            ['pref_code' => 28, 'code' => 501, 'name' => '佐用郡佐用町'],
            ['pref_code' => 28, 'code' => 585, 'name' => '美方郡香美町'],
            ['pref_code' => 28, 'code' => 586, 'name' => '美方郡新温泉町'],
            ['pref_code' => 29, 'code' => 201, 'name' => '奈良市'],
            ['pref_code' => 29, 'code' => 202, 'name' => '大和高田市'],
            ['pref_code' => 29, 'code' => 203, 'name' => '大和郡山市'],
            ['pref_code' => 29, 'code' => 204, 'name' => '天理市'],
            ['pref_code' => 29, 'code' => 205, 'name' => '橿原市'],
            ['pref_code' => 29, 'code' => 206, 'name' => '桜井市'],
            ['pref_code' => 29, 'code' => 207, 'name' => '五條市'],
            ['pref_code' => 29, 'code' => 208, 'name' => '御所市'],
            ['pref_code' => 29, 'code' => 209, 'name' => '生駒市'],
            ['pref_code' => 29, 'code' => 210, 'name' => '香芝市'],
            ['pref_code' => 29, 'code' => 211, 'name' => '葛城市'],
            ['pref_code' => 29, 'code' => 212, 'name' => '宇陀市'],
            ['pref_code' => 29, 'code' => 322, 'name' => '山辺郡山添村'],
            ['pref_code' => 29, 'code' => 342, 'name' => '生駒郡平群町'],
            ['pref_code' => 29, 'code' => 343, 'name' => '生駒郡三郷町'],
            ['pref_code' => 29, 'code' => 344, 'name' => '生駒郡斑鳩町'],
            ['pref_code' => 29, 'code' => 345, 'name' => '生駒郡安堵町'],
            ['pref_code' => 29, 'code' => 361, 'name' => '磯城郡川西町'],
            ['pref_code' => 29, 'code' => 362, 'name' => '磯城郡三宅町'],
            ['pref_code' => 29, 'code' => 363, 'name' => '磯城郡田原本町'],
            ['pref_code' => 29, 'code' => 385, 'name' => '宇陀郡曽爾村'],
            ['pref_code' => 29, 'code' => 386, 'name' => '宇陀郡御杖村'],
            ['pref_code' => 29, 'code' => 401, 'name' => '高市郡高取町'],
            ['pref_code' => 29, 'code' => 402, 'name' => '高市郡明日香村'],
            ['pref_code' => 29, 'code' => 424, 'name' => '北葛城郡上牧町'],
            ['pref_code' => 29, 'code' => 425, 'name' => '北葛城郡王寺町'],
            ['pref_code' => 29, 'code' => 426, 'name' => '北葛城郡広陵町'],
            ['pref_code' => 29, 'code' => 427, 'name' => '北葛城郡河合町'],
            ['pref_code' => 29, 'code' => 441, 'name' => '吉野郡吉野町'],
            ['pref_code' => 29, 'code' => 442, 'name' => '吉野郡大淀町'],
            ['pref_code' => 29, 'code' => 443, 'name' => '吉野郡下市町'],
            ['pref_code' => 29, 'code' => 444, 'name' => '吉野郡黒滝村'],
            ['pref_code' => 29, 'code' => 446, 'name' => '吉野郡天川村'],
            ['pref_code' => 29, 'code' => 447, 'name' => '吉野郡野迫川村'],
            ['pref_code' => 29, 'code' => 449, 'name' => '吉野郡十津川村'],
            ['pref_code' => 29, 'code' => 450, 'name' => '吉野郡下北山村'],
            ['pref_code' => 29, 'code' => 451, 'name' => '吉野郡上北山村'],
            ['pref_code' => 29, 'code' => 452, 'name' => '吉野郡川上村'],
            ['pref_code' => 29, 'code' => 453, 'name' => '吉野郡東吉野村'],
            ['pref_code' => 30, 'code' => 201, 'name' => '和歌山市'],
            ['pref_code' => 30, 'code' => 202, 'name' => '海南市'],
            ['pref_code' => 30, 'code' => 203, 'name' => '橋本市'],
            ['pref_code' => 30, 'code' => 204, 'name' => '有田市'],
            ['pref_code' => 30, 'code' => 205, 'name' => '御坊市'],
            ['pref_code' => 30, 'code' => 206, 'name' => '田辺市'],
            ['pref_code' => 30, 'code' => 207, 'name' => '新宮市'],
            ['pref_code' => 30, 'code' => 208, 'name' => '紀の川市'],
            ['pref_code' => 30, 'code' => 209, 'name' => '岩出市'],
            ['pref_code' => 30, 'code' => 304, 'name' => '海草郡紀美野町'],
            ['pref_code' => 30, 'code' => 341, 'name' => '伊都郡かつらぎ町'],
            ['pref_code' => 30, 'code' => 343, 'name' => '伊都郡九度山町'],
            ['pref_code' => 30, 'code' => 344, 'name' => '伊都郡高野町'],
            ['pref_code' => 30, 'code' => 361, 'name' => '有田郡湯浅町'],
            ['pref_code' => 30, 'code' => 362, 'name' => '有田郡広川町'],
            ['pref_code' => 30, 'code' => 366, 'name' => '有田郡有田川町'],
            ['pref_code' => 30, 'code' => 381, 'name' => '日高郡美浜町'],
            ['pref_code' => 30, 'code' => 382, 'name' => '日高郡日高町'],
            ['pref_code' => 30, 'code' => 383, 'name' => '日高郡由良町'],
            ['pref_code' => 30, 'code' => 390, 'name' => '日高郡印南町'],
            ['pref_code' => 30, 'code' => 391, 'name' => '日高郡みなべ町'],
            ['pref_code' => 30, 'code' => 392, 'name' => '日高郡日高川町'],
            ['pref_code' => 30, 'code' => 401, 'name' => '西牟婁郡白浜町'],
            ['pref_code' => 30, 'code' => 404, 'name' => '西牟婁郡上富田町'],
            ['pref_code' => 30, 'code' => 406, 'name' => '西牟婁郡すさみ町'],
            ['pref_code' => 30, 'code' => 421, 'name' => '東牟婁郡那智勝浦町'],
            ['pref_code' => 30, 'code' => 422, 'name' => '東牟婁郡太地町'],
            ['pref_code' => 30, 'code' => 424, 'name' => '東牟婁郡古座川町'],
            ['pref_code' => 30, 'code' => 427, 'name' => '東牟婁郡北山村'],
            ['pref_code' => 30, 'code' => 428, 'name' => '東牟婁郡串本町'],
            ['pref_code' => 31, 'code' => 201, 'name' => '鳥取市'],
            ['pref_code' => 31, 'code' => 202, 'name' => '米子市'],
            ['pref_code' => 31, 'code' => 203, 'name' => '倉吉市'],
            ['pref_code' => 31, 'code' => 204, 'name' => '境港市'],
            ['pref_code' => 31, 'code' => 302, 'name' => '岩美郡岩美町'],
            ['pref_code' => 31, 'code' => 325, 'name' => '八頭郡若桜町'],
            ['pref_code' => 31, 'code' => 328, 'name' => '八頭郡智頭町'],
            ['pref_code' => 31, 'code' => 329, 'name' => '八頭郡八頭町'],
            ['pref_code' => 31, 'code' => 364, 'name' => '東伯郡三朝町'],
            ['pref_code' => 31, 'code' => 370, 'name' => '東伯郡湯梨浜町'],
            ['pref_code' => 31, 'code' => 371, 'name' => '東伯郡琴浦町'],
            ['pref_code' => 31, 'code' => 372, 'name' => '東伯郡北栄町'],
            ['pref_code' => 31, 'code' => 384, 'name' => '西伯郡日吉津村'],
            ['pref_code' => 31, 'code' => 386, 'name' => '西伯郡大山町'],
            ['pref_code' => 31, 'code' => 389, 'name' => '西伯郡南部町'],
            ['pref_code' => 31, 'code' => 390, 'name' => '西伯郡伯耆町'],
            ['pref_code' => 31, 'code' => 401, 'name' => '日野郡日南町'],
            ['pref_code' => 31, 'code' => 402, 'name' => '日野郡日野町'],
            ['pref_code' => 31, 'code' => 403, 'name' => '日野郡江府町'],
            ['pref_code' => 32, 'code' => 201, 'name' => '松江市'],
            ['pref_code' => 32, 'code' => 202, 'name' => '浜田市'],
            ['pref_code' => 32, 'code' => 203, 'name' => '出雲市'],
            ['pref_code' => 32, 'code' => 204, 'name' => '益田市'],
            ['pref_code' => 32, 'code' => 205, 'name' => '大田市'],
            ['pref_code' => 32, 'code' => 206, 'name' => '安来市'],
            ['pref_code' => 32, 'code' => 207, 'name' => '江津市'],
            ['pref_code' => 32, 'code' => 209, 'name' => '雲南市'],
            ['pref_code' => 32, 'code' => 304, 'name' => '八束郡東出雲町'],
            ['pref_code' => 32, 'code' => 343, 'name' => '仁多郡奥出雲町'],
            ['pref_code' => 32, 'code' => 386, 'name' => '飯石郡飯南町'],
            ['pref_code' => 32, 'code' => 401, 'name' => '簸川郡斐川町'],
            ['pref_code' => 32, 'code' => 441, 'name' => '邑智郡川本町'],
            ['pref_code' => 32, 'code' => 448, 'name' => '邑智郡美郷町'],
            ['pref_code' => 32, 'code' => 449, 'name' => '邑智郡邑南町'],
            ['pref_code' => 32, 'code' => 501, 'name' => '鹿足郡津和野町'],
            ['pref_code' => 32, 'code' => 505, 'name' => '鹿足郡吉賀町'],
            ['pref_code' => 32, 'code' => 525, 'name' => '隠岐郡海士町'],
            ['pref_code' => 32, 'code' => 526, 'name' => '隠岐郡西ノ島町'],
            ['pref_code' => 32, 'code' => 527, 'name' => '隠岐郡知夫村'],
            ['pref_code' => 32, 'code' => 528, 'name' => '隠岐郡隠岐の島町'],
            ['pref_code' => 33, 'code' => 101, 'name' => '岡山市北区'],
            ['pref_code' => 33, 'code' => 102, 'name' => '岡山市中区'],
            ['pref_code' => 33, 'code' => 103, 'name' => '岡山市東区'],
            ['pref_code' => 33, 'code' => 104, 'name' => '岡山市南区'],
            ['pref_code' => 33, 'code' => 202, 'name' => '倉敷市'],
            ['pref_code' => 33, 'code' => 203, 'name' => '津山市'],
            ['pref_code' => 33, 'code' => 204, 'name' => '玉野市'],
            ['pref_code' => 33, 'code' => 205, 'name' => '笠岡市'],
            ['pref_code' => 33, 'code' => 207, 'name' => '井原市'],
            ['pref_code' => 33, 'code' => 208, 'name' => '総社市'],
            ['pref_code' => 33, 'code' => 209, 'name' => '高梁市'],
            ['pref_code' => 33, 'code' => 210, 'name' => '新見市'],
            ['pref_code' => 33, 'code' => 211, 'name' => '備前市'],
            ['pref_code' => 33, 'code' => 212, 'name' => '瀬戸内市'],
            ['pref_code' => 33, 'code' => 213, 'name' => '赤磐市'],
            ['pref_code' => 33, 'code' => 214, 'name' => '真庭市'],
            ['pref_code' => 33, 'code' => 215, 'name' => '美作市'],
            ['pref_code' => 33, 'code' => 216, 'name' => '浅口市'],
            ['pref_code' => 33, 'code' => 346, 'name' => '和気郡和気町'],
            ['pref_code' => 33, 'code' => 423, 'name' => '都窪郡早島町'],
            ['pref_code' => 33, 'code' => 445, 'name' => '浅口郡里庄町'],
            ['pref_code' => 33, 'code' => 461, 'name' => '小田郡矢掛町'],
            ['pref_code' => 33, 'code' => 586, 'name' => '真庭郡新庄村'],
            ['pref_code' => 33, 'code' => 606, 'name' => '苫田郡鏡野町'],
            ['pref_code' => 33, 'code' => 622, 'name' => '勝田郡勝央町'],
            ['pref_code' => 33, 'code' => 623, 'name' => '勝田郡奈義町'],
            ['pref_code' => 33, 'code' => 643, 'name' => '英田郡西粟倉村'],
            ['pref_code' => 33, 'code' => 663, 'name' => '久米郡久米南町'],
            ['pref_code' => 33, 'code' => 666, 'name' => '久米郡美咲町'],
            ['pref_code' => 33, 'code' => 681, 'name' => '加賀郡吉備中央町'],
            ['pref_code' => 34, 'code' => 101, 'name' => '広島市中区'],
            ['pref_code' => 34, 'code' => 102, 'name' => '広島市東区'],
            ['pref_code' => 34, 'code' => 103, 'name' => '広島市南区'],
            ['pref_code' => 34, 'code' => 104, 'name' => '広島市西区'],
            ['pref_code' => 34, 'code' => 105, 'name' => '広島市安佐南区'],
            ['pref_code' => 34, 'code' => 106, 'name' => '広島市安佐北区'],
            ['pref_code' => 34, 'code' => 107, 'name' => '広島市安芸区'],
            ['pref_code' => 34, 'code' => 108, 'name' => '広島市佐伯区'],
            ['pref_code' => 34, 'code' => 202, 'name' => '呉市'],
            ['pref_code' => 34, 'code' => 203, 'name' => '竹原市'],
            ['pref_code' => 34, 'code' => 204, 'name' => '三原市'],
            ['pref_code' => 34, 'code' => 205, 'name' => '尾道市'],
            ['pref_code' => 34, 'code' => 207, 'name' => '福山市'],
            ['pref_code' => 34, 'code' => 208, 'name' => '府中市'],
            ['pref_code' => 34, 'code' => 209, 'name' => '三次市'],
            ['pref_code' => 34, 'code' => 210, 'name' => '庄原市'],
            ['pref_code' => 34, 'code' => 211, 'name' => '大竹市'],
            ['pref_code' => 34, 'code' => 212, 'name' => '東広島市'],
            ['pref_code' => 34, 'code' => 213, 'name' => '廿日市市'],
            ['pref_code' => 34, 'code' => 214, 'name' => '安芸高田市'],
            ['pref_code' => 34, 'code' => 215, 'name' => '江田島市'],
            ['pref_code' => 34, 'code' => 302, 'name' => '安芸郡府中町'],
            ['pref_code' => 34, 'code' => 304, 'name' => '安芸郡海田町'],
            ['pref_code' => 34, 'code' => 307, 'name' => '安芸郡熊野町'],
            ['pref_code' => 34, 'code' => 309, 'name' => '安芸郡坂町'],
            ['pref_code' => 34, 'code' => 368, 'name' => '山県郡安芸太田町'],
            ['pref_code' => 34, 'code' => 369, 'name' => '山県郡北広島町'],
            ['pref_code' => 34, 'code' => 431, 'name' => '豊田郡大崎上島町'],
            ['pref_code' => 34, 'code' => 462, 'name' => '世羅郡世羅町'],
            ['pref_code' => 34, 'code' => 545, 'name' => '神石郡神石高原町'],
            ['pref_code' => 35, 'code' => 201, 'name' => '下関市'],
            ['pref_code' => 35, 'code' => 202, 'name' => '宇部市'],
            ['pref_code' => 35, 'code' => 203, 'name' => '山口市'],
            ['pref_code' => 35, 'code' => 204, 'name' => '萩市'],
            ['pref_code' => 35, 'code' => 206, 'name' => '防府市'],
            ['pref_code' => 35, 'code' => 207, 'name' => '下松市'],
            ['pref_code' => 35, 'code' => 208, 'name' => '岩国市'],
            ['pref_code' => 35, 'code' => 210, 'name' => '光市'],
            ['pref_code' => 35, 'code' => 211, 'name' => '長門市'],
            ['pref_code' => 35, 'code' => 212, 'name' => '柳井市'],
            ['pref_code' => 35, 'code' => 213, 'name' => '美祢市'],
            ['pref_code' => 35, 'code' => 215, 'name' => '周南市'],
            ['pref_code' => 35, 'code' => 216, 'name' => '山陽小野田市'],
            ['pref_code' => 35, 'code' => 305, 'name' => '大島郡周防大島町'],
            ['pref_code' => 35, 'code' => 321, 'name' => '玖珂郡和木町'],
            ['pref_code' => 35, 'code' => 341, 'name' => '熊毛郡上関町'],
            ['pref_code' => 35, 'code' => 343, 'name' => '熊毛郡田布施町'],
            ['pref_code' => 35, 'code' => 344, 'name' => '熊毛郡平生町'],
            ['pref_code' => 35, 'code' => 502, 'name' => '阿武郡阿武町'],
            ['pref_code' => 36, 'code' => 201, 'name' => '徳島市'],
            ['pref_code' => 36, 'code' => 202, 'name' => '鳴門市'],
            ['pref_code' => 36, 'code' => 203, 'name' => '小松島市'],
            ['pref_code' => 36, 'code' => 204, 'name' => '阿南市'],
            ['pref_code' => 36, 'code' => 205, 'name' => '吉野川市'],
            ['pref_code' => 36, 'code' => 206, 'name' => '阿波市'],
            ['pref_code' => 36, 'code' => 207, 'name' => '美馬市'],
            ['pref_code' => 36, 'code' => 208, 'name' => '三好市'],
            ['pref_code' => 36, 'code' => 301, 'name' => '勝浦郡勝浦町'],
            ['pref_code' => 36, 'code' => 302, 'name' => '勝浦郡上勝町'],
            ['pref_code' => 36, 'code' => 321, 'name' => '名東郡佐那河内村'],
            ['pref_code' => 36, 'code' => 341, 'name' => '名西郡石井町'],
            ['pref_code' => 36, 'code' => 342, 'name' => '名西郡神山町'],
            ['pref_code' => 36, 'code' => 368, 'name' => '那賀郡那賀町'],
            ['pref_code' => 36, 'code' => 383, 'name' => '海部郡牟岐町'],
            ['pref_code' => 36, 'code' => 387, 'name' => '海部郡美波町'],
            ['pref_code' => 36, 'code' => 388, 'name' => '海部郡海陽町'],
            ['pref_code' => 36, 'code' => 401, 'name' => '板野郡松茂町'],
            ['pref_code' => 36, 'code' => 402, 'name' => '板野郡北島町'],
            ['pref_code' => 36, 'code' => 403, 'name' => '板野郡藍住町'],
            ['pref_code' => 36, 'code' => 404, 'name' => '板野郡板野町'],
            ['pref_code' => 36, 'code' => 405, 'name' => '板野郡上板町'],
            ['pref_code' => 36, 'code' => 468, 'name' => '美馬郡つるぎ町'],
            ['pref_code' => 36, 'code' => 489, 'name' => '三好郡東みよし町'],
            ['pref_code' => 37, 'code' => 201, 'name' => '高松市'],
            ['pref_code' => 37, 'code' => 202, 'name' => '丸亀市'],
            ['pref_code' => 37, 'code' => 203, 'name' => '坂出市'],
            ['pref_code' => 37, 'code' => 204, 'name' => '善通寺市'],
            ['pref_code' => 37, 'code' => 205, 'name' => '観音寺市'],
            ['pref_code' => 37, 'code' => 206, 'name' => 'さぬき市'],
            ['pref_code' => 37, 'code' => 207, 'name' => '東かがわ市'],
            ['pref_code' => 37, 'code' => 208, 'name' => '三豊市'],
            ['pref_code' => 37, 'code' => 322, 'name' => '小豆郡土庄町'],
            ['pref_code' => 37, 'code' => 324, 'name' => '小豆郡小豆島町'],
            ['pref_code' => 37, 'code' => 341, 'name' => '木田郡三木町'],
            ['pref_code' => 37, 'code' => 364, 'name' => '香川郡直島町'],
            ['pref_code' => 37, 'code' => 386, 'name' => '綾歌郡宇多津町'],
            ['pref_code' => 37, 'code' => 387, 'name' => '綾歌郡綾川町'],
            ['pref_code' => 37, 'code' => 403, 'name' => '仲多度郡琴平町'],
            ['pref_code' => 37, 'code' => 404, 'name' => '仲多度郡多度津町'],
            ['pref_code' => 37, 'code' => 406, 'name' => '仲多度郡まんのう町'],
            ['pref_code' => 38, 'code' => 201, 'name' => '松山市'],
            ['pref_code' => 38, 'code' => 202, 'name' => '今治市'],
            ['pref_code' => 38, 'code' => 203, 'name' => '宇和島市'],
            ['pref_code' => 38, 'code' => 204, 'name' => '八幡浜市'],
            ['pref_code' => 38, 'code' => 205, 'name' => '新居浜市'],
            ['pref_code' => 38, 'code' => 206, 'name' => '西条市'],
            ['pref_code' => 38, 'code' => 207, 'name' => '大洲市'],
            ['pref_code' => 38, 'code' => 210, 'name' => '伊予市'],
            ['pref_code' => 38, 'code' => 213, 'name' => '四国中央市'],
            ['pref_code' => 38, 'code' => 214, 'name' => '西予市'],
            ['pref_code' => 38, 'code' => 215, 'name' => '東温市'],
            ['pref_code' => 38, 'code' => 356, 'name' => '越智郡上島町'],
            ['pref_code' => 38, 'code' => 386, 'name' => '上浮穴郡久万高原町'],
            ['pref_code' => 38, 'code' => 401, 'name' => '伊予郡松前町'],
            ['pref_code' => 38, 'code' => 402, 'name' => '伊予郡砥部町'],
            ['pref_code' => 38, 'code' => 422, 'name' => '喜多郡内子町'],
            ['pref_code' => 38, 'code' => 442, 'name' => '西宇和郡伊方町'],
            ['pref_code' => 38, 'code' => 484, 'name' => '北宇和郡松野町'],
            ['pref_code' => 38, 'code' => 488, 'name' => '北宇和郡鬼北町'],
            ['pref_code' => 38, 'code' => 506, 'name' => '南宇和郡愛南町'],
            ['pref_code' => 39, 'code' => 201, 'name' => '高知市'],
            ['pref_code' => 39, 'code' => 202, 'name' => '室戸市'],
            ['pref_code' => 39, 'code' => 203, 'name' => '安芸市'],
            ['pref_code' => 39, 'code' => 204, 'name' => '南国市'],
            ['pref_code' => 39, 'code' => 205, 'name' => '土佐市'],
            ['pref_code' => 39, 'code' => 206, 'name' => '須崎市'],
            ['pref_code' => 39, 'code' => 208, 'name' => '宿毛市'],
            ['pref_code' => 39, 'code' => 209, 'name' => '土佐清水市'],
            ['pref_code' => 39, 'code' => 210, 'name' => '四万十市'],
            ['pref_code' => 39, 'code' => 211, 'name' => '香南市'],
            ['pref_code' => 39, 'code' => 212, 'name' => '香美市'],
            ['pref_code' => 39, 'code' => 301, 'name' => '安芸郡東洋町'],
            ['pref_code' => 39, 'code' => 302, 'name' => '安芸郡奈半利町'],
            ['pref_code' => 39, 'code' => 303, 'name' => '安芸郡田野町'],
            ['pref_code' => 39, 'code' => 304, 'name' => '安芸郡安田町'],
            ['pref_code' => 39, 'code' => 305, 'name' => '安芸郡北川村'],
            ['pref_code' => 39, 'code' => 306, 'name' => '安芸郡馬路村'],
            ['pref_code' => 39, 'code' => 307, 'name' => '安芸郡芸西村'],
            ['pref_code' => 39, 'code' => 341, 'name' => '長岡郡本山町'],
            ['pref_code' => 39, 'code' => 344, 'name' => '長岡郡大豊町'],
            ['pref_code' => 39, 'code' => 363, 'name' => '土佐郡土佐町'],
            ['pref_code' => 39, 'code' => 364, 'name' => '土佐郡大川村'],
            ['pref_code' => 39, 'code' => 386, 'name' => '吾川郡いの町'],
            ['pref_code' => 39, 'code' => 387, 'name' => '吾川郡仁淀川町'],
            ['pref_code' => 39, 'code' => 401, 'name' => '高岡郡中土佐町'],
            ['pref_code' => 39, 'code' => 402, 'name' => '高岡郡佐川町'],
            ['pref_code' => 39, 'code' => 403, 'name' => '高岡郡越知町'],
            ['pref_code' => 39, 'code' => 405, 'name' => '高岡郡檮原町'],
            ['pref_code' => 39, 'code' => 410, 'name' => '高岡郡日高村'],
            ['pref_code' => 39, 'code' => 411, 'name' => '高岡郡津野町'],
            ['pref_code' => 39, 'code' => 412, 'name' => '高岡郡四万十町'],
            ['pref_code' => 39, 'code' => 424, 'name' => '幡多郡大月町'],
            ['pref_code' => 39, 'code' => 427, 'name' => '幡多郡三原村'],
            ['pref_code' => 39, 'code' => 428, 'name' => '幡多郡黒潮町'],
            ['pref_code' => 40, 'code' => 101, 'name' => '北九州市門司区'],
            ['pref_code' => 40, 'code' => 103, 'name' => '北九州市若松区'],
            ['pref_code' => 40, 'code' => 105, 'name' => '北九州市戸畑区'],
            ['pref_code' => 40, 'code' => 106, 'name' => '北九州市小倉北区'],
            ['pref_code' => 40, 'code' => 107, 'name' => '北九州市小倉南区'],
            ['pref_code' => 40, 'code' => 108, 'name' => '北九州市八幡東区'],
            ['pref_code' => 40, 'code' => 109, 'name' => '北九州市八幡西区'],
            ['pref_code' => 40, 'code' => 131, 'name' => '福岡市東区'],
            ['pref_code' => 40, 'code' => 132, 'name' => '福岡市博多区'],
            ['pref_code' => 40, 'code' => 133, 'name' => '福岡市中央区'],
            ['pref_code' => 40, 'code' => 134, 'name' => '福岡市南区'],
            ['pref_code' => 40, 'code' => 135, 'name' => '福岡市西区'],
            ['pref_code' => 40, 'code' => 136, 'name' => '福岡市城南区'],
            ['pref_code' => 40, 'code' => 137, 'name' => '福岡市早良区'],
            ['pref_code' => 40, 'code' => 202, 'name' => '大牟田市'],
            ['pref_code' => 40, 'code' => 203, 'name' => '久留米市'],
            ['pref_code' => 40, 'code' => 204, 'name' => '直方市'],
            ['pref_code' => 40, 'code' => 205, 'name' => '飯塚市'],
            ['pref_code' => 40, 'code' => 206, 'name' => '田川市'],
            ['pref_code' => 40, 'code' => 207, 'name' => '柳川市'],
            ['pref_code' => 40, 'code' => 210, 'name' => '八女市'],
            ['pref_code' => 40, 'code' => 211, 'name' => '筑後市'],
            ['pref_code' => 40, 'code' => 212, 'name' => '大川市'],
            ['pref_code' => 40, 'code' => 213, 'name' => '行橋市'],
            ['pref_code' => 40, 'code' => 214, 'name' => '豊前市'],
            ['pref_code' => 40, 'code' => 215, 'name' => '中間市'],
            ['pref_code' => 40, 'code' => 216, 'name' => '小郡市'],
            ['pref_code' => 40, 'code' => 217, 'name' => '筑紫野市'],
            ['pref_code' => 40, 'code' => 218, 'name' => '春日市'],
            ['pref_code' => 40, 'code' => 219, 'name' => '大野城市'],
            ['pref_code' => 40, 'code' => 220, 'name' => '宗像市'],
            ['pref_code' => 40, 'code' => 221, 'name' => '太宰府市'],
            ['pref_code' => 40, 'code' => 223, 'name' => '古賀市'],
            ['pref_code' => 40, 'code' => 224, 'name' => '福津市'],
            ['pref_code' => 40, 'code' => 225, 'name' => 'うきは市'],
            ['pref_code' => 40, 'code' => 226, 'name' => '宮若市'],
            ['pref_code' => 40, 'code' => 227, 'name' => '嘉麻市'],
            ['pref_code' => 40, 'code' => 228, 'name' => '朝倉市'],
            ['pref_code' => 40, 'code' => 229, 'name' => 'みやま市'],
            ['pref_code' => 40, 'code' => 230, 'name' => '糸島市'],
            ['pref_code' => 40, 'code' => 231, 'name' => '那珂川市'],
            ['pref_code' => 40, 'code' => 305, 'name' => '筑紫郡那珂川町'],
            ['pref_code' => 40, 'code' => 341, 'name' => '糟屋郡宇美町'],
            ['pref_code' => 40, 'code' => 342, 'name' => '糟屋郡篠栗町'],
            ['pref_code' => 40, 'code' => 343, 'name' => '糟屋郡志免町'],
            ['pref_code' => 40, 'code' => 344, 'name' => '糟屋郡須惠町'],
            ['pref_code' => 40, 'code' => 345, 'name' => '糟屋郡新宮町'],
            ['pref_code' => 40, 'code' => 348, 'name' => '糟屋郡久山町'],
            ['pref_code' => 40, 'code' => 349, 'name' => '糟屋郡粕屋町'],
            ['pref_code' => 40, 'code' => 381, 'name' => '遠賀郡芦屋町'],
            ['pref_code' => 40, 'code' => 382, 'name' => '遠賀郡水巻町'],
            ['pref_code' => 40, 'code' => 383, 'name' => '遠賀郡岡垣町'],
            ['pref_code' => 40, 'code' => 384, 'name' => '遠賀郡遠賀町'],
            ['pref_code' => 40, 'code' => 401, 'name' => '鞍手郡小竹町'],
            ['pref_code' => 40, 'code' => 402, 'name' => '鞍手郡鞍手町'],
            ['pref_code' => 40, 'code' => 421, 'name' => '嘉穂郡桂川町'],
            ['pref_code' => 40, 'code' => 447, 'name' => '朝倉郡筑前町'],
            ['pref_code' => 40, 'code' => 448, 'name' => '朝倉郡東峰村'],
            ['pref_code' => 40, 'code' => 503, 'name' => '三井郡大刀洗町'],
            ['pref_code' => 40, 'code' => 522, 'name' => '三潴郡大木町'],
            ['pref_code' => 40, 'code' => 544, 'name' => '八女郡広川町'],
            ['pref_code' => 40, 'code' => 601, 'name' => '田川郡香春町'],
            ['pref_code' => 40, 'code' => 602, 'name' => '田川郡添田町'],
            ['pref_code' => 40, 'code' => 604, 'name' => '田川郡糸田町'],
            ['pref_code' => 40, 'code' => 605, 'name' => '田川郡川崎町'],
            ['pref_code' => 40, 'code' => 608, 'name' => '田川郡大任町'],
            ['pref_code' => 40, 'code' => 609, 'name' => '田川郡赤村'],
            ['pref_code' => 40, 'code' => 610, 'name' => '田川郡福智町'],
            ['pref_code' => 40, 'code' => 621, 'name' => '京都郡苅田町'],
            ['pref_code' => 40, 'code' => 625, 'name' => '京都郡みやこ町'],
            ['pref_code' => 40, 'code' => 642, 'name' => '築上郡吉富町'],
            ['pref_code' => 40, 'code' => 646, 'name' => '築上郡上毛町'],
            ['pref_code' => 40, 'code' => 647, 'name' => '築上郡築上町'],
            ['pref_code' => 41, 'code' => 201, 'name' => '佐賀市'],
            ['pref_code' => 41, 'code' => 202, 'name' => '唐津市'],
            ['pref_code' => 41, 'code' => 203, 'name' => '鳥栖市'],
            ['pref_code' => 41, 'code' => 204, 'name' => '多久市'],
            ['pref_code' => 41, 'code' => 205, 'name' => '伊万里市'],
            ['pref_code' => 41, 'code' => 206, 'name' => '武雄市'],
            ['pref_code' => 41, 'code' => 207, 'name' => '鹿島市'],
            ['pref_code' => 41, 'code' => 208, 'name' => '小城市'],
            ['pref_code' => 41, 'code' => 209, 'name' => '嬉野市'],
            ['pref_code' => 41, 'code' => 210, 'name' => '神埼市'],
            ['pref_code' => 41, 'code' => 327, 'name' => '神埼郡吉野ヶ里町'],
            ['pref_code' => 41, 'code' => 341, 'name' => '三養基郡基山町'],
            ['pref_code' => 41, 'code' => 345, 'name' => '三養基郡上峰町'],
            ['pref_code' => 41, 'code' => 346, 'name' => '三養基郡みやき町'],
            ['pref_code' => 41, 'code' => 387, 'name' => '東松浦郡玄海町'],
            ['pref_code' => 41, 'code' => 401, 'name' => '西松浦郡有田町'],
            ['pref_code' => 41, 'code' => 423, 'name' => '杵島郡大町町'],
            ['pref_code' => 41, 'code' => 424, 'name' => '杵島郡江北町'],
            ['pref_code' => 41, 'code' => 425, 'name' => '杵島郡白石町'],
            ['pref_code' => 41, 'code' => 441, 'name' => '藤津郡太良町'],
            ['pref_code' => 42, 'code' => 201, 'name' => '長崎市'],
            ['pref_code' => 42, 'code' => 202, 'name' => '佐世保市'],
            ['pref_code' => 42, 'code' => 203, 'name' => '島原市'],
            ['pref_code' => 42, 'code' => 204, 'name' => '諫早市'],
            ['pref_code' => 42, 'code' => 205, 'name' => '大村市'],
            ['pref_code' => 42, 'code' => 207, 'name' => '平戸市'],
            ['pref_code' => 42, 'code' => 208, 'name' => '松浦市'],
            ['pref_code' => 42, 'code' => 209, 'name' => '対馬市'],
            ['pref_code' => 42, 'code' => 210, 'name' => '壱岐市'],
            ['pref_code' => 42, 'code' => 211, 'name' => '五島市'],
            ['pref_code' => 42, 'code' => 212, 'name' => '西海市'],
            ['pref_code' => 42, 'code' => 213, 'name' => '雲仙市'],
            ['pref_code' => 42, 'code' => 214, 'name' => '南島原市'],
            ['pref_code' => 42, 'code' => 307, 'name' => '西彼杵郡長与町'],
            ['pref_code' => 42, 'code' => 308, 'name' => '西彼杵郡時津町'],
            ['pref_code' => 42, 'code' => 321, 'name' => '東彼杵郡東彼杵町'],
            ['pref_code' => 42, 'code' => 322, 'name' => '東彼杵郡川棚町'],
            ['pref_code' => 42, 'code' => 323, 'name' => '東彼杵郡波佐見町'],
            ['pref_code' => 42, 'code' => 383, 'name' => '北松浦郡小値賀町'],
            ['pref_code' => 42, 'code' => 391, 'name' => '北松浦郡佐々町'],
            ['pref_code' => 42, 'code' => 411, 'name' => '南松浦郡新上五島町'],
            ['pref_code' => 43, 'code' => 101, 'name' => '熊本市中央区'],
            ['pref_code' => 43, 'code' => 102, 'name' => '熊本市東区'],
            ['pref_code' => 43, 'code' => 103, 'name' => '熊本市西区'],
            ['pref_code' => 43, 'code' => 104, 'name' => '熊本市南区'],
            ['pref_code' => 43, 'code' => 105, 'name' => '熊本市北区'],
            ['pref_code' => 43, 'code' => 201, 'name' => '熊本市'],
            ['pref_code' => 43, 'code' => 202, 'name' => '八代市'],
            ['pref_code' => 43, 'code' => 203, 'name' => '人吉市'],
            ['pref_code' => 43, 'code' => 204, 'name' => '荒尾市'],
            ['pref_code' => 43, 'code' => 205, 'name' => '水俣市'],
            ['pref_code' => 43, 'code' => 206, 'name' => '玉名市'],
            ['pref_code' => 43, 'code' => 208, 'name' => '山鹿市'],
            ['pref_code' => 43, 'code' => 210, 'name' => '菊池市'],
            ['pref_code' => 43, 'code' => 211, 'name' => '宇土市'],
            ['pref_code' => 43, 'code' => 212, 'name' => '上天草市'],
            ['pref_code' => 43, 'code' => 213, 'name' => '宇城市'],
            ['pref_code' => 43, 'code' => 214, 'name' => '阿蘇市'],
            ['pref_code' => 43, 'code' => 215, 'name' => '天草市'],
            ['pref_code' => 43, 'code' => 216, 'name' => '合志市'],
            ['pref_code' => 43, 'code' => 348, 'name' => '下益城郡美里町'],
            ['pref_code' => 43, 'code' => 364, 'name' => '玉名郡玉東町'],
            ['pref_code' => 43, 'code' => 367, 'name' => '玉名郡南関町'],
            ['pref_code' => 43, 'code' => 368, 'name' => '玉名郡長洲町'],
            ['pref_code' => 43, 'code' => 369, 'name' => '玉名郡和水町'],
            ['pref_code' => 43, 'code' => 403, 'name' => '菊池郡大津町'],
            ['pref_code' => 43, 'code' => 404, 'name' => '菊池郡菊陽町'],
            ['pref_code' => 43, 'code' => 423, 'name' => '阿蘇郡南小国町'],
            ['pref_code' => 43, 'code' => 424, 'name' => '阿蘇郡小国町'],
            ['pref_code' => 43, 'code' => 425, 'name' => '阿蘇郡産山村'],
            ['pref_code' => 43, 'code' => 428, 'name' => '阿蘇郡高森町'],
            ['pref_code' => 43, 'code' => 432, 'name' => '阿蘇郡西原村'],
            ['pref_code' => 43, 'code' => 433, 'name' => '阿蘇郡南阿蘇村'],
            ['pref_code' => 43, 'code' => 441, 'name' => '上益城郡御船町'],
            ['pref_code' => 43, 'code' => 442, 'name' => '上益城郡嘉島町'],
            ['pref_code' => 43, 'code' => 443, 'name' => '上益城郡益城町'],
            ['pref_code' => 43, 'code' => 444, 'name' => '上益城郡甲佐町'],
            ['pref_code' => 43, 'code' => 447, 'name' => '上益城郡山都町'],
            ['pref_code' => 43, 'code' => 468, 'name' => '八代郡氷川町'],
            ['pref_code' => 43, 'code' => 482, 'name' => '葦北郡芦北町'],
            ['pref_code' => 43, 'code' => 484, 'name' => '葦北郡津奈木町'],
            ['pref_code' => 43, 'code' => 501, 'name' => '球磨郡錦町'],
            ['pref_code' => 43, 'code' => 505, 'name' => '球磨郡多良木町'],
            ['pref_code' => 43, 'code' => 506, 'name' => '球磨郡湯前町'],
            ['pref_code' => 43, 'code' => 507, 'name' => '球磨郡水上村'],
            ['pref_code' => 43, 'code' => 510, 'name' => '球磨郡相良村'],
            ['pref_code' => 43, 'code' => 511, 'name' => '球磨郡五木村'],
            ['pref_code' => 43, 'code' => 512, 'name' => '球磨郡山江村'],
            ['pref_code' => 43, 'code' => 513, 'name' => '球磨郡球磨村'],
            ['pref_code' => 43, 'code' => 514, 'name' => '球磨郡あさぎり町'],
            ['pref_code' => 43, 'code' => 531, 'name' => '天草郡苓北町'],
            ['pref_code' => 44, 'code' => 201, 'name' => '大分市'],
            ['pref_code' => 44, 'code' => 202, 'name' => '別府市'],
            ['pref_code' => 44, 'code' => 203, 'name' => '中津市'],
            ['pref_code' => 44, 'code' => 204, 'name' => '日田市'],
            ['pref_code' => 44, 'code' => 205, 'name' => '佐伯市'],
            ['pref_code' => 44, 'code' => 206, 'name' => '臼杵市'],
            ['pref_code' => 44, 'code' => 207, 'name' => '津久見市'],
            ['pref_code' => 44, 'code' => 208, 'name' => '竹田市'],
            ['pref_code' => 44, 'code' => 209, 'name' => '豊後高田市'],
            ['pref_code' => 44, 'code' => 210, 'name' => '杵築市'],
            ['pref_code' => 44, 'code' => 211, 'name' => '宇佐市'],
            ['pref_code' => 44, 'code' => 212, 'name' => '豊後大野市'],
            ['pref_code' => 44, 'code' => 213, 'name' => '由布市'],
            ['pref_code' => 44, 'code' => 214, 'name' => '国東市'],
            ['pref_code' => 44, 'code' => 322, 'name' => '東国東郡姫島村'],
            ['pref_code' => 44, 'code' => 341, 'name' => '速見郡日出町'],
            ['pref_code' => 44, 'code' => 461, 'name' => '玖珠郡九重町'],
            ['pref_code' => 44, 'code' => 462, 'name' => '玖珠郡玖珠町'],
            ['pref_code' => 45, 'code' => 201, 'name' => '宮崎市'],
            ['pref_code' => 45, 'code' => 202, 'name' => '都城市'],
            ['pref_code' => 45, 'code' => 203, 'name' => '延岡市'],
            ['pref_code' => 45, 'code' => 204, 'name' => '日南市'],
            ['pref_code' => 45, 'code' => 205, 'name' => '小林市'],
            ['pref_code' => 45, 'code' => 206, 'name' => '日向市'],
            ['pref_code' => 45, 'code' => 207, 'name' => '串間市'],
            ['pref_code' => 45, 'code' => 208, 'name' => '西都市'],
            ['pref_code' => 45, 'code' => 209, 'name' => 'えびの市'],
            ['pref_code' => 45, 'code' => 341, 'name' => '北諸県郡三股町'],
            ['pref_code' => 45, 'code' => 361, 'name' => '西諸県郡高原町'],
            ['pref_code' => 45, 'code' => 382, 'name' => '東諸県郡国富町'],
            ['pref_code' => 45, 'code' => 383, 'name' => '東諸県郡綾町'],
            ['pref_code' => 45, 'code' => 401, 'name' => '児湯郡高鍋町'],
            ['pref_code' => 45, 'code' => 402, 'name' => '児湯郡新富町'],
            ['pref_code' => 45, 'code' => 403, 'name' => '児湯郡西米良村'],
            ['pref_code' => 45, 'code' => 404, 'name' => '児湯郡木城町'],
            ['pref_code' => 45, 'code' => 405, 'name' => '児湯郡川南町'],
            ['pref_code' => 45, 'code' => 406, 'name' => '児湯郡都農町'],
            ['pref_code' => 45, 'code' => 421, 'name' => '東臼杵郡門川町'],
            ['pref_code' => 45, 'code' => 429, 'name' => '東臼杵郡諸塚村'],
            ['pref_code' => 45, 'code' => 430, 'name' => '東臼杵郡椎葉村'],
            ['pref_code' => 45, 'code' => 431, 'name' => '東臼杵郡美郷町'],
            ['pref_code' => 45, 'code' => 441, 'name' => '西臼杵郡高千穂町'],
            ['pref_code' => 45, 'code' => 442, 'name' => '西臼杵郡日之影町'],
            ['pref_code' => 45, 'code' => 443, 'name' => '西臼杵郡五ヶ瀬町'],
            ['pref_code' => 46, 'code' => 201, 'name' => '鹿児島市'],
            ['pref_code' => 46, 'code' => 203, 'name' => '鹿屋市'],
            ['pref_code' => 46, 'code' => 204, 'name' => '枕崎市'],
            ['pref_code' => 46, 'code' => 206, 'name' => '阿久根市'],
            ['pref_code' => 46, 'code' => 208, 'name' => '出水市'],
            ['pref_code' => 46, 'code' => 210, 'name' => '指宿市'],
            ['pref_code' => 46, 'code' => 213, 'name' => '西之表市'],
            ['pref_code' => 46, 'code' => 214, 'name' => '垂水市'],
            ['pref_code' => 46, 'code' => 215, 'name' => '薩摩川内市'],
            ['pref_code' => 46, 'code' => 216, 'name' => '日置市'],
            ['pref_code' => 46, 'code' => 217, 'name' => '曽於市'],
            ['pref_code' => 46, 'code' => 218, 'name' => '霧島市'],
            ['pref_code' => 46, 'code' => 219, 'name' => 'いちき串木野市'],
            ['pref_code' => 46, 'code' => 220, 'name' => '南さつま市'],
            ['pref_code' => 46, 'code' => 221, 'name' => '志布志市'],
            ['pref_code' => 46, 'code' => 222, 'name' => '奄美市'],
            ['pref_code' => 46, 'code' => 223, 'name' => '南九州市'],
            ['pref_code' => 46, 'code' => 224, 'name' => '伊佐市'],
            ['pref_code' => 46, 'code' => 225, 'name' => '姶良市'],
            ['pref_code' => 46, 'code' => 303, 'name' => '鹿児島郡三島村'],
            ['pref_code' => 46, 'code' => 304, 'name' => '鹿児島郡十島村'],
            ['pref_code' => 46, 'code' => 392, 'name' => '薩摩郡さつま町'],
            ['pref_code' => 46, 'code' => 404, 'name' => '出水郡長島町'],
            ['pref_code' => 46, 'code' => 452, 'name' => '姶良郡湧水町'],
            ['pref_code' => 46, 'code' => 468, 'name' => '曽於郡大崎町'],
            ['pref_code' => 46, 'code' => 482, 'name' => '肝属郡東串良町'],
            ['pref_code' => 46, 'code' => 490, 'name' => '肝属郡錦江町'],
            ['pref_code' => 46, 'code' => 491, 'name' => '肝属郡南大隅町'],
            ['pref_code' => 46, 'code' => 492, 'name' => '肝属郡肝付町'],
            ['pref_code' => 46, 'code' => 501, 'name' => '熊毛郡中種子町'],
            ['pref_code' => 46, 'code' => 502, 'name' => '熊毛郡南種子町'],
            ['pref_code' => 46, 'code' => 505, 'name' => '熊毛郡屋久島町'],
            ['pref_code' => 46, 'code' => 523, 'name' => '大島郡大和村'],
            ['pref_code' => 46, 'code' => 524, 'name' => '大島郡宇検村'],
            ['pref_code' => 46, 'code' => 525, 'name' => '大島郡瀬戸内町'],
            ['pref_code' => 46, 'code' => 527, 'name' => '大島郡龍郷町'],
            ['pref_code' => 46, 'code' => 529, 'name' => '大島郡喜界町'],
            ['pref_code' => 46, 'code' => 530, 'name' => '大島郡徳之島町'],
            ['pref_code' => 46, 'code' => 531, 'name' => '大島郡天城町'],
            ['pref_code' => 46, 'code' => 532, 'name' => '大島郡伊仙町'],
            ['pref_code' => 46, 'code' => 533, 'name' => '大島郡和泊町'],
            ['pref_code' => 46, 'code' => 534, 'name' => '大島郡知名町'],
            ['pref_code' => 46, 'code' => 535, 'name' => '大島郡与論町'],
            ['pref_code' => 47, 'code' => 201, 'name' => '那覇市'],
            ['pref_code' => 47, 'code' => 205, 'name' => '宜野湾市'],
            ['pref_code' => 47, 'code' => 207, 'name' => '石垣市'],
            ['pref_code' => 47, 'code' => 208, 'name' => '浦添市'],
            ['pref_code' => 47, 'code' => 209, 'name' => '名護市'],
            ['pref_code' => 47, 'code' => 210, 'name' => '糸満市'],
            ['pref_code' => 47, 'code' => 211, 'name' => '沖縄市'],
            ['pref_code' => 47, 'code' => 212, 'name' => '豊見城市'],
            ['pref_code' => 47, 'code' => 213, 'name' => 'うるま市'],
            ['pref_code' => 47, 'code' => 214, 'name' => '宮古島市'],
            ['pref_code' => 47, 'code' => 215, 'name' => '南城市'],
            ['pref_code' => 47, 'code' => 301, 'name' => '国頭郡国頭村'],
            ['pref_code' => 47, 'code' => 302, 'name' => '国頭郡大宜味村'],
            ['pref_code' => 47, 'code' => 303, 'name' => '国頭郡東村'],
            ['pref_code' => 47, 'code' => 306, 'name' => '国頭郡今帰仁村'],
            ['pref_code' => 47, 'code' => 308, 'name' => '国頭郡本部町'],
            ['pref_code' => 47, 'code' => 311, 'name' => '国頭郡恩納村'],
            ['pref_code' => 47, 'code' => 313, 'name' => '国頭郡宜野座村'],
            ['pref_code' => 47, 'code' => 314, 'name' => '国頭郡金武町'],
            ['pref_code' => 47, 'code' => 315, 'name' => '国頭郡伊江村'],
            ['pref_code' => 47, 'code' => 324, 'name' => '中頭郡読谷村'],
            ['pref_code' => 47, 'code' => 325, 'name' => '中頭郡嘉手納町'],
            ['pref_code' => 47, 'code' => 326, 'name' => '中頭郡北谷町'],
            ['pref_code' => 47, 'code' => 327, 'name' => '中頭郡北中城村'],
            ['pref_code' => 47, 'code' => 328, 'name' => '中頭郡中城村'],
            ['pref_code' => 47, 'code' => 329, 'name' => '中頭郡西原町'],
            ['pref_code' => 47, 'code' => 348, 'name' => '島尻郡与那原町'],
            ['pref_code' => 47, 'code' => 350, 'name' => '島尻郡南風原町'],
            ['pref_code' => 47, 'code' => 353, 'name' => '島尻郡渡嘉敷村'],
            ['pref_code' => 47, 'code' => 354, 'name' => '島尻郡座間味村'],
            ['pref_code' => 47, 'code' => 355, 'name' => '島尻郡粟国村'],
            ['pref_code' => 47, 'code' => 356, 'name' => '島尻郡渡名喜村'],
            ['pref_code' => 47, 'code' => 357, 'name' => '島尻郡南大東村'],
            ['pref_code' => 47, 'code' => 358, 'name' => '島尻郡北大東村'],
            ['pref_code' => 47, 'code' => 359, 'name' => '島尻郡伊平屋村'],
            ['pref_code' => 47, 'code' => 360, 'name' => '島尻郡伊是名村'],
            ['pref_code' => 47, 'code' => 361, 'name' => '島尻郡久米島町'],
            ['pref_code' => 47, 'code' => 362, 'name' => '島尻郡八重瀬町'],
            ['pref_code' => 47, 'code' => 375, 'name' => '宮古郡多良間村'],
            ['pref_code' => 47, 'code' => 381, 'name' => '八重山郡竹富町'],
            ['pref_code' => 47, 'code' => 382, 'name' => '八重山郡与那国町'],
        ];
        DB::table('mst_cities')->insert($cities);
    }
}
