<?php

use Illuminate\Database\Seeder;

class MstLawrestrictionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // データのクリア
        DB::table('mst_lawrestrictions')->truncate();

        // データの挿入
        $law_restriction = [
            ['code' => 1, 'name' => '文化財保護法'],
            ['code' => 2, 'name' => '古都保存法'],
            ['code' => 3, 'name' => '景観法'],
            ['code' => 4, 'name' => '密集市街地整備法'],
            ['code' => 5, 'name' => '航空法'],
            ['code' => 6, 'name' => '河川法'],
            ['code' => 7, 'name' => '砂防法'],
            ['code' => 8, 'name' => '農地法届出要'],
            ['code' => 9, 'name' => '安全条例'],
            ['code' => 10, 'name' => '宅地造成工事規制区域'],
            ['code' => 11, 'name' => '急傾斜地崩壊危険区域'],
            ['code' => 12, 'name' => '高度地区'],
            ['code' => 13, 'name' => '高度利用地区'],
            ['code' => 14, 'name' => '中高層階住居専用地区'],
            ['code' => 15, 'name' => '構想住居誘導地区'],
            ['code' => 16, 'name' => '防火地域'],
            ['code' => 17, 'name' => '準防火地域'],
            ['code' => 18, 'name' => '風致地区'],
            ['code' => 19, 'name' => '景観地区'],
            ['code' => 20, 'name' => '準景観地区'],
            ['code' => 21, 'name' => '観光地区'],
            ['code' => 22, 'name' => '歴史風土保存地区'],
            ['code' => 23, 'name' => '伝統的建造物群保存地区'],
            ['code' => 24, 'name' => '特定街区'],
            ['code' => 25, 'name' => '特別用途制限地域'],
            ['code' => 26, 'name' => '文教地区'],
            ['code' => 27, 'name' => '都市再生特別地区'],
            ['code' => 28, 'name' => '特別緑地保全地区'],
            ['code' => 29, 'name' => '高さ最高限度有'],
            ['code' => 30, 'name' => '高さ最低限度有'],
            ['code' => 31, 'name' => '建ぺい率最低限度有'],
            ['code' => 32, 'name' => '容積率最低限度有'],
            ['code' => 33, 'name' => '敷地面積最高限度有'],
            ['code' => 34, 'name' => '敷地面積最低限度有'],
            ['code' => 35, 'name' => '建物面積最高限度有'],
            ['code' => 36, 'name' => '建物面積最低限度有'],
        ];
        DB::table('mst_lawrestrictions')->insert($law_restriction);
    }
}
