$(function(){
    $('#btnSearch').on('click', function(){
        var from = $('[name^=year_month_from]').val();
        var to = $('[name^=year_month_to]').val();
        if(from != "") {
            var res = checkAge(from);
            if(!res) {
                return res;
            }
        }
        if(to != "") {
            var res = checkAge(to);
            if(!res) {
                return res;
            }
        }
    });

    $('[name^=property]').on('change', function(){
        var property = $(this).val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/get_parking',
            data: {
                property: property,
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合

            $('[name^=parking]').children('option').remove();
            $('[name^=parking]').append($('<option>').text('駐車場を選択').attr('value', ''));
            $.each(data, function(row, value){
                $('[name^=parking]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
    });

    $(document).on('change', '[name^=address1]', function(){
        var prefId = $(this).val();
        var obj = $(this);
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/pref',
            data: {
                prefId: prefId
            }
        })
            .done(function(data){ //ajaxの通信に成功した場合
                // alert("success!");
                $(obj).next('[name^=address2]').children('option').remove();
                $(obj).next('[name^=address2]').append($('<option>').text('市区郡を選択').attr('value', ''));
                $.each(data, function(row, value){
                    $(obj).next('[name^=address2]').append($('<option>').text(value['name']).attr('value', value['code']));
                });
                //$(obj).next().next('[name^=address3]').children('option').remove();
                //$(obj).next().next('[name^=address3]').append($('<option>').text('町村を選択').attr('value', ''));

                getLatlng($(obj));
            })
            .fail(function(data){ //ajaxの通信に失敗した場合
                alert("error!");
            });
    });

    $(document).on('change', '[name^=address2]', function(){
	if ($(this).hasClass("sai-kyoto")) {
            return;
        }
        var cityId = $(this).val();
        var obj = $(this);
        var prefId = $('[name^=address1]').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/city_search',
            data: {
                prefId: prefId,
                cityId: cityId
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合
            // alert("success!");
            $(obj).next('[name^=address3]').children('option').remove();
            $(obj).next('[name^=address3]').append($('<option>').text('町村を選択').attr('value', ''));
            $.each(data[0], function(row, value){
                $(obj).next('[name^=address3]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name^=primary_school]').children('option').remove();
            $('[name^=primary_school]').append($('<option>').text('小学校区を選択').attr('value', ''));
            $.each(data[1], function(row, value){
                $('[name^=primary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name^=secondary_school]').children('option').remove();
            $('[name^=secondary_school]').append($('<option>').text('中学校区を選択').attr('value', ''));
            $.each(data[2], function(row, value){
                $('[name^=secondary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
    });

    $(document).on('change', '[name^=access1]', function(){
        var id = $(this).val();

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/search_station_line',
            data: {
                line: id,
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $('[name^=access2] option').remove();
            $('[name^=access2]').append($('<option>').text('駅を選択').attr('value', ''));
            $.each(data, function(row, value){
                $('[name^=access2').append($('<option>').text(value['name']).attr('value', value['id']));
            });

            return false;
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
            return false
        });

        return false;

    });

    $(document).on('change', '[id^=form-forsale]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    $(document).on('change', '[id^=form-mansion]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count_mansion',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    $(document).on('change', '[id^=form-close]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count_close',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    $(document).on('change', '[id^=form-lot]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count_lot',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    function checkAge(age) {
        var res = true;
        var array_age = age.split('/');
        var year = '';
        var month = '';
        if(array_age[0]) {
            year = array_age[0];
        }
        if(array_age[1]) {
            month = array_age[1];
        }
        
        if(year == '' || month == '') {  //どちらかの入力がない場合はNG
            alert('築年月はyyyy/mの形式で入力してください。');
            res = false;
        }else if( !(year.match(/^[0-9]+/)) || year.length != 4)  {  //半角英数でない、もしくは4桁でない場合はNG
            alert('築年月はyyyy/mの形式で入力してください。');
            res = false;
        }else if( !(month.match(/^[0-9]+/)) || month.length > 2)  {  //半角英数でない、もしくは3桁を越す場合はNG
            alert('築年月はyyyy/mの形式で入力してください。');
            res = false;
        }
        return res;
    }

    $(document).on('click', '#copyCondition', function(){
        var form_obj = $("#template_form");
        var clone = $(form_obj).clone();
        var num = $('.p-search-common__tbl-number').length;
        
        $(clone).find('.p-search-common__tbl-number').text(('00' + (num+1)).slice(-2));
        $(clone).find('form').attr('id', $(clone).find('form').attr('id')+(num+1));

        $('select',$(form_obj)).each(function(i){
            $('select',clone).eq(i).val($(this).val());
          });

        $('#form-forsale').append(clone);

    });

    $(document).on('click', '#addCondition', function(){
        var form_obj = $("#template_form");
        var clone = $(form_obj).clone();
        var num = $('.p-search-common__tbl-number').length;
        
        $(clone).find('.p-search-common__tbl-number').text(('00' + (num+1)).slice(-2));
        $(clone).find('form').attr('id', $(clone).find('form').attr('id')+(num+1));

        $(clone).find('form')
        .find("input, select, textarea")
        .not(":button, :submit, :reset, :hidden, [name=address1]")
        .val("")
        .prop("checked", false)
        .prop("selected", false);
        $('#form-forsale').append(clone);
    });

    $(document).on('click', '.delete-form-button', function(){
        var num = $('.p-search-common__tbl-number').length;
        if(num != 1) {
            $(this).parents('#template_form').remove();
        }

        var target = $('.p-search-common__tbl-number');
        var no = 1;
        $.each(target, function(key, val){
            $(val).text(('00' + (no)).slice(-2));
            no++;
        });
    });


    $(document).on("click", ".clear-button", function () {
        clearForm($(this).parents('form'));
    });

    function clearForm (form) {
        $(form)
            .find("input, select, textarea")
            .not(":button, :submit, :reset, :hidden, [name=address1], [name=search_lot_address1], [name=search_address1]")
            .val("")
            .prop("checked", false)
            .prop("selected", false)
        ;
    }

    $( ".cal_picker" ).datepicker({ 
        dateFormat: "yy/mm/dd" 
    });
});
