$(function(){
    // クリックで矢印切り替え
    $(".p-search-common__collapse-link").click(function() {
        var $this = $(".p-search-common__collapse-link");
        if ($("#searchUnique").hasClass("show")) {
            $this.addClass("p-search-common__collapse-link--open");
            $this.removeClass("p-search-common__collapse-link--close");
        } else {
            $this.removeClass("p-search-common__collapse-link--open");
            $this.addClass("p-search-common__collapse-link--close");
        }
    });

    // 売出、成約用
    $('.c-circle-btn__check').on('click', function(){
        $(this).parents('.p-results-image').find('.p-form-check').toggle();
        if($("#open_flag").val() == 0) {
            $("#open_flag").val(1);
        } else {
            $("#open_flag").val(0);
        }
        return false;
    });

    $('[name=c-circle-btn__check]').on('click', function(){
        $(this).parents('.p-results-noimage').find('.p-form-check').toggle();
        if($("#noimage_open_flag").val() == 0) {
            $("#noimage_open_flag").val(1);
        } else {
            $("#noimage_open_flag").val(0);
        }
        return false;
    });



    // マンション、分譲地用
    $('.disp_room').on('click', function(){
        $(this).parents('li').find('.p-mansion-room').toggle();
        return false;
    });

    $('.c-circle-btn__check-mansion').on('click', function(){
        $(this).parents('.p-results-image__li').find('.p-form-check').toggle();
        if($("#open_flag").val() == 0) {
            $("#open_flag").val(1);
        } else {
            $("#open_flag").val(0);
        }
        return false;
    });

    $('.c-circle-btn__disp-mansion').on('click', function(){
        $(this).parents('.p-mansion-room').toggle();
        return false;
    });

    
    $('.disp_room_noimage').on('click', function(){
        $(this).parents('.mansion-list').find('.p-mansion-room').toggle();
        return false;
    });

    $('.c-circle-btn__check-mansion_noimage').on('click', function(){
        $(this).parents('.mansion-list').find('.p-form-check').toggle();
        if($("#noimage_open_flag").val() == 0) {
            $("#noimage_open_flag").val(1);
        } else {
            $("#noimage_open_flag").val(0);
        }
        return false;
    });

    $('.c-circle-btn__disp-mansion_noimage').on('click', function(){
        $(this).parents('.p-mansion-room').toggle();
        return false;
    });


    $('.c-circle-btn__display').on('click', function(){
        $(this).parents('li').hide(300);
        return false;
    });

    $('.c-circle-btn__display__list').on('click', function(){
        $(this).parents('.target_list').hide(300);
        return false;
    });

    $('[name=all_not]').on('click', function(){
        var target = $(this).parent().parent('ul').find('.c-selectbox');
        $.each(target, function(key, val){
            $(val).val(3);
        });
    });

    $('.btnSearchSave').on('click', function(){
        var form = $(this).parents('form');
        
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/business/save_vendor',
            data: form.serialize(),
        })
        .done(function(data){ //ajaxの通信に成功した場合
            alert("保存しました。");
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
        return false;
    });

    $( ".cal_picker" ).datepicker({ 
        dateFormat: "yy/mm/dd" 
    });

    $(document).on('click', '#copyCondition', function(){
        var form_obj = $("#template_form");
        var clone = $(form_obj).clone();
        var num = $('.p-search-common__tbl-number').length;
        
        $(clone).find('.p-search-common__tbl-number').text(('00' + (num+1)).slice(-2));
        $(clone).find('form').attr('id', $(clone).find('form').attr('id')+(num+1));

        $('select',$(form_obj)).each(function(i){
            $('select',clone).eq(i).val($(this).val());
          });

        $('#form-forsale').append(clone);

    });

    $(document).on('click', '#addCondition', function(){
        var form_obj = $("#template_form");
        var clone = $(form_obj).clone();
        var num = $('.p-search-common__tbl-number').length;
        
        $(clone).find('.p-search-common__tbl-number').text(('00' + (num+1)).slice(-2));
        $(clone).find('form').attr('id', $(clone).find('form').attr('id')+(num+1));

        $(clone).find('form')
        .find("input, select, textarea")
        .not(":button, :submit, :reset, :hidden, [name=address1]")
        .val("")
        .prop("checked", false)
        .prop("selected", false);
        $('#form-forsale').append(clone);
    });

    $(document).on('click', '.delete-form-button', function(){
        var num = $('.p-search-common__tbl-number').length;
        if(num != 1) {
            $(this).parents('#template_form').remove();
        }

        var target = $('.p-search-common__tbl-number');
        var no = 1;
        $.each(target, function(key, val){
            $(val).text(('00' + (no)).slice(-2));
            no++;
        });
    });

    $(document).on("click", ".clear-button", function () {
        clearForm($(this).parents('form'));
    });

    function clearForm (form) {
        $(form)
            .find("input, select, textarea")
            .not(":button, :submit, :reset, :hidden, [name=address1], [name=search_lot_address1], [name=search_address1]")
            .val("")
            .prop("checked", false)
            .prop("selected", false)
        ;
    }

    $('#btnSearch').on('click', function(){
        var from = $('[name^=year_month_from]').val();
        var to = $('[name^=year_month_to]').val();
        if(from != "") {
            var res = checkAge(from);
            if(!res) {
                return res;
            }
        }
        if(to != "") {
            var res = checkAge(to);
            if(!res) {
                return res;
            }
        }
    });

    $('[name^=property]').on('change', function(){
        var property = $(this).val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/get_parking',
            data: {
                property: property,
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合

            $('[name^=parking]').children('option').remove();
            $('[name^=parking]').append($('<option>').text('駐車場を選択').attr('value', ''));
            $.each(data, function(row, value){
                $('[name^=parking]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
    });

    $(document).on('change', '[name^=address2]', function(){
        var cityId = $(this).val();
        var obj = $(this);
        var prefId = $('[name^=address1]').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/city_search',
            data: {
                prefId: prefId,
                cityId: cityId
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合
            // alert("success!");
            $(obj).next('[name^=address3]').children('option').remove();
            $(obj).next('[name^=address3]').append($('<option>').text('町村を選択').attr('value', ''));
            $.each(data[0], function(row, value){
                $(obj).next('[name^=address3]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name^=primary_school]').children('option').remove();
            $('[name^=primary_school]').append($('<option>').text('小学校区を選択').attr('value', ''));
            $.each(data[1], function(row, value){
                $('[name^=primary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name^=secondary_school]').children('option').remove();
            $('[name^=secondary_school]').append($('<option>').text('中学校区を選択').attr('value', ''));
            $.each(data[2], function(row, value){
                $('[name^=secondary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
    });

    $(document).on('change', '[name^=access1]', function(){
        var id = $(this).val();

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/search_station_line',
            data: {
                line: id,
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $('[name^=access2] option').remove();
            $('[name^=access2]').append($('<option>').text('駅を選択').attr('value', ''));
            $.each(data, function(row, value){
                $('[name^=access2').append($('<option>').text(value['name']).attr('value', value['id']));
            });

            return false;
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
            return false
        });

        return false;

    });

    $(document).on('change', '[id^=form-forsale]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    $(document).on('change', '[id^=form-close]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count_close',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    $(document).on('change', '[id^=form-mansion]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count_mansion',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    $(document).on('change', '[id^=form-lot]', function(){

        var target = $(this);
        var fd = new FormData($(this).get(0));
        // var q = "";
        // for (let value of fd.entries()) { 

        // }

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/get_count_lot',
            data: fd,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $(target).find('.p-search-footer__count-text').text(data);
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
        });
    });

    function checkAge(age) {
        var res = true;
        var array_age = age.split('/');
        var year = '';
        var month = '';
        if(array_age[0]) {
            year = array_age[0];
        }
        if(array_age[1]) {
            month = array_age[1];
        }
        
        if(year == '' || month == '') {  //どちらかの入力がない場合はNG
            alert('築年月はyyyy/mの形式で入力してください。');
            res = false;
        }else if( !(year.match(/^[0-9]+/)) || year.length != 4)  {  //半角英数でない、もしくは4桁でない場合はNG
            alert('築年月はyyyy/mの形式で入力してください。');
            res = false;
        }else if( !(month.match(/^[0-9]+/)) || month.length > 2)  {  //半角英数でない、もしくは3桁を越す場合はNG
            alert('築年月はyyyy/mの形式で入力してください。');
            res = false;
        }
        return res;
    }









    $('[name=property]').on('change', function(){
        var property = $(this).val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/get_parking',
            data: {
                property: property,
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合

            $('[name=parking]').children('option').remove();
            $('[name=parking]').append($('<option>').text('駐車場を選択').attr('value', ''));
            $.each(data, function(row, value){
                $('[name=parking]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
    });

    $(document).on('change', '[name^=address2]', function(){
        var cityId = $(this).val();
        var obj = $(this);
        var prefId = $('[name^=address1]').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/city_search',
            data: {
                prefId: prefId,
                cityId: cityId
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合
            // alert("success!");
            $(obj).next('[name^=address3]').children('option').remove();
            $(obj).next('[name^=address3]').append($('<option>').text('町村を選択').attr('value', ''));
            $.each(data[0], function(row, value){
                $(obj).next('[name^=address3]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name=primary_school]').children('option').remove();
            $('[name=primary_school]').append($('<option>').text('小学校区を選択').attr('value', ''));
            $.each(data[1], function(row, value){
                $('[name=primary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name=secondary_school]').children('option').remove();
            $('[name=secondary_school]').append($('<option>').text('中学校区を選択').attr('value', ''));
            $.each(data[2], function(row, value){
                $('[name=secondary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
    });

    $(document).on('change', '[name=access1]', function(){
        var id = $(this).val();

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: '/admin/search_station_line',
            data: {
                line: id,
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合
            $('[name=access2] option').remove();
            $('[name=access2]').append($('<option>').text('駅を選択').attr('value', ''));
            $.each(data, function(row, value){
                $('[name=access2]').append($('<option>').text(value['name']).attr('value', value['id']));
            });

            return false;
        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!"); 
            return false
        });

        return false;

    });

    $('#btnAllDisp').on('click', function(){
        $('.list-unstyled').find('li').each(function(index, element){
            $(element).show(500);
        })
        $('.target_list').each(function(index, element){
            $(element).show(500);
        })
        return false;
    });
    
    $('#btnPrint').on('click', function(){
        $(this).parents('form').submit();
    });

    // さらに絞り込み
    $('.notCondition').on('click', function(){
        var id = $(this).attr('id');
        var uri = location.href.replace(location.host, '').replace(/https:\/\//g,'').replace(/http:\/\//g,'').replace(/\?.*/g, '');
        var action = uri;
        $('#link_detail').attr('action', action+'?notcondition='+id);
        $('#link_detail').submit();
        return false;
    });

    $('.business_search > .pagination > li > a').on('click', function(){
        var uri = location.href.replace(location.host, '').replace(/https:\/\//g,'').replace(/http:\/\//g,'').replace(/[\?||&]page=[0-9]*/g,'');

        var num = $(this).text();
        if ( uri.match(/\?/)) {
            uri += '&page='+num;
        } else {
            uri += '?page='+num;
        }
        $('#link_detail').attr('action', uri)
        $('#link_detail').submit();
        return false;
    });

    $('.p-results-sort__sort li').on('click', function(){
        var uri = location.href.replace(location.host, '').replace(/https:\/\//g,'').replace(/http:\/\//g,'').replace(/[\?||&]page=[0-9]*/g,'').replace(/[\?||&]sort=[^&]*/g,'');

        var sort = $(this).children('a').attr('class');
        sort = sort.replace('p-results-sort', '');
        if ( uri.match(/\?/)) {
            uri += '&sort='+sort;
        } else {
            uri += '?sort='+sort;
        }

        $('#link_detail').attr('action', uri)
        $('#link_detail').submit();
        return false;
    });


    // 詳細ページへ
    $('[id^=btnDetail]').on('click', function(){
        var uri = location.href.replace(location.host, '').replace(/https:\/\//g,'').replace(/http:\/\//g,'').replace(/[\?||&]page=[0-9]*/g,'').replace(/[\?||&]sort=[^&]*/g,'').replace(/#/g,'');
        uri = uri.replace('lot', 'for-sale');
        uri = uri.replace('mansion', 'for-sale');

        var id = $(this).attr('id').replace("btnDetail", "");
        var action = uri+'/detail/';
        action = action+id;
        var open1 = $("#open_flag").val();
        var open2 = $("#noimage_open_flag").val();
        if((Number(open1)+Number(open2)) > 0) {
            action = action + '?open=1';
        }
        $('#link_detail').attr('action', action);
        $('#link_detail').submit();

        console.log(location.href);
    });
    $('[id^=btnParentDetail]').on('click', function(){
        var uri = location.href.replace(location.host, '').replace(/https:\/\//g,'').replace(/http:\/\//g,'').replace(/[\?||&]page=[0-9]*/g,'').replace(/[\?||&]sort=[^&]*/g,'').replace(/#/g,'');

        var id = $(this).attr('id').replace("btnParentDetail", "");
        var action = uri+'/parentDetail/';
        $('[name=id\\[\\]]').val(id);
        $('#link_detail').attr('action', action+id)
        $('#link_detail').submit();

        console.log(location.href);
    });


    // まとめて印刷
    $('#btnMultiPrint').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPrintForm').submit();
                break;
            case 'nav-photo-tab':
                openSelectModal(2);
                break;
            case 'nav-map-tab':

                break;
            case 'nav-summary-tab':
                $('#multiPrintForm').attr('action', $('#multiPrintForm').attr('action')+'?summary=1');
                $('#multiPrintForm').submit();
                break;
            default:

                break;
        }
    });

    $('#btnMultiPrintSet').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPrintForm').submit();
                break;
            case 'nav-photo-tab':
                openSelectModal(2);
                break;
            case 'nav-map-tab':

                break;
            case 'nav-summary-tab':
                $('#multiPrintForm').attr('action', $('#multiPrintForm').attr('action')+'?summary=1');
                $('#multiPrintForm').submit();
                break;
            default:

                break;
        }
    });



    // １枚印刷
    $('#btnSinglePrint').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePrintForm').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(1);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePrintForm').attr('action', $('#singlePrintForm').attr('action')+'?summary=1');
                $('#singlePrintForm').submit();
            break;

            default:
            break;
        }
    });

    $('#btnSinglePrintSet').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePrintForm').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(1);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePrintForm').attr('action', $('#singlePrintForm').attr('action')+'?summary=1');
                $('#singlePrintForm').submit();
            break;

            default:
            break;
        }
    });

    // まとめて印刷
    $('#btnMultiPrintVendor').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPrintFormVendor').submit();
                break;
            case 'nav-photo-tab':
                openSelectModal(2);
                break;
            case 'nav-map-tab':

                break;
            case 'nav-summary-tab':
                $('#multiPrintFormVendor').attr('action', $('#multiPrintFormVendor').attr('action')+'?summary=1');
                $('#multiPrintFormVendor').submit();
                break;
            default:

                break;
        }
    });



    // １枚印刷
    $('#btnSinglePrintVendor').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePrintFormVendor').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(1);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePrintFormVendor').attr('action', $('#singlePrintFormVendor').attr('action')+'?summary=1');
                $('#singlePrintFormVendor').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPdf').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPdfForm').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPdfForm').attr('action', $('#multiPdfForm').attr('action')+'?summary=1');
                $('#multiPdfForm').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPdfSet').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPdfForm').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPdfForm').attr('action', $('#multiPdfForm').attr('action')+'?summary=1');
                $('#multiPdfForm').submit();
            break;

            default:
            break;
        }
    });

    $('#btnSinglePrintSet1').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePrintFormSet1').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePrintFormSet1').attr('action', $('#singlePrintFormSet1').attr('action')+'?summary=1');
                $('#singlePrintFormSet1').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPrintSet1').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPrintFormSet1').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPrintFormSet1').attr('action', $('#multiPrintFormSet1').attr('action')+'?summary=1');
                $('#multiPrintFormSet1').submit();
            break;

            default:
            break;
        }
    });

    $('#btnSinglePrintSet2').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePrintFormSet2').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePrintFormSet2').attr('action', $('#singlePrintFormSet2').attr('action')+'?summary=1');
                $('#singlePrintFormSet2').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPrintSet2').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPrintFormSet2').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPrintFormSet2').attr('action', $('#multiPrintFormSet2').attr('action')+'?summary=1');
                $('#multiPrintFormSet2').submit();
            break;

            default:
            break;
        }
    });

    $('#btnSinglePrintSet3').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePrintFormSet3').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePrintFormSet3').attr('action', $('#singlePrintFormSet3').attr('action')+'?summary=1');
                $('#singlePrintFormSet3').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPrintSet3').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPrintFormSet3').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPrintFormSet3').attr('action', $('#multiPrintFormSet3').attr('action')+'?summary=1');
                $('#multiPrintFormSet3').submit();
            break;

            default:
            break;
        }
    });


    $('#btnSinglePdfSet1').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePdfFormSet1').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePdfFormSet1').attr('action', $('#singlePdfFormSet1').attr('action')+'?summary=1');
                $('#singlePdfFormSet1').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPdfSet1').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPdfFormSet1').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPdfFormSet1').attr('action', $('#multiPdfFormSet1').attr('action')+'?summary=1');
                $('#multiPdfFormSet1').submit();
            break;

            default:
            break;
        }
    });

    $('#btnSinglePdfSet2').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePdfFormSet2').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePdfFormSet2').attr('action', $('#singlePdfFormSet2').attr('action')+'?summary=1');
                $('#singlePdfFormSet2').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPdfSet2').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPdfFormSet2').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPdfFormSet2').attr('action', $('#multiPdfFormSet2').attr('action')+'?summary=1');
                $('#multiPdfFormSet2').submit();
            break;

            default:
            break;
        }
    });

    $('#btnSinglePdfSet3').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePdfFormSet3').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePdfFormSet3').attr('action', $('#singlePdfFormSet3').attr('action')+'?summary=1');
                $('#singlePdfFormSet3').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPdfSet3').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPdfFormSet3').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPdfFormSet3').attr('action', $('#multiPdfFormSet3').attr('action')+'?summary=1');
                $('#multiPdfFormSet3').submit();
            break;

            default:
            break;
        }
    });


    $('#btnSinglePdf').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePdfForm').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(3);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePdfForm').attr('action', $('#singlePdfForm').attr('action')+'?summary=1');
                $('#singlePdfForm').submit();
            break;

            default:
            break;
        }
    });


    $('#btnSinglePdfSet').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePdfForm').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(3);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePdfForm').attr('action', $('#singlePdfForm').attr('action')+'?summary=1');
                $('#singlePdfForm').submit();
            break;

            default:
            break;
        }
    });

    $('#btnMultiPdfVendor').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#multiPdfFormVendor').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(4);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#multiPdfFormVendor').attr('action', $('#multiPdfFormVendor').attr('action')+'?summary=1');
                $('#multiPdfFormVendor').submit();
            break;

            default:
            break;
        }
    });

    $('#btnSinglePdfVendor').on('click', function(){
        var id = $('a.nav-link.active').attr('id');
        switch (id) {
            case 'nav-property-tab':
                $('#singlePdfFormVendor').submit();
            break;

            case 'nav-photo-tab':
                openSelectModal(3);
            break;

            case 'nav-map-tab':
            break;

            case 'nav-summary-tab':
                $('#singlePdfFormVendor').attr('action', $('#singlePdfFormVendor').attr('action')+'?summary=1');
                $('#singlePdfFormVendor').submit();
            break;

            default:
            break;
        }
    });


    // 写真枚数選択
    $('.btnPhotoPrint').on('click', function(){
        var num = $(this).attr('data-n');
        var type = $('#type').val();
        switch(type) {
            case '1':
                $('#singlePrintForm').attr('action', $('#singlePrintForm').attr('action')+'?photo=1&num='+num);
                $('#singlePrintForm').submit();
            break;

            case '2':
                $('#multiPrintForm').attr('action', $('#multiPrintForm').attr('action')+'?photo=1&num='+num);
                $('#multiPrintForm').submit();
            break;

            case '3':
                $('#singlePdfForm').attr('action', $('#singlePdfForm').attr('action')+'?photo=1&num='+num);
                $('#singlePdfForm').submit();
            break;
    
            case '4':
                $('#multiPdfForm').attr('action', $('#multiPdfForm').attr('action')+'?photo=1&num='+num);
                $('#multiPdfForm').submit();
            break;

            default:
            break;
        }
    });



    // １枚印刷
    $('#btnListPrint').on('click', function(){
        $('#listPrintForm').submit();
    });

    $('#btnListPdf').on('click', function(){
        $('#listPrintForm').attr('action', $('#listPrintForm').attr('action')+'?type=1');
        $('#listPrintForm').submit();
    });

    $('.modal-open-history').on('click', function(){
        var num = $(this).attr('data-num');
        openSelectModal("", num);
        return false;
    });

    $('.modal-open-set').on('click', function(){
        openSetModal("");
        return false;
    });
    $('.modal-open-set-pdf').on('click', function(){
        openSetModalPDF("");
        return false;
    });

    //モーダルウィンドウを出現させるクリックイベント
    function openSelectModal(type, num="") {

        //キーボード操作などにより、オーバーレイが多重起動するのを防止する
        $( this ).blur();  //ボタンからフォーカスを外す
        if( $( "#modal-overlay" )[0] ) return false;       //新しくモーダルウィンドウを起動しない (防止策1)
        //if($("#modal-overlay")[0]) $("#modal-overlay").remove();     //現在のモーダルウィンドウを削除して新しく起動する (防止策2)
        if(type != "") {
            $('#type').val(type);
        }

        //オーバーレイを出現させる
        $( "body" ).append( '<div id="modal-overlay"></div>' );
        $( "#modal-overlay" ).fadeIn( "slow" );

        //コンテンツをセンタリングする
        centeringModalSyncer(num);

        //コンテンツをフェードインする
        if(num == "") {
            $( "#modal-content" ).fadeIn( "slow" );
        } else {
            $( "#modal-content"+num ).fadeIn( "slow" );
        }

        if(num == "") {
        //[#modal-overlay]、または[#modal-close]をクリックしたら…
            $( "#modal-overlay,#modal-close" ).unbind().click( function(){

                //[#modal-content]と[#modal-overlay]をフェードアウトした後に…
                $( "#modal-content,#modal-overlay" ).fadeOut( "slow" , function(){

                    //[#modal-overlay]を削除する
                    $('#modal-overlay').remove();

                });
        });
        } else {
            //[#modal-overlay]、または[#modal-close]をクリックしたら…
            $( "#modal-overlay,#modal-close" ).unbind().click( function(){

                //[#modal-content]と[#modal-overlay]をフェードアウトした後に…
                $( "#modal-content"+num+",#modal-overlay" ).fadeOut( "slow" , function(){

                    //[#modal-overlay]を削除する
                    $('#modal-overlay').remove();

                });
        });
        }

    }

    //モーダルウィンドウを出現させるクリックイベント
    function openSetModal(type, num="") {

        //キーボード操作などにより、オーバーレイが多重起動するのを防止する
        $( this ).blur();  //ボタンからフォーカスを外す
        if( $( "#modal-overlay" )[0] ) return false;       //新しくモーダルウィンドウを起動しない (防止策1)
        //if($("#modal-overlay")[0]) $("#modal-overlay").remove();     //現在のモーダルウィンドウを削除して新しく起動する (防止策2)
        if(type != "") {
            $('#type').val(type);
        }

        //オーバーレイを出現させる
        $( "body" ).append( '<div id="modal-overlay"></div>' );
        $( "#modal-overlay" ).fadeIn( "slow" );

        //コンテンツをセンタリングする
        centeringSetModalSyncer(num);

        //コンテンツをフェードインする
        $( "#modal-content-set" ).fadeIn( "slow" );

        $( "#modal-overlay,#modal-close" ).unbind().click( function(){

                //[#modal-content]と[#modal-overlay]をフェードアウトした後に…
                $( "#modal-content-set,#modal-overlay" ).fadeOut( "slow" , function(){

                    //[#modal-overlay]を削除する
                    $('#modal-overlay').remove();

                });
        });

    }

        //モーダルウィンドウを出現させるクリックイベント
        function openSetModalPDF(type, num="") {

            //キーボード操作などにより、オーバーレイが多重起動するのを防止する
            $( this ).blur();  //ボタンからフォーカスを外す
            if( $( "#modal-overlay" )[0] ) return false;       //新しくモーダルウィンドウを起動しない (防止策1)
            //if($("#modal-overlay")[0]) $("#modal-overlay").remove();     //現在のモーダルウィンドウを削除して新しく起動する (防止策2)
            if(type != "") {
                $('#type').val(type);
            }
    
            //オーバーレイを出現させる
            $( "body" ).append( '<div id="modal-overlay"></div>' );
            $( "#modal-overlay" ).fadeIn( "slow" );
    
            //コンテンツをセンタリングする
            centeringSetModalSyncer(num);
    
            //コンテンツをフェードインする
            $( "#modal-content-set-pdf" ).fadeIn( "slow" );
    
            $( "#modal-overlay,#modal-close" ).unbind().click( function(){
    
                    //[#modal-content]と[#modal-overlay]をフェードアウトした後に…
                    $( "#modal-content-set-pdf,#modal-overlay" ).fadeOut( "slow" , function(){
    
                        //[#modal-overlay]を削除する
                        $('#modal-overlay').remove();
    
                    });
            });
    
        }

    //リサイズされたら、センタリングをする関数[centeringModalSyncer()]を実行する
    $( window ).resize( centeringModalSyncer );

    //センタリングを実行する関数
    function centeringModalSyncer(num = "") {

        //画面(ウィンドウ)の幅、高さを取得
        var w = $( window ).width();
        var h = $( window ).height();

        // コンテンツ(#modal-content)の幅、高さを取得
        if(num == "") {
            var cw = $( "#modal-content" ).outerWidth();
            var ch = $( "#modal-content" ).outerHeight();
    
            //センタリングを実行する
            $( "#modal-content" ).css( {"left": ((w - cw)/2) + "px","top": ((h - ch)/2) + "px"} );
        } else {
            var cw = $( "#modal-content"+num ).outerWidth();
            var ch = $( "#modal-content"+num ).outerHeight();
    
            //センタリングを実行する
            $( "#modal-content"+num ).css( {"left": ((w - cw)/2) + "px","top": ((h - ch)/2) + "px"} );
        }

    }

    //センタリングを実行する関数
    function centeringSetModalSyncer(num = "") {

        //画面(ウィンドウ)の幅、高さを取得
        var w = $( window ).width();
        var h = $( window ).height();

        // コンテンツ(#modal-content)の幅、高さを取得
        var cw = $( "#modal-content-set" ).outerWidth();
        var ch = $( "#modal-content-set" ).outerHeight();

        //センタリングを実行する
        $( "#modal-content-set" ).css( {"left": ((w - cw)/2) + "px","top": ((h - ch)/2) + "px"} );

    }
});
