<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'The :attribute must be accepted.',
    'active_url' => 'The :attribute is not a valid URL.',
    'after' => 'The :attribute must be a date after :date.',
    'after_or_equal' => 'The :attribute must be a date after or equal to :date.',
    'alpha' => 'The :attribute may only contain letters.',
    'alpha_dash' => 'The :attribute may only contain letters, numbers, dashes and underscores.',
    'alpha_num' => 'The :attribute may only contain letters and numbers.',
    'array' => 'The :attribute must be an array.',
    'before' => 'The :attribute must be a date before :date.',
    'before_or_equal' => 'The :attribute must be a date before or equal to :date.',
    'between' => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file' => 'The :attribute must be between :min and :max kilobytes.',
        'string' => 'The :attribute must be between :min and :max characters.',
        'array' => 'The :attribute must have between :min and :max items.',
    ],
    'boolean' => 'The :attribute field must be true or false.',
    'confirmed' => ':attributeと:attribute（確認用）が一致しません。',
    'date' => 'The :attribute is not a valid date.',
    'date_equals' => 'The :attribute must be a date equal to :date.',
    'date_format' => 'The :attribute does not match the format :format.',
    'different' => 'The :attribute and :other must be different.',
    'digits' => 'The :attribute must be :digits digits.',
    'digits_between' => 'The :attribute must be between :min and :max digits.',
    'dimensions' => 'The :attribute has invalid image dimensions.',
    'distinct' => 'The :attribute field has a duplicate value.',
    'email' => ':attributeがメールアドレスの形式と一致しません',
    'exists' => 'The selected :attribute is invalid.',
    'file' => 'The :attribute must be a file.',
    'filled' => 'The :attribute field must have a value.',
    'gt' => [
        'numeric' => 'The :attribute must be greater than :value.',
        'file' => 'The :attribute must be greater than :value kilobytes.',
        'string' => 'The :attribute must be greater than :value characters.',
        'array' => 'The :attribute must have more than :value items.',
    ],
    'gte' => [
        'numeric' => 'The :attribute must be greater than or equal :value.',
        'file' => 'The :attribute must be greater than or equal :value kilobytes.',
        'string' => 'The :attribute must be greater than or equal :value characters.',
        'array' => 'The :attribute must have :value items or more.',
    ],
    'image' => 'The :attribute must be an image.',
    'in' => 'The selected :attribute is invalid.',
    'in_array' => 'The :attribute field does not exist in :other.',
    'integer' => ':attribute は数値で入力してください。',
    'ip' => 'The :attribute must be a valid IP address.',
    'ipv4' => 'The :attribute must be a valid IPv4 address.',
    'ipv6' => 'The :attribute must be a valid IPv6 address.',
    'json' => 'The :attribute must be a valid JSON string.',
    'lt' => [
        'numeric' => 'The :attribute must be less than :value.',
        'file' => 'The :attribute must be less than :value kilobytes.',
        'string' => 'The :attribute must be less than :value characters.',
        'array' => 'The :attribute must have less than :value items.',
    ],
    'lte' => [
        'numeric' => 'The :attribute must be less than or equal :value.',
        'file' => 'The :attribute must be less than or equal :value kilobytes.',
        'string' => 'The :attribute must be less than or equal :value characters.',
        'array' => 'The :attribute must not have more than :value items.',
    ],
    'max' => [
        'numeric' => 'The :attributeは:max以下の数字で設定してください。',
        'file' => ':attribute may not be greater than :max kilobytes.',
        'string' => ':attributeは:max文字以下にしてください。',
        'array' => 'The :attribute may not have more than :max items.',
    ],
    'mimes' => 'The :attribute must be a file of type: :values.',
    'mimetypes' => 'The :attribute must be a file of type: :values.',
    'min' => [
        'numeric' => 'The :attribute must be at least :min.',
        'file' => 'The :attribute must be at least :min kilobytes.',
        'string' => 'The :attribute must be at least :min characters.',
        'array' => 'The :attribute must have at least :min items.',
    ],
    'not_in' => 'The selected :attribute is invalid.',
    'not_regex' => 'The :attribute format is invalid.',
    'numeric' => ':attributeは数値で入力してください。',
    'present' => 'The :attribute field must be present.',
    'regex' => 'The :attribute format is invalid.',
    'required' => ':attributeは必須項目です。',
    'required_if' => 'The :attribute field is required when :other is :value.',
    'required_unless' => 'The :attribute field is required unless :other is in :values.',
    'required_with' => 'The :attribute field is required when :values is present.',
    'required_with_all' => 'The :attribute field is required when :values are present.',
    'required_without' => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'same' => 'The :attribute and :other must match.',
    'size' => [
        'numeric' => 'The :attribute must be :size.',
        'file' => 'The :attribute must be :size kilobytes.',
        'string' => 'The :attribute must be :size characters.',
        'array' => 'The :attribute must contain :size items.',
    ],
    'starts_with' => 'The :attribute must start with one of the following: :values',
    'string' => 'The :attribute must be a string.',
    'timezone' => 'The :attribute must be a valid zone.',
    'unique' => 'すでに登録されている:attributeです。',
    'uploaded' => 'The :attribute failed to upload.',
    'url' => 'The :attribute format is invalid.',
    'uuid' => 'The :attribute must be a valid UUID.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        // 物件登録_基本情報
        'name' =>  '物件名',
        'name_portal' =>  '物件名（ポータル用）',
        'zip' =>  '所在地の郵便番号',
        'address1' =>  '所在地の都道府県',
        'address2' =>  '所在地の市区郡',
        'address3' =>  '所在地の町村',
        'main_traffic' => '主要交通',
        'main_traffic_line' => '主要交通の路線',
        'main_traffic_station' => '主要交通の駅名',
        'main_traffic_time' => '主要交通の時間',
        'main_traffic_bus_time' => '主要交通の乗車時間',
        'main_traffic_bus' => '主要交通のバス停名',
        'main_traffic_bus_walk' => '主要交通の時間',
        'sub_traffic1' => '補助交通１',
        'sub_traffic1_line' => '補助交通１の路線',
        'sub_traffic1_station' => '補助交通１の駅名',
        'sub_traffic1_time' => '補助交通１の時間',
        'sub_traffic1_bus_time' => '補助交通１の乗車時間',
        'sub_traffic1_bus' => '補助交通１のバス停名',
        'sub_traffic1_bus_walk' => '補助交通１の時間',
        'sub_traffic2' => '補助交通２',
        'sub_traffic2_line' => '補助交通２の路線',
        'sub_traffic2_station' => '補助交通２の駅名',
        'sub_traffic2_time' => '補助交通２の時間',
        'sub_traffic2_bus_time' => '補助交通２の乗車時間',
        'sub_traffic2_bus' => '補助交通２のバス停名',
        'sub_traffic2_bus_walk' => '補助交通２の時間',
        'memo1' => '備考１',
        'memo2' => '備考２',

        // マンション_部屋
        'room_num' => '部屋番号',
        'whereabouts' => '階数',
        'move_in' => '引き渡し',
        

        // 物件情報_価格
        'price' => '物件価格',
        'council_cost' => '町会費の金額',
        'spring_cost' => '温泉の金額',
        'another_cost1' => 'その他諸経費１の金額',
        'another_cost2' => 'その他諸経費２の金額',

        // 物件情報_概要
        'land_area_val' => '土地面積',
        'building_plan_place' => '建築条件の建物価格',
        'building_plan_area' => '建築条件の建物面積',
        'building_rate' => '建ぺい率',
        'volume_rate' => '容積率',
        'road_burden_area' => '私道負担の私道面積',
        'road_numerator' => '私道負担の私道持分比率：持分',
        'road_denominator' => '私道負担の私道持分比率：全体',
        'easement_area' => '地役権の面積',
        'set_area' => 'セットパックの面積',
        'other_comment' => 'その他制限事項',
        'internet_cost' => 'インターネットに係る費用の初期費用',
        'internet_fixed_cost' => 'インターネットに係る費用の定額費用',
        'catv_cost' => 'CATVに係る費用の初期費用',
        'catv_fixed_cost' => 'CATVに係る費用の定額費用',

        'age_year' => '築年月（年）',
        'age_month' => '築年月（月）',
        'move_year' => '引き渡し（年）',
        'move_month' => '引き渡し（月）',
        'architecture_no' => '建築確認番号',
        

        
        // ユーザー設定
        'last_name' => '名字',
        'first_name' => '名前',
        'email' => 'メールアドレス',
        'password' => 'パスワード',
        'password_confirmation' => 'パスワード（確認用）',

        // リフォーム
        'cost' => 'リフォーム費用',

    ],

];
