@php
    $menu_list = config('const.NAV_LIST');
@endphp
<nav class="navbar navbar-expand-lg navbar-light l-nav">
  <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarToggler" aria-controls="navbarToggler" aria-expanded="false" aria-label="Toggle navigation">
    <span class="navbar-toggler-icon"></span>
  </button>
  <div class="collapse navbar-collapse l-nav__container" id="navbarToggler">
    <ul class="navbar-nav mr-auto mt-2 mt-lg-0 nav-justified l-nav__gmenu">
      @foreach($menu_list as $menu_info)
      <li class="nav-item {{ isActiveUrl($menu_info['url']) }} l-nav__gmenu--list">
        <a class="nav-link l-nav__gmenu--link" href="@if(!isset($menu_info['subtitle'])) {{$menu_info['url']}} @else javascript:void; @endif">{{$menu_info['title']}}</a>
        @if(isset($menu_info['subtitle']))
          <ul class="l-nav__submenu">
          @foreach($menu_info['subtitle'] as $sub)
            <li class="l-nav__submenu--list"><a class="l-nav__submenu--link" href="{{$sub['url']}}" @if($sub['url'] == "") style="pointer-events: none; color:gray !important;" @endif>{{$sub['name']}}</a></li>
          @endforeach
          </ul>
        @endif
      </li>
      @endforeach
      <li class="nav-item d-lg-none">
        <a class="nav-link" href="{{ route('logout') }}"
          onclick="event.preventDefault();
                        document.getElementById('logout-form').submit();">
          {{ __('messages.Logout') }}
        </a>
      </li>
    </ul>
  </div>
</nav>