{{-- チェックボックス --}}
{{-- 
    $name:パーツ使用時のnameを指定(必須)
    $checkbox:チェックボックスに使用するアイテムの配列($options[['code', 'name', 'checked'],...])
    $class: 追加クラス
--}}
@if(count($checkbox) > 1)
    @foreach($checkbox as $item)
<label class="u-checkbox {{$class??''}}">
    <input type="checkbox" class="u-checkbox__obj" name="{{$name}}[]" value="{{$item['code']}}" @if((old($name)==$item['code'])) checked="checked" @elseif(isset($item['checked']) && $item['checked'] == 1) checked="checked" @endif id="{{$name}}-{{$loop->iteration}}">
    <span class="u-checkbox__text">{{$item['name']}}</span>
</label>
    @if($loop->iteration % 12 == 0 && !$loop->last)
    <hr>
    @endif
    @endforeach
@else
    @foreach($checkbox as $item)
<label class="u-checkbox">
    <input type="checkbox" class="u-checkbox__obj" name="{{$name}}" value="{{$item['code']}}" @if((old($name)==$item['code'])) checked="checked" @elseif(isset($item['checked']) && $item['checked'] == 1) checked="checked" @endif id="{{$name}}-{{$loop->iteration}}">
    <span class="u-checkbox__text">{{$item['name']}}</span>
</label>
    @endforeach
@endif