{{-- ラジオボタン --}}
{{-- 
    $name:パーツ使用時のnameを指定(必須)
    $radio:ラジオボタンに使用するアイテムの配列($options[['code', 'name'],...])
    $checked:設定されているvalueを指定
    $default: デフォルトで選択されるラジオボタンのvalue
--}}
@php
    $check_item = $default??null;
    $old = old($name)??null;
    if(isset($old)) {
        $check_item = old($name);
    } elseif(isset($checked)) {
        $check_item = $checked;
    }
@endphp
@foreach($radio as $item)
<input type="radio" class="u-radio" name="{{$name}}" value="{{$item['code']}}" @if($check_item == $item['code']) checked @endif id="{{$name}}-{{$loop->iteration}}">
@if(str_contains($item['name'], '&sup2;'))
    @php
        $item_name = $item['name'];
        $item_name = str_replace('&sup2;', '', $item_name);
    @endphp
<label for="{{$name}}-{{$loop->iteration}}" class="u-radio__label">{{$item_name}}&sup2;</label>
@elseif(str_contains($item['name'], 'その他'))
<label for="{{$name}}-{{$loop->iteration}}" class="u-radio__label">{{$item['name']}}</label>
    @include('admin.objects.components.input', ['name' => $name.'_text', 'value' => isset($article->{$name.'_text'})??''])
@else
<label for="{{$name}}-{{$loop->iteration}}" class="u-radio__label">{{$item['name']}}</label>
@endif
@if(isset($item['add_text']))
<span class="search_target">{{$item['add_text']}}</span>
@endif
@endforeach