{{-- セレクトボックス --}}
{{-- 
    $name:パーツ使用時のnameを指定(必須)
    $options:optionに使用するアイテムの配列($options[['code', 'name'],...])
    $selected:設定されているvalueを指定
    $class: 追加クラス
    $title:未選択のテキストを指定(「$titleを選択してください」が表示される)
--}}
<select class="c-selectbox @if(isset($class)) {{$class}} @endif" name="{{$name}}">
@if(!empty($title))
<option value="" {{isSelected('', $selected?? null) }}>{{$title}}選択</option>
@endif
@foreach($options as $item)
    <option value="{{$item['code']}}" @if(isset($selected) && $selected==$item['code']) selected @elseif(old($name) != null && old($name)==$item['code']) selected @endif>{{$item['name']}}</option>
@endforeach
</select>