@php
$regular_leased_registration = [
    ['code' => 0, 'name' => '未選択'], 
    ['code' => 1, 'name' => '可'],
    ['code' => 2, 'name' => '不可'],
    ['code' => 3, 'name' => '相談'],
];
$regular_leased_season = [
    ['code' => 0, 'name' => '未選択'], 
    ['code' => 1, 'name' => '一定期間毎'],
    ['code' => 2, 'name' => '事前協議により決定'],
];
$regular_leased_cost = [
    ['code' => 0, 'name' => '未選択'], 
    ['code' => 1, 'name' => '公式'],
    ['code' => 2, 'name' => '事前協議により決定'],
];
$regular_leased_transfer = [
    ['code' => 0, 'name' => '未選択'], 
    ['code' => 1, 'name' => '可'],
    ['code' => 2, 'name' => '不可'],
];
$regular_leased_transfer_method = [
    ['code' => 0, 'name' => '未選択'], 
    ['code' => 1, 'name' => '承諾不要'],
    ['code' => 2, 'name' => '通知要'],
    ['code' => 3, 'name' => '承諾要'],
];
$regular_leased_transfer_necessity = [
    ['code' => 0, 'name' => '未選択'], 
    ['code' => 1, 'name' => '要'],
    ['code' => 2, 'name' => '不要'],
    ['code' => 3, 'name' => '未定'],
];
$regular_leased_transfer_consent = [
    ['code' => 0, 'name' => '未選択'], 
    ['code' => 1, 'name' => '地主'],
    ['code' => 2, 'name' => '転貸主'],
];
@endphp
<tr>
    <th colspan="2" rowspan="13">土地権利</th>
    <td colspan="4">
        @include('admin.objects.components.radio', ['name' => 'land_right', 'radio' => $land_right, 'default' => 0, 'checked' => $article->land_right?? 0])
    </td>
</tr>
<tr id="land_right1">
    <th>借地権種別</th>
    <td colspan="3">
        @include('admin.objects.components.radio', ['name' => 'leasehold_kind', 'radio' => $leasehold, 'default' => 1, 'checked' => $article->leasehold_kind?? 1])
    </td>
</tr>
<tr id="land_right2">
    <th>借地権割合</th>
    <td colspan="3">
        @include('admin.objects.components.input', ['name' => 'leasehold_rate', 'value' => $article->leasehold_rate?? ''])%
    </td>
</tr>
<tr id="land_right3">
    <th>地代</th>
    <td colspan="3">
        @include('admin.objects.projects.umu-radio', ['name' => 'land_rent', 'default' => 0, 'checked' => $article->land_rent?? 0])
        <div id="land_rent_area">
            @include('admin.objects.components.input', ['name' => 'land_rent_val', 'value' => $article->land_rent_val?? ''])円/
            @include('admin.objects.components.radio', ['name' => 'land_rent_unit', 'radio' => $land_rent_unit, 'default' => 1, 'checked' => $article->land_rent_unit?? 1])
        </div>
    </td>
</tr>
<tr id="land_right4">
    <th>借地期間</th>
    <td colspan="3">
        @include('admin.objects.components.radio', ['name' => 'leasehold_period', 'radio' => $leasehold_period, 'default' => 2, 'checked' => $article->leasehold_period?? 2])
        <div>
            @include('admin.objects.components.selectbox', ['name' => 'leasehold_period_year', 'options' => Config::get('const.NEN'), 'selected' => $article->leasehold_period_year?? ''])年
            @include('admin.objects.components.selectbox', ['name' => 'leasehold_period_month', 'options' => Config::get('const.KAGETSU'), 'selected' => $article->leasehold_period_month?? ''])ヶ月
        </div>
    </td>
</tr>
<tr id="land_right5">
    <th>権利金</th>
    <td colspan="3">
        @include('admin.objects.components.radio', ['name' => 'right_cost', 'radio' => $right_cost, 'default' => 0, 'checked' => $article->right_cost?? 0])
        <div id="right_cost_area">
            @include('admin.objects.components.input', ['name' => 'right_cost_val', 'value' => $article->right_cost_val?? ''])万円
        </div>
    </td>
</tr>
<tr id="land_right6">
    <th>保証金</th>
    <td colspan="3">
        @include('admin.objects.projects.umu-radio', ['name' => 'deposit_cost', 'default' => 0, 'checked' => $article->deposit_cost?? 0])
        <div id="deposit_cost_area">
            @include('admin.objects.components.input', ['name' => 'deposit_cost_val', 'value' => $article->deposit_cost_val?? ''])万円
        </div>
    </td>
</tr>
<tr id="land_right7">
    <th>敷金</th>
    <td colspan="3">
        @include('admin.objects.projects.umu-radio', ['name' => 'security_deposit_cost', 'default' => 0, 'checked' => $article->security_deposit_cost?? 0])
        <div id="security_deposit_cost_area">
            @include('admin.objects.components.input', ['name' => 'security_deposit_cost_val', 'value' => $article->security_deposit_cost_val?? ''])万円
        </div>
    </td>
</tr>
<tr id="land_right8">
    <th>借地権その他契約事項</th>
    <td colspan="3">
        @include('admin.objects.components.input', ['name' => 'other_leasehold', 'class' => 'w200', 'value' => $article->other_leasehold?? ''])
    </td>
</tr>



<tr id="land_right9">
    <th>定期借地権設定登記</th>
    <td colspan="3">
        @include('admin.objects.components.radio', ['name' => 'regular_leased_registration', 'radio' => $regular_leased_registration, 'default' => 0, 'checked' => $article->t?? 0])
    </td>
</tr>
<tr id="land_right10">
    <th>定期借地権賃料改定時期</th>
    <td colspan="3">
        @include('admin.objects.components.radio', ['name' => 'regular_leased_season', 'radio' => $regular_leased_season, 'default' => 0, 'checked' => $article->regular_leased_season?? 0])
        <div id="regular_leased_season_area">
            @include('admin.objects.components.input', ['name' => 'regular_leased_season_nen', 'class' => 'w100', 'value' => $article->regular_leased_season_nen?? ''])年毎
        </div>
    </td>
</tr>
<tr id="land_right11">
    <th>定期借地権賃料改定額</th>
    <td colspan="3">
        @include('admin.objects.components.radio', ['name' => 'regular_leased_cost', 'radio' => $regular_leased_cost, 'default' => 0, 'checked' => $article->regular_leased_cost?? 0])
    </td>
</tr>
<tr id="land_right12">
    <th>定期借地権譲渡転貸</th>
    <td colspan="3">
        <div class="d-flex"><p class="w125 mb-0">譲渡可否</p>&nbsp;@include('admin.objects.components.radio', ['name' => 'regular_leased_transfer', 'radio' => $regular_leased_transfer, 'default' => 0, 'checked' => $article->regular_leased_transfer?? 0])</div>
        <div id="regular_leased_transfer_area">
            <div class="d-flex"><p class="w125 mb-0">承諾要否・方法</p>&nbsp;@include('admin.objects.components.radio', ['name' => 'regular_leased_transfer_method', 'radio' => $regular_leased_transfer_method, 'default' => 0, 'checked' => $article->regular_leased_transfer_method?? 0])</div>
            <div class="d-flex"><p class="w125 mb-0">承諾料要否</p>&nbsp;@include('admin.objects.components.radio', ['name' => 'regular_leased_transfer_necessity', 'radio' => $regular_leased_transfer_necessity, 'default' => 0, 'checked' => $article->regular_leased_transfer_necessity?? 0])</div>
            <div class="d-flex"><p class="w125 mb-0">承諾者</p>&nbsp;@include('admin.objects.components.radio', ['name' => 'regular_leased_transfer_consent', 'radio' => $regular_leased_transfer_consent, 'default' => 0, 'checked' => $article->regular_leased_transfer_consent?? 0])</div>
        </div>
    </td>
</tr>