{{-- 並び替え --}}
<div class="p-results-noimage">
@foreach($article_list as $item)
    <div class="mb-3 mansion-list">
        <table class="p-results-noimage__tbl">
            <tr>
                <td rowspan="2" class="p-results-noimage__tbl-num-date">
                    <p><span class="p-results-noimage__tbl-number">分譲地番号</span><br><a href="/admin/editLot/{{$item->building_id}}" class="target_link_id">{{$item->building_id}}</a></p>
                    <p class="mt-1"><a href="javascript:void(0);" class="p-results-current-condition__panel--btn-delete disp_room_noimage" name="show_room_btn">売出({{$item->lot_count}})</a></p>
                </td>
                <th class="w70">物件名</th>
                <td class="w250">
                    <div class="d-flex justify-content-between">
                        <p>{{$item->name}}</p>
                        <a href="/admin/editLot/{{$item->building_id}}" class="p-results-noimage__tbl-link-mansion">
                            <img src="../../admin/img/toroku.png">
                        </a>
                    </div>
                </td>
                <th class="w70">住所</th><td>{{$item->address}}</td>
                <th class="w70">校区</th><td class="w250">{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
            </tr>
            <tr>
                <th class="w100">総区画数</th>
                <td>{{$item->section}}区画</td>
                <th>交通</th><td>{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                <th></th><td></td>
            </tr>
        </table>
        @foreach($item->lot_list as $lot)
            @php
                $url = "";
                if($lot->property < 4) {
                    $url = '/admin/editLand/'.$lot->building_id;
                } else {
                    $url = '/admin/editHouse/'.$lot->building_id;
                }
            @endphp
        <div class="p-mansion-room">
            <table class="p-mansion-room__tbl">
                <tr>
                    <td class="p-mansion-room__tbl-number" rowspan="2">物件番号<br>
                    @include('business.objects.components.link', ['url' => $url, 'title' => $lot->building_id, 'class' => 'p-form-check__tbl-link-id'])
                    </td>
                    <th>物件名</th>
                    <td class="p-mansion-room__tbl__w200">{{$lot->name}}</td>
                    <th>価格</th>
                    <td>{{$lot->price?? '-'}}<span>万円</span></td>
                    <th>土地</th>
                    <td>{{$lot->land_area_val?? '-'}}m&sup2;</td>
                    <th>間取り</th>
                    <td>{{$lot->floor_plan_text?? '-'}}</td>
                    <td></td>
                    <td colspan="3" rowspan="2">
                        <ul class="p-results-image__li-btns d-flex justify-content-end list-unstyled">
                            <li>
                                @include('admin.objects.components.circle-btn-mansion',
                                    ['id' => 'btnCheck', 'class' => 'c-circle-btn__check-mansion_noimage', 'linkUrl' => '#',
                                    'img' => '../../admin/img/icon_check.png', 'title' => '確認'])
                            </li>
                            <li>
                                @include('admin.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDetail'.$item->building_id, 'class' => 'c-circle-btn__detail', 'linkUrl' => $url,
                                    'img' => '../../admin/img/icon_detail.png', 'title' => '詳細'])
                            </li>
                        </ul>
                    </td>
                </tr>
                <tr>
                    <th>種別</th>
                    <td>{{$lot->property_name}}</td>
                    <th>築年月</th>
                    <td>{{$lot->age_year}}年{{$lot->age_month}}月</td>
                    <th>延床</th>
                    <td>{{$lot->total_area_val}}m&sup2;</td>
                    <th>階数</th>
                    <td>{{$lot->floor}}階建</td>
                    <td><img src="/admin/img/icon_camera.png" alt="写真">{{$lot->file_count}}</p></td>
                </tr>
            </table>

            {{-- 確認ボタンクリック時に表示する --}}
            @include('admin.objects.projects.form-check-lot', ['data_num' => $loop->iteration+$lot_count, 'history_count' => count($lot->history)])
            @include('admin.objects.projects.modal-history', ['history' => $lot->history, 'data_num' => $loop->iteration+$lot_count])
        </div>
        @endforeach
    </div>
@endforeach
</div>
