{{-- 並び替え --}}
<div class="p-results-noimage">
@include("admin.objects.components.delete-multi-control")
@foreach($article_list as $item)
    <div class="mb-3 mansion-list">
        <table class="p-results-noimage__tbl">
            <tr>
		<td rowspan="2" style="width: 30px">
                    <input type="checkbox" onclick="clickElementDelete(this)" class="cb-delete" name="article_id[]" value="{{ $item->id }}">
                </td>
                <td rowspan="2" class="p-results-noimage__tbl-num-date">
                    <p><span class="p-results-noimage__tbl-number">マンションID</span><br><a href="/admin/editMansion/{{$item->building_id}}" class="target_link_id">{{$item->building_id}}</a></p>
                    <p class="mt-1"><a href="/admin/editMansion/{{$item->building_id}}" class="p-results-current-condition__panel--btn-delete disp_room_noimage" name="show_room_btn">売出({{$item["room_count"]}})</a></p>
                </td>
                <th>物件名</th>
                <td colspan="2">
                    <div class="d-flex justify-content-between">
                        <p>{{$item->name}}</p>
                        <a href="/admin/editMansion/{{$item->building_id}}" class="p-results-noimage__tbl-link-mansion">
                            <img src="../../admin/img/toroku.png">
                        </a>
                    </div>
                </td>
                <th>所在地</th><td colspan="2">{{$item->address}}</td>
                <th>築年月</th><td>{{$item->age_year?? "-"}}年{{$item->age_month?? "-"}}月</td>
                <th>校区</th><td>{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
		<td rowspan="2">
                    <form action="{{ route("admin-mansion-delete", $item) }}" method="POST" onsubmit="return submitDelete(this)">
                        @csrf
                        @method("DELETE")
                        <button>削除</button>
                    </form>
                </td>
            </tr>
            <tr>
                <th>種別</th>
                <td colspan="2">
                        @if($item->property == 6)
                            @if($item->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            マンション
                        @elseif($item->property == 7)
                            @if($item->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            タウンハウス
                        @endif		
                </td>
                <th>交通</th><td colspan="2">{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                <th>総戸数</th><td>{{$item->total_unit?? "-"}}戸</td>
                <th>階数</th><td>{{$item->floor}}階建</td>
            </tr>
        </table>
        @foreach($item->room_list as $room)
        <div class="p-mansion-room">
            <table class="p-mansion-room__tbl">
                <tr>
                    <td class="p-mansion-room__tbl-number">物件番号<br>
                    @include('business.objects.components.link', ['url' => '/admin/editRoom/'.$room->mansion_id.'/'.$room->building_id, 'title' => $room->building_id, 'class' => 'p-form-check__tbl-link-id'])
                </td>
                    <th>部屋</th>
                    <td>{{$room->room_num}}号室</td>
                    <th>価格</th>
                    <td>{{$room->price?? '-'}}<span>万円</span></td>
                    <th>専有</th>
                    <td>{{$room->total_area_val?? '-'}}m&sup2;</td>
                    <th>間取り</th>
                    <td>{{$room->floor_plan_text?? '-'}}</td>
                    <th>階数</th>
                    <td class="p-mansion-room__tbl__w200
                    ">@if($room->maisonette == 1) {{$room->maisonette_from?? '-'}}階〜{{$room->maisonette_to?? '-'}}階部分 @else {{$room->whereabouts?? '-'}}階 @endif</td>
                    <td><img src="/admin/img/icon_camera.png" alt="写真">{{$room->file_count}}</p></td>
                    <td colspan="3">
                        <ul class="p-results-image__li-btns d-flex justify-content-end list-unstyled">
                            <li>
                                @include('admin.objects.components.circle-btn-mansion',
                                    ['id' => 'btnCheck', 'class' => 'c-circle-btn__check-mansion_noimage', 'linkUrl' => '#',
                                    'img' => '../../admin/img/icon_check.png', 'title' => '確認'])
                            </li>
                            <li>
                                @include('admin.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDetail'.$item->building_id, 'class' => 'c-circle-btn__detail', 'linkUrl' => '/admin/editRoom/'.$room->mansion_id.'/'.$room->building_id,
                                    'img' => '../../admin/img/icon_detail.png', 'title' => '詳細'])
                            </li>
                        </ul>
                    </td>
                </tr>
            </table>

            {{-- 確認ボタンクリック時に表示する --}}
            @include('admin.objects.projects.form-check-mansion', ['data_num' => $loop->iteration, 'history_count' => count($room->history)])
            @include('admin.objects.projects.modal-history', ['history' => $room->history, 'data_num' => $loop->iteration])
        </div>
        @endforeach
    </div>
@endforeach
</div>
