{{-- 並び替え --}}
<div class="p-results-noimage">
  @foreach($data as $item)
@php
$bukken_url = '';
if(is_null($item->property)) {
    $bukken_url = '/admin/editRoom/'.$item->mansion_id.'/'.$item->building_id;
} elseif($item->property < 4) {
    $bukken_url = '/admin/editLand/'.$item->building_id;
} elseif($item->property < 6) {
    $bukken_url = '/admin/editHouse/'.$item->building_id;
} elseif($item->property < 8) {
    $bukken_url = '/admin/editMansion/'.$item->building_id;
}
@endphp
  <div class="mb-3">
    <div class="clearfix">
        <ul class="p-results-noimage__btns d-flex justify-content-center list-unstyled float-right">
            <li>
                <a href="javascript:void(0);" name="c-circle-btn__check"><img src="/admin/img/icon_check.png"></a>
            </li>
            <li>
                <a href="
                @if(is_null($item->property))
                /admin/editRoom/{{$item->mansion_id}}/{{$item->building_id}}
                @elseif($item->property < 4)
                /admin/editLand/{{$item->building_id}}
                @elseif($item->property < 6)
                /admin/editHouse/{{$item->building_id}}
                @elseif($item->property < 8)
                /admin/editMansion/{{$item->building_id}}
                @endif
                
                "><img src="/business/img/toroku.png"></a>
            </li>
        </ul>
    </div>
    <table class="p-results-noimage__tbl">
        <tr>
            <td rowspan="2" class="p-results-noimage__tbl-num-date">
                <p><span class="p-results-noimage__tbl-number">物件番号</span><br>
                @include('business.objects.components.link', ['url' => $bukken_url, 'title' => $item->building_id, 'class' => 'p-form-check__tbl-link-id'])
                </p>
                <p class="mt-1"><span class="p-results-noimage__tbl-date">物件登録日</span><br>{{$item->created_at->format('Y/m/d')}}</p>
            </td>
            <th>物件名</th>
            <td colspan="3">
                <div class="d-flex justify-content-between">
                    <p>{{$item->name}}</p>
                    @if(!is_null($item->mansion_id))
                    <a href="/admin/editMansion/{{$item->mansion_id}}" class="p-results-noimage__tbl-link-mansion"><img src="/business/img/toroku.png"></a>
                    @endif
                </div>
            </td>
            <th>所在地</th><td>{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}</td>
            <th>価格</th><td><span>{{$item->price}}</span>万円</td>
            <th>土地</th><td>{{$item->land_area_val?? "-"}}m&sup2;</td>
            <th>校区</th><td>{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
        </tr>
        <tr>
            <th>種別</th><td>{{$item->property_name?? "-"}}</td>
            <th>間取り</th><td>{{$item->floor_plan_text?? "-"}}</td>
            <th>交通</th><td>{{$item->main_traffic_line?? "-"}}「{{$item->main_traffic_station?? "-"}}」徒歩{{$item->main_traffic_time?? "-"}}分</td>
            <th>築年月</th><td>{{$item->age_year?? "-"}}年{{$item->age_month?? "-"}}月</td>
            <th>延床</th><td>{{$item->total_area_val?? "-"}}m&sup2;</td>
            <th>階数</th><td>{{$item->whereabouts?? "-"}}階</td>
        </tr>
    </table>
    {{-- 確認ボタンクリック時に表示する --}}
    @include('admin.objects.projects.form-check', ['data_num' => $loop->iteration+count($data), 'history_count' => count($item->history)])
    @include('admin.objects.projects.modal-history', ['history' => $item->history, 'data_num' => $loop->iteration+count($data)])
  </div>

  
  @endforeach
</div>
