<div class="p-search-mansion">
    <table class="p-search-mansion__tbl">
        <tr>
            <td rowspan="7" class="p-search-mansion__tbl-number">01</td>
            <th>マンション名</th>
            <td class="p-search-mansion__name">
                @include('business.objects.components.input', ['name' => 'name'])
            </td>
            <th>マンションID</th>
            <td class="p-search-mansion__id">
                @include('business.objects.components.input', ['name' => 'id'])
            </td>
            <th>築年数</th>
            <td class="p-search-mansion__years">
                @include('business.objects.components.input', ['name' => 'years_from', 'placeholder' => '下限なし'])〜
                @include('business.objects.components.input', ['name' => 'years_to', 'placeholder' => '上限なし'])年
            </td>
            <th>築年月</th>
            <td class="p-search-mansion__year-month">
                @include('business.objects.components.input', ['name' => 'year_month_from', 'placeholder' => '0000/00'])〜
                @include('business.objects.components.input', ['name' => 'year_month_to', 'placeholder' => '0000/00'])年
            </td>
        </tr>
        <tr>
            <th>所在地</th>
            <td colspan="3" class="p-search-mansion__address">
                @include('business.objects.components.selectbox', ['name' => 'address1', 'options' => [], 'title' => '都道府県'])
                @include('business.objects.components.selectbox', ['name' => 'address2', 'options' => [], 'title' => '市区郡'])
                @include('business.objects.components.selectbox', ['name' => 'address3', 'options' => [], 'title' => '町村'])
                @include('business.objects.components.input', ['name' => 'address4'])
            </td>
            <th>階建</th>
            <td class="p-search-mansion__floor">
                @include('business.objects.components.input', ['name' => 'floor_from', 'placeholder' => '下限なし'])〜
                @include('business.objects.components.input', ['name' => 'floor_to', 'placeholder' => '上限なし'])階建
            </td>
            <th>総戸数</th>
            <td class="p-search-mansion__total-floor">
                @include('business.objects.components.input', ['name' => 'total_floor_from', 'placeholder' => '下限なし'])〜
                @include('business.objects.components.input', ['name' => 'total_floor_to', 'placeholder' => '上限なし'])戸
            </td>
        </tr>
        <tr>
            <th>交通</th>
            <td colspan="5" class="p-search-mansion__access">
                @include('business.objects.components.selectbox', ['name' => 'access1', 'options' => [], 'title' => '沿線'])
                @include('business.objects.components.selectbox', ['name' => 'access2', 'options' => [], 'title' => '駅'])
                @include('business.objects.components.selectbox', ['name' => 'access3', 'options' => [], 'title' => '徒歩/バス'])
                <span>バス</span>@include('business.objects.components.input', ['name' => 'bus'])<span>分以内 / 徒歩</span>
                @include('business.objects.components.input', ['name' => 'walk'])<span>分以内</span>
            </td>
            <th>ペット</th>
            <td>
                @include('business.objects.components.selectbox', ['name' => 'is_pet', 'options' => [], 'title' => '可or不可'])
                @include('business.objects.components.selectbox', ['name' => 'pet_num', 'options' => [], 'title' => '匹数'])
            </td>            
        </tr>
        <tr>
            <th>学校区</th>
            <td colspan="3" class="p-search-mansion__school">
                @include('business.objects.components.selectbox', ['name' => 'primary_school', 'options' => [], 'title' => '小学校区'])
                徒歩@include('business.objects.components.input', ['name' => 'primary_school_walk'])<span>分以内</span>
                @include('business.objects.components.selectbox', ['name' => 'secondary_school', 'options' => [], 'title' => '中学校区'])
                徒歩@include('business.objects.components.input', ['name' => 'secondary_school_walk'])<span>分以内</span>
            </td>
            <th>用途地域</th>
            <td>
                @include('business.objects.components.selectbox', ['name' => 'use_area', 'options' => [], 'title' => ''])
            </td>
            <th>駐車場</th>
            <td>
                @include('business.objects.components.selectbox', ['name' => 'parking', 'options' => [], 'title' => '駐車場'])
            </td>
        </tr>
        <tr>
            <th rowspan="2">共用部</th>
            <td rowspan="2" colspan="5" class="p-search-mansion__shared">
                @include('admin.objects.components.checkbox', ['name' => 'shared',
                    'checkbox' => [
                        ['code'=>'1', 'name'=>'ゲストルーム'], ['code'=>'2', 'name'=>'24時間ゴミ出し可']
                       ,['code'=>'3', 'name'=>'プール'], ['code'=>'4', 'name'=>'エレベーター']]
                ])<br>
                @include('admin.objects.components.checkbox', ['name' => 'shared',
                    'checkbox' => [
                        ['code'=>'5', 'name'=>'宅配ボックス'], ['code'=>'6', 'name'=>'キッズルーム・託児所']
                       ,['code'=>'7', 'name'=>'共用露天風呂']]
                ])
            </td>
            <th>事業主</th>
            <td>
                @include('business.objects.components.input', ['name' => 'owner', 'placeholder' => ''])
            </td>
        </tr>
        <tr>
            <th>施工</th>
            <td>
                @include('business.objects.components.input', ['name' => 'construction', 'placeholder' => ''])
            </td>
        </tr>
        <tr>
            <td colspan="8">
                <ul class="p-search-mansion__search-clear">
                    <li><a href="#">この条件をクリア</a></li>
                    <li><a href="#">この条件を削除</a></li>
                </ul>
            </td>
        </tr>
    </table>
</div>