{{-- 登録フォーム内の学校検索 --}}
{{-- 
    $title:モーダルボタンテキスト名
    $data:モーダルと紐付く番号を指定
    $name:パーツ使用時のnameを指定(必須)
--}}
@php
    $time = 0;
    $distance = $article->{$name.'_distance'}??0;
    if(isset($article->{$name.'_distance'})) {
        $time = ceil($distance / 80);
    }
@endphp
<div class="d-flex mb5">
    <div class="mr10">@include('admin.objects.components.selectbox', ['title' => '市区郡', 'class' => 'w150','name' => $name . '_city', 'options' => $school_town??[], 'selected' => $article->{$name.'_city'}??''])</div>
    <div class="mr10">@include('admin.objects.components.selectbox', ['title' => '学校', 'class' => 'w150','name' => $name . '_school', 'options' => ${$name.'_list'}??[], 'selected' => $article->{$name.'_school'}??''])</div>
    <div>約@include('admin.objects.components.input', ['name' => $name . '_distance', 'class' => 'w50', 'value' => $article->{$name.'_distance'}??''])m&nbsp;（徒歩<span name='{{$name}}_time'>{{$time}}</span>分）</div>
    @include('admin.objects.components.hidden', ['name' => $name.'_hidden', 'value' => $article->{$name.'_school'}??''])
</div>