{{-- 登録フォーム内の交通検索 --}}
{{-- 
    $data:モーダルと紐付く番号を指定
    $name:パーツ使用時のnameを指定(必須)
--}}
@include('admin.objects.components.modal-btn', ['title' => '路線・駅検索', 'class'=> 'btn_search', 'data' => $data])
<div class="d-flex">
    <input type="radio" class="u-radio" name="{{$name}}" @if(old($name, '1')=='1') checked @endif value="1" id="{{$name}}_1" checked>
    <label for="{{$name}}_1" class="u-radio__label">電車</label>
    <div class="mr10">@include('admin.objects.components.input', ['name' => $name.'_line', 'class' => 'w150 line_name'])</div>
    <div class="mr10">@include('admin.objects.components.input', ['name' => $name.'_station', 'class' => 'w150 station_name'])駅</div>
    <div class="">徒歩@include('admin.objects.components.input', ['name' => $name.'_time', 'class' => 'w50 walk_time'])分</div>
    @include('admin.objects.components.hidden', ['name' => $name.'_line_id', 'class' => 'line_id'])
    @include('admin.objects.components.hidden', ['name' => $name.'_station_id', 'class' => 'station_id'])

</div>
<div class="d-flex">
    <input type="radio" class="u-radio" name="{{$name}}" @if(old($name, '1')=='2') checked @endif value="2" id="{{$name}}_2">
    <label for="{{$name}}_2" class="u-radio__label">バス</label>
    <div class="mr38">@include('admin.objects.components.input', ['name' => $name.'_bus_time', 'class' => 'w50'])分乗車</div>
    <div class="mr10">バス停@include('admin.objects.components.input', ['name' => $name.'_bus', 'class' => 'w150'])停</div>
    <div class="">停歩@include('admin.objects.components.input', ['name' => $name.'_bus_walk', 'class' => 'w50'])分</div>
</div>