@include('admin.objects.components.regist-tab-image', ['title' => $main_title])
<form method="POST" action="{{ route('registImage', ['id' => $article->building_id]) }}" enctype="multipart/form-data">
{{ csrf_field() }}

    @include('admin.objects.components.hidden', ['name' => 'article_id', 'value' => $article->building_id])
    @include('admin.objects.components.hidden', ['name' => 'referer', 'value' => $referer])
    <div class="mb-3">
    @if($disp_flag == 1)
        @include('admin.objects.components.regist-band', ['title' => '画像登録'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">区画図・間取り</th>
                        <td>
                            <div class="d-flex">
                                @include('admin.objects.components.add-floor-image', ['id' => 'imageArea'])
                                <div class="ml10">
                                    画像種類
                                    @include('admin.objects.components.radio', ['name' => 'floor_file_type', 'radio' => $image_kind, 'default' => 0,  'checked' => $article->floor_file_type??''])
                                    <div class="mt10">
                                        @include('admin.objects.components.btn', ['name' => 'del_article_floor_photo', 'class' => '', 'title' => '削除', 'type' => 'button'])
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            @include('admin.objects.components.hidden', ['name' => 'saved_photo_id', 'value' => $article->images_id])
            @include('admin.objects.components.hidden', ['name' => 'del_photo_id', 'value' => ''])
            <table class="p-regist__table mt10">
                <tbody id="image_list">
                @include('admin.objects.projects.image-upload-large2', ['id' => 'iamgeAreaMulti', 'cid' => 'iamgeAreaMultiChild'])
                <tr>
                    <td colspan="8">
                        <table id="sortable_article_image" class="p-regist__sorttable">
                            <tbody id="image_list">
                            @include('admin.objects.components.add-photo-template')
                            @foreach($article->images as $photo)
                                <tr>
                                    <td colspan="7">
                                        <div class="d-flex">
                                            <div>
                                                <div class="p-add-photo">
                                                <img src="{{$photo->file_path}}" width="200">
                                                <canvas name="canvas" width="0" height="0"></canvas>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="ml10 d-flex">
                                                    <div class="ml10">
                                                        種別
                                                        @include('admin.objects.components.selectbox', ['name' => 'photo_property_sub'.$loop->index, 'options' => $photo_property, 'selected' => $photo->property_sub])
                                                    </div>
                                                </div>
                                                <div class="mt10 ml10">
                                                    @include('admin.objects.components.textarea', ['name' => 'photo_comment'.$loop->index, 'class' => 'img_text', 'count' => 100, 'site' => 1, 'placeholder' => '自社HPHP１００文字まで/ホームズ１００文字まで/
                                    スーモ３０文字まで/アットホーム５０文字まで', 'value' => $photo->memo])
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="p-regist__table-registtrader">
                                        @include('admin.objects.components.hidden', ['name' => 'article_photo_id'.$loop->index, 'value' => $photo->id])
                                        @include('admin.objects.components.btn', ['name' => 'del_photo', 'class' => 'btn_imagedel', 'title' => '削除', 'type' => 'button'])
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </td>
                </tr>


                </tbody>
            </table>
            <table class="p-regist__table mt10">
                <tbody>
                @include('admin.objects.projects.sheet-disp')
                </tbody>
            </table>
            @include('admin.objects.projects.edit-facility')
            <div class="regist__div">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </div>

    @elseif($disp_flag == 2)
        @include('admin.objects.components.regist-band', ['title' => '外観写真登録'])
        <div class="p-regist">
            @include('admin.objects.components.hidden', ['name' => 'saved_photo_id', 'value' => $article->images_id])
            @include('admin.objects.components.hidden', ['name' => 'del_photo_id', 'value' => ''])
            <table class="p-regist__table mt10">
                <tbody id="image_list">
                @include('admin.objects.projects.image-upload-large2', ['id' => 'iamgeAreaMulti', 'cid' => 'iamgeAreaMultiChild'])
                <tr>
                    <td colspan="8">
                        <table id="sortable_article_image" class="p-regist__sorttable">
                            <tbody id="image_list">
                            @include('admin.objects.components.add-photo-template')
                            @foreach($article->images as $photo)
                                <tr>
                                    <td colspan="7">
                                        <div class="d-flex">
                                            <div>
                                                <div class="p-add-photo">
                                                <img src="{{$photo->file_path}}" width="200">
                                                <canvas name="canvas" width="0" height="0"></canvas>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="ml10 d-flex">
                                                    <div class="ml10">
                                                        種別
                                                        @include('admin.objects.components.selectbox', ['name' => 'photo_property_sub'.$loop->index, 'options' => $photo_property, 'selected' => $photo->property_sub])
                                                    </div>
                                                </div>
                                                <div class="mt10 ml10">
                                                    @include('admin.objects.components.textarea', ['name' => 'photo_comment'.$loop->index, 'class' => 'img_text', 'count' => 100, 'placeholder' => '自社HPHP１００文字まで/ホームズ１００文字まで/
                                    スーモ３０文字まで/アットホーム５０文字まで', 'value' => $photo->memo])
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="p-regist__table-registtrader">
                                    @include('admin.objects.components.hidden', ['name' => 'article_photo_id'.$loop->index, 'value' => $photo->id])
                                    @include('admin.objects.components.btn', ['name' => 'del_photo', 'class' => 'btn_imagedel', 'title' => '削除', 'type' => 'button'])
                                    </td>

                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </td>
                </tr>

                </tbody>
            </table>
            <div class="regist__div">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </div>
    @elseif($disp_flag == 3)
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">全体区画図</th>
                        <td>
                            <div class="d-flex">
                                @include('admin.objects.components.add-floor-image', ['id' => 'imageArea'])
                                <div class="ml10">
                                    画像種類
                                    @include('admin.objects.components.radio', ['name' => 'floor_file_type', 'radio' => $image_kind, 'checked' => $article->floor_file_type])
                                    <div class="mt10">
                                        @include('admin.objects.components.btn', ['name' => 'del_article_floor_photo', 'class' => '', 'title' => '削除', 'type' => 'button'])
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="regist__div">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </div>
    @endif
    </div>
</form>

@if($saved == 1)
@include('admin.objects.projects.modal-message')
<script type="text/javascript">
    window.onload = function(){
        var message = '登録・保存しました。';
        $('#saved_message').text(message);
        openMessageModal();
    };

</script>
@endif