@extends('admin.layouts.base')

{{-- header --}}
@section('contents-header')
    @include('admin.objects.projects.search-results-header', ['title' => '成約物件', 'img_flag' => true])
@endsection

@php

// 並び替えデータ
$sorts = $sorts ?? [];

$sort = new stdClass();
$sort->name = '新着順';
$sort->class = 'new';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '新価格';
$sort->class = 'newprice';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '価格が安い順';
$sort->class = 'inexpensive';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '駅近い順';
$sort->class = 'station';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '築年浅い順';
$sort->class = 'age';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '土地面積広い順';
$sort->class = 'land';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '延べ床面積広い順';
$sort->class = 'floor';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '物件種別順';
$sort->class = 'property';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '所在地順';
$sort->class = 'address';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '沿線・駅順';
$sort->class = 'line';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '業者順';
$sort->class = 'vendor';
array_push($sorts, $sort);
@endphp

@section('contents')


{{-- 現在の検索条件 --}}
@include('admin.objects.projects.results-current-condition', [])

{{-- 並び替え --}}
@include('admin.objects.projects.results-sort', ['sorts' => $sorts])

@include('business.objects.projects.form-to-other', ['action' => route('business-for-sale-detail', ['id' => '']), 'id' => 'link_detail', 'params' => $params])

{{-- 検索結果一覧 ※tab-img-or-list.bladeと連動 --}}
<div class="tab-content mt-3">
  <div class="tab-pane u-bg-default active_con" id="nav-list" role="tabpanel" aria-labelledby="nav-list-tab">
    @include('admin.objects.projects.results-noimage', ['data' => $article_list, 'flag' => 1])
  </div>
</div>

@endsection
