@extends('admin.layouts.base')
@section('contents')

@php
// Place area
    $place_area = [
        ['code' => "", 'name' => '未選択'],
        ['code' => "安朱", 'name' => '安朱'],
        ['code' => "音羽", 'name' => '音羽'],
        ['code' => "勧修寺", 'name' => '勧修寺'],
        ['code' => "御陵", 'name' => '御陵'],
        ['code' => "四ノ宮", 'name' => '四ノ宮'],
        ['code' => "小山", 'name' => '小山'],
        ['code' => "上花山", 'name' => '上花山'],
        ['code' => "厨子奥", 'name' => '厨子奥'],
        ['code' => "西野", 'name' => '西野'],
        ['code' => "西野山", 'name' => '西野山'],
        ['code' => "川田", 'name' => '川田'],
        ['code' => "大宅", 'name' => '大宅'],
        ['code' => "大塚", 'name' => '大塚'],
        ['code' => "醍醐", 'name' => '醍醐'],
        ['code' => "竹鼻", 'name' => '竹鼻'],
        ['code' => "東野", 'name' => '東野'],
        ['code' => "藤尾", 'name' => '藤尾'],
        ['code' => "日ノ岡", 'name' => '日ノ岡'],
        ['code' => "北花山", 'name' => '北花山'],
        ['code' => "椥辻", 'name' => '椥辻'],
        ['code' => "小野", 'name' => '小野'],
    ];
//// 3 物件概要
// 地目
$ground = [
    ['code' => 1, 'name' => '宅地'],
    ['code' => 2, 'name' => '田'],
    ['code' => 3, 'name' => '畑'],
    ['code' => 4, 'name' => '山林'],
    ['code' => 5, 'name' => '雑種地'],
    ['code' => 6, 'name' => '原野'],
    ['code' => 7, 'name' => 'その他'],
];

// 地役権
$easement = [
    ['code' => 1, 'name' => '無'],
    ['code' => 2, 'name' => '地役権'],
    ['code' => 3, 'name' => '通行地役権'],
    ['code' => 4, 'name' => '引水地役権'],
    ['code' => 5, 'name' => '眺望地役権'],
    ['code' => 6, 'name' => '通路賃借権'],
    ['code' => 0, 'name' => '未選択'],
];

// 上水道
$water_supply = [
    ['code' => 1, 'name' => '公営水道'],
    ['code' => 2, 'name' => '私設水道'],
    ['code' => 3, 'name' => '井戸'],
    ['code' => 0, 'name' => '未選択'],
];

// 下水道
$sewerage = [
    ['code' => 1, 'name' => '本下水'],
    ['code' => 2, 'name' => '集中浄化槽'],
    ['code' => 3, 'name' => '個別浄化槽'],
    ['code' => 0, 'name' => '未選択'],
];

// ガス・オール電化
$gas = [
    ['code' => 1, 'name' => '都市ガス'],
    ['code' => 2, 'name' => '集中ＬＰＧ'],
    ['code' => 3, 'name' => '個別ＬＰＧ'],
    ['code' => 4, 'name' => 'オール電化'],
    ['code' => 0, 'name' => '未選択'],

];

//// 3 画像
// 画像種類
$image_kind = [
    ['code' => 4, 'name' => '全体区画図'],
];

@endphp
@if($errors->any())
 <div class="error">
   <ul>
     @foreach($errors->all() as $message)
       <li>{{ $message }}</li>
     @endforeach
   </ul>
 </div>
@endif
<form method="POST" action="{{ route('edit-lot', ['id' => $article->building_id]) }}" enctype="multipart/form-data">
{{ csrf_field() }}
    @include('admin.objects.components.base-tab')
    @include('admin.objects.components.regist-tab-lot', ['title' => '物件登録-分譲地', 'active' => 'base'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '１.基本情報'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">分譲地番号</th>
                        <td>
                            <span>{{$article->building_id}}</span>
                            @include('admin.objects.components.hidden', ['name' => 'num_bukken', 'value' => $article->building_ids])
                            @include('admin.objects.components.hidden', ['name' => 'property', 'value' => 99])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>分譲地名</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w-50', 'value' => $article->article_name])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>所在地</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.form-address-edit')
                        </td>
                    </tr>
                    @include('admin.objects.projects.latlng')
                    <tr>
                        <th rowspan="4">交通</th>
                        <th>交通</th>
                        <td>
                            @include('admin.objects.components.modal-btn', ['title' => '路線をまとめて検索', 'class'=> 'btn_search', 'data' => 3])
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="d-flex justify-content-between">
                                 <div>主要交通</div>
                                 <span class="require">必須</span>
                            </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.search-station-edit', ['data' => 4, 'name' => 'main_traffic'])
                        </td>
                    </tr>
                    <tr>
                        <th>補助交通１</th>
                        <td>
                            @include('admin.objects.projects.search-station-edit', ['data' => 5, 'name' => 'sub_traffic1'])
                        </td>
                    </tr>
                    <tr>
                        <th>補助交通２</th>
                        <td>
                            @include('admin.objects.projects.search-station-edit', ['data' => 6, 'name' => 'sub_traffic2'])
                        </td>
                    </tr>
                    @include('admin.objects.projects.set-school')
                    <tr>
                        <th colspan="2">備考1(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo1', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください', 'value' => $article->memo1])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">備考2(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo2', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください', 'value' => $article->memo2])
                        </td>
                    </tr>
		@if (auth()->user()->isOwnerOfSaiKyoto())
		    <tr>
                        <th colspan="2">所在地エリア</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'place_area', 'class' => 'w150', 'options' => $place_area, 'selected' => $article->place_area])
                        </td>
                    </tr>
		@endif
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab-lot', ['active' => 'overview'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '２.共通概要'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">土地権利</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'land_right', 'radio' => $land_right, 'checked' => $article->land_right, 'default' => 1])
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>分譲地情報</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>地目</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'ground', 'radio' => $ground, 'checked' => $article->ground, 'default' => 1])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>建ぺい率</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'building_rate', 'class' => 'w100', 'value' => $article->building_rate])％
                            <span class="ml10">※「都市計画区域外」以外は必須</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>容積率</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'volume_rate', 'class' => 'w100', 'value' => $article->volume_rate])％
                            <span class="ml10">※「都市計画区域外」以外は必須</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>私道負担</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                        @include('admin.objects.projects.umu-share-radio', ['name' => 'road_burden', 'default' => 0, 'checked' => $article->road_burden ?? 0])
                            <div id="road_burden_area1" class="mb10">
                                私道面積&nbsp;@include('admin.objects.components.input', ['name' => 'road_burden_area', 'class' => 'w100', 'value' => $article->road_burden_area, 'placeholder' => '000.00'])m&sup2;
                            </div>
                            <div id="road_burden_area2">
                                私道持分比率&nbsp;持分@include('admin.objects.components.input', ['name' => 'road_numerator', 'class' => 'w50', 'value' => $article->road_numerator, 'placeholder' => '0.0'])/全体@include('admin.objects.components.input', ['name' => 'road_denominator', 'class' => 'w50', 'value' => $article->road_denominator, 'placeholder' => '0.0'])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>地役権</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'easement', 'radio' => $easement, 'checked' => $article->easement, 'default' => 1])
                            <div id="easement_area">
                                @include('admin.objects.components.input', ['name' => 'easement_area', 'value' => $article->easement_area])m&sup2;
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">上水道</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'water_supply', 'radio' => $water_supply, 'checked' => $article->water_supply])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">下水道</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'sewerage', 'radio' => $sewerage, 'checked' => $article->sewerage])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">ガス・オール電化</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'gas', 'radio' => $gas, 'checked' => $article->gas])
                        </td>
                    </tr>
                    @include('admin.objects.projects.set-use-area')
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>都市計画</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'city_plan', 'options' => $city_plan, 'selected' => $article->city_plan])
                            <div id="city_plan_area">
                                建築許可理由
                                @include('admin.objects.components.selectbox', ['name' => 'city_plan_reason', 'options' => $city_plan_reason, 'selected' => $article->city_plan_reason])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            開発許可番号
                        </th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'develop_num', 'class' => 'w200', 'value' => $article->develop_num])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            総区画(戸)数
                        </th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'section', 'class' => 'w50', 'value' => $article->section])区画（戸）
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>制限事項</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>法律上の制限</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.checkbox-law', ['name' => 'law_restriction', 'checkbox' => $law, 'class' => 'checkbox_small'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2" rowspan="3">
                           <div class="d-flex justify-content-between">
                                 <div>その他制限事項</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.checkbox', ['name' => 'other_restriction', 'checkbox' => $other, 'class' => 'checkbox_small'])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'other_reason', 'options' => $other_reason])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'other_comment', 'class' => 'ta50 w-75', 'value' => $article->other_comment, 'placeholder' => 'その他制限事項がある場合は１５０文字以内で入力してください', 'count' => 150])
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>コメント</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">コメント</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'comment', 'class' => 'ta50 w-75', 'placeholder' => ''])
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="regist__div d-flex justify-content-center">
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__image saved_to_image', 'title' => '画像登録・編集画面へ', 'type' => 'submit'])
                </div>
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__save', 'title' => '登録・保存して閉じる'])
                </div>
            </div>
        </div>
    </div>
</form>



{{-- 分譲地検索モーダルウィンドウ --}}
@include('admin.objects.projects.modal-map', ['no' => 2])
@include('admin.objects.projects.modal-traffic-multi', ['no' => 3])
@include('admin.objects.projects.modal-traffic-single', ['no' => 4])
@include('admin.objects.projects.modal-traffic-single', ['no' => 5])
@include('admin.objects.projects.modal-traffic-single', ['no' => 6])
@include('admin.objects.projects.address-script')
@if($saved == 1)
@include('admin.objects.projects.modal-message')
<script type="text/javascript">
    window.onload = function(){
        var message = '登録・保存しました。';
        $('#saved_message').text(message);
        openMessageModal();
    };

</script>
@endif
@endsection
