@extends('admin.layouts.base')
@section('contents')

@php
// Place area
    $place_area = [
        ['code' => "", 'name' => '未選択'],
        ['code' => "安朱", 'name' => '安朱'],
        ['code' => "音羽", 'name' => '音羽'],
        ['code' => "勧修寺", 'name' => '勧修寺'],
        ['code' => "御陵", 'name' => '御陵'],
        ['code' => "四ノ宮", 'name' => '四ノ宮'],
        ['code' => "小山", 'name' => '小山'],
        ['code' => "上花山", 'name' => '上花山'],
        ['code' => "厨子奥", 'name' => '厨子奥'],
        ['code' => "西野", 'name' => '西野'],
        ['code' => "西野山", 'name' => '西野山'],
        ['code' => "川田", 'name' => '川田'],
        ['code' => "大宅", 'name' => '大宅'],
        ['code' => "大塚", 'name' => '大塚'],
        ['code' => "醍醐", 'name' => '醍醐'],
        ['code' => "竹鼻", 'name' => '竹鼻'],
        ['code' => "東野", 'name' => '東野'],
        ['code' => "藤尾", 'name' => '藤尾'],
        ['code' => "日ノ岡", 'name' => '日ノ岡'],
        ['code' => "北花山", 'name' => '北花山'],
        ['code' => "椥辻", 'name' => '椥辻'],
        ['code' => "小野", 'name' => '小野'],
    ];
//// 1 基本情報
$disp_num = [
    ['code' => 1, 'name' => 'する'],
    ['code' => 0, 'name' => 'しない'],
];

//// 2 価格
// 修繕・管理費
$cost_unit = [
    ['code' => 1, 'name' => '月'],
    ['code' => 2, 'name' => '年'],
];

$running_cost_unit = [
    ['code' => 1, 'name' => '月'],
    ['code' => 2, 'name' => '年'],
];

// その他諸経費
$other_cost_unit = [
    ['code' => 1, 'name' => '月'],
    ['code' => 2, 'name' => '年'],
    ['code' => 3, 'name' => '一括'],
    ['code' => 0, 'name' => '未選択'], 
];

//// 3 物件概要
$mansion_unit1 = [
    ['code' => 1, 'name' => '壁芯'],
    ['code' => 2, 'name' => '登記'],
    ['code' => 0, 'name' => '未選択'],
];

$mansion_cost_unit = [
    ['code' => 1, 'name' => '月'],
    ['code' => 2, 'name' => '年'],
];

$parking = [
    ['code' => 1, 'name' => '無'],
    ['code' => 2, 'name' => '駐車場空無'],
    ['code' => 3, 'name' => '駐車場空有'],
    ['code' => 4, 'name' => '分譲駐車場(必購入)'],
    ['code' => 5, 'name' => '分譲駐車場(任意購入)'],
    ['code' => 6, 'name' => '専用使用権付駐車場'],
    ['code' => 0, 'name' => '未選択'],
];

$maisonette = [
    ['code' => 1, 'name' => 'メゾネット']
];

$floor = [
    ['code' => 1, 'name' => 1],
    ['code' => 2, 'name' => 2],
    ['code' => 3, 'name' => 3],
    ['code' => 4, 'name' => 4],
    ['code' => 5, 'name' => 5],
    ['code' => 6, 'name' => 6],
    ['code' => 7, 'name' => 7],
    ['code' => 8, 'name' => 8],
    ['code' => 9, 'name' => 9],
    ['code' => 10, 'name' => 10],
    ['code' => 11, 'name' => 11],
    ['code' => 12, 'name' => 12],
    ['code' => 13, 'name' => 13],
    ['code' => 14, 'name' => 14],
    ['code' => 15, 'name' => 15],
];

$parking_unit = [
    ['code' => 1, 'name' => '未選択'],
    ['code' => 2, 'name' => '〜'],
    ['code' => 3, 'name' => '・'],
];

//// 4 投資・事業用
// 区分
$classification = [
    ['code' => 1, 'name' => '居住用'],
    ['code' => 2, 'name' => '事業用'],
];

// 事業用用途
$use_method = [
    ['code' => 1, 'name' => 'マンション'],
    ['code' => 2, 'name' => 'アパート'],
    ['code' => 3, 'name' => 'ビル'],
    ['code' => 4, 'name' => '店舗'],
    ['code' => 5, 'name' => '事務所'],
    ['code' => 6, 'name' => '寮・社宅'],
    ['code' => 7, 'name' => '工場'],
    ['code' => 8, 'name' => '倉庫'],
    ['code' => 9, 'name' => 'その他'],
];

//// 5 取引情報
$ad_conf = [
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];

$ad_instructions = [
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '入稿'],
];

//// 6 画像
// 画像種類
$image_kind = [
    ['code' => 1, 'name' => '区画図'],
    ['code' => 2, 'name' => '間取り'],
    ['code' => 3, 'name' => '参考プラン'],
    ['code' => 0, 'name' => '未選択'],
];

//// 7 イベント
// イベントカテゴリ
$event_category = [
    ['code' => 1, 'name' => '現地見学会'],
    ['code' => 2, 'name' => '現地案内会'],
    ['code' => 3, 'name' => '現地販売会'],
    ['code' => 4, 'name' => 'オープンハウス'],
    ['code' => 5, 'name' => 'オープンルーム'],
    ['code' => 0, 'name' => '未選択'],
];

// イベント日程
$event_schedule = [
    ['code' => 1, 'name' => '毎週土日祝'],
    ['code' => 2, 'name' => '毎週土日'],
    ['code' => 3, 'name' => '日時指定'],
    ['code' => 4, 'name' => '期間限定'],
    ['code' => 5, 'name' => '公開中'],
    ['code' => 0, 'name' => '未選択'],
];

// イベント予約
$reservation = [
    ['code' => 1, 'name' => '完全予約制'],
];

// イベント予約
$vendor_building_photo = [
    ['code' => 1, 'name' => '優先使用'],
    ['code' => 2, 'name' => '不使用'],
];
@endphp
@if($errors->any())
 <div class="error">
   <ul>
     @foreach($errors->all() as $message)
       <li>{{ $message }}</li>
     @endforeach
   </ul>
 </div>
@endif
<form method="POST" action="{{ route('editRoom', ['mid' => $mansion->building_id, 'id' => $article->building_id]) }}" enctype="multipart/form-data">
{{ csrf_field() }}
    @include('admin.objects.components.base-tab-edit')
    @include('admin.objects.components.regist-tab', ['title' => '物件登録-マンション（部屋）', 'active' => 'base'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '１.基本情報'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">マンション建物番号</th>
                        <td>
                            <span>{{$mansion->building_id}}</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">マンション名</th>
                        <td>
                            {{$mansion->name_apartment}}
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件番号</th>
                        <td>
                            <span>{{$article->building_id}}</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件種別</th>
                        <td>
                            @if($mansion->property_sub == 1)
                                新築
                            @elseif($mansion->property_sub == 2)
                                中古
                            @endif

                            @if($mansion->property == 6)
                                マンション
                            @elseif($mansion->property == 7)
                                タウンハウス
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>物件名</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w400', 'count' => 30, 'placeholder' => '物件名を３０文字以内で入力', 'value' => $article->article_name])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>部屋番号</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'room_num', 'class' => 'w50', 'value' => $article->room_num])号室
                            部屋番号の表示
                            @include('admin.objects.components.radio', ['name' => 'room_num_disp', 'radio' => $disp_num, 'default' => 0, 'checked' => $article->room_num_disp])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件名（ポータル用）</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'name_portal', 'class' => 'w400', 'count' => 30, 'placeholder' => '物件名を３０文字以内で入力', 'value' => $article->name_portal])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">未入居</th>
                        <td class="">
                            @include('admin.objects.components.checkbox', ['name' => 'occupied', 'checkbox' => $occupied, 'checked' => $article->occupied])
                            <div>
                            ※「未入居」とは、建築後１年以上経過したものであって、かつ居住の用に供されたことがない物件のことを指します。<br>
                              居住の用に供されたことのあるリフォーム済・リノベーション済物件は「中古」
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">収益物件</th>
                        <td>
                            @include('admin.objects.components.checkbox', ['name' => 'revenue', 'checkbox' => $revenue, 'checked' => $article->revenue])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">ステータス</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'status', 'options' => $statuses, 'selected' => $article->status])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件取扱店舗名</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'shop', 'options' => $shops, 'selected' => $article->shop])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">所在地</th>
                        <td>
                            &#12306;{{$mansion->zip}}<br>
                            {{$mansion->pref_name}}{{$mansion->city_name}}{{$mansion->town_name}}
                            @include('admin.objects.components.hidden', ['name' => 'address1', 'value' => $article->address1])
                            @include('admin.objects.components.hidden', ['name' => 'address2', 'value' => $article->address2])
                            @include('admin.objects.components.hidden', ['name' => 'address3', 'value' => $article->address3])
                            @include('admin.objects.components.hidden', ['name' => 'address4', 'value' => $article->address4])
                        </td>
                    </tr>
                    @include('admin.objects.projects.latlng')
                    <tr>
                        <th colspan="2">交通</th>
                        <td>
                            {{$mansion->main_traffic_line}}「{{$mansion->main_traffic_station}}」駅　徒歩{{$mansion->main_traffic_time}}分
                            @if($mansion->sub_traffic1_line != ""){{$mansion->sub_traffic1_line}}「{{$mansion->sub_traffic1_station}}」駅　徒歩{{$mansion->sub_traffic1_time}}分@endif
                            @if($mansion->sub_traffic2_line != ""){{$mansion->sub_traffic2_line}}「{{$mansion->sub_traffic2_station}}」駅　徒歩{{$mansion->sub_traffic2_time}}分@endif
                            
                            @include('admin.objects.components.hidden', ['name' => 'main_traffic', 'value' => $mansion->main_traffic])

                            @include('admin.objects.components.hidden', ['name' => 'main_traffic_line', 'value' => $mansion->main_traffic_line])
                            @include('admin.objects.components.hidden', ['name' => 'main_traffic_line_id', 'value' => $mansion->main_traffic_line_id])
                            @include('admin.objects.components.hidden', ['name' => 'main_traffic_station', 'value' => $mansion->main_traffic_station])
                            @include('admin.objects.components.hidden', ['name' => 'main_traffic_station_id', 'value' => $mansion->main_traffic_station_id])
                            @include('admin.objects.components.hidden', ['name' => 'main_traffic_time', 'value' => $mansion->main_traffic_time])

                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic1_line', 'value' => $mansion->sub_traffic1_line])
                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic1_line_id', 'value' => $mansion->sub_traffic1_line_id])
                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic1_station', 'value' => $mansion->sub_traffic1_station])
                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic1_station_id', 'value' => $mansion->sub_traffic1_station_id])

                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic1_time', 'value' => $mansion->sub_traffic1_time])

                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic2_line', 'value' => $mansion->sub_traffic2_line])
                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic2_line_id', 'value' => $mansion->sub_traffic2_line_id])
                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic2_station', 'value' => $mansion->sub_traffic2_station])
                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic2_station_id', 'value' => $mansion->sub_traffic2_station_id])
                            @include('admin.objects.components.hidden', ['name' => 'sub_traffic2_time', 'value' => $mansion->sub_traffic2_time])

                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">学校区</th>
                        <td>
                            @if(isset($mansion->primary_school_name))
                                {{$mansion->primary_school_name}}&nbsp;約{{$mansion->primary_school_distance}}m&nbsp; @if(isset($mansion->primary_school_time))/&nbsp;徒歩{{$mansion->primary_school_time}}分 @endif <br>
                                @include('admin.objects.components.hidden', ['name' => 'primary_school_city', 'value' => $mansion->primary_school_city])
                                @include('admin.objects.components.hidden', ['name' => 'primary_school_school', 'value' => $mansion->primary_school_school])
                                @include('admin.objects.components.hidden', ['name' => 'primary_school_distance', 'value' => $mansion->primary_school_distance])
                            @endif
                            @if(isset($mansion->primary_school_name2))
                                {{$mansion->primary_school_name2}}&nbsp;約{{$mansion->primary_school2_distance}}m&nbsp; @if(isset($mansion->primary_school_time2))/&nbsp;徒歩{{$mansion->primary_school_time2}}分 @endif <br>
                                @include('admin.objects.components.hidden', ['name' => 'primary_school2_city', 'value' => $mansion->primary_school2_city])
                                @include('admin.objects.components.hidden', ['name' => 'primary_school2_school', 'value' => $mansion->primary_school2_school])
                                @include('admin.objects.components.hidden', ['name' => 'primary_school2_distance', 'value' => $mansion->primary_school2_distance])
                            @endif
                            @if(isset($mansion->secondary_school_name))
                                {{$mansion->secondary_school_name}}&nbsp;約{{$mansion->secondary_school_distance}}m&nbsp; @if(isset($mansion->secondary_school_time))/&nbsp;徒歩{{$mansion->secondary_school_time}}分 @endif <br>   
                                @include('admin.objects.components.hidden', ['name' => 'secondary_school_city', 'value' => $mansion->secondary_school_city])
                                @include('admin.objects.components.hidden', ['name' => 'secondary_school_school', 'value' => $mansion->secondary_school_school])
                                @include('admin.objects.components.hidden', ['name' => 'secondary_school_distance', 'value' => $mansion->secondary_school_distance])
                            @endif
                            @if(isset($mansion->secondary_school_name2))
                                {{$mansion->secondary_school_name2}}&nbsp;約{{$mansion->secondary_school2_distance}}m&nbsp; @if(isset($mansion->secondary_school_time2))/&nbsp;徒歩{{$mansion->secondary_school_time2}}分 @endif   
                                @include('admin.objects.components.hidden', ['name' => 'secondary_school2_city', 'value' => $mansion->secondary_school2_city])
                                @include('admin.objects.components.hidden', ['name' => 'secondary_school2_school', 'value' => $mansion->secondary_school2_school])
                                @include('admin.objects.components.hidden', ['name' => 'secondary_school2_distance', 'value' => $mansion->secondary_school2_distance])

                            @endif

                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">備考1(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo1', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください', 'value' => $article->memo1])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">備考2(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo2', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください', 'value' => $article->memo2])
                        </td>
                    </tr>
		@if (auth()->user()->isOwnerOfSaiKyoto())
		    <tr>
                        <th colspan="2">所在地エリア</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'place_area', 'class' => 'w150', 'options' => $place_area, 'selected' => $article->place_area])
                        </td>
                    </tr>
		@endif
                    <tr>
                        <th colspan="2">レインズ番号</th>
                        <td>
                            <p></p>
                        </td>
                    </tr>
                    @include('admin.objects.projects.original-edit')
                    <tr>
                        <th colspan="2">
                             <div class="d-flex justify-content-between">
                                  <div class="search_target_title">物件登録日</div>
                                  <span class="search_target">検索</span>
                              </div>
                         </th>
                         <td>@if(isset($article->disp_create)){{$article->disp_create}}@endif</td>
                    </tr>
                    <tr>
                        <th colspan="2">取引態様</th>
                        <td>
                        @include('admin.objects.components.selectbox', ['name' => 'company_manner', 'options' => $manner, 'title' => '取引態様', 'selected' => $article->company_manner])
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'price'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '２.価格'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>価格</div>
                                <span class="require">必須</span>
                            </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'price', 'class' => 'w100', 'value' => $article->price])万円&nbsp;
                            @include('admin.objects.components.selectbox', ['name' => 'tax', 'options' => $tax, 'selected' => $article->tax])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件価格変更履歴</th>
                        <td>
                            <span>未設定</span>
                            @include('admin.objects.components.hidden', ['name' => 'name_bunjyou'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>管理費</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.projects.umu-radio', ['name' => 'management', 'default' => 0, 'checked' => $article->management?? 0])
                            </div>
                            <div id="management_cost_area">
                                @include('admin.objects.components.input', ['name' => 'management_cost', 'value' => $article->management_cost])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'management_cost_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->management_cost_unit])
                            </div>

                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>修繕積立金</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.projects.umu-radio', ['name' => 'repair', 'default' => 0, 'checked' => $article->repair?? 0])
                            </div>
                            <div id="repair_cost_area">
                                @include('admin.objects.components.input', ['name' => 'repair_cost', 'value' => $article->repair_cost])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'repair_cost_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->repair_cost_unit])
                            </div>

                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>駐車場（敷地内）</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'parking', 'radio' => $parking, 'default' => 0, 'checked' => $article->parking])
                            </div>
                            <div id="parking_cost_area_3" class="parking_cost_area">
                                料金&nbsp;@include('admin.objects.projects.umu-radio', ['name' => 'parking_yes', 'default' => 0, 'checked' => $article->parking_yes])
                                <div id="parking_yes_area">
                                    @include('admin.objects.components.input', ['name' => 'parking_yes_cost_from', 'class' => 'w150', 'value' => $article->parking_yes_cost_from])円
                                    @include('admin.objects.components.selectbox', ['name' => 'parking_yes_cost_range', 'options' => $parking_unit, 'selected' => $article->parking_yes_cost_range])
                                    @include('admin.objects.components.input', ['name' => 'parking_yes_cost_to', 'class' => 'w150', 'value' => $article->parking_yes_cost_to])円
                                    @include('admin.objects.components.radio', ['name' => 'parking_yes_cost_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->parking_yes_cost_unit])
                                    @include('admin.objects.components.input', ['name' => 'parking_yes_cost_date', 'class' => 'cal_picker', 'placeholder' => '0000/00/00', 'value' => $article->parking_yes_cost_date])現在
                                </div>
                            </div>
                            <div id="parking_cost_area_4" class="parking_cost_area">
                                <div>
                                   分譲価格&nbsp;@include('admin.objects.components.input', ['name' => 'parking_require_cost', 'class' => 'w150', 'value' => $article->parking_require_cost])円（物件価格に含む）
                                </div>
                                <div>
                                    管理費&nbsp;@include('admin.objects.projects.umu-radio', ['name' => 'parking_require_management', 'default' => 0, 'checked' => $article->parking_require_management])
                                    <div id="parking_require_management_area">
                                    @include('admin.objects.components.input', ['name' => 'parking_require_management_cost', 'class' => 'w150', 'value' => $article->parking_require_management_cost])円 / @include('admin.objects.components.radio', ['name' => 'parking_require_management_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->parking_require_management_unit])
                                    </div>
                                </div>
                                <div>
                                    修繕積立金&nbsp;@include('admin.objects.projects.umu-radio', ['name' => 'parking_require_repair', 'default' => 0, 'checked' => $article->parking_require_repair])
                                    <div id="parking_require_repair_area">
                                        @include('admin.objects.components.input', ['name' => 'parking_require_repair_cost', 'class' => 'w150', 'value' => $article->parking_require_repair_cost])円 / @include('admin.objects.components.radio', ['name' => 'parking_require_repair_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->parking_require_repair_unit])
                                    </div>
                                </div>
                            </div>
                            <div id="parking_cost_area_5" class="parking_cost_area">
                                <div>
                                    分譲価格&nbsp;@include('admin.objects.components.input', ['name' => 'parking_any_cost_from', 'class' => 'w150', 'value' => $article->parking_any_cost_from])円
                                    @include('admin.objects.components.selectbox', ['name' => 'parking_any_cost_range', 'options' => $parking_unit, 'selected' => $article->parking_any_cost_range])
                                    @include('admin.objects.components.input', ['name' => 'parking_any_cost_to', 'class' => 'w150', 'value' => $article->parking_any_cost_to])円（物件価格に含まない）
                                </div>
                                <div>
                                    管理費&nbsp;@include('admin.objects.projects.umu-radio', ['name' => 'parking_any_management', 'default' => 0, 'checked' => $article->parking_any_management])
                                    <div id="parking_any_management_area">
                                    @include('admin.objects.components.input', ['name' => 'parking_any_management_cost', 'class' => 'w150', 'value' => $article->parking_any_management_cost])円 / @include('admin.objects.components.radio', ['name' => 'parking_any_management_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->parking_any_management_unit])
                                    </div>
                                </div>
                                <div>
                                    修繕積立金&nbsp;@include('admin.objects.projects.umu-radio', ['name' => 'parking_any_repair', 'default' => 0, 'checked' => $article->parking_any_repair])
                                    <div id="parking_any_repair_area">
                                        @include('admin.objects.components.input', ['name' => 'parking_any_repair_cost', 'class' => 'w150', 'value' => $article->parking_any_repair_cost])円 / @include('admin.objects.components.radio', ['name' => 'parking_any_repair_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->parking_any_repair_unit])
                                    </div>
                                </div>
                            </div>
                            <div id="parking_cost_area_6" class="parking_cost_area">
                                    使用料&nbsp;@include('admin.objects.projects.umu-radio', ['name' => 'parking_designated', 'default' => 0, 'checked' => $article->parking_designated])
                                <div id="parking_designated_area">
                                    @include('admin.objects.components.input', ['name' => 'parking_designated_cost', 'class' => 'w150', 'value' => $article->parking_designated_cost])円 / @include('admin.objects.components.radio', ['name' => 'parking_designated_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->repair_cost_unit])
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>駐車場（敷地外）</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.projects.umu-radio', ['name' => 'parking_out', 'default' => 0, 'checked' => $article->parking_out])
                            </div>
                            <div id="parking_out_area">
                                @include('admin.objects.components.input', ['name' => 'parking_out_cost_from', 'class' => 'w150', 'value' => $article->parking_out_cost_from])円
                                @include('admin.objects.components.selectbox', ['name' => 'parking_out_cost_range', 'options' => $parking_unit, 'selected' => $article->parking_out_cost_range])
                                @include('admin.objects.components.input', ['name' => 'parking_out_cost_to', 'class' => 'w150', 'value' => $article->parking_out_cost_to])円
                                @include('admin.objects.components.radio', ['name' => 'parking_out_cost_unit', 'radio' => $cost_unit, 'default' => 1, 'checked' => $article->parking_out_cost_unit])
                                @include('admin.objects.components.input', ['name' => 'parking_out_cost_date', 'class' => 'cal_picker', 'placeholder' => '0000/00/00', 'value' => $article->parking_out_cost_date])現在
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>有線放送に係る費用</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio-cost', ['name' => 'broadcasting', 'default' => 2, 'checked' => $article->broadcasting?? 2])
                            <div class="initial_cost">
                                初期費用@include('admin.objects.projects.umu-money-radio', ['name' => 'broadcasting_presence', 'default' => 0, 'checked' => $article->broadcasting_presence?? 0])
                                <div class="initial_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'broadcasting_cost', 'value' => $article->broadcasting_cost])円
                                </div>
                            </div>

                            <div class="running_cost">
                                定額費用@include('admin.objects.projects.umu-money-radio', ['name' => 'broadcasting_fixed_presence', 'default' => 0, 'checked' => $article->broadcasting_fixed_presence?? 0])
                                <div class="running_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'broadcasting_fixed_cost', 'value' => $article->broadcasting_cost])円&#047;
                                    @include('admin.objects.components.radio', ['name' => 'broadcasting_fixed_cost_unit', 'radio' => $running_cost_unit, 'default' => 1, 'checked' => $article->broadcasting_fixed_cost_unit])
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>インターネットに係る費用</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                        @include('admin.objects.projects.umu-radio-cost', ['name' => 'internet', 'default' => 2, 'checked' => $article->internet?? 2])
                            <div class="initial_cost">
                                初期費用@include('admin.objects.projects.umu-money-radio', ['name' => 'internet_presence', 'default' => 0, 'checked' => $article->internet_presence?? 0])
                                <div class="initial_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'internet_cost', 'value' => $article->internet_cost])円
                            </div>
                            <div class="running_cost">
                                定額費用@include('admin.objects.projects.umu-money-radio', ['name' => 'internet_fixed_presence', 'default' => 0, 'checked' => $article->internet_fixed_presence?? 0])
                                <div class="running_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'internet_fixed_cost', 'value' => $article->internet_fixed_cost])円&#047;
                                    @include('admin.objects.components.radio', ['name' => 'internet_fixed_cost_unit', 'radio' => $running_cost_unit, 'default' => 1, 'checked' => $article->internet_fixed_cost_unit])
                               </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>CATVに係る費用</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio-cost', ['name' => 'catv', 'default' => 2, 'checked' => $article->catv?? 2])
                            <div class="initial_cost">
                                初期費用@include('admin.objects.projects.umu-money-radio', ['name' => 'catv_presence', 'default' => 0, 'checked' => $article->catv_presence?? 0])
                                <div class="initial_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'catv_cost', 'value' => $article->catv_cost])円
                                </div>
                            </div>
                            <div class="running_cost">
                                定額費用@include('admin.objects.projects.umu-money-radio', ['name' => 'catv_fixed_presence', 'default' => 0, 'checked' => $article->catv_fixed_presence?? 0])
                                <div class="running_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'catv_fixed_cost', 'value' => $article->catv_fixed_cost])円&#047;
                                    @include('admin.objects.components.radio', ['name' => 'catv_fixed_cost_unit', 'radio' => $running_cost_unit, 'default' => 1, 'checked' => $article->catv_fixed_cost])
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>町会費など</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'council', 'radio' => $council_cost, 'default' => 0, 'checked' => $article->council])
                            </div>
                            <div id="council_presence_area">
                                @include('admin.objects.projects.umu-money-radio', ['name' => 'council_presence', 'default' => 0, 'checked' => $article->council_presence?? 0])
                            </div>
                            <div id="council_cost_area">
                                @include('admin.objects.components.input', ['name' => 'council_cost', 'value' => $article->council_cost])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'council_cost_unit', 'radio' => $cost_unit, 'default' => 0, 'checked' => $article->council_cost_unit])
                            </div>

                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>温泉</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'spring', 'radio' => $spring_cost, 'default' => 0, 'checked' => $article->spring])
                            </div>
                            <div id="spring_area">
                                @include('admin.objects.projects.umu-money-radio', ['name' => 'spring_presence', 'default' => 0, 'checked' => $article->spring_presence?? 0])
                            </div>
                            <div id="spring_cost_area">
                                @include('admin.objects.components.input', ['name' => 'spring_cost', 'value' => $article->spring_cost])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'spring_cost_unit', 'radio' => $cost_unit, 'default' => 0, 'checked' => $article->spring_cost_unit])
                            </div>
                            <div id="spring_kind_area">
                                <p class="mb-0">天然温泉ではない場合は選択</p>
                                @include('admin.objects.components.checkbox', ['name' => 'spring_kind', 'checkbox' => $spring_kind, 'checked' => $article->spring_kind])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>その他諸経費１</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            <div>
                                名称
                                @include('admin.objects.components.input', ['name' => 'another_cost_name1', 'value' => $article->another_cost_name1])
                            </div>
                            <div>
                                金額
                                @include('admin.objects.components.input', ['name' => 'another_cost1', 'value' => $article->another_cost1])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'another_cost_unit1', 'radio' => $other_cost_unit, 'default' => 0, 'checked' => $article->another_cost_unit1])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                <div>その他諸経費２</div>
                                <span class="require_applicable">該当必須</span>
                            </div>
                        </th>
                        <td>
                            <div>
                                名称
                                @include('admin.objects.components.input', ['name' => 'another_cost_name2', 'value' => $article->another_cost_name2])
                            </div>
                            <div>
                                金額
                                @include('admin.objects.components.input', ['name' => 'another_cost2', 'value' => $article->another_cost2])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'another_cost_unit2', 'radio' => $other_cost_unit, 'default' => 0, 'checked' => $article->another_cost_unit2])
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'overview'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '３.物件概要'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">土地権利</th>
                        <td>

                            @if(isset($mansion->land_right))
                            {{ $arry_land_right[$mansion->land_right] }}
                            @endif
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>土地情報</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">用途地域</th>
                        <td>
                            <div class="mb10">
                                @if(!empty($mansion->use_area))
                                    {{$arr_use_area[$mansion->use_area]}}
                                @endif
                            </div>
                            <div>
                                @if(!empty($mansion->land_use))
                                一部&nbsp;{{$arr_use_area_district[$mansion->land_use]}}&nbsp;を含む
                                @endif
                                @if(!empty($mansion->land_use2))
                                一部&nbsp;{{$arr_use_area_district[$mansion->land_use2]}}&nbsp;を含む
                                @endif
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">都市計画</th>
                        <td>
                            @if($mansion->city_plan != null)
                                {{$arr_city_plan[$mansion->city_plan]}}
                            @endif
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>マンション建物情報</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>専有面積</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'total_area', 'radio' => $mansion_unit1, 'default' => 0, 'checked' => $article->total_area])
                            @include('admin.objects.components.input', ['name' => 'total_area_val', 'placeholder' => '000.00', 'value' => $article->total_area_val])&nbsp;m&sup2;
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>間取り</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'floor_plan', 'options' => $floor_plan, 'selected' => $article->floor_plan])
                            @include('admin.objects.components.selectbox', ['name' => 'floor_plan_type', 'options' => $floor_type, 'selected' => $article->floor_plan_type])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>バルコニー面積</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio', ['name' => 'balcony_area', 'default' => 0, 'checked' => $article->balcony_area])
                            <div id="balcony_area_area">
                                @include('admin.objects.components.input', ['name' => 'balcony_area_val', 'placeholder' => '000.00', 'value' => $article->balcony_area_val])&nbsp;m&sup2;
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>ルーフバルコニー面積</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio', ['name' => 'loof_balcony_area', 'default' => 0, 'checked' => $article->loof_balcony_area])
                            <div id="loof_balcony_area_area">
                                @include('admin.objects.components.input', ['name' => 'loof_balcony_area_val', 'placeholder' => '000.00', 'value' => $article->loof_balcony_area_val])&nbsp;m&sup2;
                                @include('admin.objects.components.input', ['name' => 'loof_balcony_area_cost', 'value' => $article->loof_balcony_area_cost])円
                                @include('admin.objects.components.radio', ['name' => 'loof_balcony_area_unit', 'radio' => $mansion_cost_unit, 'default' => 1, 'checked' => $article->loof_balcony_area_unit])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>専用庭面積</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio', ['name' => 'garden_area', 'default' => 0, 'checked' => $article->garden_area])
                            <div id="garden_area_area">
                                @include('admin.objects.components.input', ['name' => 'garden_area_val', 'placeholder' => '000.00', 'value' => $article->garden_area_val])&nbsp;m&sup2;
                                @include('admin.objects.components.input', ['name' => 'garden_area_cost', 'value' => $article->garden_area_cost])円
                                @include('admin.objects.components.radio', ['name' => 'garden_area_unit', 'radio' => $mansion_cost_unit, 'default' => 1, 'checked' => $article->garden_area_unit])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>テラス面積</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio', ['name' => 'terrace_area', 'default' => 0, 'checked' => $article->terrace_area])
                            <div id="terrace_area_area">
                                @include('admin.objects.components.selectbox', ['name' => 'terrace_direction', 'options' => $land_direction, 'selected' => $article->terrace_direction])
                                @include('admin.objects.components.input', ['name' => 'terrace_area_val', 'placeholder' => '000.00', 'value' => $article->terrace_area_val])&nbsp;m&sup2;
                                @include('admin.objects.components.input', ['name' => 'terrace_area_cost', 'value' => $article->terrace_area_cost])円
                                @include('admin.objects.components.radio', ['name' => 'terrace_area_unit', 'radio' => $mansion_cost_unit, 'default' => 1, 'checked' => $article->terrace_area_unit])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">現況</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'current_status', 'options' => $genkyou, 'default' => 1, 'title' => '現況', 'selected' => $article->current_status])
                            <div id="current_status_area" class="mt5">
                                <div class="mb5">賃料&nbsp;@include('admin.objects.components.input', ['name' => 'current_status_val', 'class' => 'w100', 'value' => $article->current_status_val])円 / 月</div>
                                <div class="">利回り&nbsp;@include('admin.objects.components.input', ['name' => 'current_status_rate', 'class' => 'w100', 'value' => $article->current_status_rate])％</div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>引き渡し</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'move_in', 'radio' => $move_in, 'default' => 0, 'checked' => $article->move_in])
                            <div id="move_in_year" class="mb10">
                                @include('admin.objects.components.selectbox', ['name' => 'move_in_year', 'options' => Config::get('const.YEAR'), 'selected' => $article->move_in_year, 'title' => '引き渡し（年）'])年
                                @include('admin.objects.components.selectbox', ['name' => 'move_in_month', 'options' => Config::get('const.MONTH'), 'selected' => $article->move_in_month, 'title' => '引き渡し（月）'])月
                            </div>
                            <div id="move_in_month">
                                @include('admin.objects.components.selectbox', ['name' => 'move_in_contract_month', 'options' => Config::get('const.MONTH'), 'selected' => $article->move_in_contract_month])ヶ月
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>階数</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            <div class="d-flex">
                                <div class="mr-3">
                                    @include('admin.objects.components.input', ['name' => 'whereabouts', 'class' => 'w100', 'value' => $article->whereabouts])階部分/地上{{$article->floor}}階&nbsp;地下{{$article->underground}}階
                                </div>
                                <div class="ml-3">
                                    @include('admin.objects.components.checkbox', ['name' => 'maisonette', 'checkbox' => $maisonette, 'checked' => $article->maisonette])
                                    @include('admin.objects.components.input', ['name' => 'maisonette_from', 'class' => 'w100', 'value' => $article->maisonette_from])階〜
                                    @include('admin.objects.components.input', ['name' => 'maisonette_to', 'class' => 'w100', 'value' => $article->maisonette_to])階部分
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">リフォーム&nbsp;内装</th>
                        <td>
                            <div>
                            @include('admin.objects.components.radio', ['name' => 'interior', 'radio' => $reform, 'default' => 1, 'checked' => $article->interior])
                            </div>
                            <div id="interior_detail">
                                内装年月
                                @include('admin.objects.components.selectbox', ['name' => 'interior_year', 'options' => Config::get('const.REFORM_YEAR'), 'selected' => $article->interior_year])年
                                @include('admin.objects.components.selectbox', ['name' => 'interior_month', 'options' => Config::get('const.MONTH'), 'selected' => $article->interior_month])月
                                <br>
                                内装箇所
                                @include('admin.objects.components.checkbox', ['name' => 'interior_place', 'checkbox' => $interior])
                                @include('admin.objects.components.input', ['name' => 'interior_text', 'class' => 'w100', 'value' => $article->interior_text])
                            </div>
                        </td>
                    </tr>




                    <tr>
                        <th colspan="2">総戸数</th>
                        <td>
                            {{$mansion->total_unit}}戸
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">築年月</th>
                        <td>
                            {{$mansion->age_year}}年{{$mansion->age_month}}月
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">構造</th>
                        <td>
                            <div>
                                @if(!empty($mansion->construction))
                                {{$arr_construction[$mansion->construction]}}
                                @endif
                            </div>
                            <div>
                                @if(!empty($mansion->construction_sub))
                                一部{{$arr_construction_sub[$mansion->construction_sub]}}を含む
                                @endif
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">敷地面積</th>
                        <td>
                            {{$mansion->land_area_val}}m&sup2;
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">分譲会社</th>
                        <td>
                            {{$mansion->sales_company}}
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">施工会社</th>
                        <td>
                            {{$mansion->construction_company}}
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">管理会社</th>
                        <td>
                            {{$mansion->management_company}}
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">管理形態</th>
                        <td>
                            @if(!empty($mansion->management_form))
                            {{$arr_management_form[$mansion->management_form]}}
                                @endif
                            
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">共用部</th>
                        <td>
                            {{$mansion->shared_text??'-'}}
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">ペット飼育</th>
                        <td>
                        @if(!empty($mansion->pet))
                        {{$arr_pet[$mansion->pet]}} @if($mansion->pet == 2) {{$mansion->pet_count}} 匹 @endif
                        @endif
                            
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    @include('admin.objects.components.regist-tab', ['active' => 'investment'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '４.投資・事業用'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">区分<span class="require">必須</span></th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'classfication', 'radio' => $classification, 'default' => 1, 'checked' => $article->classfication])
                            </div>
                        </td>
                    </tr>
                    <tr id="classfication_area">
                        <th colspan="2">事業用用途</th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'use_method', 'radio' => $use_method, 'default' => 1, 'checked' => $article->use_method])
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'advertisement'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '５.取引情報・広告'])
        @include('admin.objects.projects.edit-vendor')
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'event'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '６.イベント'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                @include('admin.objects.projects.event')
                </tbody>
            </table>
            <div class="regist__div d-flex justify-content-center">
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__image saved_to_image', 'title' => '画像登録・編集画面へ', 'type' => 'submit'])
                </div>
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__save', 'title' => '登録・保存して閉じる'])
                </div>
            </div>
        </div>
    </div>
</form>



{{-- 分譲地検索モーダルウィンドウ --}}


@include('admin.objects.projects.modal-vendor', ['no' => 9])
@include('admin.objects.projects.address-script')
@if($saved == 1)
@include('admin.objects.projects.modal-message')
<script type="text/javascript">
    window.onload = function(){
        var message = '登録・保存しました。';
        $('#saved_message').text(message);
        openMessageModal();
    };

</script>
@endif
@endsection
