@extends('admin.layouts.base')

@section('contents')
<div class="loading_disp loading_hide"></div>
<div class="mt5">
    <p>施設登録</p>
    @include('admin.objects.components.facility-tab', ['title' => '施設管理'])
    @include('admin.objects.components.regist-band', ['title' => '施設検索'])
    <form method="POST" action="{{ route('facility-edit', ['id' => $facility_info->id]) }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    <div id="@if(isset($tmp_id)){{$tmp_id}}@endif"  class="facility_regist @if(isset($add_class)) {{$add_class}} @endif">
        <table>
            <tr>
                <td rowspan="5">
                    <div class="facility_image_area">
                        @include('admin.objects.components.add-facility-image', ['id' => 'imageArea'])
                    </div>
                    <div class="facility_image_area_sub">
                        @include('admin.objects.components.hidden', ['name' => 'del_img'])
                        @include('admin.objects.components.btn', ['name' => 'del_facility_img', 'type' => 'button', 'title' => '削除'])
                    </div>
                </td>
                <th>施設ID</th>
                <td colspan="3">
                    {{$facility_info->id}}
                </td>
            </tr>
            <tr>
                <th>施設名</th>
                <td>
                @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w300', 'value' => $facility_info->name])
                </td>
                <th>施設種別</th>
                <td>
                @include('admin.objects.components.selectbox', ['name' => 'kind', 'options' => $kind, 'title' => '施設種別', 'selected' => $facility_info->kind])
                </td>
            </tr>
            <tr>
                <th>住所</th>
                <td colspan="3">
                    <div>
                        &#12306;@include('admin.objects.components.input', ['name' => 'zip', 'class' => 'mb-2', 'placeholder' => '000-0000', 'value' => $facility_info['zip']])
                        @include('admin.objects.components.btn', ['title' => '郵便番号から住所決定', 'class' => 'btn_decision', 'id'=>'zipToAddress'])
                        @include('admin.objects.components.btn', ['title' => '住所から郵便番号決定', 'class' => 'btn_decision', 'id' => 'addressToZip'])
                    </div>
                    <div>
                        @include('admin.objects.components.selectbox', ['name' => 'address1', 'class' => 'mb-2', 'options' => $pref, 'title' => '都道府県', 'selected' => $facility_info['address1']])
                        @include('admin.objects.components.selectbox', ['name' => 'address2', 'class' => 'mb-2', 'options' => $city, 'title' => '市区郡', 'selected' => $facility_info['address2']])
                        @include('admin.objects.components.selectbox', ['name' => 'address3', 'class' => 'mb-2', 'options' => $town, 'title' => '町村', 'selected' => $facility_info['address3']])
                    </div>
                    <div>
                        @include('admin.objects.components.input', ['name' => 'address4', 'class' => 'w-50', 'placeholder' => '町村以降を入力', 'value' => $facility_info['address4']])
                    </div>
                </td>
            </tr>
            <tr>
                <th>物件位置情報</th>
                <td colspan="3">
                    緯度&#047;<span name="lat_text">{{$facility_info->lat}}}</span>&nbsp;経度&#047;<span name="lng_text">{{$facility_info->lng}}</span>
                    @include('admin.objects.components.hidden', ['name' => 'lat', 'value' => $facility_info->lat])
                    @include('admin.objects.components.hidden', ['name' => 'lng', 'value' => $facility_info->lng])
                    @include('admin.objects.components.modal-btn', ['title' => '位置確認・修正', 'class' => 'btn_position', 'data' => 2])
                </td>

            </tr>
            <tr>
                <th>キャプション</th>
                <td colspan="3">
                @include('admin.objects.components.textarea', ['name' => 'memo', 'class' => 'w500', 'count' => 100, 'placeholder' => 'キャプションを入力してください', 'value' => $facility_info->memo])
                </td>

            </tr>
        </table>
    </div>
        <div class="regist__div">
            @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
        </div>
    </form>
</div>
@endsection