@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @if (session('message'))
        <div class="flash_message">
            {{ session('message') }}
        </div>
    @endif
    @include('admin.objects.components.facility-tab', ['title' => '施設管理'])
    @include('admin.objects.components.regist-band', ['title' => '施設検索'])
    <div class="search_vendor">
        <form method="POST" action="{{ route('facility-top') }}" id="test">
        {{ csrf_field() }}
        <dl class="d-flex search_vendor__con">
            <dt>施設名</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'search_name', 'class' => 'w400', 'value' => $search['search_name']?? ''])</dd>
        </dl>
        <dl class="d-flex search_vendor__con">
            <dt>施設種別</dt>
            <dd>
            @include('admin.objects.components.selectbox', ['name' => 'search_property', 'class' => 'mb-2', 'options' => $facility_property, 'title' => '施設種別', 'selected' => $search['search_property']?? ''])
            </dd>

            <dt>住所</dt>
            <dd>
            <input type="hidden" name="search_address1" value="14">
            @include('admin.objects.components.selectbox', ['name' => 'search_address1', 'class' => 'mb-2', 'options' => $pref, 'default' => Config::get('const.DEFAULT_PREF'), 'selected' => $search['search_address1']?? ''])
            @include('admin.objects.components.selectbox', ['name' => 'search_address2', 'class' => 'mb-2', 'options' => $city, 'title' => '市区郡', 'selected' => $search['search_address2']?? ''])
            @include('admin.objects.components.selectbox', ['name' => 'search_address3', 'class' => 'mb-2', 'options' => $town, 'title' => '町村', 'selected' => $search['search_address3']?? ''])
            </dd>
        </dl>
 
        <div class="search_vendor__btn">
        @include('admin.objects.components.btn', ['title' => '検索', 'class'=> 'btn_search w120'])
        <a href="{{ route('facility-regist') }}" class="btn_imagesave w120">新規登録</a>

        <a href="javascript:void(0);" class="facility_clear">条件をクリア</a>
        </div>
        </form>    
    </div>
    @if(isset($facility_list))
    <div class="facility_list">
        <div class="d-flex justify-content-between pager mt10">
            <div class="m-2"><span class="pager-total">検索結果&nbsp;{{$facility_list->total()}}</span><span>件中&nbsp; {{$first}}〜{{$last}}件表示</span></div>
            <div class="mt-2">{{ $facility_list->links() }}</div>
        </div>
        <table>
            <tr>
                <th class="w200">写真画像</th>
                <th >施設番号</th>
                <th class="w150">施設種別</th>
                <th class="w250">施設名</th>
                <th class="w250">住所</th>
                <th></th>
            </tr>
            @foreach($facility_list as $item)
            <tr>
                <td>
                    @if(!empty($item['file_path']))
                    <img src="{{$item['file_path']}}" width="150" />
                    @else
                    <img src="{{root('img/noimage2.jpg')}}" width="150" />
                    @endif
                </td>
                <td name="user_id"><a class="target_link_id" href="/admin/editFacility/{{$item['id']}}">{{$item['id']}}</a></td>
                <td>{{$item['property']}}</td>
                <td>{{$item['name']}}</td>
                <td>{{$item['pref_name']}}{{$item['city_name']}}{{$item['town_name']}}</td>
                <td>
                    <div class="d-flex">
                        @include('admin.objects.components.hidden', ['name' => 'facility_id', 'value' => $item['id']])
                        @include('admin.objects.components.link-btn-nostyle', ['name' => 'edit_facility', 'url' => '/admin/editFacility/'.$item['id'], 'class' => 'edit_facilirty_btn ', 'title' => '編集'])
                        @include('admin.objects.components.link-btn-nostyle', ['name' => 'delete_facility', 'url' => 'javascript:void(0);', 'class' => 'del_facilirty_btn delete_facility', 'title' => '削除'])
                    </div>
                </td>
            </tr>
            @endforeach
        </table>
    </div>
    @endif
</div>
@endsection