@extends('admin.layouts.base')

@section('contents')
<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ー店舗情報', 'type' => 'store'])
@if($store->disp == 1)
    @php $url = ""; if($store->name_kana != null && $store->name_kana != ""){ $url = '/shop/'.$store->name_kana.'.html'; } @endphp
    @include('admin.objects.components.regist-band', ['title' => '店舗情報一覧', 'conf_url' => $url])
@else
    @include('admin.objects.components.regist-band', ['title' => '店舗情報一覧'])
@endif
    <div class="news_regist">
        @if($errors->any())
        <div class="error">
        <ul>
            @foreach($errors->all() as $message)
            <li>{{ $message }}</li>
            @endforeach
        </ul>
        </div>
        @endif
        @if (session('message'))
            <div class="flash_message">
                {{ session('message') }}
            </div>
        @endif
        <form method="POST" action="{{ route('store-edit', ['id' => $store->code]) }}" enctype="multipart/form-data">
        {{ csrf_field() }}  
            <div>
                <table>
                    <tr>
                        <th class="w200">店舗番号</th>
                        <td>{{$store->code}}</td>
                    </tr>
                    <tr>
                        <th>店舗名</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w250', 'placeholder' => '店舗名を入力', 'value' => $store->name])
                        </td>
                    </tr>
                    <tr>
                        <th>店舗名（英字）</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'name_kana', 'class' => 'w250', 'placeholder' => 'eiji', 'value' => $store->name_kana])
                        </td>
                    </tr>
                    <tr>
                        <th>住所</th>
                        <td>
                        @include('admin.objects.projects.form-address-store')
                        </td>
                    </tr>
                    <tr>
                        <th>フリーダイヤル</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'freedial', 'class' => 'w250', 'placeholder' => '000-00-000', 'value' => $store->freedial])
                        </td>
                    </tr>
                    <tr>
                        <th>電話番号</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'tel', 'class' => 'w250', 'placeholder' => '000-00-000', 'value' => $store->tel])
                        </td>
                    </tr>
                    <tr>
                        <th>FAX番号</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'fax', 'class' => 'w250', 'placeholder' => '000-00-000', 'value' => $store->fax])
                        </td>
                    </tr>
                    <tr>
                        <th>メール</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'email', 'class' => 'w250', 'placeholder' => '000@000', 'value' => $store->email])
                        </td>
                    </tr>
                    <tr>
                        <th>営業時間</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'business_hours', 'class' => 'w250', 'placeholder' => '00:00〜00:00', 'value' => $store->business_hours])
                        </td>
                    </tr>
                    <tr>
                        <th>定休日</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'holiday', 'class' => 'w250', 'placeholder' => '曜日', 'value' => $store->holiday])
                        </td>
                    </tr>
                    <tr>
                        <th>駐車場台数</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'parking', 'class' => 'w500', 'value' => $store->parking])
                        </td>
                    </tr>
                    <tr>
                        <th>メッセージ</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'comment', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください', 'value' => $store->comment])
                        </td>
                    </tr>
                </table>
            </div>
            <div class="search_vendor__btn">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
            <table class="p-regist__table mt10">
                <tbody>
                @include('admin.objects.projects.image-upload-large-store', ['id' => 'iamgeAreaMulti', 'cid' => 'iamgeAreaMultiChild'])
                <tr>
                    <td colspan="8">
                        <table id="sortable_store_image">
                            <tbody id="image_list">
                        @include('admin.objects.components.add-store-template')
                        @foreach($photos as $photo)
                            @include('admin.objects.components.add-store-template-edit', ['num' => $loop->iteration+1])
                        @endforeach
                            </tbody>
                        </table>
                    </td>
                </tr>

                </tbody>
            </table>
            <div class="regist__div">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </form>
        
       
    </div>
</div>
@endsection