@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.vendor-tab', ['title' => '業者管理'])
    @include('admin.objects.components.regist-band', ['title' => '業者検索'])
    <div class="search_vendor">
        <form method="POST" action="{{ route('vendor-search') }}">
        {{ csrf_field() }}
        <dl class="d-flex search_vendor__con">
            <dt>業者番号</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'id', 'class' => 'w125'])</dd>
            <dt>業者名</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'name', 'class' => 'w175'])</dd>
            <dt>担当</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'vendor_charge', 'class' => 'w100'])</dd>
            <dt>電話</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'vendor_tel', 'class' => 'w125'])</dd>
            <dt>FAX</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'vendor_fax', 'class' => 'w125'])</dd>
        </dl>
        <dl class="d-flex search_vendor__con">
            <dt>物件確認日</dt>
            <dd>
            @include('admin.objects.components.input', ['name' => 'from_conf_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])〜
            @include('admin.objects.components.input', ['name' => 'to_conf_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])
            </dd>
            <dt>ステータス</dt>
            <dd>@include('admin.objects.components.selectbox', ['name' => 'status', 'options' => []])</dd>
            <dt>成約価格</dt>
            <dd>
                @include('admin.objects.components.input', ['name' => 'price', 'class' => 'w75'])万円
                @include('admin.objects.components.checkbox', ['name' => 'tax', 'checkbox' => [['name' => '税込', 'code' => 1]]])
            </dd>
            <dt>価格変更日</dt>
            <dd>
            @include('admin.objects.components.input', ['name' => 'from_price_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])〜
            @include('admin.objects.components.input', ['name' => 'to_price_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])
        </dl>
        <dl class="d-flex search_vendor__con">
            <dt>広告確認日</dt>
            <dd>
            @include('admin.objects.components.input', ['name' => 'from_ad_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])〜
            @include('admin.objects.components.input', ['name' => 'to_ad_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])
            </dd>
            <dt>確認手法</dt>
            <dd>@include('admin.objects.components.selectbox', ['name' => 'status', 'options' => []])</dd>
            <dt></dt>
            <dd>
                <ul class="d-flex p-regist__table-list">
                    <li>
                        <p>チラシ</p>
                        @include('admin.objects.components.selectbox', ['name' => 'flyer', 'options' => $ad_conf])
                    </li>
                    <li>
                        <p>情報誌</p>
                        @include('admin.objects.components.selectbox', ['name' => 'freepaper', 'options' => $ad_conf])
                    </li>
                    <li>
                        <p>自社HP</p>
                        @include('admin.objects.components.selectbox', ['name' => 'house_hp', 'options' => $ad_conf])
                    </li>
                    <li>
                        <p>ポータル</p>
                        @include('admin.objects.components.selectbox', ['name' => 'portal', 'options' => $ad_conf])
                    </li>

                    <li>
                        <p>現地看板</p>
                        @include('admin.objects.components.selectbox', ['name' => 'signboard', 'options' => $ad_conf])
                    </li>
                </ul>
            </dd>
            <dt>物件登録日</dt>
            <dd>
            @include('admin.objects.components.input', ['name' => 'from_regist_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])〜
            @include('admin.objects.components.input', ['name' => 'to_regist_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00'])
        </dl>
        <div class="search_vendor__btn">
        @include('admin.objects.components.btn', ['title' => '検索', 'class'=> 'btn_search w120'])
@if(false)
        @include('admin.objects.components.btn', ['id' => 'regist_vendor', 'class' => 'btn_imagesave', 'title' => '新規保存'])
        <a href="javascript:void(0);" >クリア</a>
@endif
        </div>
        </form>    
    </div>
</div>
@endsection