@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ーお知らせ', 'type' => 'news'])
    @include('admin.objects.components.regist-band', ['title' => 'お知らせ一覧'])
    <div class="d-flex justify-content-end">
        <a href="{{ route('news-regist') }}" class="btn_imagesave w120 news_new_btn">新規登録</a>
    </div>
    <div class="news_list">
        <table>
            <tr>
                <th class="w150">写真画像</th>
                <th class="w150">日付/カテゴリ</th>
                <th class="w300">見出し</th>
                <th class="w200">リンク先</th>
                <th class="w125">公開</th>
                <th class=""></th>
            </tr>
            @foreach($news as $item)
            <tr>
                <td>
                    @if(!empty($item->file_path))
                    <img src="{{$item->file_path}}" width="150" />
                    @else
                    <img src="{{root('img/noimage2.jpg')}}" width="150" />
                    @endif
                    
                </td>
                <td>{{$item->news_date}}/{{$item->category_name}}</td>
                <td>{{$item->news_title}}</td>
                <td>
                    @if($item->news_link == 0)
                    - 
                    @else
                        @if($item->news_link_target == 1)
                            URL/<br><a href="{{$item->news_link_target_url}}">{{$item->news_link_target_url}}</a>
                        @else
                            新規ページ/<br><a href="{{Request::root()}}{{$item->news_link_target_url}}">{{Request::root()}}{{$item->news_link_target_url}}</a>
                        @endif
                        
                    @endif
                </td>
                <td class="text-center">@include('admin.objects.components.switch-disp', ['name' => 'news_disp', 'checked' => $item->disp])</td>
                <td>
                        @include('admin.objects.components.hidden', ['name' => 'news_id', 'value' => $item->news_id])
                        @include('admin.objects.components.link-btn-nostyle', ['url' => route('news-edit', ['id' => $item->news_id]), 'title' => '編集', 'class' => 'edit_news_btn'])
                        @include('admin.objects.components.link-btn-nostyle', ['url' => 'javascript:void(0);', 'title' => '削除', 'class' => 'del_news_btn', 'name' => 'news_delete'])
                </td>
            </tr>
            @endforeach
        </table>
    </div>
</div>
@endsection