@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ーおすすめ物件', 'type' => 'recommend'])
    @include('admin.objects.components.regist-band', ['title' => 'おすすめ物件一覧'])
    <div class="d-flex justify-content-between pager mt10">
        <div class="m-2"><span class="recommend_text"> 登録数&nbsp;{{ count($recommend) }}&nbsp;/&nbsp;{{Config::get('const.RECOMMEND_MAX')}}件</span><span class="recommend_text_sub">ドラッグ＆ドロップで並べ替えができます。</span></div>
    </div>
    <div class="recommend_list">
        <table  id="sortable_new">
            <thead>
                <tr>
                    <th class="" rowspan="2"></th>
                    <th class="w150">物件番号</th>
                    <th class="" colspan="2">物件名</th>
                    <th class="">所在地</th>
                    <th class="">価格</th>
                    <th class="">土地面積</th>
                    <th class="">小学校区/中学校区</th>
                    <th class="w125" rowspan="2"></th>
                </tr>
                <tr>
                    <th class="">物件登録日</th>
                    <th class="">物件種別</th>
                    <th class="">間取り</th>
                    <th class="">交通</th>
                    <th class="">築年月</th>
                    <th class="">延床面積</th>
                    <th class="">階/階建</th>
                </tr>
            </thead>
            @foreach($recommend as $item)
            <tbody class="@if($loop->iteration % 2 == 0) even @else odd @endif">
            <tr>
                <td rowspan="2" class="rank_td">
                    <span class="rank">{{$loop->iteration}}</span>
                </td>
                <td>物件番号<br><a class="target_link_id" href="
                    @if($item->property < 4)
					/admin/editLand/{{$item->building_id}}
                    @elseif($item->property < 6)
                    /admin/editHouse/{{$item->building_id}}
                    @elseif($item->property < 8)
                    /admin/editMansion/{{$item->building_id}}
                    @elseif($item->property == 99)
                    /admin/editLot/{{$item->building_id}}
					@endif
                ">{{$item->building_id}}</a></td>
                <td colspan="2">{{$item->name}}</td>
                <td>{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}</td>
                <td><span class="price_text">{{$item->price}}</span><span>万円</span></td>
                <td>{{$item->land_area_val?? "-"}}m&sup2;</td>
                <td>{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
                <td rowspan="2">
                    @include('admin.objects.components.hidden', ['name' => 'recommend_id', 'value' => $item->building_id])
                    @include('admin.objects.components.link-btn-nostyle', ['url' => 'javascript:void(0);', 'title' => '削除', 'class' => 'del_facilirty_btn', 'name' => 'recommend_delete'])
                </td>
            </tr>
            <tr>
                <td>{{$item->created_at->format('Y/m/d')}}</td>
                <td>
                    @if(isset($item->property_sub) && $item->property_sub == 1)
                        新築
                    @elseif(isset($item->property_sub) && $item->property_sub == 2)
                        中古
                    @endif

                    @if(isset($item->property) && $item->property == 1)
                    土地
                    @elseif(isset($item->property) && $item->property == 2)
                    土地
                    @elseif(isset($item->property) && $item->property == 3)
                    土地
                    @elseif(isset($item->property) && $item->property == 4)
                    戸建
                    @elseif(isset($item->property) && $item->property == 5)
                    テラスハウス
                    @elseif(isset($item->property) && $item->property == 6)
                    マンション
                    @elseif(isset($item->property) && $item->property == 7)
                    タウンハウス
                    @endif
                </td>
                <td>{{$item->floor_plan_text?? "-"}}</td>
                <td>{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                <td>{{$item->age_year?? "-"}}年{{$item->age_month?? "-"}}月</td>
                <td>{{$item->total_area_val?? "-"}}m&sup2;</td>
                <td>@if(isset($item->whereabouts)) {{$item->whereabouts}}階 @else - @endif/@if(isset($item->floor)) {{$item->floor}}階 @else - @endif</td>
            </tr>
            </tbody>
            @endforeach
        </table>
    </div>
</div>
@endsection