@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ーリフォーム事例', 'type' => 'reform'])
    @include('admin.objects.components.regist-band', ['title' => 'リフォーム事例一覧', 'conf_url' => '/reform/works'])

    <div class="d-flex justify-content-between pager mt10">
        <div class="m-2">
            <span class="recommend_text"> 登録数&nbsp;{{count($reform)}}件&nbsp;&nbsp;&nbsp;公開中物件数&nbsp;{{$disp_count}}件</span><span class="recommend_text_sub">ドラッグ＆ドロップで並べ替えができます。</span>
        </div>
        <div class="d-flex justify-content-end">
            <a href="{{ route('reform-regist') }}" class="btn_imagesave w120 store_new_btn">新規登録</a>
        </div>
    </div>
    
    <div class="reform_list">
        <table  id="sortable_reform">
            <thead>
                <tr>
                    <th colspan="2" class="w150">写真画像</th>
                    <th class="w150">リフォーム番号<br>カテゴリ</th>
                    <th class="">タイトル<br>住所</th>
                    <th class="w125">公開</th>
                    <th class="w250"></th>
                </tr>
            </thead>
            @foreach($reform as $item)
            <tbody class="@if($loop->iteration % 2 == 0) even @else odd @endif">
                <tr>
                    <td rowspan="2" class="rank_td">
                        <span class="rank">{{$loop->iteration}}</span>
                    </td>
                    <td rowspan="2">
                        @if(!empty($item->disp_file))
                        <img src="{{$item->disp_file}}" width="150" />
                        @else
                        <img src="{{root('img/noimage2.jpg')}}" width="150" />
                        @endif
                        
                    </td>
                    <td>{{$item->code}}</td>
                    <td>{{$item->title}}</td>
                    <td rowspan="2" class="text-center">@include('admin.objects.components.switch-disp', ['name' => 'reform_disp', 'checked' => $item->disp])</td>
                    <td rowspan="2">
                        @include('admin.objects.components.hidden', ['name' => 'reform_id', 'value' => $item->code])
                        @include('admin.objects.components.link-btn-nostyle', ['url' => route('reform-edit', ['id' => $item->code]), 'title' => '編集', 'class' => 'edit_news_btn'])
                        @include('admin.objects.components.link-btn-nostyle', ['url' => 'javascript:void(0);', 'title' => '削除', 'class' => 'del_news_btn', 'name' => 'reform_delete'])
                    </td>
                </tr>
                <tr>
                    <td>{{$item->category_name}}</td>
                    <td>{{$item->area}}</td>
                </tr>
            </tbody>
            @endforeach
        </table>
    </div>
</div>
@endsection