@extends('admin.layouts.base')

@section('contents')
<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ーお知らせ', 'type' => 'news'])
    @include('admin.objects.components.regist-band', ['title' => 'お知らせ一覧'])
    <div class="news_regist mb-3">
        @if($errors->any())
        <div class="error">
        <ul>
            @foreach($errors->all() as $message)
            <li>{{ $message }}</li>
            @endforeach
        </ul>
        </div>
        @endif
        @if (session('message'))
            <div class="flash_message">
                {{ session('message') }}
            </div>
        @endif
        <form method="POST" action="{{ route('news-regist') }}" enctype="multipart/form-data">
        {{ csrf_field() }}  
            <div>
                <table>
                    <tr>
                        <th class="w200">日付</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'news_date', 'class' => 'cal_picker', 'placeholder' => '0000/00/00', 'value' => $today])
                        </td>
                        <td rowspan="5">
                            <div class="p-imgupload__area">
                                <canvas name="canvas_floor" width="0" height="0"></canvas>
                                <p class="p-imgupload__text">クリックまたは<br>ドラッグ&amp;ドロップ</p>
                                <input id="fileSingleInput" type="file" name="file_single_input" style="display:none;">
                                <input type="hidden" name="file_path" value="{{$file_path??''}}">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>カテゴリ</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'news_category', 'radio' => $category, 'default' => 0])
                        </td>
                    </tr>
                    <tr>
                        <th>見出し（一覧に表示）</th>
                        <td>
                            @include('admin.objects.components.textarea_reform', ['name' => 'news_title', 'class' => 'ta50', 'count' => 100])
                        </td>
                    </tr>
                    <tr>
                        <th>テキストリンク</th>
                        <td>
                        @include('admin.objects.projects.umu-radio', ['name' => 'news_link', 'default' => 0])
                        </td>
                    </tr>
                    <tr class="no_disp">
                        <th>リンク先</th>
                        <td>
                            <div class="d-flex">
                                <input type="radio" class="u-radio" name="news_link_target" @if(old('news_link', '1')=='1') checked @endif value="1" id="news_link_target_1" checked>
                                <label for="news_link_target_1" class="u-radio__label news_link">URL</label>
                                <div class="mr10">@include('admin.objects.components.input', ['name' => 'news_link_target_1', 'class' => 'w250'])</div>
                            </div>
                            <div class="d-flex">
                                <input type="radio" class="u-radio" name="news_link_target" @if(old('news_link', '1')=='2') checked @endif value="2" id="news_link_target_2">
                                <label for="news_link_target_2" class="u-radio__label news_link">新規ページ</label>
                                <div class="mr10">@include('admin.objects.components.input', ['name' => 'news_link_target_2', 'class' => 'w250', 'other_attr' => 'readonly', 'placeholder' => 'URLが自動生成されます。'])</div>
                            </div>
                            <div class="news_detail_area">
                                <dl>
                                    <dt>
                                    新規（詳細ページ）内容
                                    </dt>
                                    <dd>
                                    @include('admin.objects.components.textarea_reform', ['name' => 'news_link_target_text', 'class' => 'ta500', 'count' => 500])
                                    </dd>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="search_vendor__btn">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </form>
        
       
    </div>
</div>
@endsection