@extends('admin.layouts.base')

@section('contents')
<script type="text/javascript">
$(document).on('change', '[name^=address2]', function(){
        var cityId = $(this).val();
        var obj = $(this);
        var prefId = $('[name^=address1]').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            datatype: 'json',
            url: '/admin/city_search',
            data: {
                prefId: prefId,
                cityId: cityId
            }
        })
        .done(function(data){ //ajaxの通信に成功した場合
            // alert("success!");
            $(obj).next('[name^=address3]').children('option').remove();
            $(obj).next('[name^=address3]').append($('<option>').text('町村を選択').attr('value', ''));
            $.each(data[0], function(row, value){
                $(obj).next('[name^=address3]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name=primary_school]').children('option').remove();
            $('[name=primary_school]').append($('<option>').text('小学校区を選択').attr('value', ''));
            $.each(data[1], function(row, value){
                $('[name=primary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

            $('[name=secondary_school]').children('option').remove();
            $('[name=secondary_school]').append($('<option>').text('中学校区を選択').attr('value', ''));
            $.each(data[2], function(row, value){
                $('[name=secondary_school]').append($('<option>').text(value['name']).attr('value', value['code']));
            });

        })
        .fail(function(data){ //ajaxの通信に失敗した場合
            alert("error!");
        });
    });
</script>
<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ーおすすめ物件', 'type' => 'recommend'])
    @include('admin.objects.components.regist-band', ['title' => 'おすすめ物件一覧'])
    <form method="POST" action="{{ route('recommend-regist') }}#recommend_list" enctype="multipart/form-data">
    {{ csrf_field() }}
        @include('admin.objects.projects.search-common-multi', ['isForSale' => true])
        @include('admin.objects.projects.search-footer-recommend')
    </form>
@if(isset($recommend))
    <div id="recommend_list" class="recommend_list">
    
        @include('admin.objects.components.hidden', ['name' => 'remaining', 'value' => $remaining])
        <div class="d-flex justify-content-between pager mt10">
            <div class="m-2"><span class="pager-total">検索結果&nbsp;{{$recommend->total()}}</span><span>件中&nbsp; {{$recommend->first}}〜{{$recommend->last}}件表示</span></div>
            <div class="mt-2">{!!$recommend->appends($con)->render()!!}</div>
            
        </div>
        <div>
            <a href="javascript:void(0);" name="recommend_save" class="recommend_save_btn">チェックした物件を登録する</a>
        </div>
        <table>
            <tr>
                <th class="" rowspan="2"></th>
                <th class="w150">物件番号</th>
                <th class="" colspan="2">物件名</th>
                <th class="">所在地</th>
                <th class="">価格</th>
                <th class="">土地</th>
                <th class="">校区</th>
            </tr>
            <tr>
                <th class="">物件登録日</th>
                <th class="">種別</th>
                <th class="">間取り</th>
                <th class="">交通</th>
                <th class="">築年月</th>
                <th class="">延床</th>
                <th class="">階/階建</th>
            </tr>
            @foreach($recommend as $item)
            <tr class="@if($loop->iteration % 2 == 0) even @else odd @endif">
                <td rowspan="2">
                @include('admin.objects.components.checkbox', ['name' => 'recommend_target[]', 'checkbox' => [['code' => $item->building_id, 'name' => '']], 'nocheck' => true])
                </td>
                <td>物件番号<br><a class="target_link_id" href="
                    @if($item->property == null)
                    /admin/editRoom/{{$item->mansion_id}}/{{$item->building_id}}
                    @elseif($item->property < 4)
					/admin/editLand/{{$item->building_id}}
                    @elseif($item->property < 6)
                    /admin/editHouse/{{$item->building_id}}
                    @elseif($item->property < 8)
                    /admin/editMansion/{{$item->building_id}}
                    @elseif($item->property == 99)
                    /admin/editLot/{{$item->building_id}}
					@endif
                ">{{$item->building_id}}</a></td>
                <td colspan="2">{{$item->name}}</td>
                <td>{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}</td>
                <td><span class="price_text">{{$item->price}}</span><span>万円</span></td>
                <td>{{$item->land_area_val?? "-"}}m&sup2;</td>
                <td>{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
            </tr>
            <tr class="@if($loop->iteration % 2 == 0) even @else odd @endif">
                <td>物件登録日</td>
                <td>
                    @if(isset($item->property_sub) && $item->property_sub == 1)
                        新築
                    @elseif(isset($item->property_sub) && $item->property_sub == 2)
                        中古
                    @endif
                    @if($item->property == null)
                    マンション
                    @elseif(isset($item->property) && $item->property == 1)
                    土地
                    @elseif(isset($item->property) && $item->property == 2)
                    土地
                    @elseif(isset($item->property) && $item->property == 3)
                    土地
                    @elseif(isset($item->property) && $item->property == 4)
                    戸建
                    @elseif(isset($item->property) && $item->property == 5)
                    テラスハウス
                    @elseif(isset($item->property) && $item->property == 6)
                    マンション
                    @elseif(isset($item->property) && $item->property == 7)
                    タウンハウス
                    @elseif(isset($item->property) && $item->property == null)
                    マンション（部屋）
                    @endif
                </td>
                <td>{{$item->floor_plan_text?? "-"}}</td>
                <td>{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                <td>{{$item->age_year?? "-"}}年{{$item->age_month?? "-"}}月</td>
                <td>{{$item->total_area_val?? "-"}}m&sup2;</td>
                <td>
                    {{$item->whereabouts}}階/{{$item->floor}}階建
                </td>
            </tr>
            @endforeach
        </table>
        <div>
            <a href="javascript:void(0);" name="recommend_save" class="recommend_save_btn">チェックした物件を登録する</a>
        </div>
    </div>
@endif
</div>
@endsection