@extends('admin.layouts.base')

@section('contents')
<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ーリフォーム情報', 'type' => 'reform'])
    @include('admin.objects.components.regist-band', ['title' => 'リフォーム情報一覧'])
    <div class="news_regist">
        @if($errors->any())
        <div class="error">
        <ul>
            @foreach($errors->all() as $message)
            <li>{{ $message }}</li>
            @endforeach
        </ul>
        </div>
        @endif
        @if (session('message'))
            <div class="flash_message">
                {{ session('message') }}
            </div>
        @endif
        <form method="POST" action="{{ route('reform-regist') }}" enctype="multipart/form-data">
        {{ csrf_field() }}  
            <div>
                <table>
                    <tr>
                        <th class="w200">リフォーム番号</th>
                        <td></td>
                    </tr>
                    <tr>
                        <th>登録日</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'regist_date', 'class' => 'w250 cal_picker', 'value' => $today])
                        </td>
                    </tr>
                    <tr>
                        <th>カテゴリ</th>
                        <td>
                        @include('admin.objects.components.radio', ['name' => 'category', 'radio' => $category, 'default' => 1])
                        </td>
                    </tr>
                    <tr>
                        <th>タイトル</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'title', 'class' => 'ta500', 'count' => 50, 'placeholder' => '５０文字以内で入力してください'])
                        </td>
                    </tr>
                    <tr>
                        <th>エリア</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'area', 'class' => 'w500'])
                        </td>
                    </tr>
                    <tr>
                        <th>築年</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'from_year', 'options' => Config::get('const.OLD_YEAR')])年
                            @include('admin.objects.components.selectbox', ['name' => 'from_month', 'options' => Config::get('const.MONTH')])月
                        </td>
                    </tr>
                    <tr>
                        <th>リフォーム費用</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'cost', 'class' => 'w250'])万円
                        </td>
                    </tr>
                    <tr>
                        <th>施工箇所</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'target', 'class' => 'ta500', 'count' => 50, 'placeholder' => '５０文字以内で入力してください'])
                        </td>
                    </tr>
                    <tr>
                        <th>プランの特徴</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'plan', 'class' => 'ta500', 'count' => 500, 'placeholder' => '５００文字以内で入力してください'])
                        </td>
                    </tr>
                    <tr>
                        <th>施工のポイント</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'point', 'class' => 'ta500', 'count' => 500, 'placeholder' => '５００文字以内で入力してください'])
                        </td>
                    </tr>
                </table>
            </div>
            <div class="search_vendor__btn">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
            <table class="p-regist__table mt10">
                <tbody>
                @include('admin.objects.projects.image-upload-large-reform', ['id' => 'iamgeAreaMulti', 'cid' => 'iamgeAreaMultiChild'])
                <tr>
                    <td colspan="8">
                        <table id="sortable_reform_image">
                            <tbody id="image_list">
                        @include('admin.objects.components.add-reform-template')
                            </tbody>
                        </table>
                    </td>
                </tr>
                </tbody>
            </table>
            <div class="regist__div">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>

            <table class="p-regist__table mt10">
                <tbody>
                    <tr>
                        <th rowspan="2" class="w200i">間取り</th>
                        <td>
                            <div class="d-flex">
                                <div>
                                    @include('admin.objects.components.add-reform-before', ['id' => 'imageArea2'])
                                </div>
                                <div class="ml10">
                                    <span>BEFORE図面</span>
                                </div>
                            </div>
                        </td>
                        <td class="w200i">
                        @include('admin.objects.components.btn', ['name' => 'del_before_img', 'class' => '', 'title' => '削除', 'type' => 'button'])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="d-flex">
                                <div>
                                    @include('admin.objects.components.add-reform-after', ['id' => 'imageArea3'])
                                </div>
                                <div class="ml10">
                                    <span>AFTER図面</span>
                                </div>
                            </div>
                        </td>
                        <td class="w200i">
                        @include('admin.objects.components.btn', ['name' => 'del_after_img', 'class' => '', 'title' => '削除', 'type' => 'button'])
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="regist__div">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>

        </form>
        
       
    </div>
</div>
@endsection