@extends('admin.layouts.base')

@section('contents')
<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ー店舗情報', 'type' => 'store'])
    @include('admin.objects.components.regist-band', ['title' => '店舗情報一覧'])
    <div class="news_regist">
        @if($errors->any())
        <div class="error">
        <ul>
            @foreach($errors->all() as $message)
            <li>{{ $message }}</li>
            @endforeach
        </ul>
        </div>
        @endif
        @if (session('message'))
            <div class="flash_message">
                {{ session('message') }}
            </div>
        @endif
        <form method="POST" action="{{ route('store-regist') }}" enctype="multipart/form-data">
        {{ csrf_field() }}  
            <div>
                <table>
                    <tr>
                        <th class="w200">店舗番号</th>
                        <td></td>
                    </tr>
                    <tr>
                        <th>店舗名</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w250', 'placeholder' => '店舗名を入力'])
                        </td>
                    </tr>
                    <tr>
                        <th>店舗名（英字）</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'name_kana', 'class' => 'w250', 'placeholder' => 'eiji'])
                        </td>
                    </tr>
                    <tr>
                        <th>住所</th>
                        <td>
                        @include('admin.objects.projects.form-address')
                        </td>
                    </tr>
                    <tr>
                        <th>フリーダイヤル</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'freedial', 'class' => 'w250', 'placeholder' => '000-00-000'])
                        </td>
                    </tr>
                    <tr>
                        <th>電話番号</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'tel', 'class' => 'w250', 'placeholder' => '000-00-000'])
                        </td>
                    </tr>
                    <tr>
                        <th>FAX番号</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'fax', 'class' => 'w250', 'placeholder' => '000-00-000'])
                        </td>
                    </tr>
                    <tr>
                        <th>メール</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'email', 'class' => 'w250', 'placeholder' => '000@000'])
                        </td>
                    </tr>
                    <tr>
                        <th>営業時間</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'business_hours', 'class' => 'w250', 'placeholder' => '00:00〜00:00'])
                        </td>
                    </tr>
                    <tr>
                        <th>定休日</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'holiday', 'class' => 'w250', 'placeholder' => '曜日'])
                        </td>
                    </tr>
                    <tr>
                        <th>駐車場台数</th>
                        <td>
                        @include('admin.objects.components.input', ['name' => 'parking', 'class' => 'w500'])
                        </td>
                    </tr>
                    <tr>
                        <th>メッセージ</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'comment', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください'])
                        </td>
                    </tr>
                </table>
            </div>
            <div class="search_vendor__btn">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
            <table class="p-regist__table mt10">
                <tbody>
                @include('admin.objects.projects.image-upload-large-store', ['id' => 'iamgeAreaMulti', 'cid' => 'iamgeAreaMultiChild'])
                <tr>
                    <td colspan="8">
                        <table id="sortable_store_image">
                            <tbody id="image_list">
                        @include('admin.objects.components.add-store-template')
                            </tbody>
                        </table>
                    </td>
                </tr>
                </tbody>
            </table>
            <div class="regist__div">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </form>
        
       
    </div>
</div>
@endsection