@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.hp-tab', ['title' => 'HP管理ー店舗情報', 'type' => 'store'])
    @include('admin.objects.components.regist-band', ['title' => '店舗情報一覧'])

    <div class="store_list">
        <div class="d-flex justify-content-end">
            <a href="{{ route('store-regist') }}" class="btn_imagesave w120 store_new_btn">新規登録</a>
        </div>
        <table>
            <tr>
                <th class="w150">写真画像</th>
                <th class="w150">店舗ID</th>
                <th class="w200">店舗名</th>
                <th class="w300">住所</th>
                <th class="w125">公開</th>
                <th class=""></th>
            </tr>
            @foreach($store as $item)
            <tr>
                <td>
                    @if(!empty($item->file_path))
                    <img src="{{$item->file_path}}" width="150" />
                    @else
                    <img src="{{root('img/noimage2.jpg')}}" width="150" />
                    @endif
                    
                </td>
                <td>{{$item->code}}</td>
                <td>{{$item->name}}</td>
                <td>
                    {{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}
                </td>
                <td class="text-center">@include('admin.objects.components.switch-disp', ['name' => 'store_disp', 'checked' => $item->disp])</td>
                <td @if(!$del || true) class="text-center" @endif>
                    @include('admin.objects.components.hidden', ['name' => 'store_id', 'value' => $item->id])
                    @include('admin.objects.components.link-btn-nostyle', ['url' => route('store-edit', ['id' => $item->code]), 'title' => '編集', 'class' => 'edit_store_btn'])
                    @if($del && false)
                    @include('admin.objects.components.link-btn-nostyle', ['url' => 'javascript:void(0);', 'title' => '削除', 'class' => 'del_store_btn', 'name' => 'store_delete'])
                    @endif
                </td>
            </tr>
            @endforeach
        </table>
    </div>
</div>
@endsection
