@extends('admin.layouts.base')

@section("styles")
    <link rel="stylesheet" href="{{ asset("admin/css/mansion/index.css") }}">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="{{ asset("admin/js/mansion/index.js") }}"></script>
@endsection

{{-- header --}}
@section('contents-header')
    @include('admin.objects.projects.search-results-header', ['title' => 'マンション（建物）'])
@endsection

@php

// TODO:並び替えデータ
$sorts = $sorts ?? [];

$sort1 = new stdClass();
$sort1->name = '新着順';
$sort1->class = 'new';
array_push($sorts, $sort1);

$sort2 = new stdClass();
$sort2->name = '価格が安い順';
$sort2->class = 'inexpensive';
array_push($sorts, $sort2);
@endphp

@section('contents')
{{-- 画像有/リスト切り替え、除外ボタンリスト --}}

{{-- 現在の検索条件 --}}
@include('admin.objects.projects.results-current-condition', [])

{{-- 並び替え --}}
@include('admin.objects.projects.results-sort', ['sorts' => $sorts])

@include('business.objects.projects.form-to-other', ['action' => route('business-for-sale-detail', ['id' => '']), 'id' => 'link_detail', 'params' => $params])

{{-- 検索結果一覧 ※tab-img-or-list.bladeと連動 --}}
<div class="tab-content mt-3">
  <div class="tab-pane u-bg-default active_con" id="nav-list" role="tabpanel" aria-labelledby="nav-list-tab">
    @include('admin.objects.projects.results-noimage-mansion')
  </div>
</div>

@endsection
