@extends('admin.layouts.base')

@section('contents')

<div class="mt5 p-rains">
    <div class="d-flex justify-content-between">
        <div class="d-flex">
            <p><span class="p-rains__count">該当件数{{$article->total()}}</span>件中 {{$first}}〜{{$last}}件表示</p>
        </div>
        <div class="p-rains__pager">{{ $article->appends($pager_params)->links() }}</div>
    </div>
    @include('admin.objects.components.regist-band-provisional', ['title' => '仮登録物件'])

    <div>
        <div class="p-rains__duplicate">
            <p class="p-rains__duplicate__schedule">登録予定物件</p>
@foreach($article as $row)
@php
            $url = '';
            if($row['property'] == null) {
                if($row['mansion_info']->provisional == 1) {
                    $url = '/admin/editMansion/'.$row['mansion_info']->building_id;
                } else {
                    $url = '/admin/editRoom/'.$row['mansion_info']->building_id.'/'.$row['building_id'];
                }
            } elseif($row['property'] < 4) {
                $url = '/admin/editLand/'.$row['building_id'];
            } elseif($row['property'] < 6) {
                $url = '/admin/editHouse/'.$row['building_id'];
            } elseif($row['property'] < 8) {
                $url = '/admin/editMansion/'.$row['building_id'];
            } elseif($row['property'] == 99) {
                $url = '/admin/editLot/'.$row['building_id'];
            }
@endphp
            <div class="mb10">
                <table border="1" class="w-100">
                    <tr>
                        <td rowspan="2" class="w100 bg-white">
                            物件番号<br>
                            {{$row['rains_no']}}
                            物件登録日
                            {{$row['created_at']->format('Y/m/d')}}
                            @include('admin.objects.components.hidden', ['name' => 'duplicate_id', 'value' => $row['id']])
                        </td>
                        <th>物件名</th>
                        <td colspan="3" class="w250 bg-white">{{$row['article_name']}}</td>
                        <th>所在地</th>
                        <td colspan="3" class="w250 bg-white">{{$row['pref_name']}}{{$row['city_name']}}{{$row['town_name']}}{{$row['address']}}</td>
@if($row['property'] != null)
                        <th>価格</th>
                        <td class="w80 bg-white">{{$row['price']}}万円</td>
                        <th>土地</th>
                        <td class="w80 bg-white">{{$row['land_area_val']?? '-'}}m&sup2;</td>
                        <th>校区</th>
                        <td class="w80 bg-white">{{$row['school']?? '-'}}</td>
@else
                        <th>部屋</th>
                        <td class="w80 bg-white">{{$row['room_num']?? '-'}}</td>
                        <th>価格</th>
                        <td class="w80 bg-white">{{$row['price']}}万円</td>
                        <th>土地</th>
                        <td class="w80 bg-white">{{$row['land_area_val']?? '-'}}m&sup2;</td>
@endif
                    </tr>
                    <tr>
                        <th>種別</th>
                        <td class="w120 bg-white">
                        @if($row['property'] == 1)
						    土地	
                        @elseif($row['property'] == 2)
                            土地（借地権）
                        @elseif($row['property'] == 3)
                            土地（底地権）
                        @elseif($row['property'] == 4)
                            @if($row['property_sub'] == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            戸建
                        @elseif($row['property'] == 5)
                            @if($row['property_sub'] == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            テラスハウス
                        @elseif($row['property'] == 6)
                            @if($row['property_sub'] == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            マンション
                        @elseif($row['property'] == 7)
                            @if($row['property_sub'] == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            タウンハウス
                        @endif	
                        
                        
                        
                        </td>
                        <th>間取り</th>
                        <td class="w80 bg-white">{{$row['floor_plan']?? '-'}}{{$row['floor_type_text']?? '-'}}</td>
                        <th>交通</th>
                        <td colspan="3" class="bg-white">{{$row['main_traffic_line']?? '-'}}&nbsp;「{{$row['main_traffic_station']?? '-'}}」駅&nbsp;徒歩{{$row['main_traffic_time']?? '-'}}分</td>
                        <th>築年月</th>
                        <td class="bg-white">{{$row['age']?? '-'}}</td>

@if($row['property'] != null)
                        <th>延床</th>
                        <td class="bg-white">{{$row['total_area_val']?? '-'}}m&sup2;</td>
                        <th>階数</th>
                        <td class="bg-white">{{$row['floor']?? '-'}}</td>
@else
                        <th>階数</th>
                        <td class="bg-white">{{$row['floor']?? '-'}}</td>
                        <th>延床</th>
                        <td class="bg-white">{{$row['total_area_val']?? '-'}}m&sup2;</td>
                        
@endif
                    </tr>
                    <tr class="p-rains__duplicate__vendor">
                        <th>業者名</th>
                        <td colspan="3">{{$row['vendor_name']}}</td>
                        <th>担当</th>
                        <td class="w100"><span id="vendor_charge">{{$row['vendor_charge']}}</span></td>
                        <th>電話</th>
                        <td>{{$row['vendor_tel1']}}</td>
                        <th>備考1</th>
                        <td colspan="2">{{$row['memo1']?? ''}}</td>
                        <td colspan="5" rowspan="2" class="p-rains__duplicate__btnarea">
                            <div class="d-flex">
                                <div>
                                @include('admin.objects.components.hidden', ['name' => 'del_id', 'value' => $row['building_id']])
                                @include('admin.objects.components.selectbox', ['name' => 'target', 'class' => ' mt10 mr10', 'options' => [['code' => 1, 'name' => '仮登録'],['code' => 2, 'name' => '削除']], 'default' => 0])
                                </div>
                                <div>
                                @include('admin.objects.components.link-btn', ['url' => $url, 'class' => 'c-registbtn d-block mt-1 provisional_btn', 'title' => '反映して次へ'])
                                </div>
                            </div>
                            
                            
                        </td>
                    </tr>
                    <tr class="p-rains__duplicate__vendor">
                        <th>業者ID</th>
                        <td colspan="3"><span id="vendor_id">{{$row['vendor_id']?? '-'}}</span></td>
                        <th>態様</th>
                        <td>{{$row['manner']?? '-'}}</td>
                        <th>FAX</th>
                        <td>{{$row['vendor_fax']?? '-'}}</td>
                        <th>備考2</th>
                        <td colspan="2">{{$row['memo2']?? ''}}</td>
                    </tr>
                </table>
            </div>
@endforeach
        </div>
    </div>
</div>
@endsection


