@extends('admin.layouts.base')

@section('contents')

<div class="mt5 p-rains">
    <div class="d-flex justify-content-between">
        <div class="d-flex">
            <p class="p-rains__count">@if(!is_null($data)) {{$data->currentPage()}} @else 0 @endif/@if(!is_null($data)) {{$data->total()}} @else 0 @endif</p>
            <div class="p-rains__pager">@if(!is_null($data)) {{$data->appends($params)->links("admin.objects.projects.pager-rains")}}@endif</div>
        </div>
        <div>
        @if(isset($hold))
            @include('admin.objects.components.link-btn', ['title' => '戻る', 'url' => '/admin/duplicateCsv'.$uri, 'class' => 'btn_search d-block', 'id' => 'btnSearch'])
        @else
            @include('admin.objects.components.link-btn', ['title' => '「要確認」物件('.$hold_count.')', 'url' => '/admin/holdDuplicateCsv'.$uri, 'class' => 'btn_search d-block', 'id' => 'btnSearch'])
        @endif
        
        </div>
    </div>
    @if(isset($hold))
    @include('admin.objects.components.regist-band-duplicate', ['title' => '要確認物件'])
    @else
    @include('admin.objects.components.regist-band-duplicate', ['title' => '物件重複チェック'])
    @endif
    
    <div>
    @if(empty($duplicate_article))
    @if(isset($hold))
        <form method="POST" action="{{ route('holdDuplicateCsv') }}{{$uri??''}}" id="rains_form">
    @else
        <form method="POST" action="{{ route('duplicateCsv') }}{{$uri??''}}" id="rains_form">
    @endif
        <div class="p-rains__zero">
            <p>対象店舗の未処理物件はございません。</p>
        </div>
        </form>
    @else
    @if(isset($hold))
        <form method="POST" action="{{ route('holdDuplicateCsv') }}{{$uri??''}}" id="rains_form">
    @else
        <form method="POST" action="{{ route('duplicateCsv') }}{{$uri??''}}" id="rains_form">
    @endif
        {{ csrf_field() }}
        @include('admin.objects.components.hidden', ['name' => 'm_target'])
            <div class="p-rains__duplicate">
                <p class="p-rains__duplicate__schedule">登録予定物件</p>
                <div class="mb10">
                    <table border="1">
                        <tr>
                            <td rowspan="2" class="w100">
                                物件番号<br>
                                {{$duplicate_article['rains_no']}}
                                物件登録日

                                @include('admin.objects.components.hidden', ['name' => 'duplicate_id', 'value' => $duplicate_article['id']])
                            </td>
                            <th>物件名</th>
                            <td colspan="3" class="w250">{{$duplicate_article['name']}}</td>
                            <th>所在地</th>
                            <td colspan="3" class="w250">{{$duplicate_article['address']}}</td>

@if($duplicate_article['property_num'] < 6)
                            <th>価格</th>
                            <td class="w80">{{$duplicate_article['price']}}万円</td>
                            <th>土地</th>
                            <td class="w80">{{$duplicate_article['land_area_val']?? '-'}}m&sup2;</td>
                            <th>校区</th>
                            <td class="w80">{{$duplicate_article['school']?? '-'}}</td>
@else
                            <th>部屋</th>
                            <td class="w80">{{$duplicate_article['room_num']?? '-'}}</td>
                            <th>価格</th>
                            <td class="w80">{{$duplicate_article['price']}}万円</td>
                            <th>土地</th>
                            <td class="w80">{{$duplicate_article['land_area_val']?? '-'}}m&sup2;</td>
@endif

                        </tr>
                        <tr>
                            <th>種別</th>
                            <td class="w120">{{$duplicate_article['property']?? '-'}}</td>
                            <th>間取り</th>
                            <td class="w80">{{$duplicate_article['floor_plan']?? '-'}}</td>
                            <th>交通</th>
                            <td colspan="3">{{$duplicate_article['traffic']?? '-'}}</td>
                            <th>築年月</th>
                            <td>{{$duplicate_article['age']?? '-'}}</td>
@if($duplicate_article['property_num'] < 6)
                            <th>延床</th>
                            <td>{{$duplicate_article['area']?? '-'}}m&sup2;</td>
                            <th>階数</th>
                            <td>{{$duplicate_article['floor']?? '-'}}</td>
@else
                            <th>階数</th>
                            <td>{{$duplicate_article['floor']?? '-'}}</td>
                            <th>延床</th>
                            <td>{{$duplicate_article['area']?? '-'}}m&sup2;</td>
@endif

                        </tr>
                        <tr class="p-rains__duplicate__vendor">
                            <td rowspan="2"></td>
                            <th>業者名</th>
                            <td colspan="3">{{$duplicate_vendor['name']}}</td>
                            <th>担当</th>
                            <td class="w100"><span id="vendor_charge">{{$duplicate_vendor['vendor_charge']}}</span></td>
                            <th>電話</th>
                            <td>{{$duplicate_vendor['vendor_tel1']}}</td>
                            <th>備考1</th>
                            <td colspan="1">{{$duplicate_article['memo1']?? ''}}</td>
                            <td colspan="4" rowspan="2" class="p-rains__duplicate__btnarea">
                                @include('admin.objects.components.selectbox', ['name' => 'target', 'options' => $target, 'default' => 0])
                                @include('admin.objects.components.btn', ['class' => 'save_change', 'title' => '反映して次へ'])
                            </td>
                        </tr>
                        <tr class="p-rains__duplicate__vendor">
                            <th>業者ID</th>
                            <td colspan="3"><span id="vendor_id">{{$duplicate_vendor['id']?? '-'}}</span></td>
                            <th>態様</th>
                            <td>{{$duplicate_vendor['manner']?? '-'}}</td>
                            <th>FAX</th>
                            <td>{{$duplicate_vendor['vendor_fax']?? '-'}}</td>
                            <th>備考2</th>
                            <td colspan="1">{{$duplicate_article['memo2']?? ''}}</td>
                        </tr>
                    </table>
                </div>

                @include('admin.objects.components.duplication-tab', ['active' => $active])
                <p class="p-rains__duplicate__schedule mt-0">マッチング物件</p>
                @foreach($saved_article as $items)
                <div class="mb10 @if($loop->iteration != 1) p-rains__none @endif" name="duplicate_data{{$loop->iteration}}">
    @php
        $num = $loop->iteration;
    @endphp
                    @foreach($items as $saved)
                    <table >
                        <tr>
                            <td rowspan="2" class="w100">
                                物件番号<br>
                                {{$saved['item']['building_id']}}
                                @include('admin.objects.components.hidden', ['name' => 'article_id_'.$saved['item']['building_id'].'_'.$num, 'value' => $saved['item']['building_id']])
                            </td>
                            <th>物件名</th>
                            <td colspan="3" class="w250">{{$saved['item']['name']}}</td>
                            <th>所在地</th>
                            <td colspan="3" class="w250">{{$saved['item']['address']}}</td>
@if($num < 5)
                            <th>価格</th>
                            <td class="w80">{{$saved['item']['price']}}万円</td>
                            <th>土地</th>
                            <td class="w80">{{$saved['item']['land_area_val']?? '-'}}m&sup2;</td>
                            <th>校区</th>
                            <td class="w80">{{$saved['item']['school']}}</td>
@else
                            <th>部屋</th>
                            <td class="w80">{{$saved['item']['room_num']}}</td>
                            <th>価格</th>
                            <td class="w80">ー万円</td>
                            <th>土地</th>
                            <td class="w80">{{$saved['item']['land_area_val']?? '-'}}m&sup2;</td>
@endif
                        </tr>
                        <tr>
                            <th>種別</th>
                            <td class="w120">{{$saved['item']['property']?? '-'}}@if($num == 5)(建物)@endif</td>
                            <th>間取り</th>
                            <td class="w80">{{$saved['item']['floor_plan']?? '-'}}</td>
                            <th>交通</th>
                            <td colspan="3">{{$saved['item']['traffic']?? '-'}}</td>
                            <th>築年月</th>
                            <td>{{$saved['item']['age']?? '-'}}</td>
@if($num < 5)
                            <th>延床</th>
                            <td>{{$saved['item']['area']?? '-'}}m&sup2;</td>
                            <th>階数</th>
                            <td>{{$saved['item']['floor']?? '-'}}</td>
@else
                            <th>階数</th>
                            <td>{{$saved['item']['floor']?? '-'}}</td>
                            <th>延床</th>
                            <td>{{$saved['item']['area']?? '-'}}m&sup2;</td>
@endif
                        </tr>
@if($num < 5)
<tr>
                            <td rowspan="3">
                                @include('admin.objects.components.modal-btn', ['title' => '業者追加('.$saved['vendor_list']->count().')', 'class'=> '', 'data' => 9, 'list_num' => $saved['item']['building_id'].'_'.$num, 'btn_name' => 'modal_vendor_search'])
                                @include('admin.objects.components.checkbox', ['name' => 'change_target[]', 'checkbox' => [['code' => $saved['item']['building_id'].'_'.$num, 'name' => '重複対象']]])
                            </td>
                            <td colspan="8" rowspan="3" class="p-0 align-top">
                                <div class="vendor_area" id="vendor_list_area{{$saved['item']['building_id']}}_{{$num}}">
                                    @foreach($saved['vendor_list'] as $vendor)
                                    <table>
                                        <tr>
                                            <th>業者名</th>
                                            <td>{{$vendor->name}}@include('admin.objects.components.hidden', ['name' => 'vendor_id_'.$saved['item']['building_id'].'_'.$num.'[]', 'value' => $vendor->vendor_id])</td>
                                            <th>担当</th>
                                            <td class="w100">
                                                @include('admin.objects.components.input', ['name' => 'charge_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'value' => $vendor->charge])
                                            </td>
                                            <th>電話</th>
                                            <td>{{$vendor->vendor_tel1?? '-'}}</td>
                                        </tr>
                                        <tr class="p-rains__duplicate__vendor">
                                            <th>業者ID</th>
                                            <td><span id="vendor_id">{{$vendor->vendor_id}}</span></td>
                                            <th>態様</th>
                                            <td>@include('admin.objects.components.selectbox', ['name' => 'manner_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $manner, 'selected' => $vendor->manner])</td>
                                            <th>FAX</th>
                                            <td>{{$vendor->vendor_fax?? '-'}}</td>
                                        </tr>
                                        <tr>
                                            <td colspan="6">
                                                <div class="d-flex">
                                                    <div>
                                                        物件確認日<br>
                                                        @include('admin.objects.components.input', ['name' => 'ad_conf_day_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'class' => 'cal_picker', 'placeholder' => '0000/00/00'])
                                                    </div>
                                                    <div>
                                                        チラシ<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'flyer_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->flyer])
                                                    </div>
                                                    <div>
                                                        情報誌<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'freepaper_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->freepaper])
                                                    </div>
                                                    <div>
                                                        自社HP<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'house_hp_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->house_hp])
                                                    </div>
                                                    <div>
                                                        ポータル<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'portal_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->portal])
                                                    </div>
                                                    <div>
                                                        現地看板<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'signboard_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->signboard])
                                                    </div>
                                                    <div>
                                                        確認手法<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'ad_conf_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $method_conf])
                                                    </div>
                                                    <div>
                                                        広告確認び<br>
                                                        @include('admin.objects.components.input', ['name' => 'article_conf_day_'.$saved['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'class' => 'cal_picker', 'placeholder' => '0000/00/00'])
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                    @endforeach
                                </div>
                            </td>
                            <td colspan="6">
                                @include('admin.objects.components.checkbox', ['name' => 'change_flag_'.$saved['item']['building_id'].'_'.$num, 'checkbox' => [['code' => 1, 'name' => '価格変更']]])
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                            @include('admin.objects.components.selectbox', ['name' => 'status_'.$saved['item']['building_id'].'_'.$num, 'options' => $statuses, 'selected' => $saved['item']['status'], 'title' => 'ステータス'])
                            
                            @include('admin.objects.components.input', ['name' => 'price_closing_'.$saved['item']['building_id'].'_'.$num, 'value' => $saved['item']['price_closing'], 'placeholder' => '成約価格'])万円
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                <span>BK</span>
                                <span>鍵</span>
                                <span>備考1</span>
                                <span>備考2</span>

                            </td>
                        </tr>
@else
                        <tr>
                            <td >
                                @include('admin.objects.components.checkbox', ['name' => 'change_target[]', 'checkbox' => [['code' => $saved['item']['building_id'].'_'.$num, 'name' => '登録対象']]])
                                @include('admin.objects.components.hidden', ['name' => 'save_targe'.$saved['item']['building_id'].'_'.$num, 'value' => $saved['item']['property_num']])
                            </td>
                            <td colspan="8" class="">
       
                            </td>
                            <td colspan="6">
                                <span>BK</span>
                                <span>鍵</span>
                                <span>備考1</span>
                                <span>備考2</span>
                            </td>
                        </tr>
@endif
                    </table>
                    @if(false)
                    @foreach($saved['item']['room_list'] as $room)
                    <table>
                        <tr>
                            <td rowspan="2" class="w100">
                                物件番号<br>
                                {{$room['item']['building_id']}}
                                @include('admin.objects.components.hidden', ['name' => 'article_id_'.$room['item']['building_id'].'_'.$num, 'value' => $room['item']['building_id']])
                            </td>
                            <th>物件名</th>
                            <td colspan="3" class="w250">{{$saved['item']['name']}}</td>
                            <th>所在地</th>
                            <td colspan="3" class="w250">{{$room['item']['address']}}</td>
@if($num < 5)
                            <th>価格</th>
                            <td class="w80">{{$room['item']['price']}}万円</td>
                            <th>土地</th>
                            <td class="w80">{{$room['item']['land_area_val']?? '-'}}m&sup2;</td>
                            <th>校区</th>
                            <td class="w80">{{$room['item']['school']}}</td>
@else
                            <th>部屋</th>
                            <td class="w80">{{$room['item']['room_num']}}</td>
                            <th>価格</th>
                            <td class="w80">{{$room['item']['price']}}万円</td>
                            <th>土地</th>
                            <td class="w80">{{$room['item']['land_area_val']?? '-'}}m&sup2;</td>
@endif
                        </tr>
                        <tr>
                            <th>種別</th>
                            <td class="w120">{{$room['item']['property']?? '-'}}</td>
                            <th>間取り</th>
                            <td class="w80">{{$room['item']['floor_plan']?? '-'}}</td>
                            <th>交通</th>
                            <td colspan="3">{{$room['item']['traffic']?? '-'}}</td>
                            <th>築年月</th>
                            <td>{{$room['item']['age']?? '-'}}</td>
@if($num < 5)
                            <th>延床</th>
                            <td>{{$room['item']['area']?? '-'}}m&sup2;</td>
                            <th>階数</th>
                            <td>{{$room['item']['floor']?? '-'}}</td>
@else
                            <th>階数</th>
                            <td>{{$room['item']['floor']?? '-'}}</td>
                            <th>延床</th>
                            <td>{{$room['item']['area']?? '-'}}m&sup2;</td>
@endif
                        </tr>
                        <tr>
                            <td rowspan="3">
                                @include('admin.objects.components.modal-btn', ['title' => '業者追加('.$room['vendor_list']->count().')', 'class'=> '', 'data' => 9, 'list_num' => $room['item']['building_id'].'_'.$num, 'btn_name' => 'modal_vendor_search'])
                                @include('admin.objects.components.checkbox', ['name' => 'change_target[]', 'checkbox' => [['code' => $room['item']['building_id'].'_'.$num, 'name' => '重複対象']]])
                            </td>
                            <td colspan="8" rowspan="3" class="p-0 align-top">
                                <div class="vendor_area" id="vendor_list_area{{$room['item']['building_id']}}_{{$num}}">
                                    @foreach($room['vendor_list'] as $vendor)
                                    <table>
                                        <tr>
                                            <th>業者名</th>
                                            <td>{{$vendor->name}}@include('admin.objects.components.hidden', ['name' => 'vendor_id_'.$room['item']['building_id'].'_'.$num.'[]', 'value' => $vendor->vendor_id])</td>
                                            <th>担当</th>
                                            <td class="w100">
                                                @include('admin.objects.components.input', ['name' => 'charge_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'value' => $vendor->charge])
                                            </td>
                                            <th>電話</th>
                                            <td>{{$vendor->vendor_tel1?? '-'}}</td>
                                        </tr>
                                        <tr class="p-rains__duplicate__vendor">
                                            <th>業者ID</th>
                                            <td><span id="vendor_id">{{$vendor->vendor_id}}</span></td>
                                            <th>態様</th>
                                            <td>@include('admin.objects.components.selectbox', ['name' => 'manner_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $manner, 'selected' => $vendor->manner])</td>
                                            <th>FAX</th>
                                            <td>{{$vendor->vendor_fax?? '-'}}</td>
                                        </tr>
                                        <tr>
                                            <td colspan="6">
                                                <div class="d-flex">
                                                    <div>
                                                        物件確認日<br>
                                                        @include('admin.objects.components.input', ['name' => 'ad_conf_day_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'class' => 'cal_picker', 'placeholder' => '0000/00/00'])
                                                    </div>
                                                    <div>
                                                        チラシ<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'flyer_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->flyer])
                                                    </div>
                                                    <div>
                                                        情報誌<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'freepaper_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->freepaper])
                                                    </div>
                                                    <div>
                                                        自社HP<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'house_hp_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->house_hp])
                                                    </div>
                                                    <div>
                                                        ポータル<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'portal_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->portal])
                                                    </div>
                                                    <div>
                                                        現地看板<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'signboard_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $ad_conf, 'selected' => $vendor->signboard])
                                                    </div>
                                                    <div>
                                                        確認手法<br>
                                                        @include('admin.objects.components.selectbox', ['name' => 'ad_conf_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'options' => $method_conf])
                                                    </div>
                                                    <div>
                                                        広告確認び<br>
                                                        @include('admin.objects.components.input', ['name' => 'article_conf_day_'.$room['item']['building_id'].'_'.$num.'_'.$vendor->vendor_id, 'class' => 'cal_picker', 'placeholder' => '0000/00/00'])
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                    @endforeach
                                </div>
                            </td>
                            <td colspan="6">
                                @include('admin.objects.components.checkbox', ['name' => 'change_flag_'.$room['item']['building_id'].'_'.$num, 'checkbox' => [['code' => 1, 'name' => '価格変更']]])
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                            @include('admin.objects.components.selectbox', ['name' => 'status_'.$room['item']['building_id'].'_'.$num, 'options' => $statuses, 'selected' => $room['item']['status'], 'title' => 'ステータス'])
                            
                            @include('admin.objects.components.input', ['name' => 'price_closing_'.$room['item']['building_id'].'_'.$num, 'value' => $room['item']['price_closing'], 'placeholder' => '成約価格'])万円
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                <span>BK</span>
                                <span>鍵</span>
                                <span>備考1</span>
                                <span>備考2</span>

                            </td>
                        </tr>
                    </table>
                    @endforeach
                    @endif
                    @endforeach
                </div>
                @endforeach
            </div>
        </form>
    </div>
    <table id="vendor_tmplate" class="d-none">
        <tr>
            <th>業者名</th>
            <td><span name="vendor_name"></span>@include('admin.objects.components.hidden', ['name' => 'vendor_id_'])</td>
            <th>担当</th>
            <td class="w100">
                @include('admin.objects.components.input', ['name' => 'charge_'])
            </td>
            <th>電話</th>
            <td>{{$vendor->vendor_tel1?? '-'}}</td>
        </tr>
        <tr class="p-rains__duplicate__vendor">
            <th>業者ID</th>
            <td><span id="vendor_id"></span></td>
            <th>態様</th>
            <td>@include('admin.objects.components.selectbox', ['name' => 'manner_', 'options' => $manner])</td>
            <th>FAX</th>
            <td><span name="vendor_fax"></span></td>
        </tr>
        <tr>
            <td colspan="6">
                <div class="d-flex">
                    <div>
                        物件確認日<br>
                        @include('admin.objects.components.input', ['name' => 'ad_conf_day_', 'class' => 'cal_picker', 'placeholder' => '0000/00/00'])
                    </div>
                    <div>
                        チラシ<br>
                        @include('admin.objects.components.selectbox', ['name' => 'flyer_', 'options' => $ad_conf])
                    </div>
                    <div>
                        情報誌<br>
                        @include('admin.objects.components.selectbox', ['name' => 'freepaper_', 'options' => $ad_conf])
                    </div>
                    <div>
                        自社HP<br>
                        @include('admin.objects.components.selectbox', ['name' => 'house_hp_', 'options' => $ad_conf])
                    </div>
                    <div>
                        ポータル<br>
                        @include('admin.objects.components.selectbox', ['name' => 'portal_', 'options' => $ad_conf])
                    </div>
                    <div>
                        現地看板<br>
                        @include('admin.objects.components.selectbox', ['name' => 'signboard_', 'options' => $ad_conf])
                    </div>
                    <div>
                        確認手法<br>
                        @include('admin.objects.components.selectbox', ['name' => 'ad_conf_', 'options' => $method_conf])
                    </div>
                    <div>
                        広告確認び<br>
                        @include('admin.objects.components.input', ['name' => 'article_conf_day_', 'class' => 'cal_picker', 'placeholder' => '0000/00/00'])
                    </div>
                </div>
            </td>
        </tr>
    </table>
    @endif
</div>
@include('admin.objects.projects.modal-vendor-duplicate', ['no' => 9])
@endsection


