@extends('admin.layouts.base')
@section('contents')

@php
// Place area
$place_area = [
    ['code' => "", 'name' => '未選択'],
    ['code' => "安朱", 'name' => '安朱'],
    ['code' => "音羽", 'name' => '音羽'],
    ['code' => "勧修寺", 'name' => '勧修寺'],
    ['code' => "御陵", 'name' => '御陵'],
    ['code' => "四ノ宮", 'name' => '四ノ宮'],
    ['code' => "小山", 'name' => '小山'],
    ['code' => "上花山", 'name' => '上花山'],
    ['code' => "厨子奥", 'name' => '厨子奥'],
    ['code' => "西野", 'name' => '西野'],
    ['code' => "西野山", 'name' => '西野山'],
    ['code' => "川田", 'name' => '川田'],
    ['code' => "大宅", 'name' => '大宅'],
    ['code' => "大塚", 'name' => '大塚'],
    ['code' => "醍醐", 'name' => '醍醐'],
    ['code' => "竹鼻", 'name' => '竹鼻'],
    ['code' => "東野", 'name' => '東野'],
    ['code' => "藤尾", 'name' => '藤尾'],
    ['code' => "日ノ岡", 'name' => '日ノ岡'],
    ['code' => "北花山", 'name' => '北花山'],
    ['code' => "椥辻", 'name' => '椥辻'],
    ['code' => "小野", 'name' => '小野'],
];
//// 1 基本情報
//// 2 価格

$running_cost_unit = [
    ['code' => 1, 'name' => '月'],
    ['code' => 2, 'name' => '年'],
];

// その他諸経費
$cost_unit = [
    ['code' => 1, 'name' => '月'],
    ['code' => 2, 'name' => '年'],
    ['code' => 3, 'name' => '一括'],
    ['code' => 0, 'name' => '未選択'], 
];

//// 3 物件概要
// 土地権利




// 土地面積
$land_area = [
    ['code' => 1, 'name' => '登記'],
    ['code' => 2, 'name' => '実測'],
    ['code' => 0, 'name' => '未選択'], 
];

// 土地条件
$land_condition_unit = [['code' => 2, 'name' => 'm&sup2;'], ['code' => 3, 'name' => '％'], ['code' => 0, 'name' => '未選択'],];
$land_condition1 = [['code' => 1, 'name' => 'うち傾斜部分'],];
$land_condition2 = [['code' => 2, 'name' => 'うち路地状部分'],];
$land_condition3 = [['code' => 3, 'name' => 'うち高圧線下'],];

// 建築面積
$total_area = [
    ['code' => 1, 'name' => '登記'],
    ['code' => 2, 'name' => '実測'],
    ['code' => 0, 'name' => '未選択'], 
];

// 建築条件
$building_condition_unit = [['code' => 1, 'name' => 'm&sup2;'], ['code' => 1, 'name' => '％'], ['code' => 0, 'name' => '未選択'],];
$building_condition1 = [['code' => 1, 'name' => 'うち地下室'],];
$building_condition2 = [['code' => 2, 'name' => 'うち１F車庫'],];
$building_condition3 = [['code' => 3, 'name' => 'うち地下車庫'],];
$building_condition4 = [['code' => 4, 'name' => 'うち居住用途以外'],];
$building_use = [
    ['code' => 1, 'name' => '店舗'],
    ['code' => 2, 'name' => '事務所'],
    ['code' => 3, 'name' => '倉庫'], 
    ['code' => 4, 'name' => '工場'],
    ['code' => 5, 'name' => '診療所'],
    ['code' => 6, 'name' => '賃貸'], 
    ['code' => 9, 'name' => 'その他'],
];

// 引き渡し
$move_in = [
    ['code' => 1, 'name' => '即引き渡し可', 'add_text' => '検索', 'add_class' => ''],
    ['code' => 2, 'name' => '相談'],
    ['code' => 3, 'name' => '指定有'], 
    ['code' => 4, 'name' => '契約後'],
    ['code' => 0, 'name' => '未選択'],
];

// 条件外し
$land_condition_not = [
    ['code' => 1, 'name' => '可'], 
    ['code' => 2, 'name' => '不可'], 
];

// 再建築不可
$land_not = [
    ['code' => 1, 'name' => '再建築不可'], 
];

// 引渡し
$land_delivery = [
    ['code' => 1, 'name' => '即'],
    ['code' => 2, 'name' => '相談'],
    ['code' => 3, 'name' => '指定有'],
];

// 建築条件
$land_condition = [
    ['code' => 0, 'name' => '条件なし'],
    ['code' => 1, 'name' => '建築条件付き'],
];

// 地目
$ground = [
    ['code' => 1, 'name' => '宅地'],
    ['code' => 2, 'name' => '田'],
    ['code' => 3, 'name' => '畑'],
    ['code' => 4, 'name' => '山林'],
    ['code' => 5, 'name' => '雑種地'],
    ['code' => 6, 'name' => '原野'],
    ['code' => 7, 'name' => 'その他'],
    ['code' => 0, 'name' => '未選択'],
    
];

// 地役権
$easement = [
    ['code' => 1, 'name' => '無'],
    ['code' => 2, 'name' => '地役権'],
    ['code' => 3, 'name' => '通行地役権'],
    ['code' => 4, 'name' => '引水地役権'],
    ['code' => 5, 'name' => '眺望地役権'],
    ['code' => 6, 'name' => '通路賃借権'],
    ['code' => 0, 'name' => '未選択'],
];

// 上水道
$water_supply = [
    ['code' => 1, 'name' => '公営水道'],
    ['code' => 2, 'name' => '私設水道'],
    ['code' => 3, 'name' => '井戸'],
    ['code' => 0, 'name' => '未選択'],
];

// 下水道
$sewerage = [
    ['code' => 1, 'name' => '本下水'],
    ['code' => 2, 'name' => '集中浄化槽'],
    ['code' => 3, 'name' => '個別浄化槽'],
    ['code' => 0, 'name' => '未選択'],
];

// ガス・オール電化
$gas = [
    ['code' => 1, 'name' => '都市ガス'],
    ['code' => 2, 'name' => '集中ＬＰＧ'],
    ['code' => 3, 'name' => '個別ＬＰＧ'],
    ['code' => 4, 'name' => 'オール電化'],
    ['code' => 0, 'name' => '未選択'],

];

// 車庫
$garage = [
    ['code' => 1, 'name' => '掘込車庫'],
    ['code' => 0, 'name' => '未選択'],
];

// セットパック
$set = [
    ['code' => 1, 'name' => '不要'],
    ['code' => 2, 'name' => '要'],
    ['code' => 3, 'name' => '済'],
    ['code' => 0, 'name' => '未選択'],
];

//リフォーム
$reform = [
    ['code' => 1, 'name' => '無'],
    ['code' => 2, 'name' => '済'],
    ['code' => 3, 'name' => '完了予定'],
];

//// 4 投資・事業用
// 区分
$classification = [
    ['code' => 1, 'name' => '居住用'],
    ['code' => 2, 'name' => '事業用'],
    ['code' => 3, 'name' => '投資用'],
];

// 売買区分
$buy_class = [
    ['code' => 1, 'name' => '一室売'],
    ['code' => 2, 'name' => '一括売'],
];

// 事業用用途
$use_method = [
    ['code' => 4, 'name' => '店舗'],
    ['code' => 5, 'name' => '事務所'],
    ['code' => 8, 'name' => '倉庫'],
    ['code' => 7, 'name' => '工場'],
    ['code' => 9, 'name' => 'その他'],
];

// 事業用引き渡し状態
$use_status = [
    ['code' => 1, 'name' => '造作譲渡あり'],
    ['code' => 2, 'name' => '造作譲渡なし'],
    ['code' => 3, 'name' => '設備無償譲渡'],
    ['code' => 4, 'name' => 'スケルトン渡し'],
];

// 投資用現状
$investment = [
    ['code' => 1, 'name' => '貸借人なし'],
    ['code' => 2, 'name' => '貸借人あり（オーナーチェンジ）'],
];

$investment_unit = [
    ['code' => 1, 'name' => '月'],
    ['code' => 2, 'name' => '年'],
];

//// 5 取引情報
// 広告掲載確認
$ad_conf = [
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];

$ad_instructions = [
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '入稿'],
];

//// 6 画像
// 画像種類
$image_kind = [
    ['code' => 1, 'name' => '区画図'],
    ['code' => 2, 'name' => '間取り'],
    ['code' => 3, 'name' => '参考プラン'],
    ['code' => 0, 'name' => '未選択'],
];

//// 7 イベント
// イベントカテゴリ
$event_category = [
    ['code' => 1, 'name' => '現地見学会'],
    ['code' => 2, 'name' => '現地案内会'],
    ['code' => 3, 'name' => '現地販売会'],
    ['code' => 4, 'name' => 'オープンハウス'],
    ['code' => 5, 'name' => 'オープンルーム'],
    ['code' => 0, 'name' => '未選択'],
];
// イベント日程
$event_schedule = [
    ['code' => 1, 'name' => '毎週土日祝'],
    ['code' => 2, 'name' => '毎週土日'],
    ['code' => 3, 'name' => '日時指定'],
    ['code' => 4, 'name' => '期間限定'],
    ['code' => 5, 'name' => '公開中'],
    ['code' => 0, 'name' => '未選択'],
];
// イベント予約
$reservation = [
    ['code' => 1, 'name' => '完全予約制'],
];

$vendor_building_photo = [
    ['code' => 1, 'name' => '優先使用'],
    ['code' => 2, 'name' => '不使用'],
];
@endphp
<div class="error">
    <ul>
@if($errors->any())
     @foreach($errors->all() as $message)
        <li>{{ $message }}</li>
     @endforeach
@endif
    </ul>
</div>

<form method="POST" action="{{ route('registHouse') }}" enctype="multipart/form-data">
{{ csrf_field() }}
    @include('admin.objects.components.base-tab')
    @include('admin.objects.components.regist-tab', ['title' => '物件登録-戸建', 'active' => 'base'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '１.基本情報'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">分譲地番号</th>
                        <td>
                            <div class="d-flex">
                            @include('admin.objects.components.hidden', ['name' => 'company_id', 'value' => $company_id])
                            <span class="lh55" name="disp_sale_no">未設定</span>
                                @include('admin.objects.components.hidden', ['name' => 'sale_no'])
                                @include('admin.objects.components.modal-btn', ['title' => '分譲地検索', 'class'=> 'btn_search', 'data' => 1])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">分譲地名</th>
                        <td>
                            <span>未設定</span>
                            @include('admin.objects.components.hidden', ['name' => 'name_bunjyou'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件番号</th>
                        <td>
                            <span>未設定</span>
                            @include('admin.objects.components.hidden', ['name' => 'num_bukken'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2" rowspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>物件種別</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'property', 'radio' => $property, 'default' => 4])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'property_sub', 'radio' => $property_sub, 'default' => 1])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>物件名</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w-50', 'count' => 30, 'placeholder' => '物件名を３０文字以内で入力'])
                            @include('admin.objects.components.input', ['name' => 'name_gouchi'])号地
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件名（ポータル用）</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'name_portal', 'class' => 'w-50', 'count' => 30, 'placeholder' => '物件名を３０文字以内で入力'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">未入居</th>
                        <td class="">
                            @include('admin.objects.components.checkbox', ['name' => 'occupied', 'checkbox' => $occupied])
                            <div>
                            ※「未入居」とは、建築後１年以上経過したものであって、かつ居住の用に供されたことがない物件のことを指します。<br>
                              居住の用に供されたことのあるリフォーム済・リノベーション済物件は「中古」
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">収益物件</th>
                        <td>
                            @include('admin.objects.components.checkbox', ['name' => 'revenue', 'checkbox' => $revenue])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">ステータス</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'status', 'options' => $statuses])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>物件取扱店舗名</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'shop', 'options' => $shops])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>所在地</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.form-address')
                        </td>
                    </tr>
                    @include('admin.objects.projects.latlng')
                    <tr>
                        <th rowspan="4">交通</th>
                        <th>交通</th>
                        <td>
                            @include('admin.objects.components.modal-btn', ['title' => '路線をまとめて検索', 'class'=> 'btn_search', 'data' => 3])
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="d-flex justify-content-between">
                                 <div>主要交通</div>
                                 <span class="require">必須</span>
                            </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.search-station', ['data' => 4, 'name' => 'main_traffic'])
                        </td>
                    </tr>
                    <tr>
                        <th>補助交通１</th>
                        <td>
                            @include('admin.objects.projects.search-station', ['data' => 5, 'name' => 'sub_traffic1'])
                        </td>
                    </tr>
                    <tr>
                        <th>補助交通２</th>
                        <td>
                            @include('admin.objects.projects.search-station', ['data' => 6, 'name' => 'sub_traffic2'])
                        </td>
                    </tr>
                    @include('admin.objects.projects.set-school')
                    <tr>
                        <th colspan="2">備考1(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo1', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">備考2(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo2', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください'])
                        </td>
                    </tr>
		    <tr>
                        <th colspan="2">所在地エリア</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'place_area', 'class' => 'w150', 'options' => $place_area])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">レインズ番号</th>
                        <td>
                        </td>
                    </tr>
                    @include('admin.objects.projects.original')
                    <tr>
                        <th colspan="2">
                             <div class="d-flex justify-content-between">
                                  <div class="search_target_title">物件登録日</div>
                                  <span class="search_target">検索</span>
                              </div>
                         </th>

                        <td></td>
                    </tr>
                    <tr>
                        <th colspan="2">取引態様</th>
                        <td>
                        @include('admin.objects.components.selectbox', ['name' => 'company_manner', 'options' => $manner, 'title' => '取引態様'])
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'price'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '２.価格'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>物件価格</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'price', 'class' => 'w100'])万円&nbsp;
                            @include('admin.objects.components.selectbox', ['name' => 'tax', 'options' => $tax])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">物件価格変更履歴</th>
                        <td>
                            <span>未設定</span>
                            @include('admin.objects.components.hidden', ['name' => 'name_bunjyou'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>有線放送に係る費用</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio-cost', ['name' => 'broadcasting', 'default' => 2])
                            <div class="initial_cost">
                                初期費用@include('admin.objects.projects.umu-money-radio', ['name' => 'broadcasting_presence', 'default' => 0])
                                <div class="initial_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'broadcasting_cost'])円
                                </div>
                            </div>

                            <div class="running_cost">
                                定額費用@include('admin.objects.projects.umu-money-radio', ['name' => 'broadcasting_fixed_presence', 'default' => 0])
                                <div class="running_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'broadcasting_fixed_cost'])円&#047;
                                    @include('admin.objects.components.radio', ['name' => 'broadcasting_fixed_cost_unit', 'radio' => $running_cost_unit, 'default' => 1])
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>インターネットに係る費用</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio-cost', ['name' => 'internet', 'default' => 2])
                            <div class="initial_cost">
                                初期費用@include('admin.objects.projects.umu-money-radio', ['name' => 'internet_presence', 'default' => 0])
                                <div class="initial_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'internet_cost'])円
                                </div>
                            </div>
                            <div class="running_cost">
                                定額費用@include('admin.objects.projects.umu-money-radio', ['name' => 'internet_fixed_presence', 'default' => 0])
                                <div class="running_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'internet_fixed_cost'])円&#047;
                                    @include('admin.objects.components.radio', ['name' => 'internet_fixed_cost_unit', 'radio' => $running_cost_unit, 'default' => 1])
                               </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>CATVに係る費用</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-radio-cost', ['name' => 'catv', 'default' => 2])
                            <div class="initial_cost">
                                初期費用@include('admin.objects.projects.umu-money-radio', ['name' => 'catv_presence', 'default' => 0])
                                <div class="initial_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'catv_cost'])円
                                </div>
                            </div>
                            <div class="running_cost">
                                定額費用@include('admin.objects.projects.umu-money-radio', ['name' => 'catv_fixed_presence', 'default' => 0])
                                <div class="running_cost_detail">
                                    @include('admin.objects.components.input', ['name' => 'catv_fixed_cost'])円&#047;
                                    @include('admin.objects.components.radio', ['name' => 'catv_fixed_cost_unit', 'radio' => $running_cost_unit, 'default' => 1])
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>町会費など</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'council', 'radio' => $council_cost])
                            </div>
                            <div id="council_presence_area">
                                @include('admin.objects.projects.umu-money-radio', ['name' => 'council_presence', 'default' => 0])
                            </div>
                            <div id="council_cost_area">
                                @include('admin.objects.components.input', ['name' => 'council_cost'])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'council_cost_unit', 'radio' => $cost_unit])
                            </div>
                        
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>温泉</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'spring', 'radio' => $spring_cost])
                            </div>
                            <div id="spring_area">
                                @include('admin.objects.projects.umu-money-radio', ['name' => 'spring_presence', 'default' => 0])
                            </div>
                            <div id="spring_cost_area">
                                @include('admin.objects.components.input', ['name' => 'spring_cost'])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'spring_cost_unit', 'radio' => $cost_unit])
                            </div>
                            <div id="spring_kind_area">
                                <p class="mb-0">天然温泉ではない場合は選択</p>
                                @include('admin.objects.components.checkbox', ['name' => 'spring_kind', 'checkbox' => $spring_kind])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>その他諸経費１</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                名称
                                @include('admin.objects.components.input', ['name' => 'another_cost_name1'])
                            </div>
                            <div>
                                金額
                                @include('admin.objects.components.input', ['name' => 'another_cost1'])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'another_cost_unit1', 'radio' => $cost_unit, 'default' => 0])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>その他諸経費２</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                名称
                                @include('admin.objects.components.input', ['name' => 'another_cost_name2'])
                            </div>
                            <div>
                                金額
                                @include('admin.objects.components.input', ['name' => 'another_cost2'])円&#047;
                                @include('admin.objects.components.radio', ['name' => 'another_cost_unit2', 'radio' => $cost_unit, 'default' => 0])
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div>
    @include('admin.objects.components.regist-tab', ['active' => 'overview'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '３.物件概要'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                @include('admin.objects.projects.land-right')
                </tbody>
            </table>
            <span>土地情報</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>土地面積</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'land_area', 'radio' => $land_area, 'default' => 0])
                            @include('admin.objects.components.input', ['name' => 'land_area_val', 'placeholder' => '000.00'])&nbsp;m&sup2;<span>※私道面積は含めない</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>土地条件</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            <span>以下の項目があれば記入してください。</span>
                            <div>
                                @include('admin.objects.components.checkbox', ['name' => 'land_condition1', 'checkbox' => $land_condition1])
                                <span>※傾斜地部分が３割以上の場合は面積のm&sup2;か％表記が必須</span>
                                <div id="land_condition1_area">
                                    @include('admin.objects.components.input', ['name' => 'land_condition_area1'])
                                    @include('admin.objects.components.radio', ['name' => 'land_condition_unit1', 'radio' => $land_condition_unit])
                                </div>
                            </div>
                            <div>
                                @include('admin.objects.components.checkbox', ['name' => 'land_condition2', 'checkbox' => $land_condition2])
                                <span>※路地状部分が３割以上の場合は面積のm&sup2;か％表記が必須</span>
                                <div id="land_condition2_area">
                                    @include('admin.objects.components.input', ['name' => 'land_condition_area2'])
                                    @include('admin.objects.components.radio', ['name' => 'land_condition_unit2', 'radio' => $land_condition_unit])
                                </div>
                            </div>
                            <div>
                                @include('admin.objects.components.checkbox', ['name' => 'land_condition3', 'checkbox' => $land_condition3])
                                <span>※高圧線下があればm&sup2;表記が必須</span>
                                <div id="land_condition3_area">
                                    @include('admin.objects.components.input', ['name' => 'land_condition_area3'])m&sup2;
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">再建築不可</th>
                        <td>
                            @include('admin.objects.components.checkbox', ['name' => 'land_not', 'checkbox' => $land_not])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>建ぺい率</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'building_rate', 'class' => 'w100'])％
                            <span class="ml10">※「都市計画区域外」以外は必須</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>容積率</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'volume_rate', 'class' => 'w100'])％
                            <span class="ml10">※「都市計画区域外」以外は必須</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>私道負担</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.umu-share-radio-road', ['name' => 'road_burden', 'default' => 3])
                            <div id="road_burden_area1" class="mb10">
                                私道面積&nbsp;@include('admin.objects.components.input', ['name' => 'road_burden_area', 'class' => 'w100', 'placeholder' => '000.00'])m&sup2;
                            </div>
                            <div id="road_burden_area2">
                                私道持分比率&nbsp;持分@include('admin.objects.components.input', ['name' => 'road_numerator', 'class' => 'w50', 'placeholder' => '0.0'])/全体@include('admin.objects.components.input', ['name' => 'road_denominator', 'class' => 'w50', 'placeholder' => '0.0'])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>地役権</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'easement', 'radio' => $easement, 'default' => 1])
                            <div id="easement_area">
                                @include('admin.objects.components.input', ['name' => 'easement_area'])m&sup2;
                            </div>
                        </td>
                    </tr>
                    @include('admin.objects.projects.set-load')
                    <tr>
                        <th colspan="2">上水道</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'water_supply', 'radio' => $water_supply, 'default' => 0])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">下水道</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'sewerage', 'radio' => $sewerage, 'default' => 0])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">ガス・オール電化</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'gas', 'radio' => $gas, 'default' => 0])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>セットパック</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'set', 'radio' => $set, 'default' => 0])
                            <div id="set_area">
                                面積&nbsp;@include('admin.objects.components.input', ['name' => 'set_area'])m&sup2;
                                <span>※面積10％以上の場合は表記必須です。</span>
                            </div>
                        </td>
                    </tr>
                    @include('admin.objects.projects.set-use-area')
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>都市計画</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'city_plan', 'options' => $city_plan])
                            <div id="city_plan_area">
                                建築許可理由
                                @include('admin.objects.components.selectbox', ['name' => 'city_plan_reason', 'options' => $city_plan_reason])
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>

            <span>建物情報</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>建物面積</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'total_area', 'radio' => $total_area, 'default' => 0])
                            @include('admin.objects.components.input', ['name' => 'total_area_val', 'placeholder' => '000.00'])&nbsp;m&sup2;<span>※私道面積は含めない</span>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>建物条件</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            <span>以下の項目があれば記入してください。</span>
                            <div class="d-flex">
                                @include('admin.objects.components.checkbox', ['name' => 'building_condition1', 'checkbox' => $building_condition1])
                                <div id="building_condition1_area">
                                    @include('admin.objects.components.input', ['name' => 'building_condition_area1'])m&sup2;
                                </div>
                            </div>
                            <div class="d-flex">
                                @include('admin.objects.components.checkbox', ['name' => 'building_condition2', 'checkbox' => $building_condition2])
                                <div id="building_condition2_area">
                                    @include('admin.objects.components.input', ['name' => 'building_condition_area2'])m&sup2;
                                </div>
                            </div>
                            <div class="d-flex">
                                @include('admin.objects.components.checkbox', ['name' => 'building_condition3', 'checkbox' => $building_condition3])
                                <div id="building_condition3_area">
                                    @include('admin.objects.components.input', ['name' => 'building_condition_area3'])m&sup2;
                                </div>
                            </div>
                            <div class="d-flex">
                                @include('admin.objects.components.checkbox', ['name' => 'building_condition4', 'checkbox' => $building_condition4])
                                <div id="building_condition3_area">
                                    @include('admin.objects.components.selectbox', ['name' => 'building_condition_select', 'options' => $building_use])
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>間取り</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                        @include('admin.objects.components.selectbox', ['name' => 'floor_plan', 'options' => $floor_plan])
                        @include('admin.objects.components.selectbox', ['name' => 'floor_plan_type', 'options' => $floor_type])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">総戸数</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'total_unit', 'class' => 'w100'])戸
                        </td>
                    </tr>
                                        <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>築年月</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'age_year', 'options' => Config::get('const.OLD_YEAR'), 'class' => 'mr10', 'title' => '築年月（年）'])年
                            @include('admin.objects.components.selectbox', ['name' => 'age_month', 'options' => Config::get('const.MONTH'), 'class' => 'mr10', 'title' => '築年月（月）'])月
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>完成時期</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                            @include('admin.objects.components.selectbox', ['name' => 'completed_year', 'options' => $comp_year])年
                            @include('admin.objects.components.selectbox', ['name' => 'completed_month', 'options' => Config::get('const.MONTH')])月
                            <span>
                            または契約後
                            @include('admin.objects.components.selectbox', ['name' => 'completed_contract_month', 'options' => Config::get('const.KAGETSU')])ヶ月
                            </span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>引き渡し</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'move_in', 'radio' => $move_in, 'default' => 0])
                            <div id="move_in_year" class="mb10">
                                @include('admin.objects.components.selectbox', ['name' => 'move_in_year', 'options' => Config::get('const.YEAR'), 'title' => '引き渡し（年）'])年
                                @include('admin.objects.components.selectbox', ['name' => 'move_in_month', 'options' => Config::get('const.MONTH'), 'title' => '引き渡し（月）'])月
                            </div>
                            <div id="move_in_month">
                                @include('admin.objects.components.selectbox', ['name' => 'move_in_contract_month', 'options' => Config::get('const.MONTH')])ヶ月
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">現況</th>
                        <td>
                        @include('admin.objects.components.selectbox', ['name' => 'current_status', 'options' => $genkyou, 'default' => 1, 'title' => '現況'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>構造</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                主要@include('admin.objects.components.selectbox', ['name' => 'construction', 'options' => $construction, 'class' => 'ml10', 'default' => 0])
                            </div>
                            <div>
                                一部@include('admin.objects.components.selectbox', ['name' => 'construction_sub', 'options' => $construction_sub, 'class' => 'ml10', 'default' => 0])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>階数</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                        <div class="d-flex">
                                <div>
                                    地上@include('admin.objects.components.selectbox', ['name' => 'floor', 'options' => Config::get('const.FLOOR'), 'class' => 'ml10 mr10'])階&nbsp;&nbsp;
                                </div>
                                <div>
                                    地下@include('admin.objects.components.selectbox', ['name' => 'underground', 'options' => Config::get('const.FLOOR'), 'class' => 'ml10 mr10'])階
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">駐車場</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'parking', 'radio' => $parking, 'class' => 'ml10', 'default' => 0])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">駐車可能台数</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'parking_num', 'options' => Config::get('const.PARKING_NUM'), 'title' => '駐車可能台数'])&nbsp;台
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                 <div>建築確認番号</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'architecture_no', 'class' => 'w300'])
                            <span>※未完成の場合、必須</span>
                        </td>
                    </tr>
                    <tr>
                        <th rowspan="2">リフォーム<span class="search_target">検索</span></th>
                        <th>外装</th>
                        <td>
                            <div>
                            @include('admin.objects.components.radio', ['name' => 'exterior', 'radio' => $reform, 'default' => 1])
                            </div>
                            <div id="exterior_detail">
                                外装年月
                                @include('admin.objects.components.selectbox', ['name' => 'exterior_year', 'options' => Config::get('const.REFORM_YEAR')])年
                                @include('admin.objects.components.selectbox', ['name' => 'exterior_month', 'options' => Config::get('const.MONTH')])月
                                <br>
                                外装箇所
                                @include('admin.objects.components.checkbox', ['name' => 'exterior_place', 'checkbox' => $exterior])
                                @include('admin.objects.components.input', ['name' => 'exterior_text', 'class' => 'w100'])
                            </div>
                        </td>

                    </tr>
                    <tr>
                        <th>内装</th>
                        <td>
                            <div>
                            @include('admin.objects.components.radio', ['name' => 'interior', 'radio' => $reform, 'default' => 1])
                            </div>
                            <div id="interior_detail">
                                内装年月
                                @include('admin.objects.components.selectbox', ['name' => 'interior_year', 'options' => Config::get('const.REFORM_YEAR')])年
                                @include('admin.objects.components.selectbox', ['name' => 'interior_month', 'options' => Config::get('const.MONTH')])月
                                <br>
                                内装箇所
                                @include('admin.objects.components.checkbox', ['name' => 'interior_place', 'checkbox' => $interior])
                                @include('admin.objects.components.input', ['name' => 'interior_text', 'class' => 'w100'])
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>制限事項</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>法律上の制限</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.checkbox-law', ['name' => 'law_restriction', 'checkbox' => $law, 'class' => 'checkbox_small'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2" rowspan="3">
                           <div class="d-flex justify-content-between">
                                 <div>その他制限事項</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.checkbox', ['name' => 'other_restriction', 'checkbox' => $other, 'class' => 'checkbox_small'])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'other_reason', 'options' => $other_reason])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'other_comment', 'class' => 'ta50 w-75', 'placeholder' => 'その他制限事項がある場合は１５０文字以内で入力してください', 'count' => 150])
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'investment'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '４.投資・事業用'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>区分</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'classfication', 'radio' => $classification, 'default' => 1])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">売買区分</th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'trading_classfication', 'radio' => $buy_class, 'default' => 1])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">事業用用途</th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'use_method', 'radio' => $use_method, 'default' => 1])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">事業用引渡し状態</th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'use_method', 'radio' => $use_status, 'default' => 1])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">投資用現況</th>
                        <td>
                            <div>
                                @include('admin.objects.components.radio', ['name' => 'use_method', 'radio' => $investment, 'default' => 1])
                            </div>
                            <div>
                                <div>投資用収入実績@include('admin.objects.components.input', ['name' => 'vendor_name'])円　／   @include('admin.objects.components.radio', ['name' => 'use_method', 'radio' => $investment_unit, 'default' => 1])</div>
                                <div>投資用年利回り@include('admin.objects.components.input', ['name' => 'vendor_name'])％</div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'advertisement'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '５.取引情報・広告'])
        @include('admin.objects.projects.regist-vendor')
    </div>
    @include('admin.objects.components.regist-tab', ['active' => 'event'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '６.イベント'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                @include('admin.objects.projects.event')
                </tbody>
            </table>
            <div class="regist__div d-flex justify-content-center">
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__image saved_to_image', 'title' => '画像登録・編集画面へ', 'type' => 'submit'])
                </div>
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__save', 'title' => '登録・保存して閉じる'])
                </div>
            </div>
        </div>
    </div>
</form>



{{-- 分譲地検索モーダルウィンドウ --}}
@include('admin.objects.projects.modal-lot', ['no' => 1])
@include('admin.objects.projects.modal-map', ['no' => 2])
@include('admin.objects.projects.modal-traffic-multi', ['no' => 3])
@include('admin.objects.projects.modal-traffic-single', ['no' => 4])
@include('admin.objects.projects.modal-traffic-single', ['no' => 5])
@include('admin.objects.projects.modal-traffic-single', ['no' => 6])
@include('admin.objects.projects.modal-vendor', ['no' => 9])
@include('admin.objects.projects.address-script')
@endsection

