@extends('admin.layouts.base')
@section('contents')

@php
// Place area
$place_area = [
    ['code' => "", 'name' => '未選択'],
    ['code' => "安朱", 'name' => '安朱'],
    ['code' => "音羽", 'name' => '音羽'],
    ['code' => "勧修寺", 'name' => '勧修寺'],
    ['code' => "御陵", 'name' => '御陵'],
    ['code' => "四ノ宮", 'name' => '四ノ宮'],
    ['code' => "小山", 'name' => '小山'],
    ['code' => "上花山", 'name' => '上花山'],
    ['code' => "厨子奥", 'name' => '厨子奥'],
    ['code' => "西野", 'name' => '西野'],
    ['code' => "西野山", 'name' => '西野山'],
    ['code' => "川田", 'name' => '川田'],
    ['code' => "大宅", 'name' => '大宅'],
    ['code' => "大塚", 'name' => '大塚'],
    ['code' => "醍醐", 'name' => '醍醐'],
    ['code' => "竹鼻", 'name' => '竹鼻'],
    ['code' => "東野", 'name' => '東野'],
    ['code' => "藤尾", 'name' => '藤尾'],
    ['code' => "日ノ岡", 'name' => '日ノ岡'],
    ['code' => "北花山", 'name' => '北花山'],
    ['code' => "椥辻", 'name' => '椥辻'],
    ['code' => "小野", 'name' => '小野'],
];
//// 3 物件概要
$floor = [
    ['code' => 1, 'name' => 1],
    ['code' => 2, 'name' => 2],
    ['code' => 3, 'name' => 3],
    ['code' => 4, 'name' => 4],
    ['code' => 5, 'name' => 5],
    ['code' => 6, 'name' => 6],
    ['code' => 7, 'name' => 7],
    ['code' => 8, 'name' => 8],
    ['code' => 9, 'name' => 9],
    ['code' => 10, 'name' => 10],
    ['code' => 11, 'name' => 11],
    ['code' => 12, 'name' => 12],
    ['code' => 13, 'name' => 13],
    ['code' => 14, 'name' => 14],
    ['code' => 15, 'name' => 15],
];

// ガス・オール電化
$gas = [
    ['code' => 1, 'name' => '都市ガス'],
    ['code' => 2, 'name' => '集中ＬＰＧ'],
    ['code' => 3, 'name' => '個別ＬＰＧ'],
    ['code' => 4, 'name' => 'オール電化'],
    ['code' => 0, 'name' => '未選択'],

];
@endphp
@if($errors->any())
 <div class="error">
   <ul>
     @foreach($errors->all() as $message)
       <li>{{ $message }}</li>
     @endforeach
   </ul>
 </div>
@endif
<form method="POST" action="{{ route('regist-mansion') }}" enctype="multipart/form-data">
{{ csrf_field() }}
    @include('admin.objects.components.base-tab')
    @include('admin.objects.components.regist-tab-mansion', ['title' => '物件登録-マンション', 'active' => 'base'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '１.基本情報'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">マンション建物番号</th>
                        <td>
                            <span>未設定</span>
                            @include('admin.objects.components.hidden', ['name' => 'company_id', 'value' => $company_id])
                            @include('admin.objects.components.hidden', ['name' => 'num_bukken'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>マンション名</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w-50'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2" rowspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>物件種別</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'property', 'radio' => $property, 'default' => 6])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'property_sub', 'radio' => $property_sub, 'default' => 2])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>所在地</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.form-address')
                        </td>
                    </tr>
                    @include('admin.objects.projects.latlng')
                    <tr>
                        <th rowspan="4">交通</th>
                        <th>交通</th>
                        <td>
                            @include('admin.objects.components.modal-btn', ['title' => '路線をまとめて検索', 'class'=> 'btn_search', 'data' => 3])
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <div class="d-flex justify-content-between">
                                 <div>主要交通</div>
                                 <span class="require">必須</span>
                            </div>
                        </th>
                        <td>
                            @include('admin.objects.projects.search-station', ['data' => 4, 'name' => 'main_traffic'])
                        </td>
                    </tr>
                    <tr>
                        <th>補助交通１</th>
                        <td>
                            @include('admin.objects.projects.search-station', ['data' => 5, 'name' => 'sub_traffic1'])
                        </td>
                    </tr>
                    <tr>
                        <th>補助交通２</th>
                        <td>
                            @include('admin.objects.projects.search-station', ['data' => 6, 'name' => 'sub_traffic2'])
                        </td>
                    </tr>
                    @include('admin.objects.projects.set-school')
                    <tr>
                        <th colspan="2">備考1(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo1', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">備考2(非公開)</th>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'memo2', 'class' => 'ta500', 'count' => 500, 'placeholder' => '備考を５００文字以内で入力してください'])
                        </td>
                    </tr>
		    <tr>
                        <th colspan="2">所在地エリア</th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'place_area', 'class' => 'w150', 'options' => $place_area])
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    @include('admin.objects.components.regist-tab-mansion', ['active' => 'overview'])
    <div>
        @include('admin.objects.components.regist-band', ['title' => '２.共通概要'])
        <div class="p-regist">
            <table class="p-regist__table">
                <tbody>
                @include('admin.objects.projects.land-right')
                </tbody>
            </table>
            <span>土地情報</span>
            <table class="p-regist__table">
                <tbody>
                    @include('admin.objects.projects.set-use-area')
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>都市計画</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'city_plan', 'options' => $city_plan])
                            <div id="city_plan_area">
                                建築許可理由
                                @include('admin.objects.components.selectbox', ['name' => 'city_plan_reason', 'options' => $city_plan_reason])
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>マンション建物情報</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">総戸数</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'total_unit', 'class' => 'w100'])戸
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>築年月</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'age_year', 'options' => Config::get('const.OLD_YEAR'), 'class' => 'mr10', 'title' => '築年月（年）'])年
                            @include('admin.objects.components.selectbox', ['name' => 'age_month', 'options' => Config::get('const.MONTH'), 'class' => 'mr10', 'title' => '築年月（月）'])月
                        </td>
                    </tr>
                    
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>構造</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            <div>
                                主要@include('admin.objects.components.selectbox', ['name' => 'construction', 'options' => $construction, 'class' => 'ml10'])
                            </div>
                            <div>
                                一部@include('admin.objects.components.selectbox', ['name' => 'construction_sub', 'options' => $construction_sub, 'class' => 'ml10'])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>階数</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            地上@include('admin.objects.components.selectbox', ['name' => 'floor', 'options' => Config::get('const.FLOOR'), 'class' => 'mr10 ml10'])階
                            地下@include('admin.objects.components.selectbox', ['name' => 'underground', 'options' => Config::get('const.FLOOR'), 'class' => 'mr10 ml10'])階
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">敷地面積</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'land_area_val', 'class' => 'w100'])m&sup2;
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">ガス・オール電化</th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'gas', 'radio' => $gas, 'default' => 0])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">分譲会社</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'sales_company', 'class' => 'w200'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">施工会社</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'construction_company', 'class' => 'w200'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">管理会社</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'management_company', 'class' => 'w200'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <div class="d-flex justify-content-between">
                                 <div>管理形態</div>
                                 <span class="require">必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.radio', ['name' => 'management_form', 'radio' => $management_form, 'default' => 0])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">共用部</th>
                        <td>
                            @include('admin.objects.components.checkbox', ['name' => 'shared', 'checkbox' => $shared, 'class' => 'checkbox_small'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                             <div class="d-flex justify-content-between">
                                  <div class="search_target_title">ペット飼育</div>
                                  <span class="search_target">検索</span>
                              </div>
                         </th>

                        <td>
                            @include('admin.objects.components.radio', ['name' => 'pet', 'radio' => $pet, 'default' => 0])
                            @include('admin.objects.components.selectbox', ['name' => 'pet_count', 'options' => $pet_num, 'class' => 'mr10'])匹
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>制限事項</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">
                           <div class="d-flex justify-content-between">
                                 <div>法律上の制限</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.checkbox-law', ['name' => 'law_restriction', 'checkbox' => $law, 'class' => 'checkbox_small'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2" rowspan="3">
                           <div class="d-flex justify-content-between">
                                 <div>その他制限事項</div>
                                 <span class="require_applicable">該当必須</span>
                             </div>
                        </th>
                        <td>
                            @include('admin.objects.components.checkbox', ['name' => 'other_restriction', 'checkbox' => $other, 'class' => 'checkbox_small'])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.selectbox', ['name' => 'other_reason', 'options' => $other_reason])
                        </td>
                    </tr>
                    <tr>
                        <td>
                            @include('admin.objects.components.textarea', ['name' => 'other_comment', 'class' => 'ta50 w-75', 'placeholder' => 'その他制限事項がある場合は１５０文字以内で入力してください', 'count' => 150])
                        </td>
                    </tr>
                </tbody>
            </table>
            <span>コメント</span>
            <table class="p-regist__table">
                <tbody>
                    <tr>
                        <th colspan="2">コメント</th>
                        <td>
                        @include('admin.objects.components.textarea', ['name' => 'comment', 'class' => 'ta50 w-75', 'placeholder' => ''])
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="regist__div d-flex justify-content-center">
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__image saved_to_image', 'title' => '画像登録・編集画面へ', 'type' => 'submit'])
                </div>
                <div class="">
                    @include('admin.objects.components.btn', ['class' => 'c-base-tab__save', 'title' => '登録・保存して閉じる'])
                </div>
            </div>
        </div>
    </div>
</form>



{{-- 分譲地検索モーダルウィンドウ --}}
@include('admin.objects.projects.modal-lot', ['no' => 1])
@include('admin.objects.projects.modal-map', ['no' => 2])
@include('admin.objects.projects.modal-traffic-multi', ['no' => 3])
@include('admin.objects.projects.modal-traffic-single', ['no' => 4])
@include('admin.objects.projects.modal-traffic-single', ['no' => 5])
@include('admin.objects.projects.modal-traffic-single', ['no' => 6])
@include('admin.objects.projects.modal-vendor', ['no' => 9])
@include('admin.objects.projects.address-script')
@endsection
