@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.regist-tab-mansion', ['title' => '物件登録ー分譲地'])
    @include('admin.objects.components.regist-band', ['title' => '分譲地検索'])
    <div class="search_vendor">
        <form method="POST" action="{{ route('search-lot') }}">
        {{ csrf_field() }}
        <div>
            @include('admin.objects.components.hidden', ['name' => 'property', 'value' => 99])
        <dl class="d-flex search_vendor__con justify-content-center">
            <dt>分譲地名</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'name', 'class' => 'w125', 'value' => $search['name']?? ''])</dd>
            <dt>分譲地番号</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'id', 'class' => 'w175', 'value' => $search['id']?? ''])</dd>
        </dl>
        <dl class="d-flex search_vendor__con justify-content-center">
            <dt>所在地</dt>
            <dd>
            @include('admin.objects.components.selectbox', ['name' => 'address1', 'class' => 'mb-2', 'options' => $pref, 'title' => '都道府県', 'selected' => Config::get('const.DEFAULT_PREF')])
            @include('admin.objects.components.selectbox', ['name' => 'address2', 'class' => 'mb-2', 'options' => $city, 'title' => '市区郡', 'selected' => $search['address2']?? ''])
            @include('admin.objects.components.selectbox', ['name' => 'address3', 'class' => 'mb-2', 'options' => $town, 'title' => '町村', 'selected' => $search['address3']?? ''])
            </dd>
        </dl>
        </div>
 
        <div class="search_vendor__btn">
        @include('admin.objects.components.btn', ['title' => '検索', 'class'=> 'btn_search w120'])
        <a href="{{ route('regist-lot') }}" class="btn_imagesave w120" >新規登録</a>
        </div>
        </form>    
    </div>

</div>
@if(isset($list))
        <div class="lot_list mt10">
            <table class="lot_info">
                <tr>
                    <th class="w150">分譲地番号</th>
                    <th class="w350">分譲地名/総区画数/所在地</th>
                    <th  class=""></th>
                </tr>
                @foreach($list as $row)

                <tr >
                    <td rowspan="2"><a class="target_link_id" href="{{ route('showEditLot', ['id' => $row->building_id]) }}">{{$row->building_id}}</a></td>
                    <td>{{$row->name}}<br><br>{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}</td>
                    <td>
                        <div class="">
                            @include('admin.objects.components.hidden', ['name' => 'lot_id', 'value' => $row->building_id])
                            <div class="d-flex justify-content-between">
                                @include('admin.objects.components.link-btn', ['name' => '', 'url' => '/admin/editLot/'.$row['id'], 'class' => 'btn_imagesave w200i', 'title' => '分譲地データを編集'])
                                <a href="{{ route('showCopyLand') }}?copy={{$row->building_id}}" class="btn_imagesave w200i" >土地を新規登録</a>
                                <a href="{{ route('showCopyHouse') }}?copy={{$row->building_id}}" class="btn_imagesave w200i" >戸建を新規登録</a>
                            </div>
                            <div class="d-flex">
                                @include('admin.objects.components.link-btn', ['name' => 'open_table', 'url' => 'javascript:void(0);', 'class' => 'btn_addvendor w200i', 'title' => '物件を見る('.$row->count.')'])
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" class="article_td">
                        <table class="article_info">
                            <tr>
                                <th>物件番号</th>
                                <th>物件種別</th>
                                <th>号地</th>
                                <th>価格</th>
                                <th>ステータス</th>
                                <th>土地面積</th>
                                <th>建物面積</th>
                                <th>業者</th>
                                <th>更新日</th>
                                <th><a href="javascript:void(0);" name="close_table" class="close_article_list">閉じる</a></th>
                            </tr>
                            @foreach($row->relation_article as $info)
                            <tr>
                                <td>
                                <a class="target_link_id" href="
                                @if($info->property == null)
                                {{ route('editRoom', ['mid' => $info->mansion_id, 'id' => $info->building_id]) }}
                                @elseif($info->property == 1)
                                {{ route('editLand', ['id' => $info->building_id]) }}
                                @elseif($info->property == 2)
                                {{ route('editLand', ['id' => $info->building_id]) }}
                                @elseif($info->property == 3)
                                {{ route('editLand', ['id' => $info->building_id]) }}
                                @elseif($info->property == 4)
                                {{ route('showEditHouse', ['id' => $info->building_id]) }}
                                @elseif($info->property == 5)
                                {{ route('showEditHouse', ['id' => $info->building_id]) }}
                                @elseif($info->property == 6)
                                {{ route('editMansion', ['id' => $info->building_id]) }}
                                @elseif($info->property == 7)
                                {{ route('editMansion', ['id' => $info->building_id]) }}
                                @endif	
                                ">{{$info->building_id}}</a>
                                </td>
                                <td>
                                @if($info->property == 1)
						土地	
                    @elseif($info->property == 2)
                        土地（借地権）
                    @elseif($info->property == 3)
                        土地（底地権）
                    @elseif($info->property == 4)
                        戸建
                    @elseif($info->property == 5)
                        テラスハウス
                    @elseif($info->property == 6)
                        マンション
                    @elseif($info->property == 7)
						タウンハウス
					@endif	
                                </td>
                                <td>{{$info->name_gouchi}}</td>
                                <td>{{$info->price}}万円</td>
                                <td>{{$info->status_name}}</td>
                                <td>{{$info->land_area_val}}m&sup2;</td>
                                <td>{{$info->total_area_val}}m&sup2;</td>
                                <td>{{$info->vendor}}</td>
                                <td>{{$info->updated_at->format('Y/m/d')}}</td>
                                <td><div class="d-flex">@include('admin.objects.components.link-btn', ['name' => '', 'url' => $info->url, 'class' => 'edit_building_btn', 'title' => '編集'])</div></td>
                            </tr>
                            @endforeach
                        </table>
                    </td>
                </tr>
                @endforeach
            </table>
        </div>
    @endif
@endsection

