@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.regist-tab-mansion', ['title' => '物件登録ーマンション（建物）'])
    @include('admin.objects.components.regist-band', ['title' => 'マンション（建物）検索'])
    <div class="search_vendor">
        <form method="get" action="{{ route('search-mansion') }}">
        {{ csrf_field() }}
        <dl class="d-flex search_vendor__con">
            <dt>マンション名</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'search_name', 'class' => 'w125', 'value' => $params['search_name']??''])</dd>
            <dt>マンション番号</dt>
            <dd>@include('admin.objects.components.input', ['name' => 'search_id', 'class' => 'w175', 'value' => $params['search_id']??''])</dd>
        </dl>
        <dl class="d-flex search_vendor__con">
            <dt>所在地</dt>
            <dd>
            @include('admin.objects.components.selectbox', ['name' => 'search_address1', 'class' => 'mb-2', 'options' => $pref, 'title' => '都道府県', 'selected' => Config::get('const.DEFAULT_PREF'), 'selected' => $params['search_address1']??Config::get('const.DEFAULT_PREF')])
    @include('admin.objects.components.selectbox', ['name' => 'search_address2', 'class' => 'mb-2', 'options' => $city, 'title' => '市区郡', 'selected' => $params['search_address2']??''])
    @include('admin.objects.components.selectbox', ['name' => 'search_address3', 'class' => 'mb-2', 'options' => $town, 'title' => '町村', 'selected' => $params['search_address3']??''])
        </dl>
 
        <div class="search_vendor__btn">
        @include('admin.objects.components.btn', ['title' => '検索', 'class'=> 'btn_search w120'])
        <a href="{{ route('regist-mansion') }}" class="btn_imagesave w120">新規登録</a>
        </div>
        </form>    
    </div>
    @if(isset($list))
    <div class="mansion_list">
        <div class="d-flex justify-content-between pager mt10">
            <div class="m-2"><span class="pager-total">検索結果&nbsp;{{$list->total()}}</span><span>件中&nbsp; {{$first}}〜{{$last}}件表示</span></div>
            <div class="mt-2">{{ $list->appends($params)->links() }}</div>
        </div>
        <table class="mansion_info">
            <tr>
                <th class="w150">マンション番号</th>
                <th class="200" >マンション名/所在地</th>
                <th></th>
            </tr>
            @foreach($list as $item)
            <tr>
                <td rowspan="2">{{$item->building_id}}</td>
                <td>{{$item->article_name}}<br>{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}</td>
                <td>
                    <div class="d-flex">
                    @include('admin.objects.components.link-btn-nostyle', ['name' => 'edit_facility', 'url' => route('showEditMansion', ['id' => $item->building_id]), 'class' => 'p-mansion-search__build', 'title' => '「建物」データを編集'])
                    <a href="{{ route('regist-room', ['id' => $item->building_id]) }}" class="p-mansion-search__room">「部屋」を新規登録</a>
                    <a href="javascript:void(0);" class="p-mansion-search__open">部屋を見る({{$item->room_count}})</a>

                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="room_td">
                    <table class="room_info">
                        <tr>
                            <th>物件番号</th>
                            <th>部屋番号</th>
                            <th>価格</th>
                            <th>ステータス</th>
                            <th>専有面積</th>
                            <th>間取り</th>
                            <th>階数</th>
                            <th>業者</th>
                            <th>業者TEL</th>
                            <th>更新日</th>
                            <th><a href="javascript:void(0);" name="close_room_list" class="close_room_list">閉じる</th>
                        </tr>
                    @foreach($item->room_list as $room)
                        <tr>
                            <td>{{$room->building_id}}</td>
                            <td>{{$room->room_num}}</td>
                            <td>{{$room->price}}万円</td>
                            <td>{{$room->status_name}}</td>
                            <td>{{$room->total_area_val}}</td>
                            <td>{{$room->floor_plan}}{{$room->floor_plan_name}}</td>
                            <td>{{$room->whereabouts}}階</td>
                            <td>{{$room->vendor}}</td>
                            <td>{{$room->vendor_tel}}</td>
                            <td>{{$room->updated_at->format('Y/m/d')}}</td>
                            <td><a href="{{ route('showEditRoom', ['mid' => $item->building_id, 'id' => $room->building_id]) }}" class="p-mansion-search__room d-block w100">編集</a></td>
                        </tr>
                    @endforeach
                    </table>
                </td>
            </tr>
            @endforeach
        </table>
    </div>
    @endif
</div>
@endsection