@php
$type = [
    ['code' => 1, 'name' => 'チェックボックス'],
    ['code' => 2, 'name' => 'セレクトボックス'],
    ['code' => 3, 'name' => '入力エリア'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.regist-band', ['title' => '社員情報プロフィール項目'])
    <div class="user_list">
        <div class="mt10">
            <p class="text-right">ex)趣味・特技、好きなこと、子供の時の夢、仕事のやりがい、将来の夢、お客様へのメッセージ</p>
        </div>
        <form method="POST" action="{{ route('custom-item') }}">
        {{ csrf_field() }}
            <div>
                <table>
                    <tr>
                        <th class="w50">順番</th>
                        <th class="">プロフィール項目</th>
                    </tr>
                    @for($i = 1; $i <= Config::get('const.ITEM_NUM'); $i++)
                    <tr>
                        <td>0{{$i}}</td>
                        <td>@include('admin.objects.components.input', ['name' => 'custom'.$i, 'class' => 'w500', 'value' => isset(${'item'.$i})?${'item'.$i}:''])</td>
                    </tr>
                    @endfor
                </table>
            </div>
            <div class="mt10">
                <table>
                    <tr>
                        <th class="w50">No.</th>
                        <th class="">タイプ</th>
                        <th class="">項目名</th>
                        <th class="">項目内容</th>
                    </tr>
                    <tr>
                        <td>01</td>
                        <td>@include('admin.objects.components.selectbox', ['name' => 'custom_type1', 'options' => $type, 'selected' => $custom_type1??''])</td>
                        <td>@include('admin.objects.components.input', ['name' => 'custom_name1', 'class' => 'w500', 'value' => isset($custom_name1)?$custom_name1:''])</td>
                        <td>@include('admin.objects.components.input', ['name' => 'custom_contents1', 'class' => 'w500', 'value' => isset($custom_contents1)?$custom_contents1:''])</td>
                    </tr>
                    <tr>
                        <td>02</td>
                        <td>@include('admin.objects.components.selectbox', ['name' => 'custom_type2', 'options' => $type, 'selected' => $custom_type2??''])</td>
                        <td>@include('admin.objects.components.input', ['name' => 'custom_name2', 'class' => 'w500', 'value' => isset($custom_name1)?$custom_name2:''])</td>
                        <td>@include('admin.objects.components.input', ['name' => 'custom_contents2', 'class' => 'w500', 'value' => isset($custom_contents2)?$custom_contents2:''])</td>
                    </tr>
                    <tr>
                        <td>03</td>
                        <td>@include('admin.objects.components.selectbox', ['name' => 'custom_type3', 'options' => $type, 'selected' => $custom_type3??''])</td>
                        <td>@include('admin.objects.components.input', ['name' => 'custom_name3', 'class' => 'w500', 'value' => isset($custom_name1)?$custom_name3:''])</td>
                        <td>@include('admin.objects.components.input', ['name' => 'custom_contents3', 'class' => 'w500', 'value' => isset($custom_contents3)?$custom_contents3:''])</td>
                    </tr>
                </table>
            </div>
            <div class="search_vendor__btn">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </form>
        
    </div>
</div>
@endsection