@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @if($type == 2)
    @include('admin.objects.components.regist-band-user', ['title' => 'ウェブスタッフ情報一覧'])
    @elseif($type == 3)
    @include('admin.objects.components.regist-band-user', ['title' => '社員情報一覧'])
    @endif
    <div class="user_list">
    @foreach($staff as $row)
        @if(count($row) > 0)
        <table>
            <tr>
                <th class="w50"></th>
                <th class="w125">店舗カテゴリ</th>
                <th class="w150">写真画像</th>
                <th class="w125">社員ID</th>
                <th class="w300">氏名</th>
                <th class="w100">部署</th>
                <th class="w100">役職</th>
                <th class="w125">公開</th>
                <th></th>
            </tr>
            @foreach($row as $item)
            <tr>
                <td>{{$loop->iteration}}</td>
                <td>{{$item['store_name']}}</td>
                <td>
                    @if(!empty($item['file_path']))
                    <img src="{{$item['file_path']}}" width="150" />
                    @else
                    <img src="{{root('img/noimage2.jpg')}}" width="150" />
                    @endif
                </td>
                <td name="user_id">{{$item['employee_number']}}</td>
                <td>{{$item['name']}}</td>
                <td>{{$item['department']}}</td>
                <td>{{$item['position']}}</td>
                <td class="text-center">
                    @include('admin.objects.components.hidden', ['name' => 'user_id', 'value' => $item['employee_number']])
                    @include('admin.objects.components.switch', ['name' => 'user_disp', 'checked' => $item['disp']])
                </td>
                <td>
                    <div class="d-flex">
                        @include('admin.objects.components.link-btn', ['name' => 'edit_user', 'url' => '/admin/staffEdit/'.$item['employee_number'], 'class' => '', 'title' => '編集'])
                        @include('admin.objects.components.link-btn', ['name' => 'delete_user', 'url' => 'javascript:void(0);', 'class' => 'delete_user', 'title' => '削除'])
                    </div>
                </td>
            </tr>
            @endforeach
        </table>
        @endif
        @endforeach
    </div>
</div>
@endsection